/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.selectable.LockboxClearingSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing LockboxClearing} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class LockboxClearingByKeyFluentHelper
    extends
    FluentHelperByKey<LockboxClearingByKeyFluentHelper, LockboxClearing, LockboxClearingSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing LockboxClearing} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param companyCode
     *            Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code LockboxClearing}
     * @param paymentAdviceAccountType
     *            Payment Advice Account Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code LockboxClearing}
     * @param paymentAdvice
     *            Payment Advice Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 16
     *            </p>
     * @param paymentAdviceAccount
     *            Account Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param paymentAdviceItem
     *            Payment Advice Line Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     */
    public LockboxClearingByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String paymentAdvice,
        final String paymentAdviceItem,
        final String paymentAdviceAccount,
        final String paymentAdviceAccountType,
        final String companyCode )
    {
        super(servicePath, entityCollection);
        this.key.put("PaymentAdvice", paymentAdvice);
        this.key.put("PaymentAdviceItem", paymentAdviceItem);
        this.key.put("PaymentAdviceAccount", paymentAdviceAccount);
        this.key.put("PaymentAdviceAccountType", paymentAdviceAccountType);
        this.key.put("CompanyCode", companyCode);
    }

    @Override
    @Nonnull
    protected Class<LockboxClearing> getEntityClass()
    {
        return LockboxClearing.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
