/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PostLockboxServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PostLockboxService PostLockboxService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPostLockboxServiceBatch
    extends
    BatchFluentHelperBasic<PostLockboxServiceBatch, PostLockboxServiceBatchChangeSet>
    implements
    PostLockboxServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PostLockboxService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPostLockboxServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPostLockboxServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PostLockboxService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.PostLockboxService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPostLockboxServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPostLockboxServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PostLockboxService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPostLockboxServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PostLockboxServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPostLockboxServiceBatchChangeSet(this, service);
    }

}
