/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem;

/**
 * Implementation of the {@link PostLockboxServiceBatchChangeSet} interface, enabling you to combine multiple operations
 * into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PostLockboxService PostLockboxService}.
 *
 */
public class DefaultPostLockboxServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PostLockboxServiceBatch, PostLockboxServiceBatchChangeSet>
    implements
    PostLockboxServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PostLockboxService service;

    @SuppressWarnings( "deprecation" )
    DefaultPostLockboxServiceBatchChangeSet(
        @Nonnull final DefaultPostLockboxServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PostLockboxService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPostLockboxServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PostLockboxServiceBatchChangeSet createLockboxBatch( @Nonnull final LockboxBatch lockboxBatch )
    {
        return addRequestCreate(service::createLockboxBatch, lockboxBatch);
    }

    @Nonnull
    @Override
    public PostLockboxServiceBatchChangeSet createLockboxBatchItem( @Nonnull final LockboxBatchItem lockboxBatchItem )
    {
        return addRequestCreate(service::createLockboxBatchItem, lockboxBatchItem);
    }

}
