/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PostLockboxService PostLockboxService}.
 *
 */
public interface PostLockboxServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<PostLockboxServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<PostLockboxServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch LockboxBatch}
     * entity and save it to the S/4HANA system.
     *
     * @param lockboxBatch
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch LockboxBatch}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PostLockboxServiceBatchChangeSet createLockboxBatch( @Nonnull final LockboxBatch lockboxBatch );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem
     * LockboxBatchItem} entity and save it to the S/4HANA system.
     *
     * @param lockboxBatchItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem
     *            LockboxBatchItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    PostLockboxServiceBatchChangeSet createLockboxBatchItem( @Nonnull final LockboxBatchItem lockboxBatchItem );

}
