/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem LockboxBatchItem}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.field.LockboxBatchItemField
 * LockboxBatchItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.link.LockboxBatchItemLink
 * LockboxBatchItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#LOCKBOX_BATCH_INTERNAL_KEY
 * LOCKBOX_BATCH_INTERNAL_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#LOCKBOX_BATCH_ITEM
 * LOCKBOX_BATCH_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#LOCKBOX_BATCH
 * LOCKBOX_BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#VALUE_DATE
 * VALUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#CURRENCY CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#AMOUNT_IN_TRANSACTION_CURRENCY
 * AMOUNT_IN_TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#LOCKBOX_BATCH_ITM_STATUS
 * LOCKBOX_BATCH_ITM_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#LOCKBOX_BATCH_ITM_STATUS_NAME
 * LOCKBOX_BATCH_ITM_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#CHEQUE CHEQUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#PARTNER_BANK_COUNTRY
 * PARTNER_BANK_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#PARTNER_BANK
 * PARTNER_BANK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#PARTNER_BANK_ACCOUNT
 * PARTNER_BANK_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#BANK_LEDGER_DOCUMENT
 * BANK_LEDGER_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#CUSTOMER CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#MEMO_LINE1
 * MEMO_LINE1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#MEMO_LINE MEMO_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#PAYMENT_ADVICE
 * PAYMENT_ADVICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#ASSIGNMENT_REFERENCE
 * ASSIGNMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#DOCUMENT_ITEM_TEXT
 * DOCUMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#DOCUMENT_REFERENCE_ID
 * DOCUMENT_REFERENCE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#PAYMENT_MANUAL_TRANSAC_TYPE
 * PAYMENT_MANUAL_TRANSAC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#BANK_LEDGER_IS_POSTED
 * BANK_LEDGER_IS_POSTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#SUBLEDGER_IS_POSTED_SUCCESSFULLY
 * SUBLEDGER_IS_POSTED_SUCCESSFULLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#LOCKBOX_SUBLEDGER_DOCUMENT
 * LOCKBOX_SUBLEDGER_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#SUBLEDGER_DOCUMENT
 * SUBLEDGER_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#LOCKBOX_BATCH_ITM_ADDITIONAL_INFO
 * LOCKBOX_BATCH_ITM_ADDITIONAL_INFO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#TO_HEADER TO_HEADER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatchItem#TO_LOCKBOX_CLEARING
 * TO_LOCKBOX_CLEARING}</li>
 * </ul>
 *
 */
public interface LockboxBatchItemSelectable extends EntitySelectable<LockboxBatchItem>
{

}
