/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch LockboxBatch}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.field.LockboxBatchField
 * LockboxBatchField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.link.LockboxBatchLink
 * LockboxBatchLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#LOCKBOX_BATCH_INTERNAL_KEY
 * LOCKBOX_BATCH_INTERNAL_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#LOCKBOX_BATCH
 * LOCKBOX_BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#LOCKBOX LOCKBOX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#LOCKBOX_BATCH_DESTINATION
 * LOCKBOX_BATCH_DESTINATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#LOCKBOX_BATCH_ORIGIN
 * LOCKBOX_BATCH_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#DEPOSIT_DATE_TIME
 * DEPOSIT_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#INCOMING_PAYMENT_FILE
 * INCOMING_PAYMENT_FILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#LOCKBOX_BATCH_STATUS
 * LOCKBOX_BATCH_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#LOCKBOX_BATCH_STATUS_NAME
 * LOCKBOX_BATCH_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#NUMBER_OF_ITEMS
 * NUMBER_OF_ITEMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#CURRENCY CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#AMOUNT_IN_TRANSACTION_CURRENCY
 * AMOUNT_IN_TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#NUMBER_OF_INCOMPLETE_CHEQUES
 * NUMBER_OF_INCOMPLETE_CHEQUES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#BATCH_IS_LATEST
 * BATCH_IS_LATEST}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#JOURNAL_ENTRY_IS_NOT_TO_BE_POSTED
 * JOURNAL_ENTRY_IS_NOT_TO_BE_POSTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxBatch#TO_ITEM TO_ITEM}</li>
 * </ul>
 *
 */
public interface LockboxBatchSelectable extends EntitySelectable<LockboxBatch>
{

}
