/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing LockboxClearing}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.field.LockboxClearingField
 * LockboxClearingField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.link.LockboxClearingLink LockboxClearingLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing#PAYMENT_ADVICE
 * PAYMENT_ADVICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing#PAYMENT_ADVICE_ITEM
 * PAYMENT_ADVICE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing#PAYMENT_ADVICE_ACCOUNT
 * PAYMENT_ADVICE_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing#PAYMENT_ADVICE_ACCOUNT_TYPE
 * PAYMENT_ADVICE_ACCOUNT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing#LOCKBOX_BATCH_INTERNAL_KEY
 * LOCKBOX_BATCH_INTERNAL_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing#LOCKBOX_BATCH_ITEM
 * LOCKBOX_BATCH_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing#LOCKBOX_BATCH
 * LOCKBOX_BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing#PAYMENT_REFERENCE
 * PAYMENT_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing#NET_PAYMENT_AMOUNT_IN_PAYT_CURRENCY
 * NET_PAYMENT_AMOUNT_IN_PAYT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing#DEDUCTION_AMOUNT_IN_PAYT_CURRENCY
 * DEDUCTION_AMOUNT_IN_PAYT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing#PAYMENT_DIFFERENCE_REASON
 * PAYMENT_DIFFERENCE_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing#CURRENCY CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing#TO_BATCH_ITEM
 * TO_BATCH_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.postlockbox.LockboxClearing#TO_ROOT TO_ROOT}</li>
 * </ul>
 *
 */
public interface LockboxClearingSelectable extends EntitySelectable<LockboxClearing>
{

}
