/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.field.PurgPrcgProcedItemTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.link.PurgPrcgProcedItemTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.selectable.PurgPrcgProcedItemTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Pricing Procedure Subtotal Lines
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurgPrcgProcedItemTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurgPrcgProcedItemText extends VdmEntity<PurgPrcgProcedItemText>
{

    /**
     * Selector for all available fields of PurgPrcgProcedItemText.
     *
     */
    public final static PurgPrcgProcedItemTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PurgPrcgProcedItemTextField<String> LANGUAGE =
        new PurgPrcgProcedItemTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     *
     * @return Usage of the condition table
     */
    @Key
    @SerializedName( "ConditionUsage" )
    @JsonProperty( "ConditionUsage" )
    @Nullable
    @ODataField( odataName = "ConditionUsage" )
    private String conditionUsage;
    /**
     * Use with available fluent helpers to apply the <b>ConditionUsage</b> field to query operations.
     *
     */
    public final static PurgPrcgProcedItemTextField<String> CONDITION_USAGE =
        new PurgPrcgProcedItemTextField<String>("ConditionUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @return Application
     */
    @Key
    @SerializedName( "ConditionApplication" )
    @JsonProperty( "ConditionApplication" )
    @Nullable
    @ODataField( odataName = "ConditionApplication" )
    private String conditionApplication;
    /**
     * Use with available fluent helpers to apply the <b>ConditionApplication</b> field to query operations.
     *
     */
    public final static PurgPrcgProcedItemTextField<String> CONDITION_APPLICATION =
        new PurgPrcgProcedItemTextField<String>("ConditionApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedure</b>
     * </p>
     *
     * @return Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    @Key
    @SerializedName( "PricingProcedure" )
    @JsonProperty( "PricingProcedure" )
    @Nullable
    @ODataField( odataName = "PricingProcedure" )
    private String pricingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedure</b> field to query operations.
     *
     */
    public final static PurgPrcgProcedItemTextField<String> PRICING_PROCEDURE =
        new PurgPrcgProcedItemTextField<String>("PricingProcedure");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     *
     * @return Step Number
     */
    @Key
    @SerializedName( "PricingProcedureStep" )
    @JsonProperty( "PricingProcedureStep" )
    @Nullable
    @ODataField( odataName = "PricingProcedureStep" )
    private String pricingProcedureStep;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedureStep</b> field to query operations.
     *
     */
    public final static PurgPrcgProcedItemTextField<String> PRICING_PROCEDURE_STEP =
        new PurgPrcgProcedItemTextField<String>("PricingProcedureStep");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     *
     * @return Condition Counter
     */
    @Key
    @SerializedName( "PricingProcedureCounter" )
    @JsonProperty( "PricingProcedureCounter" )
    @Nullable
    @ODataField( odataName = "PricingProcedureCounter" )
    private String pricingProcedureCounter;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedureCounter</b> field to query operations.
     *
     */
    public final static PurgPrcgProcedItemTextField<String> PRICING_PROCEDURE_COUNTER =
        new PurgPrcgProcedItemTextField<String>("PricingProcedureCounter");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTypeName</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "ConditionTypeName" )
    @JsonProperty( "ConditionTypeName" )
    @Nullable
    @ODataField( odataName = "ConditionTypeName" )
    private String conditionTypeName;
    /**
     * Use with available fluent helpers to apply the <b>ConditionTypeName</b> field to query operations.
     *
     */
    public final static PurgPrcgProcedItemTextField<String> CONDITION_TYPE_NAME =
        new PurgPrcgProcedItemTextField<String>("ConditionTypeName");
    /**
     * Navigation property <b>to_PurgPricingProcedure</b> for <b>PurgPrcgProcedItemText</b> to single
     * <b>PurgPricingProcedureItem</b>.
     *
     */
    @SerializedName( "to_PurgPricingProcedure" )
    @JsonProperty( "to_PurgPricingProcedure" )
    @ODataField( odataName = "to_PurgPricingProcedure" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurgPricingProcedureItem toPurgPricingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>to_PurgPricingProcedure</b> navigation property to query
     * operations.
     *
     */
    public final static PurgPrcgProcedItemTextOneToOneLink<PurgPricingProcedureItem> TO_PURG_PRICING_PROCEDURE =
        new PurgPrcgProcedItemTextOneToOneLink<PurgPricingProcedureItem>("to_PurgPricingProcedure");

    @Nonnull
    @Override
    public Class<PurgPrcgProcedItemText> getType()
    {
        return PurgPrcgProcedItemText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     *
     * @param conditionUsage
     *            Usage of the condition table
     */
    public void setConditionUsage( @Nullable final String conditionUsage )
    {
        rememberChangedField("ConditionUsage", this.conditionUsage);
        this.conditionUsage = conditionUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedure</b>
     * </p>
     *
     * @param pricingProcedure
     *            Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    public void setPricingProcedure( @Nullable final String pricingProcedure )
    {
        rememberChangedField("PricingProcedure", this.pricingProcedure);
        this.pricingProcedure = pricingProcedure;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     *
     * @param pricingProcedureStep
     *            Step Number
     */
    public void setPricingProcedureStep( @Nullable final String pricingProcedureStep )
    {
        rememberChangedField("PricingProcedureStep", this.pricingProcedureStep);
        this.pricingProcedureStep = pricingProcedureStep;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     */
    public void setPricingProcedureCounter( @Nullable final String pricingProcedureCounter )
    {
        rememberChangedField("PricingProcedureCounter", this.pricingProcedureCounter);
        this.pricingProcedureCounter = pricingProcedureCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTypeName</b>
     * </p>
     *
     * @param conditionTypeName
     *            Description
     */
    public void setConditionTypeName( @Nullable final String conditionTypeName )
    {
        rememberChangedField("ConditionTypeName", this.conditionTypeName);
        this.conditionTypeName = conditionTypeName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurgPrcgProcedItemText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("ConditionUsage", getConditionUsage());
        result.put("ConditionApplication", getConditionApplication());
        result.put("PricingProcedure", getPricingProcedure());
        result.put("PricingProcedureStep", getPricingProcedureStep());
        result.put("PricingProcedureCounter", getPricingProcedureCounter());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ConditionUsage", getConditionUsage());
        values.put("ConditionApplication", getConditionApplication());
        values.put("PricingProcedure", getPricingProcedure());
        values.put("PricingProcedureStep", getPricingProcedureStep());
        values.put("PricingProcedureCounter", getPricingProcedureCounter());
        values.put("ConditionTypeName", getConditionTypeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConditionUsage") ) {
                final Object value = values.remove("ConditionUsage");
                if( (value == null) || (!value.equals(getConditionUsage())) ) {
                    setConditionUsage(((String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((String) value));
                }
            }
            if( values.containsKey("PricingProcedure") ) {
                final Object value = values.remove("PricingProcedure");
                if( (value == null) || (!value.equals(getPricingProcedure())) ) {
                    setPricingProcedure(((String) value));
                }
            }
            if( values.containsKey("PricingProcedureStep") ) {
                final Object value = values.remove("PricingProcedureStep");
                if( (value == null) || (!value.equals(getPricingProcedureStep())) ) {
                    setPricingProcedureStep(((String) value));
                }
            }
            if( values.containsKey("PricingProcedureCounter") ) {
                final Object value = values.remove("PricingProcedureCounter");
                if( (value == null) || (!value.equals(getPricingProcedureCounter())) ) {
                    setPricingProcedureCounter(((String) value));
                }
            }
            if( values.containsKey("ConditionTypeName") ) {
                final Object value = values.remove("ConditionTypeName");
                if( (value == null) || (!value.equals(getConditionTypeName())) ) {
                    setConditionTypeName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurgPricingProcedure") ) {
                final Object value = (values).remove("to_PurgPricingProcedure");
                if( value instanceof Map ) {
                    if( toPurgPricingProcedure == null ) {
                        toPurgPricingProcedure = new PurgPricingProcedureItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurgPricingProcedure.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurgPrcgProcedItemTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurgPrcgProcedItemTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurgPrcgProcedItemTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurgPrcgProcedItemTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInPurchasingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurgPricingProcedure != null ) {
            (values).put("to_PurgPricingProcedure", toPurgPricingProcedure);
        }
        return values;
    }

    /**
     * Fetches the <b>PurgPricingProcedureItem</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PurgPricingProcedure</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurgPricingProcedureItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgPricingProcedureItem fetchPurgPricingProcedure()
    {
        return fetchFieldAsSingle("to_PurgPricingProcedure", PurgPricingProcedureItem.class);
    }

    /**
     * Retrieval of associated <b>PurgPricingProcedureItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurgPricingProcedure</b>.
     * <p>
     * If the navigation property <b>to_PurgPricingProcedure</b> of a queried <b>PurgPrcgProcedItemText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgPricingProcedureItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgPricingProcedureItem getPurgPricingProcedureOrFetch()
    {
        if( toPurgPricingProcedure == null ) {
            toPurgPricingProcedure = fetchPurgPricingProcedure();
        }
        return toPurgPricingProcedure;
    }

    /**
     * Retrieval of associated <b>PurgPricingProcedureItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurgPricingProcedure</b>.
     * <p>
     * If the navigation property for an entity <b>PurgPrcgProcedItemText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgPricingProcedure</b> is already loaded, the result
     *         will contain the <b>PurgPricingProcedureItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurgPricingProcedureItem> getPurgPricingProcedureIfPresent()
    {
        return Option.of(toPurgPricingProcedure);
    }

    /**
     * Overwrites the associated <b>PurgPricingProcedureItem</b> entity for the loaded navigation property
     * <b>to_PurgPricingProcedure</b>.
     *
     * @param value
     *            New <b>PurgPricingProcedureItem</b> entity.
     */
    public void setPurgPricingProcedure( final PurgPricingProcedureItem value )
    {
        toPurgPricingProcedure = value;
    }

    /**
     * Helper class to allow for fluent creation of PurgPrcgProcedItemText instances.
     *
     */
    public final static class PurgPrcgProcedItemTextBuilder
    {

        private PurgPricingProcedureItem toPurgPricingProcedure;

        private PurgPrcgProcedItemText.PurgPrcgProcedItemTextBuilder toPurgPricingProcedure(
            final PurgPricingProcedureItem value )
        {
            toPurgPricingProcedure = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurgPricingProcedure</b> for <b>PurgPrcgProcedItemText</b> to single
         * <b>PurgPricingProcedureItem</b>.
         *
         * @param value
         *            The PurgPricingProcedureItem to build this PurgPrcgProcedItemText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgPrcgProcedItemText.PurgPrcgProcedItemTextBuilder purgPricingProcedure(
            final PurgPricingProcedureItem value )
        {
            return toPurgPricingProcedure(value);
        }

    }

}
