/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.field.PurgPricingProcedureItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.link.PurgPricingProcedureItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.link.PurgPricingProcedureItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.selectable.PurgPricingProcedureItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Pricing Procedure Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_PurgPricingProcedureItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PurgPricingProcedureItem extends VdmEntity<PurgPricingProcedureItem>
{

    /**
     * Selector for all available fields of PurgPricingProcedureItem.
     *
     */
    public final static PurgPricingProcedureItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     *
     * @return Usage of the condition table
     */
    @Key
    @SerializedName( "ConditionUsage" )
    @JsonProperty( "ConditionUsage" )
    @Nullable
    @ODataField( odataName = "ConditionUsage" )
    private String conditionUsage;
    /**
     * Use with available fluent helpers to apply the <b>ConditionUsage</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<String> CONDITION_USAGE =
        new PurgPricingProcedureItemField<String>("ConditionUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @return Application
     */
    @Key
    @SerializedName( "ConditionApplication" )
    @JsonProperty( "ConditionApplication" )
    @Nullable
    @ODataField( odataName = "ConditionApplication" )
    private String conditionApplication;
    /**
     * Use with available fluent helpers to apply the <b>ConditionApplication</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<String> CONDITION_APPLICATION =
        new PurgPricingProcedureItemField<String>("ConditionApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedure</b>
     * </p>
     *
     * @return Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    @Key
    @SerializedName( "PricingProcedure" )
    @JsonProperty( "PricingProcedure" )
    @Nullable
    @ODataField( odataName = "PricingProcedure" )
    private String pricingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedure</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<String> PRICING_PROCEDURE =
        new PurgPricingProcedureItemField<String>("PricingProcedure");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     *
     * @return Step Number
     */
    @Key
    @SerializedName( "PricingProcedureStep" )
    @JsonProperty( "PricingProcedureStep" )
    @Nullable
    @ODataField( odataName = "PricingProcedureStep" )
    private String pricingProcedureStep;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedureStep</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<String> PRICING_PROCEDURE_STEP =
        new PurgPricingProcedureItemField<String>("PricingProcedureStep");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     *
     * @return Condition Counter
     */
    @Key
    @SerializedName( "PricingProcedureCounter" )
    @JsonProperty( "PricingProcedureCounter" )
    @Nullable
    @ODataField( odataName = "PricingProcedureCounter" )
    private String pricingProcedureCounter;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedureCounter</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<String> PRICING_PROCEDURE_COUNTER =
        new PurgPricingProcedureItemField<String>("PricingProcedureCounter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<String> CONDITION_TYPE =
        new PurgPricingProcedureItemField<String>("ConditionType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrcgProcedItemFromRefStep</b>
     * </p>
     *
     * @return From Reference Step
     */
    @SerializedName( "PrcgProcedItemFromRefStep" )
    @JsonProperty( "PrcgProcedItemFromRefStep" )
    @Nullable
    @ODataField( odataName = "PrcgProcedItemFromRefStep" )
    private String prcgProcedItemFromRefStep;
    /**
     * Use with available fluent helpers to apply the <b>PrcgProcedItemFromRefStep</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<String> PRCG_PROCED_ITEM_FROM_REF_STEP =
        new PurgPricingProcedureItemField<String>("PrcgProcedItemFromRefStep");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrcgProcedItemToRefStep</b>
     * </p>
     *
     * @return To Reference Step
     */
    @SerializedName( "PrcgProcedItemToRefStep" )
    @JsonProperty( "PrcgProcedItemToRefStep" )
    @Nullable
    @ODataField( odataName = "PrcgProcedItemToRefStep" )
    private String prcgProcedItemToRefStep;
    /**
     * Use with available fluent helpers to apply the <b>PrcgProcedItemToRefStep</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<String> PRCG_PROCED_ITEM_TO_REF_STEP =
        new PurgPricingProcedureItemField<String>("PrcgProcedItemToRefStep");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsManuallyDtmnd</b>
     * </p>
     *
     * @return Condition determined manually
     */
    @SerializedName( "ConditionIsManuallyDtmnd" )
    @JsonProperty( "ConditionIsManuallyDtmnd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsManuallyDtmnd" )
    private Boolean conditionIsManuallyDtmnd;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsManuallyDtmnd</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<Boolean> CONDITION_IS_MANUALLY_DTMND =
        new PurgPricingProcedureItemField<Boolean>("ConditionIsManuallyDtmnd");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrcgProcedItemSubtotal</b>
     * </p>
     *
     * @return Condition subtotal
     */
    @SerializedName( "PrcgProcedItemSubtotal" )
    @JsonProperty( "PrcgProcedItemSubtotal" )
    @Nullable
    @ODataField( odataName = "PrcgProcedItemSubtotal" )
    private String prcgProcedItemSubtotal;
    /**
     * Use with available fluent helpers to apply the <b>PrcgProcedItemSubtotal</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<String> PRCG_PROCED_ITEM_SUBTOTAL =
        new PurgPricingProcedureItemField<String>("PrcgProcedItemSubtotal");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForStatistics</b>
     * </p>
     *
     * @return Condition is used for statistics
     */
    @SerializedName( "ConditionIsForStatistics" )
    @JsonProperty( "ConditionIsForStatistics" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsForStatistics" )
    private Boolean conditionIsForStatistics;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsForStatistics</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<Boolean> CONDITION_IS_FOR_STATISTICS =
        new PurgPricingProcedureItemField<Boolean>("ConditionIsForStatistics");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccountKeyForGLAccount</b>
     * </p>
     *
     * @return Account Key
     */
    @SerializedName( "AccountKeyForGLAccount" )
    @JsonProperty( "AccountKeyForGLAccount" )
    @Nullable
    @ODataField( odataName = "AccountKeyForGLAccount" )
    private String accountKeyForGLAccount;
    /**
     * Use with available fluent helpers to apply the <b>AccountKeyForGLAccount</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<String> ACCOUNT_KEY_FOR_GL_ACCOUNT =
        new PurgPricingProcedureItemField<String>("AccountKeyForGLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AcctKeyForAccrualsGLAccount</b>
     * </p>
     *
     * @return Account Key - Accruals / Provisions
     */
    @SerializedName( "AcctKeyForAccrualsGLAccount" )
    @JsonProperty( "AcctKeyForAccrualsGLAccount" )
    @Nullable
    @ODataField( odataName = "AcctKeyForAccrualsGLAccount" )
    private String acctKeyForAccrualsGLAccount;
    /**
     * Use with available fluent helpers to apply the <b>AcctKeyForAccrualsGLAccount</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<String> ACCT_KEY_FOR_ACCRUALS_GL_ACCOUNT =
        new PurgPricingProcedureItemField<String>("AcctKeyForAccrualsGLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureItemPrintType</b>
     * </p>
     *
     * @return Print Type for Condition Lines
     */
    @SerializedName( "PricingProcedureItemPrintType" )
    @JsonProperty( "PricingProcedureItemPrintType" )
    @Nullable
    @ODataField( odataName = "PricingProcedureItemPrintType" )
    private String pricingProcedureItemPrintType;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedureItemPrintType</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<String> PRICING_PROCEDURE_ITEM_PRINT_TYPE =
        new PurgPricingProcedureItemField<String>("PricingProcedureItemPrintType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsMandatory</b>
     * </p>
     *
     * @return Condition is mandatory
     */
    @SerializedName( "ConditionIsMandatory" )
    @JsonProperty( "ConditionIsMandatory" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ConditionIsMandatory" )
    private Boolean conditionIsMandatory;
    /**
     * Use with available fluent helpers to apply the <b>ConditionIsMandatory</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<Boolean> CONDITION_IS_MANDATORY =
        new PurgPricingProcedureItemField<Boolean>("ConditionIsMandatory");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsAcctDetnRelevant</b>
     * </p>
     *
     * @return Statistical and Relevant for Account Determination
     */
    @SerializedName( "CndnIsAcctDetnRelevant" )
    @JsonProperty( "CndnIsAcctDetnRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CndnIsAcctDetnRelevant" )
    private Boolean cndnIsAcctDetnRelevant;
    /**
     * Use with available fluent helpers to apply the <b>CndnIsAcctDetnRelevant</b> field to query operations.
     *
     */
    public final static PurgPricingProcedureItemField<Boolean> CNDN_IS_ACCT_DETN_RELEVANT =
        new PurgPricingProcedureItemField<Boolean>("CndnIsAcctDetnRelevant");
    /**
     * Navigation property <b>to_PurgPricingConditionType</b> for <b>PurgPricingProcedureItem</b> to single
     * <b>PurgPricingConditionType</b>.
     *
     */
    @SerializedName( "to_PurgPricingConditionType" )
    @JsonProperty( "to_PurgPricingConditionType" )
    @ODataField( odataName = "to_PurgPricingConditionType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurgPricingConditionType toPurgPricingConditionType;
    /**
     * Navigation property <b>to_PurgPricingProcedure</b> for <b>PurgPricingProcedureItem</b> to single
     * <b>PurgPricingProcedure</b>.
     *
     */
    @SerializedName( "to_PurgPricingProcedure" )
    @JsonProperty( "to_PurgPricingProcedure" )
    @ODataField( odataName = "to_PurgPricingProcedure" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PurgPricingProcedure toPurgPricingProcedure;
    /**
     * Navigation property <b>to_Text</b> for <b>PurgPricingProcedureItem</b> to multiple <b>PurgPrcgProcedItemText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PurgPrcgProcedItemText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_PurgPricingConditionType</b> navigation property to query
     * operations.
     *
     */
    public final static PurgPricingProcedureItemOneToOneLink<PurgPricingConditionType> TO_PURG_PRICING_CONDITION_TYPE =
        new PurgPricingProcedureItemOneToOneLink<PurgPricingConditionType>("to_PurgPricingConditionType");
    /**
     * Use with available fluent helpers to apply the <b>to_PurgPricingProcedure</b> navigation property to query
     * operations.
     *
     */
    public final static PurgPricingProcedureItemOneToOneLink<PurgPricingProcedure> TO_PURG_PRICING_PROCEDURE =
        new PurgPricingProcedureItemOneToOneLink<PurgPricingProcedure>("to_PurgPricingProcedure");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static PurgPricingProcedureItemLink<PurgPrcgProcedItemText> TO_TEXT =
        new PurgPricingProcedureItemLink<PurgPrcgProcedItemText>("to_Text");

    @Nonnull
    @Override
    public Class<PurgPricingProcedureItem> getType()
    {
        return PurgPricingProcedureItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     *
     * @param conditionUsage
     *            Usage of the condition table
     */
    public void setConditionUsage( @Nullable final String conditionUsage )
    {
        rememberChangedField("ConditionUsage", this.conditionUsage);
        this.conditionUsage = conditionUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedure</b>
     * </p>
     *
     * @param pricingProcedure
     *            Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    public void setPricingProcedure( @Nullable final String pricingProcedure )
    {
        rememberChangedField("PricingProcedure", this.pricingProcedure);
        this.pricingProcedure = pricingProcedure;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureStep</b>
     * </p>
     *
     * @param pricingProcedureStep
     *            Step Number
     */
    public void setPricingProcedureStep( @Nullable final String pricingProcedureStep )
    {
        rememberChangedField("PricingProcedureStep", this.pricingProcedureStep);
        this.pricingProcedureStep = pricingProcedureStep;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureCounter</b>
     * </p>
     *
     * @param pricingProcedureCounter
     *            Condition Counter
     */
    public void setPricingProcedureCounter( @Nullable final String pricingProcedureCounter )
    {
        rememberChangedField("PricingProcedureCounter", this.pricingProcedureCounter);
        this.pricingProcedureCounter = pricingProcedureCounter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrcgProcedItemFromRefStep</b>
     * </p>
     *
     * @param prcgProcedItemFromRefStep
     *            From Reference Step
     */
    public void setPrcgProcedItemFromRefStep( @Nullable final String prcgProcedItemFromRefStep )
    {
        rememberChangedField("PrcgProcedItemFromRefStep", this.prcgProcedItemFromRefStep);
        this.prcgProcedItemFromRefStep = prcgProcedItemFromRefStep;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrcgProcedItemToRefStep</b>
     * </p>
     *
     * @param prcgProcedItemToRefStep
     *            To Reference Step
     */
    public void setPrcgProcedItemToRefStep( @Nullable final String prcgProcedItemToRefStep )
    {
        rememberChangedField("PrcgProcedItemToRefStep", this.prcgProcedItemToRefStep);
        this.prcgProcedItemToRefStep = prcgProcedItemToRefStep;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsManuallyDtmnd</b>
     * </p>
     *
     * @param conditionIsManuallyDtmnd
     *            Condition determined manually
     */
    public void setConditionIsManuallyDtmnd( @Nullable final Boolean conditionIsManuallyDtmnd )
    {
        rememberChangedField("ConditionIsManuallyDtmnd", this.conditionIsManuallyDtmnd);
        this.conditionIsManuallyDtmnd = conditionIsManuallyDtmnd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrcgProcedItemSubtotal</b>
     * </p>
     *
     * @param prcgProcedItemSubtotal
     *            Condition subtotal
     */
    public void setPrcgProcedItemSubtotal( @Nullable final String prcgProcedItemSubtotal )
    {
        rememberChangedField("PrcgProcedItemSubtotal", this.prcgProcedItemSubtotal);
        this.prcgProcedItemSubtotal = prcgProcedItemSubtotal;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsForStatistics</b>
     * </p>
     *
     * @param conditionIsForStatistics
     *            Condition is used for statistics
     */
    public void setConditionIsForStatistics( @Nullable final Boolean conditionIsForStatistics )
    {
        rememberChangedField("ConditionIsForStatistics", this.conditionIsForStatistics);
        this.conditionIsForStatistics = conditionIsForStatistics;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AccountKeyForGLAccount</b>
     * </p>
     *
     * @param accountKeyForGLAccount
     *            Account Key
     */
    public void setAccountKeyForGLAccount( @Nullable final String accountKeyForGLAccount )
    {
        rememberChangedField("AccountKeyForGLAccount", this.accountKeyForGLAccount);
        this.accountKeyForGLAccount = accountKeyForGLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AcctKeyForAccrualsGLAccount</b>
     * </p>
     *
     * @param acctKeyForAccrualsGLAccount
     *            Account Key - Accruals / Provisions
     */
    public void setAcctKeyForAccrualsGLAccount( @Nullable final String acctKeyForAccrualsGLAccount )
    {
        rememberChangedField("AcctKeyForAccrualsGLAccount", this.acctKeyForAccrualsGLAccount);
        this.acctKeyForAccrualsGLAccount = acctKeyForAccrualsGLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedureItemPrintType</b>
     * </p>
     *
     * @param pricingProcedureItemPrintType
     *            Print Type for Condition Lines
     */
    public void setPricingProcedureItemPrintType( @Nullable final String pricingProcedureItemPrintType )
    {
        rememberChangedField("PricingProcedureItemPrintType", this.pricingProcedureItemPrintType);
        this.pricingProcedureItemPrintType = pricingProcedureItemPrintType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ConditionIsMandatory</b>
     * </p>
     *
     * @param conditionIsMandatory
     *            Condition is mandatory
     */
    public void setConditionIsMandatory( @Nullable final Boolean conditionIsMandatory )
    {
        rememberChangedField("ConditionIsMandatory", this.conditionIsMandatory);
        this.conditionIsMandatory = conditionIsMandatory;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CndnIsAcctDetnRelevant</b>
     * </p>
     *
     * @param cndnIsAcctDetnRelevant
     *            Statistical and Relevant for Account Determination
     */
    public void setCndnIsAcctDetnRelevant( @Nullable final Boolean cndnIsAcctDetnRelevant )
    {
        rememberChangedField("CndnIsAcctDetnRelevant", this.cndnIsAcctDetnRelevant);
        this.cndnIsAcctDetnRelevant = cndnIsAcctDetnRelevant;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_PurgPricingProcedureItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConditionUsage", getConditionUsage());
        result.put("ConditionApplication", getConditionApplication());
        result.put("PricingProcedure", getPricingProcedure());
        result.put("PricingProcedureStep", getPricingProcedureStep());
        result.put("PricingProcedureCounter", getPricingProcedureCounter());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConditionUsage", getConditionUsage());
        values.put("ConditionApplication", getConditionApplication());
        values.put("PricingProcedure", getPricingProcedure());
        values.put("PricingProcedureStep", getPricingProcedureStep());
        values.put("PricingProcedureCounter", getPricingProcedureCounter());
        values.put("ConditionType", getConditionType());
        values.put("PrcgProcedItemFromRefStep", getPrcgProcedItemFromRefStep());
        values.put("PrcgProcedItemToRefStep", getPrcgProcedItemToRefStep());
        values.put("ConditionIsManuallyDtmnd", getConditionIsManuallyDtmnd());
        values.put("PrcgProcedItemSubtotal", getPrcgProcedItemSubtotal());
        values.put("ConditionIsForStatistics", getConditionIsForStatistics());
        values.put("AccountKeyForGLAccount", getAccountKeyForGLAccount());
        values.put("AcctKeyForAccrualsGLAccount", getAcctKeyForAccrualsGLAccount());
        values.put("PricingProcedureItemPrintType", getPricingProcedureItemPrintType());
        values.put("ConditionIsMandatory", getConditionIsMandatory());
        values.put("CndnIsAcctDetnRelevant", getCndnIsAcctDetnRelevant());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionUsage") ) {
                final Object value = values.remove("ConditionUsage");
                if( (value == null) || (!value.equals(getConditionUsage())) ) {
                    setConditionUsage(((String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((String) value));
                }
            }
            if( values.containsKey("PricingProcedure") ) {
                final Object value = values.remove("PricingProcedure");
                if( (value == null) || (!value.equals(getPricingProcedure())) ) {
                    setPricingProcedure(((String) value));
                }
            }
            if( values.containsKey("PricingProcedureStep") ) {
                final Object value = values.remove("PricingProcedureStep");
                if( (value == null) || (!value.equals(getPricingProcedureStep())) ) {
                    setPricingProcedureStep(((String) value));
                }
            }
            if( values.containsKey("PricingProcedureCounter") ) {
                final Object value = values.remove("PricingProcedureCounter");
                if( (value == null) || (!value.equals(getPricingProcedureCounter())) ) {
                    setPricingProcedureCounter(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("PrcgProcedItemFromRefStep") ) {
                final Object value = values.remove("PrcgProcedItemFromRefStep");
                if( (value == null) || (!value.equals(getPrcgProcedItemFromRefStep())) ) {
                    setPrcgProcedItemFromRefStep(((String) value));
                }
            }
            if( values.containsKey("PrcgProcedItemToRefStep") ) {
                final Object value = values.remove("PrcgProcedItemToRefStep");
                if( (value == null) || (!value.equals(getPrcgProcedItemToRefStep())) ) {
                    setPrcgProcedItemToRefStep(((String) value));
                }
            }
            if( values.containsKey("ConditionIsManuallyDtmnd") ) {
                final Object value = values.remove("ConditionIsManuallyDtmnd");
                if( (value == null) || (!value.equals(getConditionIsManuallyDtmnd())) ) {
                    setConditionIsManuallyDtmnd(((Boolean) value));
                }
            }
            if( values.containsKey("PrcgProcedItemSubtotal") ) {
                final Object value = values.remove("PrcgProcedItemSubtotal");
                if( (value == null) || (!value.equals(getPrcgProcedItemSubtotal())) ) {
                    setPrcgProcedItemSubtotal(((String) value));
                }
            }
            if( values.containsKey("ConditionIsForStatistics") ) {
                final Object value = values.remove("ConditionIsForStatistics");
                if( (value == null) || (!value.equals(getConditionIsForStatistics())) ) {
                    setConditionIsForStatistics(((Boolean) value));
                }
            }
            if( values.containsKey("AccountKeyForGLAccount") ) {
                final Object value = values.remove("AccountKeyForGLAccount");
                if( (value == null) || (!value.equals(getAccountKeyForGLAccount())) ) {
                    setAccountKeyForGLAccount(((String) value));
                }
            }
            if( values.containsKey("AcctKeyForAccrualsGLAccount") ) {
                final Object value = values.remove("AcctKeyForAccrualsGLAccount");
                if( (value == null) || (!value.equals(getAcctKeyForAccrualsGLAccount())) ) {
                    setAcctKeyForAccrualsGLAccount(((String) value));
                }
            }
            if( values.containsKey("PricingProcedureItemPrintType") ) {
                final Object value = values.remove("PricingProcedureItemPrintType");
                if( (value == null) || (!value.equals(getPricingProcedureItemPrintType())) ) {
                    setPricingProcedureItemPrintType(((String) value));
                }
            }
            if( values.containsKey("ConditionIsMandatory") ) {
                final Object value = values.remove("ConditionIsMandatory");
                if( (value == null) || (!value.equals(getConditionIsMandatory())) ) {
                    setConditionIsMandatory(((Boolean) value));
                }
            }
            if( values.containsKey("CndnIsAcctDetnRelevant") ) {
                final Object value = values.remove("CndnIsAcctDetnRelevant");
                if( (value == null) || (!value.equals(getCndnIsAcctDetnRelevant())) ) {
                    setCndnIsAcctDetnRelevant(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_PurgPricingConditionType") ) {
                final Object value = (values).remove("to_PurgPricingConditionType");
                if( value instanceof Map ) {
                    if( toPurgPricingConditionType == null ) {
                        toPurgPricingConditionType = new PurgPricingConditionType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurgPricingConditionType.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_PurgPricingProcedure") ) {
                final Object value = (values).remove("to_PurgPricingProcedure");
                if( value instanceof Map ) {
                    if( toPurgPricingProcedure == null ) {
                        toPurgPricingProcedure = new PurgPricingProcedure();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPurgPricingProcedure.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PurgPrcgProcedItemText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new PurgPrcgProcedItemText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PurgPricingProcedureItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PurgPricingProcedureItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PurgPricingProcedureItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PurgPricingProcedureItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInPurchasingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPurgPricingConditionType != null ) {
            (values).put("to_PurgPricingConditionType", toPurgPricingConditionType);
        }
        if( toPurgPricingProcedure != null ) {
            (values).put("to_PurgPricingProcedure", toPurgPricingProcedure);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>PurgPricingConditionType</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_PurgPricingConditionType</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurgPricingConditionType</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgPricingConditionType fetchPurgPricingConditionType()
    {
        return fetchFieldAsSingle("to_PurgPricingConditionType", PurgPricingConditionType.class);
    }

    /**
     * Retrieval of associated <b>PurgPricingConditionType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurgPricingConditionType</b>.
     * <p>
     * If the navigation property <b>to_PurgPricingConditionType</b> of a queried <b>PurgPricingProcedureItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgPricingConditionType</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgPricingConditionType getPurgPricingConditionTypeOrFetch()
    {
        if( toPurgPricingConditionType == null ) {
            toPurgPricingConditionType = fetchPurgPricingConditionType();
        }
        return toPurgPricingConditionType;
    }

    /**
     * Retrieval of associated <b>PurgPricingConditionType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_PurgPricingConditionType</b>.
     * <p>
     * If the navigation property for an entity <b>PurgPricingProcedureItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgPricingConditionType</b> is already loaded, the
     *         result will contain the <b>PurgPricingConditionType</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurgPricingConditionType> getPurgPricingConditionTypeIfPresent()
    {
        return Option.of(toPurgPricingConditionType);
    }

    /**
     * Overwrites the associated <b>PurgPricingConditionType</b> entity for the loaded navigation property
     * <b>to_PurgPricingConditionType</b>.
     *
     * @param value
     *            New <b>PurgPricingConditionType</b> entity.
     */
    public void setPurgPricingConditionType( final PurgPricingConditionType value )
    {
        toPurgPricingConditionType = value;
    }

    /**
     * Fetches the <b>PurgPricingProcedure</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_PurgPricingProcedure</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PurgPricingProcedure</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgPricingProcedure fetchPurgPricingProcedure()
    {
        return fetchFieldAsSingle("to_PurgPricingProcedure", PurgPricingProcedure.class);
    }

    /**
     * Retrieval of associated <b>PurgPricingProcedure</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurgPricingProcedure</b>.
     * <p>
     * If the navigation property <b>to_PurgPricingProcedure</b> of a queried <b>PurgPricingProcedureItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgPricingProcedure</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PurgPricingProcedure getPurgPricingProcedureOrFetch()
    {
        if( toPurgPricingProcedure == null ) {
            toPurgPricingProcedure = fetchPurgPricingProcedure();
        }
        return toPurgPricingProcedure;
    }

    /**
     * Retrieval of associated <b>PurgPricingProcedure</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_PurgPricingProcedure</b>.
     * <p>
     * If the navigation property for an entity <b>PurgPricingProcedureItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PurgPricingProcedure</b> is already loaded, the result
     *         will contain the <b>PurgPricingProcedure</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PurgPricingProcedure> getPurgPricingProcedureIfPresent()
    {
        return Option.of(toPurgPricingProcedure);
    }

    /**
     * Overwrites the associated <b>PurgPricingProcedure</b> entity for the loaded navigation property
     * <b>to_PurgPricingProcedure</b>.
     *
     * @param value
     *            New <b>PurgPricingProcedure</b> entity.
     */
    public void setPurgPricingProcedure( final PurgPricingProcedure value )
    {
        toPurgPricingProcedure = value;
    }

    /**
     * Fetches the <b>PurgPrcgProcedItemText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PurgPrcgProcedItemText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgPrcgProcedItemText> fetchText()
    {
        return fetchFieldAsList("to_Text", PurgPrcgProcedItemText.class);
    }

    /**
     * Retrieval of associated <b>PurgPrcgProcedItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>PurgPricingProcedureItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PurgPrcgProcedItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PurgPrcgProcedItemText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>PurgPrcgProcedItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>PurgPricingProcedureItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>PurgPrcgProcedItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PurgPrcgProcedItemText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>PurgPrcgProcedItemText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>PurgPricingProcedureItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PurgPrcgProcedItemText</b> entities.
     */
    public void setText( @Nonnull final List<PurgPrcgProcedItemText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PurgPrcgProcedItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>PurgPricingProcedureItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PurgPrcgProcedItemText</b> entities.
     */
    public void addText( PurgPrcgProcedItemText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PurgPricingProcedureItem instances.
     *
     */
    public final static class PurgPricingProcedureItemBuilder
    {

        private PurgPricingConditionType toPurgPricingConditionType;
        private PurgPricingProcedure toPurgPricingProcedure;
        private List<PurgPrcgProcedItemText> toText = Lists.newArrayList();

        private PurgPricingProcedureItem.PurgPricingProcedureItemBuilder toPurgPricingConditionType(
            final PurgPricingConditionType value )
        {
            toPurgPricingConditionType = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurgPricingConditionType</b> for <b>PurgPricingProcedureItem</b> to single
         * <b>PurgPricingConditionType</b>.
         *
         * @param value
         *            The PurgPricingConditionType to build this PurgPricingProcedureItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgPricingProcedureItem.PurgPricingProcedureItemBuilder purgPricingConditionType(
            final PurgPricingConditionType value )
        {
            return toPurgPricingConditionType(value);
        }

        private PurgPricingProcedureItem.PurgPricingProcedureItemBuilder toPurgPricingProcedure(
            final PurgPricingProcedure value )
        {
            toPurgPricingProcedure = value;
            return this;
        }

        /**
         * Navigation property <b>to_PurgPricingProcedure</b> for <b>PurgPricingProcedureItem</b> to single
         * <b>PurgPricingProcedure</b>.
         *
         * @param value
         *            The PurgPricingProcedure to build this PurgPricingProcedureItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgPricingProcedureItem.PurgPricingProcedureItemBuilder purgPricingProcedure(
            final PurgPricingProcedure value )
        {
            return toPurgPricingProcedure(value);
        }

        private PurgPricingProcedureItem.PurgPricingProcedureItemBuilder toText(
            final List<PurgPrcgProcedItemText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>PurgPricingProcedureItem</b> to multiple
         * <b>PurgPrcgProcedItemText</b>.
         *
         * @param value
         *            The PurgPrcgProcedItemTexts to build this PurgPricingProcedureItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PurgPricingProcedureItem.PurgPricingProcedureItemBuilder text( PurgPrcgProcedItemText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
