/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PricingProcedureInPurchasingServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInPurchasingService
 * PricingProcedureInPurchasingService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultPricingProcedureInPurchasingServiceBatch
    extends
    BatchFluentHelperBasic<PricingProcedureInPurchasingServiceBatch, PricingProcedureInPurchasingServiceBatchChangeSet>
    implements
    PricingProcedureInPurchasingServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInPurchasingService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPricingProcedureInPurchasingServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPricingProcedureInPurchasingServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInPurchasingService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInPurchasingService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPricingProcedureInPurchasingServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPricingProcedureInPurchasingServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInPurchasingService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPricingProcedureInPurchasingServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PricingProcedureInPurchasingServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPricingProcedureInPurchasingServiceBatchChangeSet(this, service);
    }

}
