/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link PricingProcedureInPurchasingServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInPurchasingService
 * PricingProcedureInPurchasingService}.
 *
 */
public class DefaultPricingProcedureInPurchasingServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PricingProcedureInPurchasingServiceBatch, PricingProcedureInPurchasingServiceBatchChangeSet>
    implements
    PricingProcedureInPurchasingServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInPurchasingService service;

    @SuppressWarnings( "deprecation" )
    DefaultPricingProcedureInPurchasingServiceBatchChangeSet(
        @Nonnull final DefaultPricingProcedureInPurchasingServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInPurchasingService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPricingProcedureInPurchasingServiceBatchChangeSet getThis()
    {
        return this;
    }

}
