/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPrcgProcedItemText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPrcgProcedItemText
 * PurgPrcgProcedItemText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.field.PurgPrcgProcedItemTextField
 * PurgPrcgProcedItemTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.link.PurgPrcgProcedItemTextLink
 * PurgPrcgProcedItemTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPrcgProcedItemText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPrcgProcedItemText#CONDITION_USAGE
 * CONDITION_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPrcgProcedItemText#CONDITION_APPLICATION
 * CONDITION_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPrcgProcedItemText#PRICING_PROCEDURE
 * PRICING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPrcgProcedItemText#PRICING_PROCEDURE_STEP
 * PRICING_PROCEDURE_STEP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPrcgProcedItemText#PRICING_PROCEDURE_COUNTER
 * PRICING_PROCEDURE_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPrcgProcedItemText#CONDITION_TYPE_NAME
 * CONDITION_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPrcgProcedItemText#TO_PURG_PRICING_PROCEDURE
 * TO_PURG_PRICING_PROCEDURE}</li>
 * </ul>
 *
 */
public interface PurgPrcgProcedItemTextSelectable extends EntitySelectable<PurgPrcgProcedItemText>
{

}
