/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPricingProcedure;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPricingProcedure
 * PurgPricingProcedure}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.field.PurgPricingProcedureField
 * PurgPricingProcedureField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.link.PurgPricingProcedureLink
 * PurgPricingProcedureLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPricingProcedure#CONDITION_USAGE
 * CONDITION_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPricingProcedure#CONDITION_APPLICATION
 * CONDITION_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPricingProcedure#PRICING_PROCEDURE
 * PRICING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPricingProcedure#TO_PURG_PRICING_PROCEDURE_ITEM
 * TO_PURG_PRICING_PROCEDURE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPricingProcedure#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface PurgPricingProcedureSelectable extends EntitySelectable<PurgPricingProcedure>
{

}
