/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPricingProcedureText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPricingProcedureText
 * PurgPricingProcedureText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.field.PurgPricingProcedureTextField
 * PurgPricingProcedureTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.link.PurgPricingProcedureTextLink
 * PurgPricingProcedureTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPricingProcedureText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPricingProcedureText#CONDITION_USAGE
 * CONDITION_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPricingProcedureText#CONDITION_APPLICATION
 * CONDITION_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPricingProcedureText#PRICING_PROCEDURE
 * PRICING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPricingProcedureText#PRICING_PROCEDURE_NAME
 * PRICING_PROCEDURE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinpurchasing.PurgPricingProcedureText#TO_PURG_PRICING_PROCEDURE
 * TO_PURG_PRICING_PROCEDURE}</li>
 * </ul>
 *
 */
public interface PurgPricingProcedureTextSelectable extends EntitySelectable<PurgPricingProcedureText>
{

}
