/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.field.SlsPrcgCndnTypeTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.link.SlsPrcgCndnTypeTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.selectable.SlsPrcgCndnTypeTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Condition Type Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SlsPrcgCndnTypeTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SlsPrcgCndnTypeText extends VdmEntity<SlsPrcgCndnTypeText>
{

    /**
     * Selector for all available fields of SlsPrcgCndnTypeText.
     *
     */
    public final static SlsPrcgCndnTypeTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnTypeTextField<String> LANGUAGE = new SlsPrcgCndnTypeTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     *
     * @return Usage of the condition table
     */
    @Key
    @SerializedName( "ConditionUsage" )
    @JsonProperty( "ConditionUsage" )
    @Nullable
    @ODataField( odataName = "ConditionUsage" )
    private String conditionUsage;
    /**
     * Use with available fluent helpers to apply the <b>ConditionUsage</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnTypeTextField<String> CONDITION_USAGE =
        new SlsPrcgCndnTypeTextField<String>("ConditionUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @return Application
     */
    @Key
    @SerializedName( "ConditionApplication" )
    @JsonProperty( "ConditionApplication" )
    @Nullable
    @ODataField( odataName = "ConditionApplication" )
    private String conditionApplication;
    /**
     * Use with available fluent helpers to apply the <b>ConditionApplication</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnTypeTextField<String> CONDITION_APPLICATION =
        new SlsPrcgCndnTypeTextField<String>("ConditionApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @return Condition Type
     */
    @Key
    @SerializedName( "ConditionType" )
    @JsonProperty( "ConditionType" )
    @Nullable
    @ODataField( odataName = "ConditionType" )
    private String conditionType;
    /**
     * Use with available fluent helpers to apply the <b>ConditionType</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnTypeTextField<String> CONDITION_TYPE =
        new SlsPrcgCndnTypeTextField<String>("ConditionType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTypeName</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "ConditionTypeName" )
    @JsonProperty( "ConditionTypeName" )
    @Nullable
    @ODataField( odataName = "ConditionTypeName" )
    private String conditionTypeName;
    /**
     * Use with available fluent helpers to apply the <b>ConditionTypeName</b> field to query operations.
     *
     */
    public final static SlsPrcgCndnTypeTextField<String> CONDITION_TYPE_NAME =
        new SlsPrcgCndnTypeTextField<String>("ConditionTypeName");
    /**
     * Navigation property <b>to_SlsPricingConditionType</b> for <b>SlsPrcgCndnTypeText</b> to single
     * <b>SlsPricingConditionType</b>.
     *
     */
    @SerializedName( "to_SlsPricingConditionType" )
    @JsonProperty( "to_SlsPricingConditionType" )
    @ODataField( odataName = "to_SlsPricingConditionType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SlsPricingConditionType toSlsPricingConditionType;
    /**
     * Use with available fluent helpers to apply the <b>to_SlsPricingConditionType</b> navigation property to query
     * operations.
     *
     */
    public final static SlsPrcgCndnTypeTextOneToOneLink<SlsPricingConditionType> TO_SLS_PRICING_CONDITION_TYPE =
        new SlsPrcgCndnTypeTextOneToOneLink<SlsPricingConditionType>("to_SlsPricingConditionType");

    @Nonnull
    @Override
    public Class<SlsPrcgCndnTypeText> getType()
    {
        return SlsPrcgCndnTypeText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     *
     * @param conditionUsage
     *            Usage of the condition table
     */
    public void setConditionUsage( @Nullable final String conditionUsage )
    {
        rememberChangedField("ConditionUsage", this.conditionUsage);
        this.conditionUsage = conditionUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ConditionType</b>
     * </p>
     *
     * @param conditionType
     *            Condition Type
     */
    public void setConditionType( @Nullable final String conditionType )
    {
        rememberChangedField("ConditionType", this.conditionType);
        this.conditionType = conditionType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConditionTypeName</b>
     * </p>
     *
     * @param conditionTypeName
     *            Description
     */
    public void setConditionTypeName( @Nullable final String conditionTypeName )
    {
        rememberChangedField("ConditionTypeName", this.conditionTypeName);
        this.conditionTypeName = conditionTypeName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SlsPrcgCndnTypeText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("ConditionUsage", getConditionUsage());
        result.put("ConditionApplication", getConditionApplication());
        result.put("ConditionType", getConditionType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ConditionUsage", getConditionUsage());
        values.put("ConditionApplication", getConditionApplication());
        values.put("ConditionType", getConditionType());
        values.put("ConditionTypeName", getConditionTypeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConditionUsage") ) {
                final Object value = values.remove("ConditionUsage");
                if( (value == null) || (!value.equals(getConditionUsage())) ) {
                    setConditionUsage(((String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((String) value));
                }
            }
            if( values.containsKey("ConditionType") ) {
                final Object value = values.remove("ConditionType");
                if( (value == null) || (!value.equals(getConditionType())) ) {
                    setConditionType(((String) value));
                }
            }
            if( values.containsKey("ConditionTypeName") ) {
                final Object value = values.remove("ConditionTypeName");
                if( (value == null) || (!value.equals(getConditionTypeName())) ) {
                    setConditionTypeName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SlsPricingConditionType") ) {
                final Object value = (values).remove("to_SlsPricingConditionType");
                if( value instanceof Map ) {
                    if( toSlsPricingConditionType == null ) {
                        toSlsPricingConditionType = new SlsPricingConditionType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSlsPricingConditionType.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SlsPrcgCndnTypeTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SlsPrcgCndnTypeTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SlsPrcgCndnTypeTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SlsPrcgCndnTypeTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInSalesService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSlsPricingConditionType != null ) {
            (values).put("to_SlsPricingConditionType", toSlsPricingConditionType);
        }
        return values;
    }

    /**
     * Fetches the <b>SlsPricingConditionType</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SlsPricingConditionType</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SlsPricingConditionType</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SlsPricingConditionType fetchSlsPricingConditionType()
    {
        return fetchFieldAsSingle("to_SlsPricingConditionType", SlsPricingConditionType.class);
    }

    /**
     * Retrieval of associated <b>SlsPricingConditionType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SlsPricingConditionType</b>.
     * <p>
     * If the navigation property <b>to_SlsPricingConditionType</b> of a queried <b>SlsPrcgCndnTypeText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsPricingConditionType</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SlsPricingConditionType getSlsPricingConditionTypeOrFetch()
    {
        if( toSlsPricingConditionType == null ) {
            toSlsPricingConditionType = fetchSlsPricingConditionType();
        }
        return toSlsPricingConditionType;
    }

    /**
     * Retrieval of associated <b>SlsPricingConditionType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SlsPricingConditionType</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPrcgCndnTypeText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SlsPricingConditionType</b> is already loaded, the
     *         result will contain the <b>SlsPricingConditionType</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SlsPricingConditionType> getSlsPricingConditionTypeIfPresent()
    {
        return Option.of(toSlsPricingConditionType);
    }

    /**
     * Overwrites the associated <b>SlsPricingConditionType</b> entity for the loaded navigation property
     * <b>to_SlsPricingConditionType</b>.
     *
     * @param value
     *            New <b>SlsPricingConditionType</b> entity.
     */
    public void setSlsPricingConditionType( final SlsPricingConditionType value )
    {
        toSlsPricingConditionType = value;
    }

    /**
     * Helper class to allow for fluent creation of SlsPrcgCndnTypeText instances.
     *
     */
    public final static class SlsPrcgCndnTypeTextBuilder
    {

        private SlsPricingConditionType toSlsPricingConditionType;

        private SlsPrcgCndnTypeText.SlsPrcgCndnTypeTextBuilder toSlsPricingConditionType(
            final SlsPricingConditionType value )
        {
            toSlsPricingConditionType = value;
            return this;
        }

        /**
         * Navigation property <b>to_SlsPricingConditionType</b> for <b>SlsPrcgCndnTypeText</b> to single
         * <b>SlsPricingConditionType</b>.
         *
         * @param value
         *            The SlsPricingConditionType to build this SlsPrcgCndnTypeText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPrcgCndnTypeText.SlsPrcgCndnTypeTextBuilder slsPricingConditionType(
            final SlsPricingConditionType value )
        {
            return toSlsPricingConditionType(value);
        }

    }

}
