/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.selectable.SlsPrcgProcedItemTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPrcgProcedItemText
 * SlsPrcgProcedItemText} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class SlsPrcgProcedItemTextByKeyFluentHelper
    extends
    FluentHelperByKey<SlsPrcgProcedItemTextByKeyFluentHelper, SlsPrcgProcedItemText, SlsPrcgProcedItemTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPrcgProcedItemText
     * SlsPrcgProcedItemText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SlsPrcgProcedItemText}
     * @param pricingProcedureCounter
     *            Condition Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SlsPrcgProcedItemText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param pricingProcedureStep
     *            Step Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 3
     *            </p>
     * @param conditionUsage
     *            Usage of the condition table
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param conditionApplication
     *            Application
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param pricingProcedure
     *            Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public SlsPrcgProcedItemTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String language,
        final String conditionUsage,
        final String conditionApplication,
        final String pricingProcedure,
        final String pricingProcedureStep,
        final String pricingProcedureCounter )
    {
        super(servicePath, entityCollection);
        this.key.put("Language", language);
        this.key.put("ConditionUsage", conditionUsage);
        this.key.put("ConditionApplication", conditionApplication);
        this.key.put("PricingProcedure", pricingProcedure);
        this.key.put("PricingProcedureStep", pricingProcedureStep);
        this.key.put("PricingProcedureCounter", pricingProcedureCounter);
    }

    @Override
    @Nonnull
    protected Class<SlsPrcgProcedItemText> getEntityClass()
    {
        return SlsPrcgProcedItemText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
