/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.field.SlsPricingProcedureField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.link.SlsPricingProcedureLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.selectable.SlsPricingProcedureSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Pricing Procedures
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SlsPricingProcedureType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SlsPricingProcedure extends VdmEntity<SlsPricingProcedure>
{

    /**
     * Selector for all available fields of SlsPricingProcedure.
     *
     */
    public final static SlsPricingProcedureSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     *
     * @return Usage of the condition table
     */
    @Key
    @SerializedName( "ConditionUsage" )
    @JsonProperty( "ConditionUsage" )
    @Nullable
    @ODataField( odataName = "ConditionUsage" )
    private String conditionUsage;
    /**
     * Use with available fluent helpers to apply the <b>ConditionUsage</b> field to query operations.
     *
     */
    public final static SlsPricingProcedureField<String> CONDITION_USAGE =
        new SlsPricingProcedureField<String>("ConditionUsage");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @return Application
     */
    @Key
    @SerializedName( "ConditionApplication" )
    @JsonProperty( "ConditionApplication" )
    @Nullable
    @ODataField( odataName = "ConditionApplication" )
    private String conditionApplication;
    /**
     * Use with available fluent helpers to apply the <b>ConditionApplication</b> field to query operations.
     *
     */
    public final static SlsPricingProcedureField<String> CONDITION_APPLICATION =
        new SlsPricingProcedureField<String>("ConditionApplication");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedure</b>
     * </p>
     *
     * @return Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    @Key
    @SerializedName( "PricingProcedure" )
    @JsonProperty( "PricingProcedure" )
    @Nullable
    @ODataField( odataName = "PricingProcedure" )
    private String pricingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>PricingProcedure</b> field to query operations.
     *
     */
    public final static SlsPricingProcedureField<String> PRICING_PROCEDURE =
        new SlsPricingProcedureField<String>("PricingProcedure");
    /**
     * Navigation property <b>to_SalesPricingProcedureItem</b> for <b>SlsPricingProcedure</b> to multiple
     * <b>SlsPricingProcedureItem</b>.
     *
     */
    @SerializedName( "to_SalesPricingProcedureItem" )
    @JsonProperty( "to_SalesPricingProcedureItem" )
    @ODataField( odataName = "to_SalesPricingProcedureItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsPricingProcedureItem> toSalesPricingProcedureItem;
    /**
     * Navigation property <b>to_Text</b> for <b>SlsPricingProcedure</b> to multiple <b>SlsPricingProcedureText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsPricingProcedureText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesPricingProcedureItem</b> navigation property to query
     * operations.
     *
     */
    public final static SlsPricingProcedureLink<SlsPricingProcedureItem> TO_SALES_PRICING_PROCEDURE_ITEM =
        new SlsPricingProcedureLink<SlsPricingProcedureItem>("to_SalesPricingProcedureItem");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static SlsPricingProcedureLink<SlsPricingProcedureText> TO_TEXT =
        new SlsPricingProcedureLink<SlsPricingProcedureText>("to_Text");

    @Nonnull
    @Override
    public Class<SlsPricingProcedure> getType()
    {
        return SlsPricingProcedure.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ConditionUsage</b>
     * </p>
     *
     * @param conditionUsage
     *            Usage of the condition table
     */
    public void setConditionUsage( @Nullable final String conditionUsage )
    {
        rememberChangedField("ConditionUsage", this.conditionUsage);
        this.conditionUsage = conditionUsage;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConditionApplication</b>
     * </p>
     *
     * @param conditionApplication
     *            Application
     */
    public void setConditionApplication( @Nullable final String conditionApplication )
    {
        rememberChangedField("ConditionApplication", this.conditionApplication);
        this.conditionApplication = conditionApplication;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PricingProcedure</b>
     * </p>
     *
     * @param pricingProcedure
     *            Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    public void setPricingProcedure( @Nullable final String pricingProcedure )
    {
        rememberChangedField("PricingProcedure", this.pricingProcedure);
        this.pricingProcedure = pricingProcedure;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SlsPricingProcedure";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConditionUsage", getConditionUsage());
        result.put("ConditionApplication", getConditionApplication());
        result.put("PricingProcedure", getPricingProcedure());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConditionUsage", getConditionUsage());
        values.put("ConditionApplication", getConditionApplication());
        values.put("PricingProcedure", getPricingProcedure());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConditionUsage") ) {
                final Object value = values.remove("ConditionUsage");
                if( (value == null) || (!value.equals(getConditionUsage())) ) {
                    setConditionUsage(((String) value));
                }
            }
            if( values.containsKey("ConditionApplication") ) {
                final Object value = values.remove("ConditionApplication");
                if( (value == null) || (!value.equals(getConditionApplication())) ) {
                    setConditionApplication(((String) value));
                }
            }
            if( values.containsKey("PricingProcedure") ) {
                final Object value = values.remove("PricingProcedure");
                if( (value == null) || (!value.equals(getPricingProcedure())) ) {
                    setPricingProcedure(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesPricingProcedureItem") ) {
                final Object value = (values).remove("to_SalesPricingProcedureItem");
                if( value instanceof Iterable ) {
                    if( toSalesPricingProcedureItem == null ) {
                        toSalesPricingProcedureItem = Lists.newArrayList();
                    } else {
                        toSalesPricingProcedureItem = Lists.newArrayList(toSalesPricingProcedureItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsPricingProcedureItem entity;
                        if( toSalesPricingProcedureItem.size() > i ) {
                            entity = toSalesPricingProcedureItem.get(i);
                        } else {
                            entity = new SlsPricingProcedureItem();
                            toSalesPricingProcedureItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsPricingProcedureText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new SlsPricingProcedureText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SlsPricingProcedureField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SlsPricingProcedureField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SlsPricingProcedureField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SlsPricingProcedureField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInSalesService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesPricingProcedureItem != null ) {
            (values).put("to_SalesPricingProcedureItem", toSalesPricingProcedureItem);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>SlsPricingProcedureItem</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SalesPricingProcedureItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SlsPricingProcedureItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsPricingProcedureItem> fetchSalesPricingProcedureItem()
    {
        return fetchFieldAsList("to_SalesPricingProcedureItem", SlsPricingProcedureItem.class);
    }

    /**
     * Retrieval of associated <b>SlsPricingProcedureItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SalesPricingProcedureItem</b>.
     * <p>
     * If the navigation property <b>to_SalesPricingProcedureItem</b> of a queried <b>SlsPricingProcedure</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsPricingProcedureItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsPricingProcedureItem> getSalesPricingProcedureItemOrFetch()
    {
        if( toSalesPricingProcedureItem == null ) {
            toSalesPricingProcedureItem = fetchSalesPricingProcedureItem();
        }
        return toSalesPricingProcedureItem;
    }

    /**
     * Retrieval of associated <b>SlsPricingProcedureItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SalesPricingProcedureItem</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPricingProcedure</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesPricingProcedureItem</b> is already loaded, the
     *         result will contain the <b>SlsPricingProcedureItem</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsPricingProcedureItem>> getSalesPricingProcedureItemIfPresent()
    {
        return Option.of(toSalesPricingProcedureItem);
    }

    /**
     * Overwrites the list of associated <b>SlsPricingProcedureItem</b> entities for the loaded navigation property
     * <b>to_SalesPricingProcedureItem</b>.
     * <p>
     * If the navigation property <b>to_SalesPricingProcedureItem</b> of a queried <b>SlsPricingProcedure</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SlsPricingProcedureItem</b> entities.
     */
    public void setSalesPricingProcedureItem( @Nonnull final List<SlsPricingProcedureItem> value )
    {
        if( toSalesPricingProcedureItem == null ) {
            toSalesPricingProcedureItem = Lists.newArrayList();
        }
        toSalesPricingProcedureItem.clear();
        toSalesPricingProcedureItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsPricingProcedureItem</b> entities. This corresponds to the OData
     * navigation property <b>to_SalesPricingProcedureItem</b>.
     * <p>
     * If the navigation property <b>to_SalesPricingProcedureItem</b> of a queried <b>SlsPricingProcedure</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SlsPricingProcedureItem</b> entities.
     */
    public void addSalesPricingProcedureItem( SlsPricingProcedureItem... entity )
    {
        if( toSalesPricingProcedureItem == null ) {
            toSalesPricingProcedureItem = Lists.newArrayList();
        }
        toSalesPricingProcedureItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SlsPricingProcedureText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SlsPricingProcedureText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsPricingProcedureText> fetchText()
    {
        return fetchFieldAsList("to_Text", SlsPricingProcedureText.class);
    }

    /**
     * Retrieval of associated <b>SlsPricingProcedureText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SlsPricingProcedure</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsPricingProcedureText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsPricingProcedureText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>SlsPricingProcedureText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>SlsPricingProcedure</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>SlsPricingProcedureText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsPricingProcedureText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>SlsPricingProcedureText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SlsPricingProcedure</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SlsPricingProcedureText</b> entities.
     */
    public void setText( @Nonnull final List<SlsPricingProcedureText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsPricingProcedureText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SlsPricingProcedure</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SlsPricingProcedureText</b> entities.
     */
    public void addText( SlsPricingProcedureText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SlsPricingProcedure instances.
     *
     */
    public final static class SlsPricingProcedureBuilder
    {

        private List<SlsPricingProcedureItem> toSalesPricingProcedureItem = Lists.newArrayList();
        private List<SlsPricingProcedureText> toText = Lists.newArrayList();

        private SlsPricingProcedure.SlsPricingProcedureBuilder toSalesPricingProcedureItem(
            final List<SlsPricingProcedureItem> value )
        {
            toSalesPricingProcedureItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SalesPricingProcedureItem</b> for <b>SlsPricingProcedure</b> to multiple
         * <b>SlsPricingProcedureItem</b>.
         *
         * @param value
         *            The SlsPricingProcedureItems to build this SlsPricingProcedure with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPricingProcedure.SlsPricingProcedureBuilder salesPricingProcedureItem(
            SlsPricingProcedureItem... value )
        {
            return toSalesPricingProcedureItem(Lists.newArrayList(value));
        }

        private SlsPricingProcedure.SlsPricingProcedureBuilder toText( final List<SlsPricingProcedureText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>SlsPricingProcedure</b> to multiple <b>SlsPricingProcedureText</b>.
         *
         * @param value
         *            The SlsPricingProcedureTexts to build this SlsPricingProcedure with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsPricingProcedure.SlsPricingProcedureBuilder text( SlsPricingProcedureText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
