/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.selectable.SlsPricingProcedureSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedure
 * SlsPricingProcedure} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class SlsPricingProcedureByKeyFluentHelper
    extends
    FluentHelperByKey<SlsPricingProcedureByKeyFluentHelper, SlsPricingProcedure, SlsPricingProcedureSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedure
     * SlsPricingProcedure} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SlsPricingProcedure}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SlsPricingProcedure}
     * @param conditionUsage
     *            Usage of the condition table
     *            <p>
     *            Constraints: Not nullable, Maximum length: 1
     *            </p>
     * @param conditionApplication
     *            Application
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param pricingProcedure
     *            Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public SlsPricingProcedureByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String conditionUsage,
        final String conditionApplication,
        final String pricingProcedure )
    {
        super(servicePath, entityCollection);
        this.key.put("ConditionUsage", conditionUsage);
        this.key.put("ConditionApplication", conditionApplication);
        this.key.put("PricingProcedure", pricingProcedure);
    }

    @Override
    @Nonnull
    protected Class<SlsPricingProcedure> getEntityClass()
    {
        return SlsPricingProcedure.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
