/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperRead;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.selectable.SlsPricingProcedureTextSelectable;

/**
 * Fluent helper to fetch multiple
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureText
 * SlsPricingProcedureText} entities. This fluent helper allows methods which modify the underlying query to be called
 * before executing the query itself.
 *
 */
public class SlsPricingProcedureTextFluentHelper
    extends
    FluentHelperRead<SlsPricingProcedureTextFluentHelper, SlsPricingProcedureText, SlsPricingProcedureTextSelectable>
{

    /**
     * Creates a fluent helper using the specified service path and entity collection to send the read requests.
     *
     * @param entityCollection
     *            The entity collection to direct the requests to.
     * @param servicePath
     *            The service path to direct the read requests to.
     */
    public SlsPricingProcedureTextFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
    }

    @Override
    @Nonnull
    protected Class<SlsPricingProcedureText> getEntityClass()
    {
        return SlsPricingProcedureText.class;
    }

}
