/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PricingProcedureInSalesServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInSalesService
 * PricingProcedureInSalesService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPricingProcedureInSalesServiceBatch
    extends
    BatchFluentHelperBasic<PricingProcedureInSalesServiceBatch, PricingProcedureInSalesServiceBatchChangeSet>
    implements
    PricingProcedureInSalesServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInSalesService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPricingProcedureInSalesServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPricingProcedureInSalesServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInSalesService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInSalesService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPricingProcedureInSalesServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPricingProcedureInSalesServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInSalesService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPricingProcedureInSalesServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PricingProcedureInSalesServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPricingProcedureInSalesServiceBatchChangeSet(this, service);
    }

}
