/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link PricingProcedureInSalesServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInSalesService
 * PricingProcedureInSalesService}.
 *
 */
public class DefaultPricingProcedureInSalesServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PricingProcedureInSalesServiceBatch, PricingProcedureInSalesServiceBatchChangeSet>
    implements
    PricingProcedureInSalesServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInSalesService service;

    @SuppressWarnings( "deprecation" )
    DefaultPricingProcedureInSalesServiceBatchChangeSet(
        @Nonnull final DefaultPricingProcedureInSalesServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PricingProcedureInSalesService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPricingProcedureInSalesServiceBatchChangeSet getThis()
    {
        return this;
    }

}
