/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPrcgCndnTypeText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPrcgCndnTypeText
 * SlsPrcgCndnTypeText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.field.SlsPrcgCndnTypeTextField
 * SlsPrcgCndnTypeTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.link.SlsPrcgCndnTypeTextLink
 * SlsPrcgCndnTypeTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPrcgCndnTypeText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPrcgCndnTypeText#CONDITION_USAGE
 * CONDITION_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPrcgCndnTypeText#CONDITION_APPLICATION
 * CONDITION_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPrcgCndnTypeText#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPrcgCndnTypeText#CONDITION_TYPE_NAME
 * CONDITION_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPrcgCndnTypeText#TO_SLS_PRICING_CONDITION_TYPE
 * TO_SLS_PRICING_CONDITION_TYPE}</li>
 * </ul>
 *
 */
public interface SlsPrcgCndnTypeTextSelectable extends EntitySelectable<SlsPrcgCndnTypeText>
{

}
