/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem
 * SlsPricingProcedureItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.field.SlsPricingProcedureItemField
 * SlsPricingProcedureItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.link.SlsPricingProcedureItemLink
 * SlsPricingProcedureItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#CONDITION_USAGE
 * CONDITION_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#CONDITION_APPLICATION
 * CONDITION_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#PRICING_PROCEDURE
 * PRICING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#PRICING_PROCEDURE_STEP
 * PRICING_PROCEDURE_STEP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#PRICING_PROCEDURE_COUNTER
 * PRICING_PROCEDURE_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#CONDITION_TYPE
 * CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#PRCG_PROCED_ITEM_FROM_REF_STEP
 * PRCG_PROCED_ITEM_FROM_REF_STEP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#PRCG_PROCED_ITEM_TO_REF_STEP
 * PRCG_PROCED_ITEM_TO_REF_STEP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#CONDITION_IS_MANUALLY_DTMND
 * CONDITION_IS_MANUALLY_DTMND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#PRCG_PROCED_ITEM_SUBTOTAL
 * PRCG_PROCED_ITEM_SUBTOTAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#CONDITION_IS_FOR_STATISTICS
 * CONDITION_IS_FOR_STATISTICS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#ACCOUNT_KEY_FOR_GL_ACCOUNT
 * ACCOUNT_KEY_FOR_GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#ACCT_KEY_FOR_ACCRUALS_GL_ACCOUNT
 * ACCT_KEY_FOR_ACCRUALS_GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#PRICING_PROCEDURE_ITEM_PRINT_TYPE
 * PRICING_PROCEDURE_ITEM_PRINT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#CONDITION_IS_MANDATORY
 * CONDITION_IS_MANDATORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#CNDN_IS_ACCT_DETN_RELEVANT
 * CNDN_IS_ACCT_DETN_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#PRICE_ELEMENT_ACCESS_LEVEL
 * PRICE_ELEMENT_ACCESS_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#TO_SALES_PRICING_PROCEDURE
 * TO_SALES_PRICING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#TO_SLS_PRICING_CONDITION_TYPE
 * TO_SLS_PRICING_CONDITION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureItem#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface SlsPricingProcedureItemSelectable extends EntitySelectable<SlsPricingProcedureItem>
{

}
