/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureText
 * SlsPricingProcedureText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.field.SlsPricingProcedureTextField
 * SlsPricingProcedureTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.link.SlsPricingProcedureTextLink
 * SlsPricingProcedureTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureText#CONDITION_USAGE
 * CONDITION_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureText#CONDITION_APPLICATION
 * CONDITION_APPLICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureText#PRICING_PROCEDURE
 * PRICING_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureText#PRICING_PROCEDURE_NAME
 * PRICING_PROCEDURE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.pricingprocedureinsales.SlsPricingProcedureText#TO_SALES_PRICING_PROCEDURE
 * TO_SALES_PRICING_PROCEDURE}</li>
 * </ul>
 *
 */
public interface SlsPricingProcedureTextSelectable extends EntitySelectable<SlsPricingProcedureText>
{

}
