/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.field.IcmCacheResultField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.selectable.IcmCacheResultSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>IcmCacheResult</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class IcmCacheResult extends VdmEntity<IcmCacheResult>
{

    /**
     * Selector for all available fields of IcmCacheResult.
     *
     */
    public final static IcmCacheResultSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>url</b>
     * </p>
     *
     * @return The url contained in this entity.
     */
    @Key
    @SerializedName( "url" )
    @JsonProperty( "url" )
    @Nullable
    @ODataField( odataName = "url" )
    private String url;
    /**
     * Use with available fluent helpers to apply the <b>url</b> field to query operations.
     *
     */
    public final static IcmCacheResultField<String> URL = new IcmCacheResultField<String>("url");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>content</b>
     * </p>
     *
     * @return The content contained in this entity.
     */
    @SerializedName( "content" )
    @JsonProperty( "content" )
    @Nullable
    @ODataField( odataName = "content" )
    private String content;
    /**
     * Use with available fluent helpers to apply the <b>content</b> field to query operations.
     *
     */
    public final static IcmCacheResultField<String> CONTENT = new IcmCacheResultField<String>("content");

    @Nonnull
    @Override
    public Class<IcmCacheResult> getType()
    {
        return IcmCacheResult.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>url</b>
     * </p>
     *
     * @param url
     *            The url to set.
     */
    public void setUrl( @Nullable final String url )
    {
        rememberChangedField("url", this.url);
        this.url = url;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>content</b>
     * </p>
     *
     * @param content
     *            The content to set.
     */
    public void setContent( @Nullable final String content )
    {
        rememberChangedField("content", this.content);
        this.content = content;
    }

    @Override
    protected String getEntityCollection()
    {
        return "IcmCacheResultCollection";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("url", getUrl());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("url", getUrl());
        values.put("content", getContent());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("url") ) {
                final Object value = values.remove("url");
                if( (value == null) || (!value.equals(getUrl())) ) {
                    setUrl(((String) value));
                }
            }
            if( values.containsKey("content") ) {
                final Object value = values.remove("content");
                if( (value == null) || (!value.equals(getContent())) ) {
                    setContent(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> IcmCacheResultField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new IcmCacheResultField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> IcmCacheResultField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new IcmCacheResultField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PrintQueueItemService.DEFAULT_SERVICE_PATH);
    }

}
