/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.field.PrintDocumentBlobField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.selectable.PrintDocumentBlobSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>PrintDocumentBlob</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PrintDocumentBlob extends VdmEntity<PrintDocumentBlob>
{

    /**
     * Selector for all available fields of PrintDocumentBlob.
     *
     */
    public final static PrintDocumentBlobSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CountId</b>
     * </p>
     *
     * @return Attachment counter
     */
    @SerializedName( "CountId" )
    @JsonProperty( "CountId" )
    @Nullable
    @ODataField( odataName = "CountId" )
    private Short countId;
    /**
     * Use with available fluent helpers to apply the <b>CountId</b> field to query operations.
     *
     */
    public final static PrintDocumentBlobField<Short> COUNT_ID = new PrintDocumentBlobField<Short>("CountId");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 120
     * <p>
     * Original property name from the Odata EDM: <b>DocumentName</b>
     * </p>
     *
     * @return Documen Name
     */
    @Key
    @SerializedName( "DocumentName" )
    @JsonProperty( "DocumentName" )
    @Nullable
    @ODataField( odataName = "DocumentName" )
    private String documentName;
    /**
     * Use with available fluent helpers to apply the <b>DocumentName</b> field to query operations.
     *
     */
    public final static PrintDocumentBlobField<String> DOCUMENT_NAME =
        new PrintDocumentBlobField<String>("DocumentName");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Filesize</b>
     * </p>
     *
     * @return Document Size
     */
    @SerializedName( "Filesize" )
    @JsonProperty( "Filesize" )
    @Nullable
    @ODataField( odataName = "Filesize" )
    private String filesize;
    /**
     * Use with available fluent helpers to apply the <b>Filesize</b> field to query operations.
     *
     */
    public final static PrintDocumentBlobField<String> FILESIZE = new PrintDocumentBlobField<String>("Filesize");
    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>Url</b>
     * </p>
     *
     * @return Document URL
     */
    @SerializedName( "Url" )
    @JsonProperty( "Url" )
    @Nullable
    @ODataField( odataName = "Url" )
    private String url;
    /**
     * Use with available fluent helpers to apply the <b>Url</b> field to query operations.
     *
     */
    public final static PrintDocumentBlobField<String> URL = new PrintDocumentBlobField<String>("Url");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Blob</b>
     * </p>
     *
     * @return The blob contained in this entity.
     */
    @SerializedName( "Blob" )
    @JsonProperty( "Blob" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBinaryAdapter.class )
    @ODataField( odataName = "Blob" )
    private byte[] blob;
    /**
     * Use with available fluent helpers to apply the <b>Blob</b> field to query operations.
     *
     */
    public final static PrintDocumentBlobField<byte[]> BLOB = new PrintDocumentBlobField<byte[]>("Blob");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>QItemParams</b>
     * </p>
     *
     * @return Print Parameter
     */
    @SerializedName( "QItemParams" )
    @JsonProperty( "QItemParams" )
    @Nullable
    @ODataField( odataName = "QItemParams" )
    private String qItemParams;
    /**
     * Use with available fluent helpers to apply the <b>QItemParams</b> field to query operations.
     *
     */
    public final static PrintDocumentBlobField<String> Q_ITEM_PARAMS =
        new PrintDocumentBlobField<String>("QItemParams");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Metadata</b>
     * </p>
     *
     * @return Item metadata
     */
    @SerializedName( "Metadata" )
    @JsonProperty( "Metadata" )
    @Nullable
    @ODataField( odataName = "Metadata" )
    private String metadata;
    /**
     * Use with available fluent helpers to apply the <b>Metadata</b> field to query operations.
     *
     */
    public final static PrintDocumentBlobField<String> METADATA = new PrintDocumentBlobField<String>("Metadata");

    @Nonnull
    @Override
    public Class<PrintDocumentBlob> getType()
    {
        return PrintDocumentBlob.class;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CountId</b>
     * </p>
     *
     * @param countId
     *            Attachment counter
     */
    public void setCountId( @Nullable final Short countId )
    {
        rememberChangedField("CountId", this.countId);
        this.countId = countId;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 120
     * <p>
     * Original property name from the Odata EDM: <b>DocumentName</b>
     * </p>
     *
     * @param documentName
     *            Documen Name
     */
    public void setDocumentName( @Nullable final String documentName )
    {
        rememberChangedField("DocumentName", this.documentName);
        this.documentName = documentName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Filesize</b>
     * </p>
     *
     * @param filesize
     *            Document Size
     */
    public void setFilesize( @Nullable final String filesize )
    {
        rememberChangedField("Filesize", this.filesize);
        this.filesize = filesize;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1333
     * <p>
     * Original property name from the Odata EDM: <b>Url</b>
     * </p>
     *
     * @param url
     *            Document URL
     */
    public void setUrl( @Nullable final String url )
    {
        rememberChangedField("Url", this.url);
        this.url = url;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Blob</b>
     * </p>
     *
     * @param blob
     *            The blob to set.
     */
    public void setBlob( @Nullable final byte[] blob )
    {
        rememberChangedField("Blob", this.blob);
        this.blob = blob;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>QItemParams</b>
     * </p>
     *
     * @param qItemParams
     *            Print Parameter
     */
    public void setQItemParams( @Nullable final String qItemParams )
    {
        rememberChangedField("QItemParams", this.qItemParams);
        this.qItemParams = qItemParams;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Metadata</b>
     * </p>
     *
     * @param metadata
     *            Item metadata
     */
    public void setMetadata( @Nullable final String metadata )
    {
        rememberChangedField("Metadata", this.metadata);
        this.metadata = metadata;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PrintDocumentBlobSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DocumentName", getDocumentName());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CountId", getCountId());
        values.put("DocumentName", getDocumentName());
        values.put("Filesize", getFilesize());
        values.put("Url", getUrl());
        values.put("Blob", getBlob());
        values.put("QItemParams", getQItemParams());
        values.put("Metadata", getMetadata());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CountId") ) {
                final Object value = values.remove("CountId");
                if( (value == null) || (!value.equals(getCountId())) ) {
                    setCountId(((Short) value));
                }
            }
            if( values.containsKey("DocumentName") ) {
                final Object value = values.remove("DocumentName");
                if( (value == null) || (!value.equals(getDocumentName())) ) {
                    setDocumentName(((String) value));
                }
            }
            if( values.containsKey("Filesize") ) {
                final Object value = values.remove("Filesize");
                if( (value == null) || (!value.equals(getFilesize())) ) {
                    setFilesize(((String) value));
                }
            }
            if( values.containsKey("Url") ) {
                final Object value = values.remove("Url");
                if( (value == null) || (!value.equals(getUrl())) ) {
                    setUrl(((String) value));
                }
            }
            if( values.containsKey("Blob") ) {
                final Object value = values.remove("Blob");
                if( (value == null) || (!value.equals(getBlob())) ) {
                    setBlob(((byte[]) value));
                }
            }
            if( values.containsKey("QItemParams") ) {
                final Object value = values.remove("QItemParams");
                if( (value == null) || (!value.equals(getQItemParams())) ) {
                    setQItemParams(((String) value));
                }
            }
            if( values.containsKey("Metadata") ) {
                final Object value = values.remove("Metadata");
                if( (value == null) || (!value.equals(getMetadata())) ) {
                    setMetadata(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PrintDocumentBlobField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PrintDocumentBlobField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PrintDocumentBlobField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PrintDocumentBlobField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PrintQueueItemService.DEFAULT_SERVICE_PATH);
    }

}
