/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.field.PrintQueueInfoField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.selectable.PrintQueueInfoSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>PrintQueueInfo</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PrintQueueInfo extends VdmEntity<PrintQueueInfo>
{

    /**
     * Selector for all available fields of PrintQueueInfo.
     *
     */
    public final static PrintQueueInfoSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Mandt</b>
     * </p>
     *
     * @return Client
     */
    @Key
    @SerializedName( "Mandt" )
    @JsonProperty( "Mandt" )
    @Nullable
    @ODataField( odataName = "Mandt" )
    private String mandt;
    /**
     * Use with available fluent helpers to apply the <b>Mandt</b> field to query operations.
     *
     */
    public final static PrintQueueInfoField<String> MANDT = new PrintQueueInfoField<String>("Mandt");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>Qname</b>
     * </p>
     *
     * @return Unique ID of a Queue
     */
    @Key
    @SerializedName( "Qname" )
    @JsonProperty( "Qname" )
    @Nullable
    @ODataField( odataName = "Qname" )
    private String qname;
    /**
     * Use with available fluent helpers to apply the <b>Qname</b> field to query operations.
     *
     */
    public final static PrintQueueInfoField<String> QNAME = new PrintQueueInfoField<String>("Qname");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Qdescription</b>
     * </p>
     *
     * @return Queue Description
     */
    @SerializedName( "Qdescription" )
    @JsonProperty( "Qdescription" )
    @Nullable
    @ODataField( odataName = "Qdescription" )
    private String qdescription;
    /**
     * Use with available fluent helpers to apply the <b>Qdescription</b> field to query operations.
     *
     */
    public final static PrintQueueInfoField<String> QDESCRIPTION = new PrintQueueInfoField<String>("Qdescription");
    /**
     * Constraints: Not nullable, Maximum length: 51
     * <p>
     * Original property name from the Odata EDM: <b>Qformat</b>
     * </p>
     *
     * @return Technical Format ID
     */
    @SerializedName( "Qformat" )
    @JsonProperty( "Qformat" )
    @Nullable
    @ODataField( odataName = "Qformat" )
    private String qformat;
    /**
     * Use with available fluent helpers to apply the <b>Qformat</b> field to query operations.
     *
     */
    public final static PrintQueueInfoField<String> QFORMAT = new PrintQueueInfoField<String>("Qformat");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>QformatDescript</b>
     * </p>
     *
     * @return Queue Format
     */
    @SerializedName( "QformatDescript" )
    @JsonProperty( "QformatDescript" )
    @Nullable
    @ODataField( odataName = "QformatDescript" )
    private String qformatDescript;
    /**
     * Use with available fluent helpers to apply the <b>QformatDescript</b> field to query operations.
     *
     */
    public final static PrintQueueInfoField<String> QFORMAT_DESCRIPT =
        new PrintQueueInfoField<String>("QformatDescript");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>TechUserName</b>
     * </p>
     *
     * @return Technical User
     */
    @SerializedName( "TechUserName" )
    @JsonProperty( "TechUserName" )
    @Nullable
    @ODataField( odataName = "TechUserName" )
    private String techUserName;
    /**
     * Use with available fluent helpers to apply the <b>TechUserName</b> field to query operations.
     *
     */
    public final static PrintQueueInfoField<String> TECH_USER_NAME = new PrintQueueInfoField<String>("TechUserName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Qstatus</b>
     * </p>
     *
     * @return Queue Status
     */
    @SerializedName( "Qstatus" )
    @JsonProperty( "Qstatus" )
    @Nullable
    @ODataField( odataName = "Qstatus" )
    private String qstatus;
    /**
     * Use with available fluent helpers to apply the <b>Qstatus</b> field to query operations.
     *
     */
    public final static PrintQueueInfoField<String> QSTATUS = new PrintQueueInfoField<String>("Qstatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreateTime</b>
     * </p>
     *
     * @return Create time
     */
    @SerializedName( "CreateTime" )
    @JsonProperty( "CreateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime createTime;
    /**
     * Use with available fluent helpers to apply the <b>CreateTime</b> field to query operations.
     *
     */
    public final static PrintQueueInfoField<LocalDateTime> CREATE_TIME =
        new PrintQueueInfoField<LocalDateTime>("CreateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastRetrieveTime</b>
     * </p>
     *
     * @return Time of last retr.
     */
    @SerializedName( "LastRetrieveTime" )
    @JsonProperty( "LastRetrieveTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastRetrieveTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastRetrieveTime;
    /**
     * Use with available fluent helpers to apply the <b>LastRetrieveTime</b> field to query operations.
     *
     */
    public final static PrintQueueInfoField<LocalDateTime> LAST_RETRIEVE_TIME =
        new PrintQueueInfoField<LocalDateTime>("LastRetrieveTime");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CleanupPrd</b>
     * </p>
     *
     * @return Cleanup Queue Items
     */
    @SerializedName( "CleanupPrd" )
    @JsonProperty( "CleanupPrd" )
    @Nullable
    @ODataField( odataName = "CleanupPrd" )
    private Short cleanupPrd;
    /**
     * Use with available fluent helpers to apply the <b>CleanupPrd</b> field to query operations.
     *
     */
    public final static PrintQueueInfoField<Short> CLEANUP_PRD = new PrintQueueInfoField<Short>("CleanupPrd");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LocationID</b>
     * </p>
     *
     * @return Location ID
     */
    @SerializedName( "LocationID" )
    @JsonProperty( "LocationID" )
    @Nullable
    @ODataField( odataName = "LocationID" )
    private String locationID;
    /**
     * Use with available fluent helpers to apply the <b>LocationID</b> field to query operations.
     *
     */
    public final static PrintQueueInfoField<String> LOCATION_ID = new PrintQueueInfoField<String>("LocationID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LocationIDType</b>
     * </p>
     *
     * @return Location ID Type
     */
    @SerializedName( "LocationIDType" )
    @JsonProperty( "LocationIDType" )
    @Nullable
    @ODataField( odataName = "LocationIDType" )
    private String locationIDType;
    /**
     * Use with available fluent helpers to apply the <b>LocationIDType</b> field to query operations.
     *
     */
    public final static PrintQueueInfoField<String> LOCATION_ID_TYPE =
        new PrintQueueInfoField<String>("LocationIDType");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>OMSType</b>
     * </p>
     *
     * @return OMS Type
     */
    @SerializedName( "OMSType" )
    @JsonProperty( "OMSType" )
    @Nullable
    @ODataField( odataName = "OMSType" )
    private Short oMSType;
    /**
     * Use with available fluent helpers to apply the <b>OMSType</b> field to query operations.
     *
     */
    public final static PrintQueueInfoField<Short> OMS_TYPE = new PrintQueueInfoField<Short>("OMSType");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Qparams</b>
     * </p>
     *
     * @return Print Parameter
     */
    @SerializedName( "Qparams" )
    @JsonProperty( "Qparams" )
    @Nullable
    @ODataField( odataName = "Qparams" )
    private String qparams;
    /**
     * Use with available fluent helpers to apply the <b>Qparams</b> field to query operations.
     *
     */
    public final static PrintQueueInfoField<String> QPARAMS = new PrintQueueInfoField<String>("Qparams");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>NrOfNewItems</b>
     * </p>
     *
     * @return Number of Item
     */
    @SerializedName( "NrOfNewItems" )
    @JsonProperty( "NrOfNewItems" )
    @Nullable
    @ODataField( odataName = "NrOfNewItems" )
    private Short nrOfNewItems;
    /**
     * Use with available fluent helpers to apply the <b>NrOfNewItems</b> field to query operations.
     *
     */
    public final static PrintQueueInfoField<Short> NR_OF_NEW_ITEMS = new PrintQueueInfoField<Short>("NrOfNewItems");

    @Nonnull
    @Override
    public Class<PrintQueueInfo> getType()
    {
        return PrintQueueInfo.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Mandt</b>
     * </p>
     *
     * @param mandt
     *            Client
     */
    public void setMandt( @Nullable final String mandt )
    {
        rememberChangedField("Mandt", this.mandt);
        this.mandt = mandt;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 32
     * <p>
     * Original property name from the Odata EDM: <b>Qname</b>
     * </p>
     *
     * @param qname
     *            Unique ID of a Queue
     */
    public void setQname( @Nullable final String qname )
    {
        rememberChangedField("Qname", this.qname);
        this.qname = qname;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Qdescription</b>
     * </p>
     *
     * @param qdescription
     *            Queue Description
     */
    public void setQdescription( @Nullable final String qdescription )
    {
        rememberChangedField("Qdescription", this.qdescription);
        this.qdescription = qdescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 51
     * <p>
     * Original property name from the Odata EDM: <b>Qformat</b>
     * </p>
     *
     * @param qformat
     *            Technical Format ID
     */
    public void setQformat( @Nullable final String qformat )
    {
        rememberChangedField("Qformat", this.qformat);
        this.qformat = qformat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>QformatDescript</b>
     * </p>
     *
     * @param qformatDescript
     *            Queue Format
     */
    public void setQformatDescript( @Nullable final String qformatDescript )
    {
        rememberChangedField("QformatDescript", this.qformatDescript);
        this.qformatDescript = qformatDescript;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>TechUserName</b>
     * </p>
     *
     * @param techUserName
     *            Technical User
     */
    public void setTechUserName( @Nullable final String techUserName )
    {
        rememberChangedField("TechUserName", this.techUserName);
        this.techUserName = techUserName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Qstatus</b>
     * </p>
     *
     * @param qstatus
     *            Queue Status
     */
    public void setQstatus( @Nullable final String qstatus )
    {
        rememberChangedField("Qstatus", this.qstatus);
        this.qstatus = qstatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreateTime</b>
     * </p>
     *
     * @param createTime
     *            Create time
     */
    public void setCreateTime( @Nullable final LocalDateTime createTime )
    {
        rememberChangedField("CreateTime", this.createTime);
        this.createTime = createTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastRetrieveTime</b>
     * </p>
     *
     * @param lastRetrieveTime
     *            Time of last retr.
     */
    public void setLastRetrieveTime( @Nullable final LocalDateTime lastRetrieveTime )
    {
        rememberChangedField("LastRetrieveTime", this.lastRetrieveTime);
        this.lastRetrieveTime = lastRetrieveTime;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>CleanupPrd</b>
     * </p>
     *
     * @param cleanupPrd
     *            Cleanup Queue Items
     */
    public void setCleanupPrd( @Nullable final Short cleanupPrd )
    {
        rememberChangedField("CleanupPrd", this.cleanupPrd);
        this.cleanupPrd = cleanupPrd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LocationID</b>
     * </p>
     *
     * @param locationID
     *            Location ID
     */
    public void setLocationID( @Nullable final String locationID )
    {
        rememberChangedField("LocationID", this.locationID);
        this.locationID = locationID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LocationIDType</b>
     * </p>
     *
     * @param locationIDType
     *            Location ID Type
     */
    public void setLocationIDType( @Nullable final String locationIDType )
    {
        rememberChangedField("LocationIDType", this.locationIDType);
        this.locationIDType = locationIDType;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>OMSType</b>
     * </p>
     *
     * @param oMSType
     *            OMS Type
     */
    public void setOMSType( @Nullable final Short oMSType )
    {
        rememberChangedField("OMSType", this.oMSType);
        this.oMSType = oMSType;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>Qparams</b>
     * </p>
     *
     * @param qparams
     *            Print Parameter
     */
    public void setQparams( @Nullable final String qparams )
    {
        rememberChangedField("Qparams", this.qparams);
        this.qparams = qparams;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>NrOfNewItems</b>
     * </p>
     *
     * @param nrOfNewItems
     *            Number of Item
     */
    public void setNrOfNewItems( @Nullable final Short nrOfNewItems )
    {
        rememberChangedField("NrOfNewItems", this.nrOfNewItems);
        this.nrOfNewItems = nrOfNewItems;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PrintQueueInfoSet";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Mandt", getMandt());
        result.put("Qname", getQname());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Mandt", getMandt());
        values.put("Qname", getQname());
        values.put("Qdescription", getQdescription());
        values.put("Qformat", getQformat());
        values.put("QformatDescript", getQformatDescript());
        values.put("TechUserName", getTechUserName());
        values.put("Qstatus", getQstatus());
        values.put("CreateTime", getCreateTime());
        values.put("LastRetrieveTime", getLastRetrieveTime());
        values.put("CleanupPrd", getCleanupPrd());
        values.put("LocationID", getLocationID());
        values.put("LocationIDType", getLocationIDType());
        values.put("OMSType", getOMSType());
        values.put("Qparams", getQparams());
        values.put("NrOfNewItems", getNrOfNewItems());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Mandt") ) {
                final Object value = values.remove("Mandt");
                if( (value == null) || (!value.equals(getMandt())) ) {
                    setMandt(((String) value));
                }
            }
            if( values.containsKey("Qname") ) {
                final Object value = values.remove("Qname");
                if( (value == null) || (!value.equals(getQname())) ) {
                    setQname(((String) value));
                }
            }
            if( values.containsKey("Qdescription") ) {
                final Object value = values.remove("Qdescription");
                if( (value == null) || (!value.equals(getQdescription())) ) {
                    setQdescription(((String) value));
                }
            }
            if( values.containsKey("Qformat") ) {
                final Object value = values.remove("Qformat");
                if( (value == null) || (!value.equals(getQformat())) ) {
                    setQformat(((String) value));
                }
            }
            if( values.containsKey("QformatDescript") ) {
                final Object value = values.remove("QformatDescript");
                if( (value == null) || (!value.equals(getQformatDescript())) ) {
                    setQformatDescript(((String) value));
                }
            }
            if( values.containsKey("TechUserName") ) {
                final Object value = values.remove("TechUserName");
                if( (value == null) || (!value.equals(getTechUserName())) ) {
                    setTechUserName(((String) value));
                }
            }
            if( values.containsKey("Qstatus") ) {
                final Object value = values.remove("Qstatus");
                if( (value == null) || (!value.equals(getQstatus())) ) {
                    setQstatus(((String) value));
                }
            }
            if( values.containsKey("CreateTime") ) {
                final Object value = values.remove("CreateTime");
                if( (value == null) || (!value.equals(getCreateTime())) ) {
                    setCreateTime(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastRetrieveTime") ) {
                final Object value = values.remove("LastRetrieveTime");
                if( (value == null) || (!value.equals(getLastRetrieveTime())) ) {
                    setLastRetrieveTime(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CleanupPrd") ) {
                final Object value = values.remove("CleanupPrd");
                if( (value == null) || (!value.equals(getCleanupPrd())) ) {
                    setCleanupPrd(((Short) value));
                }
            }
            if( values.containsKey("LocationID") ) {
                final Object value = values.remove("LocationID");
                if( (value == null) || (!value.equals(getLocationID())) ) {
                    setLocationID(((String) value));
                }
            }
            if( values.containsKey("LocationIDType") ) {
                final Object value = values.remove("LocationIDType");
                if( (value == null) || (!value.equals(getLocationIDType())) ) {
                    setLocationIDType(((String) value));
                }
            }
            if( values.containsKey("OMSType") ) {
                final Object value = values.remove("OMSType");
                if( (value == null) || (!value.equals(getOMSType())) ) {
                    setOMSType(((Short) value));
                }
            }
            if( values.containsKey("Qparams") ) {
                final Object value = values.remove("Qparams");
                if( (value == null) || (!value.equals(getQparams())) ) {
                    setQparams(((String) value));
                }
            }
            if( values.containsKey("NrOfNewItems") ) {
                final Object value = values.remove("NrOfNewItems");
                if( (value == null) || (!value.equals(getNrOfNewItems())) ) {
                    setNrOfNewItems(((Short) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PrintQueueInfoField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PrintQueueInfoField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PrintQueueInfoField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PrintQueueInfoField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PrintQueueItemService.DEFAULT_SERVICE_PATH);
    }

}
