/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.field.RetrieveNextItemResultField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.selectable.RetrieveNextItemResultSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>RetrieveNextItemResult</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RetrieveNextItemResult extends VdmEntity<RetrieveNextItemResult>
{

    /**
     * Selector for all available fields of RetrieveNextItemResult.
     *
     */
    public final static RetrieveNextItemResultSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>item_id</b>
     * </p>
     *
     * @return The item_id contained in this entity.
     */
    @Key
    @SerializedName( "item_id" )
    @JsonProperty( "item_id" )
    @Nullable
    @ODataField( odataName = "item_id" )
    private String item_id;
    /**
     * Use with available fluent helpers to apply the <b>item_id</b> field to query operations.
     *
     */
    public final static RetrieveNextItemResultField<String> ITEM_ID =
        new RetrieveNextItemResultField<String>("item_id");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>number_of_copies</b>
     * </p>
     *
     * @return Signed INT2 / int16
     */
    @SerializedName( "number_of_copies" )
    @JsonProperty( "number_of_copies" )
    @Nullable
    @ODataField( odataName = "number_of_copies" )
    private Short number_of_copies;
    /**
     * Use with available fluent helpers to apply the <b>number_of_copies</b> field to query operations.
     *
     */
    public final static RetrieveNextItemResultField<Short> NUMBER_OF_COPIES =
        new RetrieveNextItemResultField<Short>("number_of_copies");
    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>has_more_items</b>
     * </p>
     *
     * @return Indicator
     */
    @SerializedName( "has_more_items" )
    @JsonProperty( "has_more_items" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "has_more_items" )
    private Boolean has_more_items;
    /**
     * Use with available fluent helpers to apply the <b>has_more_items</b> field to query operations.
     *
     */
    public final static RetrieveNextItemResultField<Boolean> HAS_MORE_ITEMS =
        new RetrieveNextItemResultField<Boolean>("has_more_items");

    @Nonnull
    @Override
    public Class<RetrieveNextItemResult> getType()
    {
        return RetrieveNextItemResult.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>item_id</b>
     * </p>
     *
     * @param item_id
     *            The item_id to set.
     */
    public void setItem_id( @Nullable final String item_id )
    {
        rememberChangedField("item_id", this.item_id);
        this.item_id = item_id;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>number_of_copies</b>
     * </p>
     *
     * @param number_of_copies
     *            Signed INT2 / int16
     */
    public void setNumber_of_copies( @Nullable final Short number_of_copies )
    {
        rememberChangedField("number_of_copies", this.number_of_copies);
        this.number_of_copies = number_of_copies;
    }

    /**
     * Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>has_more_items</b>
     * </p>
     *
     * @param has_more_items
     *            Indicator
     */
    public void setHas_more_items( @Nullable final Boolean has_more_items )
    {
        rememberChangedField("has_more_items", this.has_more_items);
        this.has_more_items = has_more_items;
    }

    @Override
    protected String getEntityCollection()
    {
        return "RetrieveNextItemResultCollection";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("item_id", getItem_id());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("item_id", getItem_id());
        values.put("number_of_copies", getNumber_of_copies());
        values.put("has_more_items", getHas_more_items());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("item_id") ) {
                final Object value = values.remove("item_id");
                if( (value == null) || (!value.equals(getItem_id())) ) {
                    setItem_id(((String) value));
                }
            }
            if( values.containsKey("number_of_copies") ) {
                final Object value = values.remove("number_of_copies");
                if( (value == null) || (!value.equals(getNumber_of_copies())) ) {
                    setNumber_of_copies(((Short) value));
                }
            }
            if( values.containsKey("has_more_items") ) {
                final Object value = values.remove("has_more_items");
                if( (value == null) || (!value.equals(getHas_more_items())) ) {
                    setHas_more_items(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> RetrieveNextItemResultField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RetrieveNextItemResultField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RetrieveNextItemResultField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RetrieveNextItemResultField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.PrintQueueItemService.DEFAULT_SERVICE_PATH);
    }

}
