/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link PrintQueueItemServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PrintQueueItemService PrintQueueItemService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultPrintQueueItemServiceBatch
    extends
    BatchFluentHelperBasic<PrintQueueItemServiceBatch, PrintQueueItemServiceBatchChangeSet>
    implements
    PrintQueueItemServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PrintQueueItemService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultPrintQueueItemServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPrintQueueItemServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PrintQueueItemService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.PrintQueueItemService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultPrintQueueItemServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultPrintQueueItemServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PrintQueueItemService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultPrintQueueItemServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public PrintQueueItemServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultPrintQueueItemServiceBatchChangeSet(this, service);
    }

}
