/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link PrintQueueItemServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.PrintQueueItemService PrintQueueItemService}.
 *
 */
public class DefaultPrintQueueItemServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<PrintQueueItemServiceBatch, PrintQueueItemServiceBatchChangeSet>
    implements
    PrintQueueItemServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PrintQueueItemService service;

    @SuppressWarnings( "deprecation" )
    DefaultPrintQueueItemServiceBatchChangeSet(
        @Nonnull final DefaultPrintQueueItemServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.PrintQueueItemService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultPrintQueueItemServiceBatchChangeSet getThis()
    {
        return this;
    }

}
