/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.IcmCacheResult;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.IcmCacheResult IcmCacheResult}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.field.IcmCacheResultField
 * IcmCacheResultField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.link.IcmCacheResultLink
 * IcmCacheResultLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.IcmCacheResult#URL URL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.IcmCacheResult#CONTENT CONTENT}</li>
 * </ul>
 *
 */
public interface IcmCacheResultSelectable extends EntitySelectable<IcmCacheResult>
{

}
