/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintDocumentBlob;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintDocumentBlob PrintDocumentBlob}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.field.PrintDocumentBlobField
 * PrintDocumentBlobField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.link.PrintDocumentBlobLink
 * PrintDocumentBlobLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintDocumentBlob#COUNT_ID
 * COUNT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintDocumentBlob#DOCUMENT_NAME
 * DOCUMENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintDocumentBlob#FILESIZE
 * FILESIZE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintDocumentBlob#URL URL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintDocumentBlob#BLOB BLOB}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintDocumentBlob#Q_ITEM_PARAMS
 * Q_ITEM_PARAMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintDocumentBlob#METADATA
 * METADATA}</li>
 * </ul>
 *
 */
public interface PrintDocumentBlobSelectable extends EntitySelectable<PrintDocumentBlob>
{

}
