/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintOptions;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintOptions PrintOptions}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.field.PrintOptionsField
 * PrintOptionsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.link.PrintOptionsLink PrintOptionsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintOptions#OPTIONS OPTIONS}</li>
 * </ul>
 *
 */
public interface PrintOptionsSelectable extends EntitySelectable<PrintOptions>
{

}
