/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo PrintQueueInfo}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.field.PrintQueueInfoField
 * PrintQueueInfoField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.link.PrintQueueInfoLink
 * PrintQueueInfoLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo#MANDT MANDT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo#QNAME QNAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo#QDESCRIPTION
 * QDESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo#QFORMAT QFORMAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo#QFORMAT_DESCRIPT
 * QFORMAT_DESCRIPT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo#TECH_USER_NAME
 * TECH_USER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo#QSTATUS QSTATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo#CREATE_TIME
 * CREATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo#LAST_RETRIEVE_TIME
 * LAST_RETRIEVE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo#CLEANUP_PRD
 * CLEANUP_PRD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo#LOCATION_ID
 * LOCATION_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo#LOCATION_ID_TYPE
 * LOCATION_ID_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo#OMS_TYPE OMS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo#QPARAMS QPARAMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.PrintQueueInfo#NR_OF_NEW_ITEMS
 * NR_OF_NEW_ITEMS}</li>
 * </ul>
 *
 */
public interface PrintQueueInfoSelectable extends EntitySelectable<PrintQueueInfo>
{

}
