/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.RetrieveNextItemResult;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.RetrieveNextItemResult
 * RetrieveNextItemResult}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.field.RetrieveNextItemResultField
 * RetrieveNextItemResultField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.link.RetrieveNextItemResultLink
 * RetrieveNextItemResultLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.RetrieveNextItemResult#ITEM_ID
 * ITEM_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.RetrieveNextItemResult#NUMBER_OF_COPIES
 * NUMBER_OF_COPIES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.printqueueitem.RetrieveNextItemResult#HAS_MORE_ITEMS
 * HAS_MORE_ITEMS}</li>
 * </ul>
 *
 */
public interface RetrieveNextItemResultSelectable extends EntitySelectable<RetrieveNextItemResult>
{

}
