/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.field.ProcessOrderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.link.ProcessOrderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.selectable.ProcessOrderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * API Process Order
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProcessOrderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProcessOrder extends VdmEntity<ProcessOrder>
{

    /**
     * Selector for all available fields of ProcessOrder.
     *
     */
    public final static ProcessOrderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProcessOrder</b>
     * </p>
     *
     * @return Manufacturing Order ID
     */
    @Key
    @SerializedName( "ProcessOrder" )
    @JsonProperty( "ProcessOrder" )
    @Nullable
    @ODataField( odataName = "ProcessOrder" )
    private String processOrder;
    /**
     * Use with available fluent helpers to apply the <b>ProcessOrder</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> PROCESS_ORDER = new ProcessOrderField<String>("ProcessOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @return Production Plant
     */
    @SerializedName( "ProductionPlant" )
    @JsonProperty( "ProductionPlant" )
    @Nullable
    @ODataField( odataName = "ProductionPlant" )
    private String productionPlant;
    /**
     * Use with available fluent helpers to apply the <b>ProductionPlant</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> PRODUCTION_PLANT = new ProcessOrderField<String>("ProductionPlant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @return Order Internal ID
     */
    @SerializedName( "OrderInternalBillOfOperations" )
    @JsonProperty( "OrderInternalBillOfOperations" )
    @Nullable
    @ODataField( odataName = "OrderInternalBillOfOperations" )
    private String orderInternalBillOfOperations;
    /**
     * Use with available fluent helpers to apply the <b>OrderInternalBillOfOperations</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_INTERNAL_BILL_OF_OPERATIONS =
        new ProcessOrderField<String>("OrderInternalBillOfOperations");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsCreated</b>
     * </p>
     *
     * @return The orderIsCreated contained in this entity.
     */
    @SerializedName( "OrderIsCreated" )
    @JsonProperty( "OrderIsCreated" )
    @Nullable
    @ODataField( odataName = "OrderIsCreated" )
    private String orderIsCreated;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsCreated</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_CREATED = new ProcessOrderField<String>("OrderIsCreated");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsReleased</b>
     * </p>
     *
     * @return The orderIsReleased contained in this entity.
     */
    @SerializedName( "OrderIsReleased" )
    @JsonProperty( "OrderIsReleased" )
    @Nullable
    @ODataField( odataName = "OrderIsReleased" )
    private String orderIsReleased;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsReleased</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_RELEASED = new ProcessOrderField<String>("OrderIsReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsPrinted</b>
     * </p>
     *
     * @return The orderIsPrinted contained in this entity.
     */
    @SerializedName( "OrderIsPrinted" )
    @JsonProperty( "OrderIsPrinted" )
    @Nullable
    @ODataField( odataName = "OrderIsPrinted" )
    private String orderIsPrinted;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsPrinted</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_PRINTED = new ProcessOrderField<String>("OrderIsPrinted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsConfirmed</b>
     * </p>
     *
     * @return The orderIsConfirmed contained in this entity.
     */
    @SerializedName( "OrderIsConfirmed" )
    @JsonProperty( "OrderIsConfirmed" )
    @Nullable
    @ODataField( odataName = "OrderIsConfirmed" )
    private String orderIsConfirmed;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsConfirmed</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_CONFIRMED =
        new ProcessOrderField<String>("OrderIsConfirmed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsPartiallyConfirmed</b>
     * </p>
     *
     * @return The orderIsPartiallyConfirmed contained in this entity.
     */
    @SerializedName( "OrderIsPartiallyConfirmed" )
    @JsonProperty( "OrderIsPartiallyConfirmed" )
    @Nullable
    @ODataField( odataName = "OrderIsPartiallyConfirmed" )
    private String orderIsPartiallyConfirmed;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsPartiallyConfirmed</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_PARTIALLY_CONFIRMED =
        new ProcessOrderField<String>("OrderIsPartiallyConfirmed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsDelivered</b>
     * </p>
     *
     * @return The orderIsDelivered contained in this entity.
     */
    @SerializedName( "OrderIsDelivered" )
    @JsonProperty( "OrderIsDelivered" )
    @Nullable
    @ODataField( odataName = "OrderIsDelivered" )
    private String orderIsDelivered;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsDelivered</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_DELIVERED =
        new ProcessOrderField<String>("OrderIsDelivered");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsDeleted</b>
     * </p>
     *
     * @return The orderIsDeleted contained in this entity.
     */
    @SerializedName( "OrderIsDeleted" )
    @JsonProperty( "OrderIsDeleted" )
    @Nullable
    @ODataField( odataName = "OrderIsDeleted" )
    private String orderIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsDeleted</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_DELETED = new ProcessOrderField<String>("OrderIsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsPreCosted</b>
     * </p>
     *
     * @return The orderIsPreCosted contained in this entity.
     */
    @SerializedName( "OrderIsPreCosted" )
    @JsonProperty( "OrderIsPreCosted" )
    @Nullable
    @ODataField( odataName = "OrderIsPreCosted" )
    private String orderIsPreCosted;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsPreCosted</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_PRE_COSTED =
        new ProcessOrderField<String>("OrderIsPreCosted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlementRuleIsCreated</b>
     * </p>
     *
     * @return The settlementRuleIsCreated contained in this entity.
     */
    @SerializedName( "SettlementRuleIsCreated" )
    @JsonProperty( "SettlementRuleIsCreated" )
    @Nullable
    @ODataField( odataName = "SettlementRuleIsCreated" )
    private String settlementRuleIsCreated;
    /**
     * Use with available fluent helpers to apply the <b>SettlementRuleIsCreated</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> SETTLEMENT_RULE_IS_CREATED =
        new ProcessOrderField<String>("SettlementRuleIsCreated");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsPartiallyReleased</b>
     * </p>
     *
     * @return The orderIsPartiallyReleased contained in this entity.
     */
    @SerializedName( "OrderIsPartiallyReleased" )
    @JsonProperty( "OrderIsPartiallyReleased" )
    @Nullable
    @ODataField( odataName = "OrderIsPartiallyReleased" )
    private String orderIsPartiallyReleased;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsPartiallyReleased</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_PARTIALLY_RELEASED =
        new ProcessOrderField<String>("OrderIsPartiallyReleased");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsLocked</b>
     * </p>
     *
     * @return The orderIsLocked contained in this entity.
     */
    @SerializedName( "OrderIsLocked" )
    @JsonProperty( "OrderIsLocked" )
    @Nullable
    @ODataField( odataName = "OrderIsLocked" )
    private String orderIsLocked;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsLocked</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_LOCKED = new ProcessOrderField<String>("OrderIsLocked");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsTechnicallyCompleted</b>
     * </p>
     *
     * @return The orderIsTechnicallyCompleted contained in this entity.
     */
    @SerializedName( "OrderIsTechnicallyCompleted" )
    @JsonProperty( "OrderIsTechnicallyCompleted" )
    @Nullable
    @ODataField( odataName = "OrderIsTechnicallyCompleted" )
    private String orderIsTechnicallyCompleted;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsTechnicallyCompleted</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_TECHNICALLY_COMPLETED =
        new ProcessOrderField<String>("OrderIsTechnicallyCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsClosed</b>
     * </p>
     *
     * @return The orderIsClosed contained in this entity.
     */
    @SerializedName( "OrderIsClosed" )
    @JsonProperty( "OrderIsClosed" )
    @Nullable
    @ODataField( odataName = "OrderIsClosed" )
    private String orderIsClosed;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsClosed</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_CLOSED = new ProcessOrderField<String>("OrderIsClosed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsPartiallyDelivered</b>
     * </p>
     *
     * @return The orderIsPartiallyDelivered contained in this entity.
     */
    @SerializedName( "OrderIsPartiallyDelivered" )
    @JsonProperty( "OrderIsPartiallyDelivered" )
    @Nullable
    @ODataField( odataName = "OrderIsPartiallyDelivered" )
    private String orderIsPartiallyDelivered;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsPartiallyDelivered</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_PARTIALLY_DELIVERED =
        new ProcessOrderField<String>("OrderIsPartiallyDelivered");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsMarkedForDeletion</b>
     * </p>
     *
     * @return The orderIsMarkedForDeletion contained in this entity.
     */
    @SerializedName( "OrderIsMarkedForDeletion" )
    @JsonProperty( "OrderIsMarkedForDeletion" )
    @Nullable
    @ODataField( odataName = "OrderIsMarkedForDeletion" )
    private String orderIsMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_MARKED_FOR_DELETION =
        new ProcessOrderField<String>("OrderIsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlementRuleIsCrtedManually</b>
     * </p>
     *
     * @return The settlementRuleIsCrtedManually contained in this entity.
     */
    @SerializedName( "SettlementRuleIsCrtedManually" )
    @JsonProperty( "SettlementRuleIsCrtedManually" )
    @Nullable
    @ODataField( odataName = "SettlementRuleIsCrtedManually" )
    private String settlementRuleIsCrtedManually;
    /**
     * Use with available fluent helpers to apply the <b>SettlementRuleIsCrtedManually</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> SETTLEMENT_RULE_IS_CRTED_MANUALLY =
        new ProcessOrderField<String>("SettlementRuleIsCrtedManually");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsScheduled</b>
     * </p>
     *
     * @return The orderIsScheduled contained in this entity.
     */
    @SerializedName( "OrderIsScheduled" )
    @JsonProperty( "OrderIsScheduled" )
    @Nullable
    @ODataField( odataName = "OrderIsScheduled" )
    private String orderIsScheduled;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsScheduled</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_SCHEDULED =
        new ProcessOrderField<String>("OrderIsScheduled");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderHasGeneratedOperations</b>
     * </p>
     *
     * @return The orderHasGeneratedOperations contained in this entity.
     */
    @SerializedName( "OrderHasGeneratedOperations" )
    @JsonProperty( "OrderHasGeneratedOperations" )
    @Nullable
    @ODataField( odataName = "OrderHasGeneratedOperations" )
    private String orderHasGeneratedOperations;
    /**
     * Use with available fluent helpers to apply the <b>OrderHasGeneratedOperations</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_HAS_GENERATED_OPERATIONS =
        new ProcessOrderField<String>("OrderHasGeneratedOperations");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsToBeHandledInBatches</b>
     * </p>
     *
     * @return The orderIsToBeHandledInBatches contained in this entity.
     */
    @SerializedName( "OrderIsToBeHandledInBatches" )
    @JsonProperty( "OrderIsToBeHandledInBatches" )
    @Nullable
    @ODataField( odataName = "OrderIsToBeHandledInBatches" )
    private String orderIsToBeHandledInBatches;
    /**
     * Use with available fluent helpers to apply the <b>OrderIsToBeHandledInBatches</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_IS_TO_BE_HANDLED_IN_BATCHES =
        new ProcessOrderField<String>("OrderIsToBeHandledInBatches");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialAvailyIsNotChecked</b>
     * </p>
     *
     * @return The materialAvailyIsNotChecked contained in this entity.
     */
    @SerializedName( "MaterialAvailyIsNotChecked" )
    @JsonProperty( "MaterialAvailyIsNotChecked" )
    @Nullable
    @ODataField( odataName = "MaterialAvailyIsNotChecked" )
    private String materialAvailyIsNotChecked;
    /**
     * Use with available fluent helpers to apply the <b>MaterialAvailyIsNotChecked</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> MATERIAL_AVAILY_IS_NOT_CHECKED =
        new ProcessOrderField<String>("MaterialAvailyIsNotChecked");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number for Order
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> MATERIAL = new ProcessOrderField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @return Material Description
     */
    @SerializedName( "MaterialName" )
    @JsonProperty( "MaterialName" )
    @Nullable
    @ODataField( odataName = "MaterialName" )
    private String materialName;
    /**
     * Use with available fluent helpers to apply the <b>MaterialName</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> MATERIAL_NAME = new ProcessOrderField<String>("MaterialName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductionUnit</b>
     * </p>
     *
     * @return Production Unit of Measure
     */
    @SerializedName( "ProductionUnit" )
    @JsonProperty( "ProductionUnit" )
    @Nullable
    @ODataField( odataName = "ProductionUnit" )
    private String productionUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProductionUnit</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> PRODUCTION_UNIT = new ProcessOrderField<String>("ProductionUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalQuantity</b>
     * </p>
     *
     * @return Manufacturing Order Planned Total Quantity
     */
    @SerializedName( "TotalQuantity" )
    @JsonProperty( "TotalQuantity" )
    @Nullable
    @ODataField( odataName = "TotalQuantity" )
    private BigDecimal totalQuantity;
    /**
     * Use with available fluent helpers to apply the <b>TotalQuantity</b> field to query operations.
     *
     */
    public final static ProcessOrderField<BigDecimal> TOTAL_QUANTITY =
        new ProcessOrderField<BigDecimal>("TotalQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @return Order Type
     */
    @SerializedName( "ManufacturingOrderType" )
    @JsonProperty( "ManufacturingOrderType" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderType" )
    private String manufacturingOrderType;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderType</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> MANUFACTURING_ORDER_TYPE =
        new ProcessOrderField<String>("ManufacturingOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @return MRP Area
     */
    @SerializedName( "MRPArea" )
    @JsonProperty( "MRPArea" )
    @Nullable
    @ODataField( odataName = "MRPArea" )
    private String mRPArea;
    /**
     * Use with available fluent helpers to apply the <b>MRPArea</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> MRP_AREA = new ProcessOrderField<String>("MRPArea");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingObject</b>
     * </p>
     *
     * @return Object Internal ID
     */
    @SerializedName( "ManufacturingObject" )
    @JsonProperty( "ManufacturingObject" )
    @Nullable
    @ODataField( odataName = "ManufacturingObject" )
    private String manufacturingObject;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingObject</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> MANUFACTURING_OBJECT =
        new ProcessOrderField<String>("ManufacturingObject");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Planning Plant for an Order
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> PLANT = new ProcessOrderField<String>("Plant");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderConfirmedYieldQty</b>
     * </p>
     *
     * @return Confirmed Yield Quantity From Order Confirmation
     */
    @SerializedName( "MfgOrderConfirmedYieldQty" )
    @JsonProperty( "MfgOrderConfirmedYieldQty" )
    @Nullable
    @ODataField( odataName = "MfgOrderConfirmedYieldQty" )
    private BigDecimal mfgOrderConfirmedYieldQty;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderConfirmedYieldQty</b> field to query operations.
     *
     */
    public final static ProcessOrderField<BigDecimal> MFG_ORDER_CONFIRMED_YIELD_QTY =
        new ProcessOrderField<BigDecimal>("MfgOrderConfirmedYieldQty");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderPlannedStartDate</b>
     * </p>
     *
     * @return Manufacturing Order Planned Start Date
     */
    @SerializedName( "MfgOrderPlannedStartDate" )
    @JsonProperty( "MfgOrderPlannedStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MfgOrderPlannedStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime mfgOrderPlannedStartDate;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderPlannedStartDate</b> field to query operations.
     *
     */
    public final static ProcessOrderField<LocalDateTime> MFG_ORDER_PLANNED_START_DATE =
        new ProcessOrderField<LocalDateTime>("MfgOrderPlannedStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderPlannedStartTime</b>
     * </p>
     *
     * @return Manufacturing Order Planned Start Time
     */
    @SerializedName( "MfgOrderPlannedStartTime" )
    @JsonProperty( "MfgOrderPlannedStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MfgOrderPlannedStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime mfgOrderPlannedStartTime;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderPlannedStartTime</b> field to query operations.
     *
     */
    public final static ProcessOrderField<LocalTime> MFG_ORDER_PLANNED_START_TIME =
        new ProcessOrderField<LocalTime>("MfgOrderPlannedStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderPlannedEndDate</b>
     * </p>
     *
     * @return Manufacturing Order Planned End Date
     */
    @SerializedName( "MfgOrderPlannedEndDate" )
    @JsonProperty( "MfgOrderPlannedEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MfgOrderPlannedEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime mfgOrderPlannedEndDate;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderPlannedEndDate</b> field to query operations.
     *
     */
    public final static ProcessOrderField<LocalDateTime> MFG_ORDER_PLANNED_END_DATE =
        new ProcessOrderField<LocalDateTime>("MfgOrderPlannedEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderPlannedEndTime</b>
     * </p>
     *
     * @return Manufacturing Order Planned End Time
     */
    @SerializedName( "MfgOrderPlannedEndTime" )
    @JsonProperty( "MfgOrderPlannedEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MfgOrderPlannedEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime mfgOrderPlannedEndTime;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderPlannedEndTime</b> field to query operations.
     *
     */
    public final static ProcessOrderField<LocalTime> MFG_ORDER_PLANNED_END_TIME =
        new ProcessOrderField<LocalTime>("MfgOrderPlannedEndTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderScheduledStartDate</b>
     * </p>
     *
     * @return Manufacturing Order Scheduled Start Date
     */
    @SerializedName( "MfgOrderScheduledStartDate" )
    @JsonProperty( "MfgOrderScheduledStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MfgOrderScheduledStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime mfgOrderScheduledStartDate;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderScheduledStartDate</b> field to query operations.
     *
     */
    public final static ProcessOrderField<LocalDateTime> MFG_ORDER_SCHEDULED_START_DATE =
        new ProcessOrderField<LocalDateTime>("MfgOrderScheduledStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderScheduledStartTime</b>
     * </p>
     *
     * @return Manufacturing Order Scheduled Start Time
     */
    @SerializedName( "MfgOrderScheduledStartTime" )
    @JsonProperty( "MfgOrderScheduledStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MfgOrderScheduledStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime mfgOrderScheduledStartTime;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderScheduledStartTime</b> field to query operations.
     *
     */
    public final static ProcessOrderField<LocalTime> MFG_ORDER_SCHEDULED_START_TIME =
        new ProcessOrderField<LocalTime>("MfgOrderScheduledStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderScheduledEndDate</b>
     * </p>
     *
     * @return Manufacturing Order Scheduled End Date
     */
    @SerializedName( "MfgOrderScheduledEndDate" )
    @JsonProperty( "MfgOrderScheduledEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MfgOrderScheduledEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime mfgOrderScheduledEndDate;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderScheduledEndDate</b> field to query operations.
     *
     */
    public final static ProcessOrderField<LocalDateTime> MFG_ORDER_SCHEDULED_END_DATE =
        new ProcessOrderField<LocalDateTime>("MfgOrderScheduledEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderScheduledEndTime</b>
     * </p>
     *
     * @return Manufacturing Order Scheduled End Time
     */
    @SerializedName( "MfgOrderScheduledEndTime" )
    @JsonProperty( "MfgOrderScheduledEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MfgOrderScheduledEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime mfgOrderScheduledEndTime;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderScheduledEndTime</b> field to query operations.
     *
     */
    public final static ProcessOrderField<LocalTime> MFG_ORDER_SCHEDULED_END_TIME =
        new ProcessOrderField<LocalTime>("MfgOrderScheduledEndTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> SALES_ORDER = new ProcessOrderField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> SALES_ORDER_ITEM = new ProcessOrderField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrder</b>
     * </p>
     *
     * @return Planned Order
     */
    @SerializedName( "PlannedOrder" )
    @JsonProperty( "PlannedOrder" )
    @Nullable
    @ODataField( odataName = "PlannedOrder" )
    private String plannedOrder;
    /**
     * Use with available fluent helpers to apply the <b>PlannedOrder</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> PLANNED_ORDER = new ProcessOrderField<String>("PlannedOrder");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CustomerName</b>
     * </p>
     *
     * @return Name of Customer
     */
    @SerializedName( "CustomerName" )
    @JsonProperty( "CustomerName" )
    @Nullable
    @ODataField( odataName = "CustomerName" )
    private String customerName;
    /**
     * Use with available fluent helpers to apply the <b>CustomerName</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> CUSTOMER_NAME = new ProcessOrderField<String>("CustomerName");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> WBS_ELEMENT = new ProcessOrderField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element Internal ID
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> WBS_ELEMENT_INTERNAL_ID =
        new ProcessOrderField<String>("WBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSDescription</b>
     * </p>
     *
     * @return WBS Element Name
     */
    @SerializedName( "WBSDescription" )
    @JsonProperty( "WBSDescription" )
    @Nullable
    @ODataField( odataName = "WBSDescription" )
    private String wBSDescription;
    /**
     * Use with available fluent helpers to apply the <b>WBSDescription</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> WBS_DESCRIPTION = new ProcessOrderField<String>("WBSDescription");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> COMPANY_CODE = new ProcessOrderField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> FUNCTIONAL_AREA = new ProcessOrderField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlannedCostsCostingVariant</b>
     * </p>
     *
     * @return Costing Variant for Planned Costs
     */
    @SerializedName( "PlannedCostsCostingVariant" )
    @JsonProperty( "PlannedCostsCostingVariant" )
    @Nullable
    @ODataField( odataName = "PlannedCostsCostingVariant" )
    private String plannedCostsCostingVariant;
    /**
     * Use with available fluent helpers to apply the <b>PlannedCostsCostingVariant</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> PLANNED_COSTS_COSTING_VARIANT =
        new ProcessOrderField<String>("PlannedCostsCostingVariant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ActualCostsCostingVariant</b>
     * </p>
     *
     * @return Costing Variant For Actual Costs
     */
    @SerializedName( "ActualCostsCostingVariant" )
    @JsonProperty( "ActualCostsCostingVariant" )
    @Nullable
    @ODataField( odataName = "ActualCostsCostingVariant" )
    private String actualCostsCostingVariant;
    /**
     * Use with available fluent helpers to apply the <b>ActualCostsCostingVariant</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ACTUAL_COSTS_COSTING_VARIANT =
        new ProcessOrderField<String>("ActualCostsCostingVariant");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>UserID</b>
     * </p>
     *
     * @return Object ID for recipient
     */
    @SerializedName( "UserID" )
    @JsonProperty( "UserID" )
    @Nullable
    @ODataField( odataName = "UserID" )
    private String userID;
    /**
     * Use with available fluent helpers to apply the <b>UserID</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> USER_ID = new ProcessOrderField<String>("UserID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @return Production Version
     */
    @SerializedName( "ProductionVersion" )
    @JsonProperty( "ProductionVersion" )
    @Nullable
    @ODataField( odataName = "ProductionVersion" )
    private String productionVersion;
    /**
     * Use with available fluent helpers to apply the <b>ProductionVersion</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> PRODUCTION_VERSION =
        new ProcessOrderField<String>("ProductionVersion");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @return MRP Controller
     */
    @SerializedName( "MRPController" )
    @JsonProperty( "MRPController" )
    @Nullable
    @ODataField( odataName = "MRPController" )
    private String mRPController;
    /**
     * Use with available fluent helpers to apply the <b>MRPController</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> MRP_CONTROLLER = new ProcessOrderField<String>("MRPController");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupervisor</b>
     * </p>
     *
     * @return Production Supervisor
     */
    @SerializedName( "ProductionSupervisor" )
    @JsonProperty( "ProductionSupervisor" )
    @Nullable
    @ODataField( odataName = "ProductionSupervisor" )
    private String productionSupervisor;
    /**
     * Use with available fluent helpers to apply the <b>ProductionSupervisor</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> PRODUCTION_SUPERVISOR =
        new ProcessOrderField<String>("ProductionSupervisor");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @return Order Category
     */
    @SerializedName( "ManufacturingOrderCategory" )
    @JsonProperty( "ManufacturingOrderCategory" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderCategory" )
    private String manufacturingOrderCategory;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderCategory</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> MANUFACTURING_ORDER_CATEGORY =
        new ProcessOrderField<String>("ManufacturingOrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> BUSINESS_AREA = new ProcessOrderField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderPlannedScrapQty</b>
     * </p>
     *
     * @return Manufacturing Order Planned Scrap Quantity
     */
    @SerializedName( "MfgOrderPlannedScrapQty" )
    @JsonProperty( "MfgOrderPlannedScrapQty" )
    @Nullable
    @ODataField( odataName = "MfgOrderPlannedScrapQty" )
    private BigDecimal mfgOrderPlannedScrapQty;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderPlannedScrapQty</b> field to query operations.
     *
     */
    public final static ProcessOrderField<BigDecimal> MFG_ORDER_PLANNED_SCRAP_QTY =
        new ProcessOrderField<BigDecimal>("MfgOrderPlannedScrapQty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> PROFIT_CENTER = new ProcessOrderField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderImportance</b>
     * </p>
     *
     * @return Order Importance Code
     */
    @SerializedName( "ManufacturingOrderImportance" )
    @JsonProperty( "ManufacturingOrderImportance" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderImportance" )
    private String manufacturingOrderImportance;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderImportance</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> MANUFACTURING_ORDER_IMPORTANCE =
        new ProcessOrderField<String>("ManufacturingOrderImportance");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>OrderSequenceNumber</b>
     * </p>
     *
     * @return Sequence Number Order
     */
    @SerializedName( "OrderSequenceNumber" )
    @JsonProperty( "OrderSequenceNumber" )
    @Nullable
    @ODataField( odataName = "OrderSequenceNumber" )
    private String orderSequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>OrderSequenceNumber</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> ORDER_SEQUENCE_NUMBER =
        new ProcessOrderField<String>("OrderSequenceNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderCreationDate</b>
     * </p>
     *
     * @return Order Creation Date
     */
    @SerializedName( "MfgOrderCreationDate" )
    @JsonProperty( "MfgOrderCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MfgOrderCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime mfgOrderCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderCreationDate</b> field to query operations.
     *
     */
    public final static ProcessOrderField<LocalDateTime> MFG_ORDER_CREATION_DATE =
        new ProcessOrderField<LocalDateTime>("MfgOrderCreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderCreationTime</b>
     * </p>
     *
     * @return Order Creation Time
     */
    @SerializedName( "MfgOrderCreationTime" )
    @JsonProperty( "MfgOrderCreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MfgOrderCreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime mfgOrderCreationTime;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderCreationTime</b> field to query operations.
     *
     */
    public final static ProcessOrderField<LocalTime> MFG_ORDER_CREATION_TIME =
        new ProcessOrderField<LocalTime>("MfgOrderCreationTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderActualReleaseDate</b>
     * </p>
     *
     * @return Manufacturing Order Actual Release Date
     */
    @SerializedName( "MfgOrderActualReleaseDate" )
    @JsonProperty( "MfgOrderActualReleaseDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MfgOrderActualReleaseDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime mfgOrderActualReleaseDate;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderActualReleaseDate</b> field to query operations.
     *
     */
    public final static ProcessOrderField<LocalDateTime> MFG_ORDER_ACTUAL_RELEASE_DATE =
        new ProcessOrderField<LocalDateTime>("MfgOrderActualReleaseDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @return Goods Recipient
     */
    @SerializedName( "GoodsRecipientName" )
    @JsonProperty( "GoodsRecipientName" )
    @Nullable
    @ODataField( odataName = "GoodsRecipientName" )
    private String goodsRecipientName;
    /**
     * Use with available fluent helpers to apply the <b>GoodsRecipientName</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> GOODS_RECIPIENT_NAME =
        new ProcessOrderField<String>("GoodsRecipientName");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGoodsReceiptDuration</b>
     * </p>
     *
     * @return Goods Receipt Processing Duration in Days
     */
    @SerializedName( "MaterialGoodsReceiptDuration" )
    @JsonProperty( "MaterialGoodsReceiptDuration" )
    @Nullable
    @ODataField( odataName = "MaterialGoodsReceiptDuration" )
    private BigDecimal materialGoodsReceiptDuration;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGoodsReceiptDuration</b> field to query operations.
     *
     */
    public final static ProcessOrderField<BigDecimal> MATERIAL_GOODS_RECEIPT_DURATION =
        new ProcessOrderField<BigDecimal>("MaterialGoodsReceiptDuration");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventoryUsabilityCode</b>
     * </p>
     *
     * @return Inventory Usability Code
     */
    @SerializedName( "InventoryUsabilityCode" )
    @JsonProperty( "InventoryUsabilityCode" )
    @Nullable
    @ODataField( odataName = "InventoryUsabilityCode" )
    private String inventoryUsabilityCode;
    /**
     * Use with available fluent helpers to apply the <b>InventoryUsabilityCode</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> INVENTORY_USABILITY_CODE =
        new ProcessOrderField<String>("InventoryUsabilityCode");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @return Unloading Point
     */
    @SerializedName( "UnloadingPointName" )
    @JsonProperty( "UnloadingPointName" )
    @Nullable
    @ODataField( odataName = "UnloadingPointName" )
    private String unloadingPointName;
    /**
     * Use with available fluent helpers to apply the <b>UnloadingPointName</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> UNLOADING_POINT_NAME =
        new ProcessOrderField<String>("UnloadingPointName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>QuantityDistributionKey</b>
     * </p>
     *
     * @return MRP Distribution Key
     */
    @SerializedName( "QuantityDistributionKey" )
    @JsonProperty( "QuantityDistributionKey" )
    @Nullable
    @ODataField( odataName = "QuantityDistributionKey" )
    private String quantityDistributionKey;
    /**
     * Use with available fluent helpers to apply the <b>QuantityDistributionKey</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> QUANTITY_DISTRIBUTION_KEY =
        new ProcessOrderField<String>("QuantityDistributionKey");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StockSegment</b>
     * </p>
     *
     * @return Stock Segment
     */
    @SerializedName( "StockSegment" )
    @JsonProperty( "StockSegment" )
    @Nullable
    @ODataField( odataName = "StockSegment" )
    private String stockSegment;
    /**
     * Use with available fluent helpers to apply the <b>StockSegment</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> STOCK_SEGMENT = new ProcessOrderField<String>("StockSegment");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> STORAGE_LOCATION = new ProcessOrderField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return The lastChangeDateTime contained in this entity.
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @ODataField( odataName = "LastChangeDateTime" )
    private String lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> LAST_CHANGE_DATE_TIME =
        new ProcessOrderField<String>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BasicSchedulingType</b>
     * </p>
     *
     * @return Basic Scheduling Type
     */
    @SerializedName( "BasicSchedulingType" )
    @JsonProperty( "BasicSchedulingType" )
    @Nullable
    @ODataField( odataName = "BasicSchedulingType" )
    private String basicSchedulingType;
    /**
     * Use with available fluent helpers to apply the <b>BasicSchedulingType</b> field to query operations.
     *
     */
    public final static ProcessOrderField<String> BASIC_SCHEDULING_TYPE =
        new ProcessOrderField<String>("BasicSchedulingType");
    /**
     * Navigation property <b>to_ProcessOrderComponent</b> for <b>ProcessOrder</b> to multiple
     * <b>ProcessOrderComponent</b>.
     *
     */
    @SerializedName( "to_ProcessOrderComponent" )
    @JsonProperty( "to_ProcessOrderComponent" )
    @ODataField( odataName = "to_ProcessOrderComponent" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProcessOrderComponent> toProcessOrderComponent;
    /**
     * Navigation property <b>to_ProcessOrderItem</b> for <b>ProcessOrder</b> to multiple <b>ProcessOrderItem</b>.
     *
     */
    @SerializedName( "to_ProcessOrderItem" )
    @JsonProperty( "to_ProcessOrderItem" )
    @ODataField( odataName = "to_ProcessOrderItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProcessOrderItem> toProcessOrderItem;
    /**
     * Navigation property <b>to_ProcessOrderOperation</b> for <b>ProcessOrder</b> to multiple
     * <b>ProcessOrderOperation</b>.
     *
     */
    @SerializedName( "to_ProcessOrderOperation" )
    @JsonProperty( "to_ProcessOrderOperation" )
    @ODataField( odataName = "to_ProcessOrderOperation" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProcessOrderOperation> toProcessOrderOperation;
    /**
     * Navigation property <b>to_ProcessOrderStatus</b> for <b>ProcessOrder</b> to multiple <b>ProcessOrderStatus</b>.
     *
     */
    @SerializedName( "to_ProcessOrderStatus" )
    @JsonProperty( "to_ProcessOrderStatus" )
    @ODataField( odataName = "to_ProcessOrderStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProcessOrderStatus> toProcessOrderStatus;
    /**
     * Use with available fluent helpers to apply the <b>to_ProcessOrderComponent</b> navigation property to query
     * operations.
     *
     */
    public final static ProcessOrderLink<ProcessOrderComponent> TO_PROCESS_ORDER_COMPONENT =
        new ProcessOrderLink<ProcessOrderComponent>("to_ProcessOrderComponent");
    /**
     * Use with available fluent helpers to apply the <b>to_ProcessOrderItem</b> navigation property to query
     * operations.
     *
     */
    public final static ProcessOrderLink<ProcessOrderItem> TO_PROCESS_ORDER_ITEM =
        new ProcessOrderLink<ProcessOrderItem>("to_ProcessOrderItem");
    /**
     * Use with available fluent helpers to apply the <b>to_ProcessOrderOperation</b> navigation property to query
     * operations.
     *
     */
    public final static ProcessOrderLink<ProcessOrderOperation> TO_PROCESS_ORDER_OPERATION =
        new ProcessOrderLink<ProcessOrderOperation>("to_ProcessOrderOperation");
    /**
     * Use with available fluent helpers to apply the <b>to_ProcessOrderStatus</b> navigation property to query
     * operations.
     *
     */
    public final static ProcessOrderLink<ProcessOrderStatus> TO_PROCESS_ORDER_STATUS =
        new ProcessOrderLink<ProcessOrderStatus>("to_ProcessOrderStatus");

    @Nonnull
    @Override
    public Class<ProcessOrder> getType()
    {
        return ProcessOrder.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProcessOrder</b>
     * </p>
     *
     * @param processOrder
     *            Manufacturing Order ID
     */
    public void setProcessOrder( @Nullable final String processOrder )
    {
        rememberChangedField("ProcessOrder", this.processOrder);
        this.processOrder = processOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @param productionPlant
     *            Production Plant
     */
    public void setProductionPlant( @Nullable final String productionPlant )
    {
        rememberChangedField("ProductionPlant", this.productionPlant);
        this.productionPlant = productionPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     */
    public void setOrderInternalBillOfOperations( @Nullable final String orderInternalBillOfOperations )
    {
        rememberChangedField("OrderInternalBillOfOperations", this.orderInternalBillOfOperations);
        this.orderInternalBillOfOperations = orderInternalBillOfOperations;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsCreated</b>
     * </p>
     *
     * @param orderIsCreated
     *            The orderIsCreated to set.
     */
    public void setOrderIsCreated( @Nullable final String orderIsCreated )
    {
        rememberChangedField("OrderIsCreated", this.orderIsCreated);
        this.orderIsCreated = orderIsCreated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsReleased</b>
     * </p>
     *
     * @param orderIsReleased
     *            The orderIsReleased to set.
     */
    public void setOrderIsReleased( @Nullable final String orderIsReleased )
    {
        rememberChangedField("OrderIsReleased", this.orderIsReleased);
        this.orderIsReleased = orderIsReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsPrinted</b>
     * </p>
     *
     * @param orderIsPrinted
     *            The orderIsPrinted to set.
     */
    public void setOrderIsPrinted( @Nullable final String orderIsPrinted )
    {
        rememberChangedField("OrderIsPrinted", this.orderIsPrinted);
        this.orderIsPrinted = orderIsPrinted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsConfirmed</b>
     * </p>
     *
     * @param orderIsConfirmed
     *            The orderIsConfirmed to set.
     */
    public void setOrderIsConfirmed( @Nullable final String orderIsConfirmed )
    {
        rememberChangedField("OrderIsConfirmed", this.orderIsConfirmed);
        this.orderIsConfirmed = orderIsConfirmed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsPartiallyConfirmed</b>
     * </p>
     *
     * @param orderIsPartiallyConfirmed
     *            The orderIsPartiallyConfirmed to set.
     */
    public void setOrderIsPartiallyConfirmed( @Nullable final String orderIsPartiallyConfirmed )
    {
        rememberChangedField("OrderIsPartiallyConfirmed", this.orderIsPartiallyConfirmed);
        this.orderIsPartiallyConfirmed = orderIsPartiallyConfirmed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsDelivered</b>
     * </p>
     *
     * @param orderIsDelivered
     *            The orderIsDelivered to set.
     */
    public void setOrderIsDelivered( @Nullable final String orderIsDelivered )
    {
        rememberChangedField("OrderIsDelivered", this.orderIsDelivered);
        this.orderIsDelivered = orderIsDelivered;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsDeleted</b>
     * </p>
     *
     * @param orderIsDeleted
     *            The orderIsDeleted to set.
     */
    public void setOrderIsDeleted( @Nullable final String orderIsDeleted )
    {
        rememberChangedField("OrderIsDeleted", this.orderIsDeleted);
        this.orderIsDeleted = orderIsDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsPreCosted</b>
     * </p>
     *
     * @param orderIsPreCosted
     *            The orderIsPreCosted to set.
     */
    public void setOrderIsPreCosted( @Nullable final String orderIsPreCosted )
    {
        rememberChangedField("OrderIsPreCosted", this.orderIsPreCosted);
        this.orderIsPreCosted = orderIsPreCosted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlementRuleIsCreated</b>
     * </p>
     *
     * @param settlementRuleIsCreated
     *            The settlementRuleIsCreated to set.
     */
    public void setSettlementRuleIsCreated( @Nullable final String settlementRuleIsCreated )
    {
        rememberChangedField("SettlementRuleIsCreated", this.settlementRuleIsCreated);
        this.settlementRuleIsCreated = settlementRuleIsCreated;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsPartiallyReleased</b>
     * </p>
     *
     * @param orderIsPartiallyReleased
     *            The orderIsPartiallyReleased to set.
     */
    public void setOrderIsPartiallyReleased( @Nullable final String orderIsPartiallyReleased )
    {
        rememberChangedField("OrderIsPartiallyReleased", this.orderIsPartiallyReleased);
        this.orderIsPartiallyReleased = orderIsPartiallyReleased;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsLocked</b>
     * </p>
     *
     * @param orderIsLocked
     *            The orderIsLocked to set.
     */
    public void setOrderIsLocked( @Nullable final String orderIsLocked )
    {
        rememberChangedField("OrderIsLocked", this.orderIsLocked);
        this.orderIsLocked = orderIsLocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsTechnicallyCompleted</b>
     * </p>
     *
     * @param orderIsTechnicallyCompleted
     *            The orderIsTechnicallyCompleted to set.
     */
    public void setOrderIsTechnicallyCompleted( @Nullable final String orderIsTechnicallyCompleted )
    {
        rememberChangedField("OrderIsTechnicallyCompleted", this.orderIsTechnicallyCompleted);
        this.orderIsTechnicallyCompleted = orderIsTechnicallyCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsClosed</b>
     * </p>
     *
     * @param orderIsClosed
     *            The orderIsClosed to set.
     */
    public void setOrderIsClosed( @Nullable final String orderIsClosed )
    {
        rememberChangedField("OrderIsClosed", this.orderIsClosed);
        this.orderIsClosed = orderIsClosed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsPartiallyDelivered</b>
     * </p>
     *
     * @param orderIsPartiallyDelivered
     *            The orderIsPartiallyDelivered to set.
     */
    public void setOrderIsPartiallyDelivered( @Nullable final String orderIsPartiallyDelivered )
    {
        rememberChangedField("OrderIsPartiallyDelivered", this.orderIsPartiallyDelivered);
        this.orderIsPartiallyDelivered = orderIsPartiallyDelivered;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsMarkedForDeletion</b>
     * </p>
     *
     * @param orderIsMarkedForDeletion
     *            The orderIsMarkedForDeletion to set.
     */
    public void setOrderIsMarkedForDeletion( @Nullable final String orderIsMarkedForDeletion )
    {
        rememberChangedField("OrderIsMarkedForDeletion", this.orderIsMarkedForDeletion);
        this.orderIsMarkedForDeletion = orderIsMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SettlementRuleIsCrtedManually</b>
     * </p>
     *
     * @param settlementRuleIsCrtedManually
     *            The settlementRuleIsCrtedManually to set.
     */
    public void setSettlementRuleIsCrtedManually( @Nullable final String settlementRuleIsCrtedManually )
    {
        rememberChangedField("SettlementRuleIsCrtedManually", this.settlementRuleIsCrtedManually);
        this.settlementRuleIsCrtedManually = settlementRuleIsCrtedManually;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsScheduled</b>
     * </p>
     *
     * @param orderIsScheduled
     *            The orderIsScheduled to set.
     */
    public void setOrderIsScheduled( @Nullable final String orderIsScheduled )
    {
        rememberChangedField("OrderIsScheduled", this.orderIsScheduled);
        this.orderIsScheduled = orderIsScheduled;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderHasGeneratedOperations</b>
     * </p>
     *
     * @param orderHasGeneratedOperations
     *            The orderHasGeneratedOperations to set.
     */
    public void setOrderHasGeneratedOperations( @Nullable final String orderHasGeneratedOperations )
    {
        rememberChangedField("OrderHasGeneratedOperations", this.orderHasGeneratedOperations);
        this.orderHasGeneratedOperations = orderHasGeneratedOperations;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderIsToBeHandledInBatches</b>
     * </p>
     *
     * @param orderIsToBeHandledInBatches
     *            The orderIsToBeHandledInBatches to set.
     */
    public void setOrderIsToBeHandledInBatches( @Nullable final String orderIsToBeHandledInBatches )
    {
        rememberChangedField("OrderIsToBeHandledInBatches", this.orderIsToBeHandledInBatches);
        this.orderIsToBeHandledInBatches = orderIsToBeHandledInBatches;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialAvailyIsNotChecked</b>
     * </p>
     *
     * @param materialAvailyIsNotChecked
     *            The materialAvailyIsNotChecked to set.
     */
    public void setMaterialAvailyIsNotChecked( @Nullable final String materialAvailyIsNotChecked )
    {
        rememberChangedField("MaterialAvailyIsNotChecked", this.materialAvailyIsNotChecked);
        this.materialAvailyIsNotChecked = materialAvailyIsNotChecked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number for Order
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MaterialName</b>
     * </p>
     *
     * @param materialName
     *            Material Description
     */
    public void setMaterialName( @Nullable final String materialName )
    {
        rememberChangedField("MaterialName", this.materialName);
        this.materialName = materialName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductionUnit</b>
     * </p>
     *
     * @param productionUnit
     *            Production Unit of Measure
     */
    public void setProductionUnit( @Nullable final String productionUnit )
    {
        rememberChangedField("ProductionUnit", this.productionUnit);
        this.productionUnit = productionUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalQuantity</b>
     * </p>
     *
     * @param totalQuantity
     *            Manufacturing Order Planned Total Quantity
     */
    public void setTotalQuantity( @Nullable final BigDecimal totalQuantity )
    {
        rememberChangedField("TotalQuantity", this.totalQuantity);
        this.totalQuantity = totalQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @param manufacturingOrderType
     *            Order Type
     */
    public void setManufacturingOrderType( @Nullable final String manufacturingOrderType )
    {
        rememberChangedField("ManufacturingOrderType", this.manufacturingOrderType);
        this.manufacturingOrderType = manufacturingOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     */
    public void setMRPArea( @Nullable final String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingObject</b>
     * </p>
     *
     * @param manufacturingObject
     *            Object Internal ID
     */
    public void setManufacturingObject( @Nullable final String manufacturingObject )
    {
        rememberChangedField("ManufacturingObject", this.manufacturingObject);
        this.manufacturingObject = manufacturingObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Planning Plant for an Order
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderConfirmedYieldQty</b>
     * </p>
     *
     * @param mfgOrderConfirmedYieldQty
     *            Confirmed Yield Quantity From Order Confirmation
     */
    public void setMfgOrderConfirmedYieldQty( @Nullable final BigDecimal mfgOrderConfirmedYieldQty )
    {
        rememberChangedField("MfgOrderConfirmedYieldQty", this.mfgOrderConfirmedYieldQty);
        this.mfgOrderConfirmedYieldQty = mfgOrderConfirmedYieldQty;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderPlannedStartDate</b>
     * </p>
     *
     * @param mfgOrderPlannedStartDate
     *            Manufacturing Order Planned Start Date
     */
    public void setMfgOrderPlannedStartDate( @Nullable final LocalDateTime mfgOrderPlannedStartDate )
    {
        rememberChangedField("MfgOrderPlannedStartDate", this.mfgOrderPlannedStartDate);
        this.mfgOrderPlannedStartDate = mfgOrderPlannedStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderPlannedStartTime</b>
     * </p>
     *
     * @param mfgOrderPlannedStartTime
     *            Manufacturing Order Planned Start Time
     */
    public void setMfgOrderPlannedStartTime( @Nullable final LocalTime mfgOrderPlannedStartTime )
    {
        rememberChangedField("MfgOrderPlannedStartTime", this.mfgOrderPlannedStartTime);
        this.mfgOrderPlannedStartTime = mfgOrderPlannedStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderPlannedEndDate</b>
     * </p>
     *
     * @param mfgOrderPlannedEndDate
     *            Manufacturing Order Planned End Date
     */
    public void setMfgOrderPlannedEndDate( @Nullable final LocalDateTime mfgOrderPlannedEndDate )
    {
        rememberChangedField("MfgOrderPlannedEndDate", this.mfgOrderPlannedEndDate);
        this.mfgOrderPlannedEndDate = mfgOrderPlannedEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderPlannedEndTime</b>
     * </p>
     *
     * @param mfgOrderPlannedEndTime
     *            Manufacturing Order Planned End Time
     */
    public void setMfgOrderPlannedEndTime( @Nullable final LocalTime mfgOrderPlannedEndTime )
    {
        rememberChangedField("MfgOrderPlannedEndTime", this.mfgOrderPlannedEndTime);
        this.mfgOrderPlannedEndTime = mfgOrderPlannedEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderScheduledStartDate</b>
     * </p>
     *
     * @param mfgOrderScheduledStartDate
     *            Manufacturing Order Scheduled Start Date
     */
    public void setMfgOrderScheduledStartDate( @Nullable final LocalDateTime mfgOrderScheduledStartDate )
    {
        rememberChangedField("MfgOrderScheduledStartDate", this.mfgOrderScheduledStartDate);
        this.mfgOrderScheduledStartDate = mfgOrderScheduledStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderScheduledStartTime</b>
     * </p>
     *
     * @param mfgOrderScheduledStartTime
     *            Manufacturing Order Scheduled Start Time
     */
    public void setMfgOrderScheduledStartTime( @Nullable final LocalTime mfgOrderScheduledStartTime )
    {
        rememberChangedField("MfgOrderScheduledStartTime", this.mfgOrderScheduledStartTime);
        this.mfgOrderScheduledStartTime = mfgOrderScheduledStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderScheduledEndDate</b>
     * </p>
     *
     * @param mfgOrderScheduledEndDate
     *            Manufacturing Order Scheduled End Date
     */
    public void setMfgOrderScheduledEndDate( @Nullable final LocalDateTime mfgOrderScheduledEndDate )
    {
        rememberChangedField("MfgOrderScheduledEndDate", this.mfgOrderScheduledEndDate);
        this.mfgOrderScheduledEndDate = mfgOrderScheduledEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderScheduledEndTime</b>
     * </p>
     *
     * @param mfgOrderScheduledEndTime
     *            Manufacturing Order Scheduled End Time
     */
    public void setMfgOrderScheduledEndTime( @Nullable final LocalTime mfgOrderScheduledEndTime )
    {
        rememberChangedField("MfgOrderScheduledEndTime", this.mfgOrderScheduledEndTime);
        this.mfgOrderScheduledEndTime = mfgOrderScheduledEndTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PlannedOrder</b>
     * </p>
     *
     * @param plannedOrder
     *            Planned Order
     */
    public void setPlannedOrder( @Nullable final String plannedOrder )
    {
        rememberChangedField("PlannedOrder", this.plannedOrder);
        this.plannedOrder = plannedOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CustomerName</b>
     * </p>
     *
     * @param customerName
     *            Name of Customer
     */
    public void setCustomerName( @Nullable final String customerName )
    {
        rememberChangedField("CustomerName", this.customerName);
        this.customerName = customerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            WBS Element
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            Work Breakdown Structure Element Internal ID
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSDescription</b>
     * </p>
     *
     * @param wBSDescription
     *            WBS Element Name
     */
    public void setWBSDescription( @Nullable final String wBSDescription )
    {
        rememberChangedField("WBSDescription", this.wBSDescription);
        this.wBSDescription = wBSDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PlannedCostsCostingVariant</b>
     * </p>
     *
     * @param plannedCostsCostingVariant
     *            Costing Variant for Planned Costs
     */
    public void setPlannedCostsCostingVariant( @Nullable final String plannedCostsCostingVariant )
    {
        rememberChangedField("PlannedCostsCostingVariant", this.plannedCostsCostingVariant);
        this.plannedCostsCostingVariant = plannedCostsCostingVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ActualCostsCostingVariant</b>
     * </p>
     *
     * @param actualCostsCostingVariant
     *            Costing Variant For Actual Costs
     */
    public void setActualCostsCostingVariant( @Nullable final String actualCostsCostingVariant )
    {
        rememberChangedField("ActualCostsCostingVariant", this.actualCostsCostingVariant);
        this.actualCostsCostingVariant = actualCostsCostingVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>UserID</b>
     * </p>
     *
     * @param userID
     *            Object ID for recipient
     */
    public void setUserID( @Nullable final String userID )
    {
        rememberChangedField("UserID", this.userID);
        this.userID = userID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionVersion</b>
     * </p>
     *
     * @param productionVersion
     *            Production Version
     */
    public void setProductionVersion( @Nullable final String productionVersion )
    {
        rememberChangedField("ProductionVersion", this.productionVersion);
        this.productionVersion = productionVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MRPController</b>
     * </p>
     *
     * @param mRPController
     *            MRP Controller
     */
    public void setMRPController( @Nullable final String mRPController )
    {
        rememberChangedField("MRPController", this.mRPController);
        this.mRPController = mRPController;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductionSupervisor</b>
     * </p>
     *
     * @param productionSupervisor
     *            Production Supervisor
     */
    public void setProductionSupervisor( @Nullable final String productionSupervisor )
    {
        rememberChangedField("ProductionSupervisor", this.productionSupervisor);
        this.productionSupervisor = productionSupervisor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @param manufacturingOrderCategory
     *            Order Category
     */
    public void setManufacturingOrderCategory( @Nullable final String manufacturingOrderCategory )
    {
        rememberChangedField("ManufacturingOrderCategory", this.manufacturingOrderCategory);
        this.manufacturingOrderCategory = manufacturingOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderPlannedScrapQty</b>
     * </p>
     *
     * @param mfgOrderPlannedScrapQty
     *            Manufacturing Order Planned Scrap Quantity
     */
    public void setMfgOrderPlannedScrapQty( @Nullable final BigDecimal mfgOrderPlannedScrapQty )
    {
        rememberChangedField("MfgOrderPlannedScrapQty", this.mfgOrderPlannedScrapQty);
        this.mfgOrderPlannedScrapQty = mfgOrderPlannedScrapQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderImportance</b>
     * </p>
     *
     * @param manufacturingOrderImportance
     *            Order Importance Code
     */
    public void setManufacturingOrderImportance( @Nullable final String manufacturingOrderImportance )
    {
        rememberChangedField("ManufacturingOrderImportance", this.manufacturingOrderImportance);
        this.manufacturingOrderImportance = manufacturingOrderImportance;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>OrderSequenceNumber</b>
     * </p>
     *
     * @param orderSequenceNumber
     *            Sequence Number Order
     */
    public void setOrderSequenceNumber( @Nullable final String orderSequenceNumber )
    {
        rememberChangedField("OrderSequenceNumber", this.orderSequenceNumber);
        this.orderSequenceNumber = orderSequenceNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderCreationDate</b>
     * </p>
     *
     * @param mfgOrderCreationDate
     *            Order Creation Date
     */
    public void setMfgOrderCreationDate( @Nullable final LocalDateTime mfgOrderCreationDate )
    {
        rememberChangedField("MfgOrderCreationDate", this.mfgOrderCreationDate);
        this.mfgOrderCreationDate = mfgOrderCreationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderCreationTime</b>
     * </p>
     *
     * @param mfgOrderCreationTime
     *            Order Creation Time
     */
    public void setMfgOrderCreationTime( @Nullable final LocalTime mfgOrderCreationTime )
    {
        rememberChangedField("MfgOrderCreationTime", this.mfgOrderCreationTime);
        this.mfgOrderCreationTime = mfgOrderCreationTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderActualReleaseDate</b>
     * </p>
     *
     * @param mfgOrderActualReleaseDate
     *            Manufacturing Order Actual Release Date
     */
    public void setMfgOrderActualReleaseDate( @Nullable final LocalDateTime mfgOrderActualReleaseDate )
    {
        rememberChangedField("MfgOrderActualReleaseDate", this.mfgOrderActualReleaseDate);
        this.mfgOrderActualReleaseDate = mfgOrderActualReleaseDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @param goodsRecipientName
     *            Goods Recipient
     */
    public void setGoodsRecipientName( @Nullable final String goodsRecipientName )
    {
        rememberChangedField("GoodsRecipientName", this.goodsRecipientName);
        this.goodsRecipientName = goodsRecipientName;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGoodsReceiptDuration</b>
     * </p>
     *
     * @param materialGoodsReceiptDuration
     *            Goods Receipt Processing Duration in Days
     */
    public void setMaterialGoodsReceiptDuration( @Nullable final BigDecimal materialGoodsReceiptDuration )
    {
        rememberChangedField("MaterialGoodsReceiptDuration", this.materialGoodsReceiptDuration);
        this.materialGoodsReceiptDuration = materialGoodsReceiptDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventoryUsabilityCode</b>
     * </p>
     *
     * @param inventoryUsabilityCode
     *            Inventory Usability Code
     */
    public void setInventoryUsabilityCode( @Nullable final String inventoryUsabilityCode )
    {
        rememberChangedField("InventoryUsabilityCode", this.inventoryUsabilityCode);
        this.inventoryUsabilityCode = inventoryUsabilityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @param unloadingPointName
     *            Unloading Point
     */
    public void setUnloadingPointName( @Nullable final String unloadingPointName )
    {
        rememberChangedField("UnloadingPointName", this.unloadingPointName);
        this.unloadingPointName = unloadingPointName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>QuantityDistributionKey</b>
     * </p>
     *
     * @param quantityDistributionKey
     *            MRP Distribution Key
     */
    public void setQuantityDistributionKey( @Nullable final String quantityDistributionKey )
    {
        rememberChangedField("QuantityDistributionKey", this.quantityDistributionKey);
        this.quantityDistributionKey = quantityDistributionKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StockSegment</b>
     * </p>
     *
     * @param stockSegment
     *            Stock Segment
     */
    public void setStockSegment( @Nullable final String stockSegment )
    {
        rememberChangedField("StockSegment", this.stockSegment);
        this.stockSegment = stockSegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            The lastChangeDateTime to set.
     */
    public void setLastChangeDateTime( @Nullable final String lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BasicSchedulingType</b>
     * </p>
     *
     * @param basicSchedulingType
     *            Basic Scheduling Type
     */
    public void setBasicSchedulingType( @Nullable final String basicSchedulingType )
    {
        rememberChangedField("BasicSchedulingType", this.basicSchedulingType);
        this.basicSchedulingType = basicSchedulingType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProcessOrder";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProcessOrder", getProcessOrder());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProcessOrder", getProcessOrder());
        values.put("ProductionPlant", getProductionPlant());
        values.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        values.put("OrderIsCreated", getOrderIsCreated());
        values.put("OrderIsReleased", getOrderIsReleased());
        values.put("OrderIsPrinted", getOrderIsPrinted());
        values.put("OrderIsConfirmed", getOrderIsConfirmed());
        values.put("OrderIsPartiallyConfirmed", getOrderIsPartiallyConfirmed());
        values.put("OrderIsDelivered", getOrderIsDelivered());
        values.put("OrderIsDeleted", getOrderIsDeleted());
        values.put("OrderIsPreCosted", getOrderIsPreCosted());
        values.put("SettlementRuleIsCreated", getSettlementRuleIsCreated());
        values.put("OrderIsPartiallyReleased", getOrderIsPartiallyReleased());
        values.put("OrderIsLocked", getOrderIsLocked());
        values.put("OrderIsTechnicallyCompleted", getOrderIsTechnicallyCompleted());
        values.put("OrderIsClosed", getOrderIsClosed());
        values.put("OrderIsPartiallyDelivered", getOrderIsPartiallyDelivered());
        values.put("OrderIsMarkedForDeletion", getOrderIsMarkedForDeletion());
        values.put("SettlementRuleIsCrtedManually", getSettlementRuleIsCrtedManually());
        values.put("OrderIsScheduled", getOrderIsScheduled());
        values.put("OrderHasGeneratedOperations", getOrderHasGeneratedOperations());
        values.put("OrderIsToBeHandledInBatches", getOrderIsToBeHandledInBatches());
        values.put("MaterialAvailyIsNotChecked", getMaterialAvailyIsNotChecked());
        values.put("Material", getMaterial());
        values.put("MaterialName", getMaterialName());
        values.put("ProductionUnit", getProductionUnit());
        values.put("TotalQuantity", getTotalQuantity());
        values.put("ManufacturingOrderType", getManufacturingOrderType());
        values.put("MRPArea", getMRPArea());
        values.put("ManufacturingObject", getManufacturingObject());
        values.put("Plant", getPlant());
        values.put("MfgOrderConfirmedYieldQty", getMfgOrderConfirmedYieldQty());
        values.put("MfgOrderPlannedStartDate", getMfgOrderPlannedStartDate());
        values.put("MfgOrderPlannedStartTime", getMfgOrderPlannedStartTime());
        values.put("MfgOrderPlannedEndDate", getMfgOrderPlannedEndDate());
        values.put("MfgOrderPlannedEndTime", getMfgOrderPlannedEndTime());
        values.put("MfgOrderScheduledStartDate", getMfgOrderScheduledStartDate());
        values.put("MfgOrderScheduledStartTime", getMfgOrderScheduledStartTime());
        values.put("MfgOrderScheduledEndDate", getMfgOrderScheduledEndDate());
        values.put("MfgOrderScheduledEndTime", getMfgOrderScheduledEndTime());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("PlannedOrder", getPlannedOrder());
        values.put("CustomerName", getCustomerName());
        values.put("WBSElement", getWBSElement());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("WBSDescription", getWBSDescription());
        values.put("CompanyCode", getCompanyCode());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("PlannedCostsCostingVariant", getPlannedCostsCostingVariant());
        values.put("ActualCostsCostingVariant", getActualCostsCostingVariant());
        values.put("UserID", getUserID());
        values.put("ProductionVersion", getProductionVersion());
        values.put("MRPController", getMRPController());
        values.put("ProductionSupervisor", getProductionSupervisor());
        values.put("ManufacturingOrderCategory", getManufacturingOrderCategory());
        values.put("BusinessArea", getBusinessArea());
        values.put("MfgOrderPlannedScrapQty", getMfgOrderPlannedScrapQty());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ManufacturingOrderImportance", getManufacturingOrderImportance());
        values.put("OrderSequenceNumber", getOrderSequenceNumber());
        values.put("MfgOrderCreationDate", getMfgOrderCreationDate());
        values.put("MfgOrderCreationTime", getMfgOrderCreationTime());
        values.put("MfgOrderActualReleaseDate", getMfgOrderActualReleaseDate());
        values.put("GoodsRecipientName", getGoodsRecipientName());
        values.put("MaterialGoodsReceiptDuration", getMaterialGoodsReceiptDuration());
        values.put("InventoryUsabilityCode", getInventoryUsabilityCode());
        values.put("UnloadingPointName", getUnloadingPointName());
        values.put("QuantityDistributionKey", getQuantityDistributionKey());
        values.put("StockSegment", getStockSegment());
        values.put("StorageLocation", getStorageLocation());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("BasicSchedulingType", getBasicSchedulingType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProcessOrder") ) {
                final Object value = values.remove("ProcessOrder");
                if( (value == null) || (!value.equals(getProcessOrder())) ) {
                    setProcessOrder(((String) value));
                }
            }
            if( values.containsKey("ProductionPlant") ) {
                final Object value = values.remove("ProductionPlant");
                if( (value == null) || (!value.equals(getProductionPlant())) ) {
                    setProductionPlant(((String) value));
                }
            }
            if( values.containsKey("OrderInternalBillOfOperations") ) {
                final Object value = values.remove("OrderInternalBillOfOperations");
                if( (value == null) || (!value.equals(getOrderInternalBillOfOperations())) ) {
                    setOrderInternalBillOfOperations(((String) value));
                }
            }
            if( values.containsKey("OrderIsCreated") ) {
                final Object value = values.remove("OrderIsCreated");
                if( (value == null) || (!value.equals(getOrderIsCreated())) ) {
                    setOrderIsCreated(((String) value));
                }
            }
            if( values.containsKey("OrderIsReleased") ) {
                final Object value = values.remove("OrderIsReleased");
                if( (value == null) || (!value.equals(getOrderIsReleased())) ) {
                    setOrderIsReleased(((String) value));
                }
            }
            if( values.containsKey("OrderIsPrinted") ) {
                final Object value = values.remove("OrderIsPrinted");
                if( (value == null) || (!value.equals(getOrderIsPrinted())) ) {
                    setOrderIsPrinted(((String) value));
                }
            }
            if( values.containsKey("OrderIsConfirmed") ) {
                final Object value = values.remove("OrderIsConfirmed");
                if( (value == null) || (!value.equals(getOrderIsConfirmed())) ) {
                    setOrderIsConfirmed(((String) value));
                }
            }
            if( values.containsKey("OrderIsPartiallyConfirmed") ) {
                final Object value = values.remove("OrderIsPartiallyConfirmed");
                if( (value == null) || (!value.equals(getOrderIsPartiallyConfirmed())) ) {
                    setOrderIsPartiallyConfirmed(((String) value));
                }
            }
            if( values.containsKey("OrderIsDelivered") ) {
                final Object value = values.remove("OrderIsDelivered");
                if( (value == null) || (!value.equals(getOrderIsDelivered())) ) {
                    setOrderIsDelivered(((String) value));
                }
            }
            if( values.containsKey("OrderIsDeleted") ) {
                final Object value = values.remove("OrderIsDeleted");
                if( (value == null) || (!value.equals(getOrderIsDeleted())) ) {
                    setOrderIsDeleted(((String) value));
                }
            }
            if( values.containsKey("OrderIsPreCosted") ) {
                final Object value = values.remove("OrderIsPreCosted");
                if( (value == null) || (!value.equals(getOrderIsPreCosted())) ) {
                    setOrderIsPreCosted(((String) value));
                }
            }
            if( values.containsKey("SettlementRuleIsCreated") ) {
                final Object value = values.remove("SettlementRuleIsCreated");
                if( (value == null) || (!value.equals(getSettlementRuleIsCreated())) ) {
                    setSettlementRuleIsCreated(((String) value));
                }
            }
            if( values.containsKey("OrderIsPartiallyReleased") ) {
                final Object value = values.remove("OrderIsPartiallyReleased");
                if( (value == null) || (!value.equals(getOrderIsPartiallyReleased())) ) {
                    setOrderIsPartiallyReleased(((String) value));
                }
            }
            if( values.containsKey("OrderIsLocked") ) {
                final Object value = values.remove("OrderIsLocked");
                if( (value == null) || (!value.equals(getOrderIsLocked())) ) {
                    setOrderIsLocked(((String) value));
                }
            }
            if( values.containsKey("OrderIsTechnicallyCompleted") ) {
                final Object value = values.remove("OrderIsTechnicallyCompleted");
                if( (value == null) || (!value.equals(getOrderIsTechnicallyCompleted())) ) {
                    setOrderIsTechnicallyCompleted(((String) value));
                }
            }
            if( values.containsKey("OrderIsClosed") ) {
                final Object value = values.remove("OrderIsClosed");
                if( (value == null) || (!value.equals(getOrderIsClosed())) ) {
                    setOrderIsClosed(((String) value));
                }
            }
            if( values.containsKey("OrderIsPartiallyDelivered") ) {
                final Object value = values.remove("OrderIsPartiallyDelivered");
                if( (value == null) || (!value.equals(getOrderIsPartiallyDelivered())) ) {
                    setOrderIsPartiallyDelivered(((String) value));
                }
            }
            if( values.containsKey("OrderIsMarkedForDeletion") ) {
                final Object value = values.remove("OrderIsMarkedForDeletion");
                if( (value == null) || (!value.equals(getOrderIsMarkedForDeletion())) ) {
                    setOrderIsMarkedForDeletion(((String) value));
                }
            }
            if( values.containsKey("SettlementRuleIsCrtedManually") ) {
                final Object value = values.remove("SettlementRuleIsCrtedManually");
                if( (value == null) || (!value.equals(getSettlementRuleIsCrtedManually())) ) {
                    setSettlementRuleIsCrtedManually(((String) value));
                }
            }
            if( values.containsKey("OrderIsScheduled") ) {
                final Object value = values.remove("OrderIsScheduled");
                if( (value == null) || (!value.equals(getOrderIsScheduled())) ) {
                    setOrderIsScheduled(((String) value));
                }
            }
            if( values.containsKey("OrderHasGeneratedOperations") ) {
                final Object value = values.remove("OrderHasGeneratedOperations");
                if( (value == null) || (!value.equals(getOrderHasGeneratedOperations())) ) {
                    setOrderHasGeneratedOperations(((String) value));
                }
            }
            if( values.containsKey("OrderIsToBeHandledInBatches") ) {
                final Object value = values.remove("OrderIsToBeHandledInBatches");
                if( (value == null) || (!value.equals(getOrderIsToBeHandledInBatches())) ) {
                    setOrderIsToBeHandledInBatches(((String) value));
                }
            }
            if( values.containsKey("MaterialAvailyIsNotChecked") ) {
                final Object value = values.remove("MaterialAvailyIsNotChecked");
                if( (value == null) || (!value.equals(getMaterialAvailyIsNotChecked())) ) {
                    setMaterialAvailyIsNotChecked(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialName") ) {
                final Object value = values.remove("MaterialName");
                if( (value == null) || (!value.equals(getMaterialName())) ) {
                    setMaterialName(((String) value));
                }
            }
            if( values.containsKey("ProductionUnit") ) {
                final Object value = values.remove("ProductionUnit");
                if( (value == null) || (!value.equals(getProductionUnit())) ) {
                    setProductionUnit(((String) value));
                }
            }
            if( values.containsKey("TotalQuantity") ) {
                final Object value = values.remove("TotalQuantity");
                if( (value == null) || (!value.equals(getTotalQuantity())) ) {
                    setTotalQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ManufacturingOrderType") ) {
                final Object value = values.remove("ManufacturingOrderType");
                if( (value == null) || (!value.equals(getManufacturingOrderType())) ) {
                    setManufacturingOrderType(((String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((String) value));
                }
            }
            if( values.containsKey("ManufacturingObject") ) {
                final Object value = values.remove("ManufacturingObject");
                if( (value == null) || (!value.equals(getManufacturingObject())) ) {
                    setManufacturingObject(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MfgOrderConfirmedYieldQty") ) {
                final Object value = values.remove("MfgOrderConfirmedYieldQty");
                if( (value == null) || (!value.equals(getMfgOrderConfirmedYieldQty())) ) {
                    setMfgOrderConfirmedYieldQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("MfgOrderPlannedStartDate") ) {
                final Object value = values.remove("MfgOrderPlannedStartDate");
                if( (value == null) || (!value.equals(getMfgOrderPlannedStartDate())) ) {
                    setMfgOrderPlannedStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MfgOrderPlannedStartTime") ) {
                final Object value = values.remove("MfgOrderPlannedStartTime");
                if( (value == null) || (!value.equals(getMfgOrderPlannedStartTime())) ) {
                    setMfgOrderPlannedStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MfgOrderPlannedEndDate") ) {
                final Object value = values.remove("MfgOrderPlannedEndDate");
                if( (value == null) || (!value.equals(getMfgOrderPlannedEndDate())) ) {
                    setMfgOrderPlannedEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MfgOrderPlannedEndTime") ) {
                final Object value = values.remove("MfgOrderPlannedEndTime");
                if( (value == null) || (!value.equals(getMfgOrderPlannedEndTime())) ) {
                    setMfgOrderPlannedEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MfgOrderScheduledStartDate") ) {
                final Object value = values.remove("MfgOrderScheduledStartDate");
                if( (value == null) || (!value.equals(getMfgOrderScheduledStartDate())) ) {
                    setMfgOrderScheduledStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MfgOrderScheduledStartTime") ) {
                final Object value = values.remove("MfgOrderScheduledStartTime");
                if( (value == null) || (!value.equals(getMfgOrderScheduledStartTime())) ) {
                    setMfgOrderScheduledStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MfgOrderScheduledEndDate") ) {
                final Object value = values.remove("MfgOrderScheduledEndDate");
                if( (value == null) || (!value.equals(getMfgOrderScheduledEndDate())) ) {
                    setMfgOrderScheduledEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MfgOrderScheduledEndTime") ) {
                final Object value = values.remove("MfgOrderScheduledEndTime");
                if( (value == null) || (!value.equals(getMfgOrderScheduledEndTime())) ) {
                    setMfgOrderScheduledEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("PlannedOrder") ) {
                final Object value = values.remove("PlannedOrder");
                if( (value == null) || (!value.equals(getPlannedOrder())) ) {
                    setPlannedOrder(((String) value));
                }
            }
            if( values.containsKey("CustomerName") ) {
                final Object value = values.remove("CustomerName");
                if( (value == null) || (!value.equals(getCustomerName())) ) {
                    setCustomerName(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("WBSDescription") ) {
                final Object value = values.remove("WBSDescription");
                if( (value == null) || (!value.equals(getWBSDescription())) ) {
                    setWBSDescription(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("PlannedCostsCostingVariant") ) {
                final Object value = values.remove("PlannedCostsCostingVariant");
                if( (value == null) || (!value.equals(getPlannedCostsCostingVariant())) ) {
                    setPlannedCostsCostingVariant(((String) value));
                }
            }
            if( values.containsKey("ActualCostsCostingVariant") ) {
                final Object value = values.remove("ActualCostsCostingVariant");
                if( (value == null) || (!value.equals(getActualCostsCostingVariant())) ) {
                    setActualCostsCostingVariant(((String) value));
                }
            }
            if( values.containsKey("UserID") ) {
                final Object value = values.remove("UserID");
                if( (value == null) || (!value.equals(getUserID())) ) {
                    setUserID(((String) value));
                }
            }
            if( values.containsKey("ProductionVersion") ) {
                final Object value = values.remove("ProductionVersion");
                if( (value == null) || (!value.equals(getProductionVersion())) ) {
                    setProductionVersion(((String) value));
                }
            }
            if( values.containsKey("MRPController") ) {
                final Object value = values.remove("MRPController");
                if( (value == null) || (!value.equals(getMRPController())) ) {
                    setMRPController(((String) value));
                }
            }
            if( values.containsKey("ProductionSupervisor") ) {
                final Object value = values.remove("ProductionSupervisor");
                if( (value == null) || (!value.equals(getProductionSupervisor())) ) {
                    setProductionSupervisor(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderCategory") ) {
                final Object value = values.remove("ManufacturingOrderCategory");
                if( (value == null) || (!value.equals(getManufacturingOrderCategory())) ) {
                    setManufacturingOrderCategory(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("MfgOrderPlannedScrapQty") ) {
                final Object value = values.remove("MfgOrderPlannedScrapQty");
                if( (value == null) || (!value.equals(getMfgOrderPlannedScrapQty())) ) {
                    setMfgOrderPlannedScrapQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderImportance") ) {
                final Object value = values.remove("ManufacturingOrderImportance");
                if( (value == null) || (!value.equals(getManufacturingOrderImportance())) ) {
                    setManufacturingOrderImportance(((String) value));
                }
            }
            if( values.containsKey("OrderSequenceNumber") ) {
                final Object value = values.remove("OrderSequenceNumber");
                if( (value == null) || (!value.equals(getOrderSequenceNumber())) ) {
                    setOrderSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("MfgOrderCreationDate") ) {
                final Object value = values.remove("MfgOrderCreationDate");
                if( (value == null) || (!value.equals(getMfgOrderCreationDate())) ) {
                    setMfgOrderCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MfgOrderCreationTime") ) {
                final Object value = values.remove("MfgOrderCreationTime");
                if( (value == null) || (!value.equals(getMfgOrderCreationTime())) ) {
                    setMfgOrderCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("MfgOrderActualReleaseDate") ) {
                final Object value = values.remove("MfgOrderActualReleaseDate");
                if( (value == null) || (!value.equals(getMfgOrderActualReleaseDate())) ) {
                    setMfgOrderActualReleaseDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("GoodsRecipientName") ) {
                final Object value = values.remove("GoodsRecipientName");
                if( (value == null) || (!value.equals(getGoodsRecipientName())) ) {
                    setGoodsRecipientName(((String) value));
                }
            }
            if( values.containsKey("MaterialGoodsReceiptDuration") ) {
                final Object value = values.remove("MaterialGoodsReceiptDuration");
                if( (value == null) || (!value.equals(getMaterialGoodsReceiptDuration())) ) {
                    setMaterialGoodsReceiptDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("InventoryUsabilityCode") ) {
                final Object value = values.remove("InventoryUsabilityCode");
                if( (value == null) || (!value.equals(getInventoryUsabilityCode())) ) {
                    setInventoryUsabilityCode(((String) value));
                }
            }
            if( values.containsKey("UnloadingPointName") ) {
                final Object value = values.remove("UnloadingPointName");
                if( (value == null) || (!value.equals(getUnloadingPointName())) ) {
                    setUnloadingPointName(((String) value));
                }
            }
            if( values.containsKey("QuantityDistributionKey") ) {
                final Object value = values.remove("QuantityDistributionKey");
                if( (value == null) || (!value.equals(getQuantityDistributionKey())) ) {
                    setQuantityDistributionKey(((String) value));
                }
            }
            if( values.containsKey("StockSegment") ) {
                final Object value = values.remove("StockSegment");
                if( (value == null) || (!value.equals(getStockSegment())) ) {
                    setStockSegment(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((String) value));
                }
            }
            if( values.containsKey("BasicSchedulingType") ) {
                final Object value = values.remove("BasicSchedulingType");
                if( (value == null) || (!value.equals(getBasicSchedulingType())) ) {
                    setBasicSchedulingType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_ProcessOrderComponent") ) {
                final Object value = (values).remove("to_ProcessOrderComponent");
                if( value instanceof Iterable ) {
                    if( toProcessOrderComponent == null ) {
                        toProcessOrderComponent = Lists.newArrayList();
                    } else {
                        toProcessOrderComponent = Lists.newArrayList(toProcessOrderComponent);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProcessOrderComponent entity;
                        if( toProcessOrderComponent.size() > i ) {
                            entity = toProcessOrderComponent.get(i);
                        } else {
                            entity = new ProcessOrderComponent();
                            toProcessOrderComponent.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProcessOrderItem") ) {
                final Object value = (values).remove("to_ProcessOrderItem");
                if( value instanceof Iterable ) {
                    if( toProcessOrderItem == null ) {
                        toProcessOrderItem = Lists.newArrayList();
                    } else {
                        toProcessOrderItem = Lists.newArrayList(toProcessOrderItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProcessOrderItem entity;
                        if( toProcessOrderItem.size() > i ) {
                            entity = toProcessOrderItem.get(i);
                        } else {
                            entity = new ProcessOrderItem();
                            toProcessOrderItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProcessOrderOperation") ) {
                final Object value = (values).remove("to_ProcessOrderOperation");
                if( value instanceof Iterable ) {
                    if( toProcessOrderOperation == null ) {
                        toProcessOrderOperation = Lists.newArrayList();
                    } else {
                        toProcessOrderOperation = Lists.newArrayList(toProcessOrderOperation);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProcessOrderOperation entity;
                        if( toProcessOrderOperation.size() > i ) {
                            entity = toProcessOrderOperation.get(i);
                        } else {
                            entity = new ProcessOrderOperation();
                            toProcessOrderOperation.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProcessOrderStatus") ) {
                final Object value = (values).remove("to_ProcessOrderStatus");
                if( value instanceof Iterable ) {
                    if( toProcessOrderStatus == null ) {
                        toProcessOrderStatus = Lists.newArrayList();
                    } else {
                        toProcessOrderStatus = Lists.newArrayList(toProcessOrderStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProcessOrderStatus entity;
                        if( toProcessOrderStatus.size() > i ) {
                            entity = toProcessOrderStatus.get(i);
                        } else {
                            entity = new ProcessOrderStatus();
                            toProcessOrderStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProcessOrderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProcessOrderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProcessOrderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProcessOrderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toProcessOrderComponent != null ) {
            (values).put("to_ProcessOrderComponent", toProcessOrderComponent);
        }
        if( toProcessOrderItem != null ) {
            (values).put("to_ProcessOrderItem", toProcessOrderItem);
        }
        if( toProcessOrderOperation != null ) {
            (values).put("to_ProcessOrderOperation", toProcessOrderOperation);
        }
        if( toProcessOrderStatus != null ) {
            (values).put("to_ProcessOrderStatus", toProcessOrderStatus);
        }
        return values;
    }

    /**
     * Fetches the <b>ProcessOrderComponent</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ProcessOrderComponent</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProcessOrderComponent</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProcessOrderComponent> fetchProcessOrderComponent()
    {
        return fetchFieldAsList("to_ProcessOrderComponent", ProcessOrderComponent.class);
    }

    /**
     * Retrieval of associated <b>ProcessOrderComponent</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProcessOrderComponent</b>.
     * <p>
     * If the navigation property <b>to_ProcessOrderComponent</b> of a queried <b>ProcessOrder</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProcessOrderComponent</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProcessOrderComponent> getProcessOrderComponentOrFetch()
    {
        if( toProcessOrderComponent == null ) {
            toProcessOrderComponent = fetchProcessOrderComponent();
        }
        return toProcessOrderComponent;
    }

    /**
     * Retrieval of associated <b>ProcessOrderComponent</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProcessOrderComponent</b>.
     * <p>
     * If the navigation property for an entity <b>ProcessOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProcessOrderComponent</b> is already loaded, the result
     *         will contain the <b>ProcessOrderComponent</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProcessOrderComponent>> getProcessOrderComponentIfPresent()
    {
        return Option.of(toProcessOrderComponent);
    }

    /**
     * Overwrites the list of associated <b>ProcessOrderComponent</b> entities for the loaded navigation property
     * <b>to_ProcessOrderComponent</b>.
     * <p>
     * If the navigation property <b>to_ProcessOrderComponent</b> of a queried <b>ProcessOrder</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProcessOrderComponent</b> entities.
     */
    public void setProcessOrderComponent( @Nonnull final List<ProcessOrderComponent> value )
    {
        if( toProcessOrderComponent == null ) {
            toProcessOrderComponent = Lists.newArrayList();
        }
        toProcessOrderComponent.clear();
        toProcessOrderComponent.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProcessOrderComponent</b> entities. This corresponds to the OData
     * navigation property <b>to_ProcessOrderComponent</b>.
     * <p>
     * If the navigation property <b>to_ProcessOrderComponent</b> of a queried <b>ProcessOrder</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProcessOrderComponent</b> entities.
     */
    public void addProcessOrderComponent( ProcessOrderComponent... entity )
    {
        if( toProcessOrderComponent == null ) {
            toProcessOrderComponent = Lists.newArrayList();
        }
        toProcessOrderComponent.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProcessOrderItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ProcessOrderItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProcessOrderItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProcessOrderItem> fetchProcessOrderItem()
    {
        return fetchFieldAsList("to_ProcessOrderItem", ProcessOrderItem.class);
    }

    /**
     * Retrieval of associated <b>ProcessOrderItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ProcessOrderItem</b>.
     * <p>
     * If the navigation property <b>to_ProcessOrderItem</b> of a queried <b>ProcessOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProcessOrderItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProcessOrderItem> getProcessOrderItemOrFetch()
    {
        if( toProcessOrderItem == null ) {
            toProcessOrderItem = fetchProcessOrderItem();
        }
        return toProcessOrderItem;
    }

    /**
     * Retrieval of associated <b>ProcessOrderItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_ProcessOrderItem</b>.
     * <p>
     * If the navigation property for an entity <b>ProcessOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProcessOrderItem</b> is already loaded, the result will
     *         contain the <b>ProcessOrderItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProcessOrderItem>> getProcessOrderItemIfPresent()
    {
        return Option.of(toProcessOrderItem);
    }

    /**
     * Overwrites the list of associated <b>ProcessOrderItem</b> entities for the loaded navigation property
     * <b>to_ProcessOrderItem</b>.
     * <p>
     * If the navigation property <b>to_ProcessOrderItem</b> of a queried <b>ProcessOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProcessOrderItem</b> entities.
     */
    public void setProcessOrderItem( @Nonnull final List<ProcessOrderItem> value )
    {
        if( toProcessOrderItem == null ) {
            toProcessOrderItem = Lists.newArrayList();
        }
        toProcessOrderItem.clear();
        toProcessOrderItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProcessOrderItem</b> entities. This corresponds to the OData
     * navigation property <b>to_ProcessOrderItem</b>.
     * <p>
     * If the navigation property <b>to_ProcessOrderItem</b> of a queried <b>ProcessOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProcessOrderItem</b> entities.
     */
    public void addProcessOrderItem( ProcessOrderItem... entity )
    {
        if( toProcessOrderItem == null ) {
            toProcessOrderItem = Lists.newArrayList();
        }
        toProcessOrderItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProcessOrderOperation</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ProcessOrderOperation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProcessOrderOperation</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProcessOrderOperation> fetchProcessOrderOperation()
    {
        return fetchFieldAsList("to_ProcessOrderOperation", ProcessOrderOperation.class);
    }

    /**
     * Retrieval of associated <b>ProcessOrderOperation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProcessOrderOperation</b>.
     * <p>
     * If the navigation property <b>to_ProcessOrderOperation</b> of a queried <b>ProcessOrder</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProcessOrderOperation</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProcessOrderOperation> getProcessOrderOperationOrFetch()
    {
        if( toProcessOrderOperation == null ) {
            toProcessOrderOperation = fetchProcessOrderOperation();
        }
        return toProcessOrderOperation;
    }

    /**
     * Retrieval of associated <b>ProcessOrderOperation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProcessOrderOperation</b>.
     * <p>
     * If the navigation property for an entity <b>ProcessOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProcessOrderOperation</b> is already loaded, the result
     *         will contain the <b>ProcessOrderOperation</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProcessOrderOperation>> getProcessOrderOperationIfPresent()
    {
        return Option.of(toProcessOrderOperation);
    }

    /**
     * Overwrites the list of associated <b>ProcessOrderOperation</b> entities for the loaded navigation property
     * <b>to_ProcessOrderOperation</b>.
     * <p>
     * If the navigation property <b>to_ProcessOrderOperation</b> of a queried <b>ProcessOrder</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProcessOrderOperation</b> entities.
     */
    public void setProcessOrderOperation( @Nonnull final List<ProcessOrderOperation> value )
    {
        if( toProcessOrderOperation == null ) {
            toProcessOrderOperation = Lists.newArrayList();
        }
        toProcessOrderOperation.clear();
        toProcessOrderOperation.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProcessOrderOperation</b> entities. This corresponds to the OData
     * navigation property <b>to_ProcessOrderOperation</b>.
     * <p>
     * If the navigation property <b>to_ProcessOrderOperation</b> of a queried <b>ProcessOrder</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProcessOrderOperation</b> entities.
     */
    public void addProcessOrderOperation( ProcessOrderOperation... entity )
    {
        if( toProcessOrderOperation == null ) {
            toProcessOrderOperation = Lists.newArrayList();
        }
        toProcessOrderOperation.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProcessOrderStatus</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_ProcessOrderStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProcessOrderStatus</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProcessOrderStatus> fetchProcessOrderStatus()
    {
        return fetchFieldAsList("to_ProcessOrderStatus", ProcessOrderStatus.class);
    }

    /**
     * Retrieval of associated <b>ProcessOrderStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProcessOrderStatus</b>.
     * <p>
     * If the navigation property <b>to_ProcessOrderStatus</b> of a queried <b>ProcessOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProcessOrderStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProcessOrderStatus> getProcessOrderStatusOrFetch()
    {
        if( toProcessOrderStatus == null ) {
            toProcessOrderStatus = fetchProcessOrderStatus();
        }
        return toProcessOrderStatus;
    }

    /**
     * Retrieval of associated <b>ProcessOrderStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProcessOrderStatus</b>.
     * <p>
     * If the navigation property for an entity <b>ProcessOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProcessOrderStatus</b> is already loaded, the result
     *         will contain the <b>ProcessOrderStatus</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProcessOrderStatus>> getProcessOrderStatusIfPresent()
    {
        return Option.of(toProcessOrderStatus);
    }

    /**
     * Overwrites the list of associated <b>ProcessOrderStatus</b> entities for the loaded navigation property
     * <b>to_ProcessOrderStatus</b>.
     * <p>
     * If the navigation property <b>to_ProcessOrderStatus</b> of a queried <b>ProcessOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProcessOrderStatus</b> entities.
     */
    public void setProcessOrderStatus( @Nonnull final List<ProcessOrderStatus> value )
    {
        if( toProcessOrderStatus == null ) {
            toProcessOrderStatus = Lists.newArrayList();
        }
        toProcessOrderStatus.clear();
        toProcessOrderStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProcessOrderStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_ProcessOrderStatus</b>.
     * <p>
     * If the navigation property <b>to_ProcessOrderStatus</b> of a queried <b>ProcessOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProcessOrderStatus</b> entities.
     */
    public void addProcessOrderStatus( ProcessOrderStatus... entity )
    {
        if( toProcessOrderStatus == null ) {
            toProcessOrderStatus = Lists.newArrayList();
        }
        toProcessOrderStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProcessOrder instances.
     *
     */
    public final static class ProcessOrderBuilder
    {

        private List<ProcessOrderComponent> toProcessOrderComponent = Lists.newArrayList();
        private List<ProcessOrderItem> toProcessOrderItem = Lists.newArrayList();
        private List<ProcessOrderOperation> toProcessOrderOperation = Lists.newArrayList();
        private List<ProcessOrderStatus> toProcessOrderStatus = Lists.newArrayList();

        private ProcessOrder.ProcessOrderBuilder toProcessOrderComponent( final List<ProcessOrderComponent> value )
        {
            toProcessOrderComponent.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProcessOrderComponent</b> for <b>ProcessOrder</b> to multiple
         * <b>ProcessOrderComponent</b>.
         *
         * @param value
         *            The ProcessOrderComponents to build this ProcessOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProcessOrder.ProcessOrderBuilder processOrderComponent( ProcessOrderComponent... value )
        {
            return toProcessOrderComponent(Lists.newArrayList(value));
        }

        private ProcessOrder.ProcessOrderBuilder toProcessOrderItem( final List<ProcessOrderItem> value )
        {
            toProcessOrderItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProcessOrderItem</b> for <b>ProcessOrder</b> to multiple <b>ProcessOrderItem</b>.
         *
         * @param value
         *            The ProcessOrderItems to build this ProcessOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProcessOrder.ProcessOrderBuilder processOrderItem( ProcessOrderItem... value )
        {
            return toProcessOrderItem(Lists.newArrayList(value));
        }

        private ProcessOrder.ProcessOrderBuilder toProcessOrderOperation( final List<ProcessOrderOperation> value )
        {
            toProcessOrderOperation.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProcessOrderOperation</b> for <b>ProcessOrder</b> to multiple
         * <b>ProcessOrderOperation</b>.
         *
         * @param value
         *            The ProcessOrderOperations to build this ProcessOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProcessOrder.ProcessOrderBuilder processOrderOperation( ProcessOrderOperation... value )
        {
            return toProcessOrderOperation(Lists.newArrayList(value));
        }

        private ProcessOrder.ProcessOrderBuilder toProcessOrderStatus( final List<ProcessOrderStatus> value )
        {
            toProcessOrderStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProcessOrderStatus</b> for <b>ProcessOrder</b> to multiple
         * <b>ProcessOrderStatus</b>.
         *
         * @param value
         *            The ProcessOrderStatuss to build this ProcessOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProcessOrder.ProcessOrderBuilder processOrderStatus( ProcessOrderStatus... value )
        {
            return toProcessOrderStatus(Lists.newArrayList(value));
        }

    }

}
