/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.field.ProcessOrderComponentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.selectable.ProcessOrderComponentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * API for Process Order Components
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProcessOrderComponentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProcessOrderComponent extends VdmEntity<ProcessOrderComponent>
{

    /**
     * Selector for all available fields of ProcessOrderComponent.
     *
     */
    public final static ProcessOrderComponentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @return Number of reservation/dependent requirements
     */
    @Key
    @SerializedName( "Reservation" )
    @JsonProperty( "Reservation" )
    @Nullable
    @ODataField( odataName = "Reservation" )
    private String reservation;
    /**
     * Use with available fluent helpers to apply the <b>Reservation</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> RESERVATION =
        new ProcessOrderComponentField<String>("Reservation");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @return Reservation Item
     */
    @Key
    @SerializedName( "ReservationItem" )
    @JsonProperty( "ReservationItem" )
    @Nullable
    @ODataField( odataName = "ReservationItem" )
    private String reservationItem;
    /**
     * Use with available fluent helpers to apply the <b>ReservationItem</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> RESERVATION_ITEM =
        new ProcessOrderComponentField<String>("ReservationItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     * </p>
     *
     * @return BOM item number
     */
    @SerializedName( "BillOfMaterialItemNumber" )
    @JsonProperty( "BillOfMaterialItemNumber" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialItemNumber" )
    private String billOfMaterialItemNumber;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialItemNumber</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> BILL_OF_MATERIAL_ITEM_NUMBER =
        new ProcessOrderComponentField<String>("BillOfMaterialItemNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @return BOM Item Text (Line 1)
     */
    @SerializedName( "BOMItemDescription" )
    @JsonProperty( "BOMItemDescription" )
    @Nullable
    @ODataField( odataName = "BOMItemDescription" )
    private String bOMItemDescription;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemDescription</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> BOM_ITEM_DESCRIPTION =
        new ProcessOrderComponentField<String>("BOMItemDescription");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> MATERIAL =
        new ProcessOrderComponentField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> PLANT = new ProcessOrderComponentField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @return Production Plant
     */
    @SerializedName( "ProductionPlant" )
    @JsonProperty( "ProductionPlant" )
    @Nullable
    @ODataField( odataName = "ProductionPlant" )
    private String productionPlant;
    /**
     * Use with available fluent helpers to apply the <b>ProductionPlant</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> PRODUCTION_PLANT =
        new ProcessOrderComponentField<String>("ProductionPlant");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompRequirementDate</b>
     * </p>
     *
     * @return Material Component Requirement Date
     */
    @SerializedName( "MatlCompRequirementDate" )
    @JsonProperty( "MatlCompRequirementDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MatlCompRequirementDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime matlCompRequirementDate;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompRequirementDate</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<LocalDateTime> MATL_COMP_REQUIREMENT_DATE =
        new ProcessOrderComponentField<LocalDateTime>("MatlCompRequirementDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> BASE_UNIT =
        new ProcessOrderComponentField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequiredQuantity</b>
     * </p>
     *
     * @return Requirement Quantity
     */
    @SerializedName( "RequiredQuantity" )
    @JsonProperty( "RequiredQuantity" )
    @Nullable
    @ODataField( odataName = "RequiredQuantity" )
    private BigDecimal requiredQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequiredQuantity</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<BigDecimal> REQUIRED_QUANTITY =
        new ProcessOrderComponentField<BigDecimal>("RequiredQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawnQuantity</b>
     * </p>
     *
     * @return Withdrawn Quantity
     */
    @SerializedName( "WithdrawnQuantity" )
    @JsonProperty( "WithdrawnQuantity" )
    @Nullable
    @ODataField( odataName = "WithdrawnQuantity" )
    private BigDecimal withdrawnQuantity;
    /**
     * Use with available fluent helpers to apply the <b>WithdrawnQuantity</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<BigDecimal> WITHDRAWN_QUANTITY =
        new ProcessOrderComponentField<BigDecimal>("WithdrawnQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMItem</b>
     * </p>
     *
     * @return Bill of Material Item
     */
    @SerializedName( "BOMItem" )
    @JsonProperty( "BOMItem" )
    @Nullable
    @ODataField( odataName = "BOMItem" )
    private String bOMItem;
    /**
     * Use with available fluent helpers to apply the <b>BOMItem</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> BOM_ITEM = new ProcessOrderComponentField<String>("BOMItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> STORAGE_LOCATION =
        new ProcessOrderComponentField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyArea</b>
     * </p>
     *
     * @return Production Supply Area
     */
    @SerializedName( "SupplyArea" )
    @JsonProperty( "SupplyArea" )
    @Nullable
    @ODataField( odataName = "SupplyArea" )
    private String supplyArea;
    /**
     * Use with available fluent helpers to apply the <b>SupplyArea</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> SUPPLY_AREA =
        new ProcessOrderComponentField<String>("SupplyArea");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSequence</b>
     * </p>
     *
     * @return Sequence
     */
    @SerializedName( "ManufacturingOrderSequence" )
    @JsonProperty( "ManufacturingOrderSequence" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderSequence" )
    private String manufacturingOrderSequence;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderSequence</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> MANUFACTURING_ORDER_SEQUENCE =
        new ProcessOrderComponentField<String>("ManufacturingOrderSequence");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @return Manufacturing Order ID
     */
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrder</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> MANUFACTURING_ORDER =
        new ProcessOrderComponentField<String>("ManufacturingOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @return Manufacturing Order Operation
     */
    @SerializedName( "ManufacturingOrderOperation" )
    @JsonProperty( "ManufacturingOrderOperation" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderOperation" )
    private String manufacturingOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderOperation</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> MANUFACTURING_ORDER_OPERATION =
        new ProcessOrderComponentField<String>("ManufacturingOrderOperation");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @return Manufacturing Order Category
     */
    @SerializedName( "ManufacturingOrderCategory" )
    @JsonProperty( "ManufacturingOrderCategory" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderCategory" )
    private String manufacturingOrderCategory;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderCategory</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> MANUFACTURING_ORDER_CATEGORY =
        new ProcessOrderComponentField<String>("ManufacturingOrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @return Manufacturing Order Type
     */
    @SerializedName( "ManufacturingOrderType" )
    @JsonProperty( "ManufacturingOrderType" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderType" )
    private String manufacturingOrderType;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderType</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> MANUFACTURING_ORDER_TYPE =
        new ProcessOrderComponentField<String>("ManufacturingOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @return Order Internal ID
     */
    @SerializedName( "OrderInternalBillOfOperations" )
    @JsonProperty( "OrderInternalBillOfOperations" )
    @Nullable
    @ODataField( odataName = "OrderInternalBillOfOperations" )
    private String orderInternalBillOfOperations;
    /**
     * Use with available fluent helpers to apply the <b>OrderInternalBillOfOperations</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> ORDER_INTERNAL_BILL_OF_OPERATIONS =
        new ProcessOrderComponentField<String>("OrderInternalBillOfOperations");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemText2</b>
     * </p>
     *
     * @return BOM Item Text (Line 2)
     */
    @SerializedName( "BOMItemText2" )
    @JsonProperty( "BOMItemText2" )
    @Nullable
    @ODataField( odataName = "BOMItemText2" )
    private String bOMItemText2;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemText2</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> BOM_ITEM_TEXT2 =
        new ProcessOrderComponentField<String>("BOMItemText2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemCategory</b>
     * </p>
     *
     * @return Bill of Material Item Category
     */
    @SerializedName( "BOMItemCategory" )
    @JsonProperty( "BOMItemCategory" )
    @Nullable
    @ODataField( odataName = "BOMItemCategory" )
    private String bOMItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>BOMItemCategory</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> BOM_ITEM_CATEGORY =
        new ProcessOrderComponentField<String>("BOMItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @return Bill of Material Category Code
     */
    @SerializedName( "BillOfMaterialCategory" )
    @JsonProperty( "BillOfMaterialCategory" )
    @Nullable
    @ODataField( odataName = "BillOfMaterialCategory" )
    private String billOfMaterialCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillOfMaterialCategory</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> BILL_OF_MATERIAL_CATEGORY =
        new ProcessOrderComponentField<String>("BillOfMaterialCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SortField</b>
     * </p>
     *
     * @return Sort String
     */
    @SerializedName( "SortField" )
    @JsonProperty( "SortField" )
    @Nullable
    @ODataField( odataName = "SortField" )
    private String sortField;
    /**
     * Use with available fluent helpers to apply the <b>SortField</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> SORT_FIELD =
        new ProcessOrderComponentField<String>("SortField");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @return Goods Recipient
     */
    @SerializedName( "GoodsRecipientName" )
    @JsonProperty( "GoodsRecipientName" )
    @Nullable
    @ODataField( odataName = "GoodsRecipientName" )
    private String goodsRecipientName;
    /**
     * Use with available fluent helpers to apply the <b>GoodsRecipientName</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> GOODS_RECIPIENT_NAME =
        new ProcessOrderComponentField<String>("GoodsRecipientName");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @return Unloading Point
     */
    @SerializedName( "UnloadingPointName" )
    @JsonProperty( "UnloadingPointName" )
    @Nullable
    @ODataField( odataName = "UnloadingPointName" )
    private String unloadingPointName;
    /**
     * Use with available fluent helpers to apply the <b>UnloadingPointName</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> UNLOADING_POINT_NAME =
        new ProcessOrderComponentField<String>("UnloadingPointName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> BATCH = new ProcessOrderComponentField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BatchSplitType</b>
     * </p>
     *
     * @return Batch key
     */
    @SerializedName( "BatchSplitType" )
    @JsonProperty( "BatchSplitType" )
    @Nullable
    @ODataField( odataName = "BatchSplitType" )
    private String batchSplitType;
    /**
     * Use with available fluent helpers to apply the <b>BatchSplitType</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> BATCH_SPLIT_TYPE =
        new ProcessOrderComponentField<String>("BatchSplitType");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialCompOriginalQuantity</b>
     * </p>
     *
     * @return Original Quantity of a Material Component
     */
    @SerializedName( "MaterialCompOriginalQuantity" )
    @JsonProperty( "MaterialCompOriginalQuantity" )
    @Nullable
    @ODataField( odataName = "MaterialCompOriginalQuantity" )
    private BigDecimal materialCompOriginalQuantity;
    /**
     * Use with available fluent helpers to apply the <b>MaterialCompOriginalQuantity</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<BigDecimal> MATERIAL_COMP_ORIGINAL_QUANTITY =
        new ProcessOrderComponentField<BigDecimal>("MaterialCompOriginalQuantity");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     *
     * @return Indicator: Backflush
     */
    @SerializedName( "MatlCompIsMarkedForBackflush" )
    @JsonProperty( "MatlCompIsMarkedForBackflush" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MatlCompIsMarkedForBackflush" )
    private Boolean matlCompIsMarkedForBackflush;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompIsMarkedForBackflush</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<Boolean> MATL_COMP_IS_MARKED_FOR_BACKFLUSH =
        new ProcessOrderComponentField<Boolean>("MatlCompIsMarkedForBackflush");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBulkMaterialComponent</b>
     * </p>
     *
     * @return Indicator: Bulk Material
     */
    @SerializedName( "IsBulkMaterialComponent" )
    @JsonProperty( "IsBulkMaterialComponent" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsBulkMaterialComponent" )
    private Boolean isBulkMaterialComponent;
    /**
     * Use with available fluent helpers to apply the <b>IsBulkMaterialComponent</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<Boolean> IS_BULK_MATERIAL_COMPONENT =
        new ProcessOrderComponentField<Boolean>("IsBulkMaterialComponent");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialComponentIsPhantomItem</b>
     * </p>
     *
     * @return Phantom Item Indicator
     */
    @SerializedName( "MaterialComponentIsPhantomItem" )
    @JsonProperty( "MaterialComponentIsPhantomItem" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MaterialComponentIsPhantomItem" )
    private Boolean materialComponentIsPhantomItem;
    /**
     * Use with available fluent helpers to apply the <b>MaterialComponentIsPhantomItem</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<Boolean> MATERIAL_COMPONENT_IS_PHANTOM_ITEM =
        new ProcessOrderComponentField<Boolean>("MaterialComponentIsPhantomItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialCompIsCostRelevant</b>
     * </p>
     *
     * @return Indicator for Relevancy to Costing
     */
    @SerializedName( "MaterialCompIsCostRelevant" )
    @JsonProperty( "MaterialCompIsCostRelevant" )
    @Nullable
    @ODataField( odataName = "MaterialCompIsCostRelevant" )
    private String materialCompIsCostRelevant;
    /**
     * Use with available fluent helpers to apply the <b>MaterialCompIsCostRelevant</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> MATERIAL_COMP_IS_COST_RELEVANT =
        new ProcessOrderComponentField<String>("MaterialCompIsCostRelevant");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedAvailableQuantity</b>
     * </p>
     *
     * @return Available Quantity
     */
    @SerializedName( "ConfirmedAvailableQuantity" )
    @JsonProperty( "ConfirmedAvailableQuantity" )
    @Nullable
    @ODataField( odataName = "ConfirmedAvailableQuantity" )
    private BigDecimal confirmedAvailableQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedAvailableQuantity</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<BigDecimal> CONFIRMED_AVAILABLE_QUANTITY =
        new ProcessOrderComponentField<BigDecimal>("ConfirmedAvailableQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @return Movement Type (Inventory Management)
     */
    @SerializedName( "GoodsMovementType" )
    @JsonProperty( "GoodsMovementType" )
    @Nullable
    @ODataField( odataName = "GoodsMovementType" )
    private String goodsMovementType;
    /**
     * Use with available fluent helpers to apply the <b>GoodsMovementType</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> GOODS_MOVEMENT_TYPE =
        new ProcessOrderComponentField<String>("GoodsMovementType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompRequirementTime</b>
     * </p>
     *
     * @return Material Component Requirement Time
     */
    @SerializedName( "MatlCompRequirementTime" )
    @JsonProperty( "MatlCompRequirementTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "MatlCompRequirementTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime matlCompRequirementTime;
    /**
     * Use with available fluent helpers to apply the <b>MatlCompRequirementTime</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<LocalTime> MATL_COMP_REQUIREMENT_TIME =
        new ProcessOrderComponentField<LocalTime>("MatlCompRequirementTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> SALES_ORDER =
        new ProcessOrderComponentField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> SALES_ORDER_ITEM =
        new ProcessOrderComponentField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ComponentScrapInPercent</b>
     * </p>
     *
     * @return Component Scrap in Percent
     */
    @SerializedName( "ComponentScrapInPercent" )
    @JsonProperty( "ComponentScrapInPercent" )
    @Nullable
    @ODataField( odataName = "ComponentScrapInPercent" )
    private BigDecimal componentScrapInPercent;
    /**
     * Use with available fluent helpers to apply the <b>ComponentScrapInPercent</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<BigDecimal> COMPONENT_SCRAP_IN_PERCENT =
        new ProcessOrderComponentField<BigDecimal>("ComponentScrapInPercent");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>OperationScrapInPercent</b>
     * </p>
     *
     * @return Operation Scrap
     */
    @SerializedName( "OperationScrapInPercent" )
    @JsonProperty( "OperationScrapInPercent" )
    @Nullable
    @ODataField( odataName = "OperationScrapInPercent" )
    private BigDecimal operationScrapInPercent;
    /**
     * Use with available fluent helpers to apply the <b>OperationScrapInPercent</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<BigDecimal> OPERATION_SCRAP_IN_PERCENT =
        new ProcessOrderComponentField<BigDecimal>("OperationScrapInPercent");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsFixed</b>
     * </p>
     *
     * @return Quantity is fixed
     */
    @SerializedName( "QuantityIsFixed" )
    @JsonProperty( "QuantityIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "QuantityIsFixed" )
    private Boolean quantityIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>QuantityIsFixed</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<Boolean> QUANTITY_IS_FIXED =
        new ProcessOrderComponentField<Boolean>("QuantityIsFixed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNetScrap</b>
     * </p>
     *
     * @return Net Scrap Indicator
     */
    @SerializedName( "IsNetScrap" )
    @JsonProperty( "IsNetScrap" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsNetScrap" )
    private Boolean isNetScrap;
    /**
     * Use with available fluent helpers to apply the <b>IsNetScrap</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<Boolean> IS_NET_SCRAP =
        new ProcessOrderComponentField<Boolean>("IsNetScrap");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReservationIsFinallyIssued</b>
     * </p>
     *
     * @return Final Issue for Reservation
     */
    @SerializedName( "ReservationIsFinallyIssued" )
    @JsonProperty( "ReservationIsFinallyIssued" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ReservationIsFinallyIssued" )
    private Boolean reservationIsFinallyIssued;
    /**
     * Use with available fluent helpers to apply the <b>ReservationIsFinallyIssued</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<Boolean> RESERVATION_IS_FINALLY_ISSUED =
        new ProcessOrderComponentField<Boolean>("ReservationIsFinallyIssued");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawnQuantityAmount</b>
     * </p>
     *
     * @return Value Withdrawn
     */
    @SerializedName( "WithdrawnQuantityAmount" )
    @JsonProperty( "WithdrawnQuantityAmount" )
    @Nullable
    @ODataField( odataName = "WithdrawnQuantityAmount" )
    private BigDecimal withdrawnQuantityAmount;
    /**
     * Use with available fluent helpers to apply the <b>WithdrawnQuantityAmount</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<BigDecimal> WITHDRAWN_QUANTITY_AMOUNT =
        new ProcessOrderComponentField<BigDecimal>("WithdrawnQuantityAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> CURRENCY =
        new ProcessOrderComponentField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeOffset</b>
     * </p>
     *
     * @return Lead-Time Offset
     */
    @SerializedName( "LeadTimeOffset" )
    @JsonProperty( "LeadTimeOffset" )
    @Nullable
    @ODataField( odataName = "LeadTimeOffset" )
    private BigDecimal leadTimeOffset;
    /**
     * Use with available fluent helpers to apply the <b>LeadTimeOffset</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<BigDecimal> LEAD_TIME_OFFSET =
        new ProcessOrderComponentField<BigDecimal>("LeadTimeOffset");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static ProcessOrderComponentField<String> MATERIAL_GROUP =
        new ProcessOrderComponentField<String>("MaterialGroup");

    @Nonnull
    @Override
    public Class<ProcessOrderComponent> getType()
    {
        return ProcessOrderComponent.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Reservation</b>
     * </p>
     *
     * @param reservation
     *            Number of reservation/dependent requirements
     */
    public void setReservation( @Nullable final String reservation )
    {
        rememberChangedField("Reservation", this.reservation);
        this.reservation = reservation;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReservationItem</b>
     * </p>
     *
     * @param reservationItem
     *            Reservation Item
     */
    public void setReservationItem( @Nullable final String reservationItem )
    {
        rememberChangedField("ReservationItem", this.reservationItem);
        this.reservationItem = reservationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialItemNumber</b>
     * </p>
     *
     * @param billOfMaterialItemNumber
     *            BOM item number
     */
    public void setBillOfMaterialItemNumber( @Nullable final String billOfMaterialItemNumber )
    {
        rememberChangedField("BillOfMaterialItemNumber", this.billOfMaterialItemNumber);
        this.billOfMaterialItemNumber = billOfMaterialItemNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemDescription</b>
     * </p>
     *
     * @param bOMItemDescription
     *            BOM Item Text (Line 1)
     */
    public void setBOMItemDescription( @Nullable final String bOMItemDescription )
    {
        rememberChangedField("BOMItemDescription", this.bOMItemDescription);
        this.bOMItemDescription = bOMItemDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @param productionPlant
     *            Production Plant
     */
    public void setProductionPlant( @Nullable final String productionPlant )
    {
        rememberChangedField("ProductionPlant", this.productionPlant);
        this.productionPlant = productionPlant;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompRequirementDate</b>
     * </p>
     *
     * @param matlCompRequirementDate
     *            Material Component Requirement Date
     */
    public void setMatlCompRequirementDate( @Nullable final LocalDateTime matlCompRequirementDate )
    {
        rememberChangedField("MatlCompRequirementDate", this.matlCompRequirementDate);
        this.matlCompRequirementDate = matlCompRequirementDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequiredQuantity</b>
     * </p>
     *
     * @param requiredQuantity
     *            Requirement Quantity
     */
    public void setRequiredQuantity( @Nullable final BigDecimal requiredQuantity )
    {
        rememberChangedField("RequiredQuantity", this.requiredQuantity);
        this.requiredQuantity = requiredQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawnQuantity</b>
     * </p>
     *
     * @param withdrawnQuantity
     *            Withdrawn Quantity
     */
    public void setWithdrawnQuantity( @Nullable final BigDecimal withdrawnQuantity )
    {
        rememberChangedField("WithdrawnQuantity", this.withdrawnQuantity);
        this.withdrawnQuantity = withdrawnQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>BOMItem</b>
     * </p>
     *
     * @param bOMItem
     *            Bill of Material Item
     */
    public void setBOMItem( @Nullable final String bOMItem )
    {
        rememberChangedField("BOMItem", this.bOMItem);
        this.bOMItem = bOMItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SupplyArea</b>
     * </p>
     *
     * @param supplyArea
     *            Production Supply Area
     */
    public void setSupplyArea( @Nullable final String supplyArea )
    {
        rememberChangedField("SupplyArea", this.supplyArea);
        this.supplyArea = supplyArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSequence</b>
     * </p>
     *
     * @param manufacturingOrderSequence
     *            Sequence
     */
    public void setManufacturingOrderSequence( @Nullable final String manufacturingOrderSequence )
    {
        rememberChangedField("ManufacturingOrderSequence", this.manufacturingOrderSequence);
        this.manufacturingOrderSequence = manufacturingOrderSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Manufacturing Order ID
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @param manufacturingOrderOperation
     *            Manufacturing Order Operation
     */
    public void setManufacturingOrderOperation( @Nullable final String manufacturingOrderOperation )
    {
        rememberChangedField("ManufacturingOrderOperation", this.manufacturingOrderOperation);
        this.manufacturingOrderOperation = manufacturingOrderOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @param manufacturingOrderCategory
     *            Manufacturing Order Category
     */
    public void setManufacturingOrderCategory( @Nullable final String manufacturingOrderCategory )
    {
        rememberChangedField("ManufacturingOrderCategory", this.manufacturingOrderCategory);
        this.manufacturingOrderCategory = manufacturingOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @param manufacturingOrderType
     *            Manufacturing Order Type
     */
    public void setManufacturingOrderType( @Nullable final String manufacturingOrderType )
    {
        rememberChangedField("ManufacturingOrderType", this.manufacturingOrderType);
        this.manufacturingOrderType = manufacturingOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     */
    public void setOrderInternalBillOfOperations( @Nullable final String orderInternalBillOfOperations )
    {
        rememberChangedField("OrderInternalBillOfOperations", this.orderInternalBillOfOperations);
        this.orderInternalBillOfOperations = orderInternalBillOfOperations;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemText2</b>
     * </p>
     *
     * @param bOMItemText2
     *            BOM Item Text (Line 2)
     */
    public void setBOMItemText2( @Nullable final String bOMItemText2 )
    {
        rememberChangedField("BOMItemText2", this.bOMItemText2);
        this.bOMItemText2 = bOMItemText2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BOMItemCategory</b>
     * </p>
     *
     * @param bOMItemCategory
     *            Bill of Material Item Category
     */
    public void setBOMItemCategory( @Nullable final String bOMItemCategory )
    {
        rememberChangedField("BOMItemCategory", this.bOMItemCategory);
        this.bOMItemCategory = bOMItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillOfMaterialCategory</b>
     * </p>
     *
     * @param billOfMaterialCategory
     *            Bill of Material Category Code
     */
    public void setBillOfMaterialCategory( @Nullable final String billOfMaterialCategory )
    {
        rememberChangedField("BillOfMaterialCategory", this.billOfMaterialCategory);
        this.billOfMaterialCategory = billOfMaterialCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SortField</b>
     * </p>
     *
     * @param sortField
     *            Sort String
     */
    public void setSortField( @Nullable final String sortField )
    {
        rememberChangedField("SortField", this.sortField);
        this.sortField = sortField;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @param goodsRecipientName
     *            Goods Recipient
     */
    public void setGoodsRecipientName( @Nullable final String goodsRecipientName )
    {
        rememberChangedField("GoodsRecipientName", this.goodsRecipientName);
        this.goodsRecipientName = goodsRecipientName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @param unloadingPointName
     *            Unloading Point
     */
    public void setUnloadingPointName( @Nullable final String unloadingPointName )
    {
        rememberChangedField("UnloadingPointName", this.unloadingPointName);
        this.unloadingPointName = unloadingPointName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BatchSplitType</b>
     * </p>
     *
     * @param batchSplitType
     *            Batch key
     */
    public void setBatchSplitType( @Nullable final String batchSplitType )
    {
        rememberChangedField("BatchSplitType", this.batchSplitType);
        this.batchSplitType = batchSplitType;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaterialCompOriginalQuantity</b>
     * </p>
     *
     * @param materialCompOriginalQuantity
     *            Original Quantity of a Material Component
     */
    public void setMaterialCompOriginalQuantity( @Nullable final BigDecimal materialCompOriginalQuantity )
    {
        rememberChangedField("MaterialCompOriginalQuantity", this.materialCompOriginalQuantity);
        this.materialCompOriginalQuantity = materialCompOriginalQuantity;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompIsMarkedForBackflush</b>
     * </p>
     *
     * @param matlCompIsMarkedForBackflush
     *            Indicator: Backflush
     */
    public void setMatlCompIsMarkedForBackflush( @Nullable final Boolean matlCompIsMarkedForBackflush )
    {
        rememberChangedField("MatlCompIsMarkedForBackflush", this.matlCompIsMarkedForBackflush);
        this.matlCompIsMarkedForBackflush = matlCompIsMarkedForBackflush;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsBulkMaterialComponent</b>
     * </p>
     *
     * @param isBulkMaterialComponent
     *            Indicator: Bulk Material
     */
    public void setIsBulkMaterialComponent( @Nullable final Boolean isBulkMaterialComponent )
    {
        rememberChangedField("IsBulkMaterialComponent", this.isBulkMaterialComponent);
        this.isBulkMaterialComponent = isBulkMaterialComponent;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MaterialComponentIsPhantomItem</b>
     * </p>
     *
     * @param materialComponentIsPhantomItem
     *            Phantom Item Indicator
     */
    public void setMaterialComponentIsPhantomItem( @Nullable final Boolean materialComponentIsPhantomItem )
    {
        rememberChangedField("MaterialComponentIsPhantomItem", this.materialComponentIsPhantomItem);
        this.materialComponentIsPhantomItem = materialComponentIsPhantomItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>MaterialCompIsCostRelevant</b>
     * </p>
     *
     * @param materialCompIsCostRelevant
     *            Indicator for Relevancy to Costing
     */
    public void setMaterialCompIsCostRelevant( @Nullable final String materialCompIsCostRelevant )
    {
        rememberChangedField("MaterialCompIsCostRelevant", this.materialCompIsCostRelevant);
        this.materialCompIsCostRelevant = materialCompIsCostRelevant;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedAvailableQuantity</b>
     * </p>
     *
     * @param confirmedAvailableQuantity
     *            Available Quantity
     */
    public void setConfirmedAvailableQuantity( @Nullable final BigDecimal confirmedAvailableQuantity )
    {
        rememberChangedField("ConfirmedAvailableQuantity", this.confirmedAvailableQuantity);
        this.confirmedAvailableQuantity = confirmedAvailableQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>GoodsMovementType</b>
     * </p>
     *
     * @param goodsMovementType
     *            Movement Type (Inventory Management)
     */
    public void setGoodsMovementType( @Nullable final String goodsMovementType )
    {
        rememberChangedField("GoodsMovementType", this.goodsMovementType);
        this.goodsMovementType = goodsMovementType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MatlCompRequirementTime</b>
     * </p>
     *
     * @param matlCompRequirementTime
     *            Material Component Requirement Time
     */
    public void setMatlCompRequirementTime( @Nullable final LocalTime matlCompRequirementTime )
    {
        rememberChangedField("MatlCompRequirementTime", this.matlCompRequirementTime);
        this.matlCompRequirementTime = matlCompRequirementTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>ComponentScrapInPercent</b>
     * </p>
     *
     * @param componentScrapInPercent
     *            Component Scrap in Percent
     */
    public void setComponentScrapInPercent( @Nullable final BigDecimal componentScrapInPercent )
    {
        rememberChangedField("ComponentScrapInPercent", this.componentScrapInPercent);
        this.componentScrapInPercent = componentScrapInPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>OperationScrapInPercent</b>
     * </p>
     *
     * @param operationScrapInPercent
     *            Operation Scrap
     */
    public void setOperationScrapInPercent( @Nullable final BigDecimal operationScrapInPercent )
    {
        rememberChangedField("OperationScrapInPercent", this.operationScrapInPercent);
        this.operationScrapInPercent = operationScrapInPercent;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>QuantityIsFixed</b>
     * </p>
     *
     * @param quantityIsFixed
     *            Quantity is fixed
     */
    public void setQuantityIsFixed( @Nullable final Boolean quantityIsFixed )
    {
        rememberChangedField("QuantityIsFixed", this.quantityIsFixed);
        this.quantityIsFixed = quantityIsFixed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsNetScrap</b>
     * </p>
     *
     * @param isNetScrap
     *            Net Scrap Indicator
     */
    public void setIsNetScrap( @Nullable final Boolean isNetScrap )
    {
        rememberChangedField("IsNetScrap", this.isNetScrap);
        this.isNetScrap = isNetScrap;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ReservationIsFinallyIssued</b>
     * </p>
     *
     * @param reservationIsFinallyIssued
     *            Final Issue for Reservation
     */
    public void setReservationIsFinallyIssued( @Nullable final Boolean reservationIsFinallyIssued )
    {
        rememberChangedField("ReservationIsFinallyIssued", this.reservationIsFinallyIssued);
        this.reservationIsFinallyIssued = reservationIsFinallyIssued;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>WithdrawnQuantityAmount</b>
     * </p>
     *
     * @param withdrawnQuantityAmount
     *            Value Withdrawn
     */
    public void setWithdrawnQuantityAmount( @Nullable final BigDecimal withdrawnQuantityAmount )
    {
        rememberChangedField("WithdrawnQuantityAmount", this.withdrawnQuantityAmount);
        this.withdrawnQuantityAmount = withdrawnQuantityAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>LeadTimeOffset</b>
     * </p>
     *
     * @param leadTimeOffset
     *            Lead-Time Offset
     */
    public void setLeadTimeOffset( @Nullable final BigDecimal leadTimeOffset )
    {
        rememberChangedField("LeadTimeOffset", this.leadTimeOffset);
        this.leadTimeOffset = leadTimeOffset;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProcessOrderComponent";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Reservation", getReservation());
        result.put("ReservationItem", getReservationItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Reservation", getReservation());
        values.put("ReservationItem", getReservationItem());
        values.put("BillOfMaterialItemNumber", getBillOfMaterialItemNumber());
        values.put("BOMItemDescription", getBOMItemDescription());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("ProductionPlant", getProductionPlant());
        values.put("MatlCompRequirementDate", getMatlCompRequirementDate());
        values.put("BaseUnit", getBaseUnit());
        values.put("RequiredQuantity", getRequiredQuantity());
        values.put("WithdrawnQuantity", getWithdrawnQuantity());
        values.put("BOMItem", getBOMItem());
        values.put("StorageLocation", getStorageLocation());
        values.put("SupplyArea", getSupplyArea());
        values.put("ManufacturingOrderSequence", getManufacturingOrderSequence());
        values.put("ManufacturingOrder", getManufacturingOrder());
        values.put("ManufacturingOrderOperation", getManufacturingOrderOperation());
        values.put("ManufacturingOrderCategory", getManufacturingOrderCategory());
        values.put("ManufacturingOrderType", getManufacturingOrderType());
        values.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        values.put("BOMItemText2", getBOMItemText2());
        values.put("BOMItemCategory", getBOMItemCategory());
        values.put("BillOfMaterialCategory", getBillOfMaterialCategory());
        values.put("SortField", getSortField());
        values.put("GoodsRecipientName", getGoodsRecipientName());
        values.put("UnloadingPointName", getUnloadingPointName());
        values.put("Batch", getBatch());
        values.put("BatchSplitType", getBatchSplitType());
        values.put("MaterialCompOriginalQuantity", getMaterialCompOriginalQuantity());
        values.put("MatlCompIsMarkedForBackflush", getMatlCompIsMarkedForBackflush());
        values.put("IsBulkMaterialComponent", getIsBulkMaterialComponent());
        values.put("MaterialComponentIsPhantomItem", getMaterialComponentIsPhantomItem());
        values.put("MaterialCompIsCostRelevant", getMaterialCompIsCostRelevant());
        values.put("ConfirmedAvailableQuantity", getConfirmedAvailableQuantity());
        values.put("GoodsMovementType", getGoodsMovementType());
        values.put("MatlCompRequirementTime", getMatlCompRequirementTime());
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("ComponentScrapInPercent", getComponentScrapInPercent());
        values.put("OperationScrapInPercent", getOperationScrapInPercent());
        values.put("QuantityIsFixed", getQuantityIsFixed());
        values.put("IsNetScrap", getIsNetScrap());
        values.put("ReservationIsFinallyIssued", getReservationIsFinallyIssued());
        values.put("WithdrawnQuantityAmount", getWithdrawnQuantityAmount());
        values.put("Currency", getCurrency());
        values.put("LeadTimeOffset", getLeadTimeOffset());
        values.put("MaterialGroup", getMaterialGroup());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Reservation") ) {
                final Object value = values.remove("Reservation");
                if( (value == null) || (!value.equals(getReservation())) ) {
                    setReservation(((String) value));
                }
            }
            if( values.containsKey("ReservationItem") ) {
                final Object value = values.remove("ReservationItem");
                if( (value == null) || (!value.equals(getReservationItem())) ) {
                    setReservationItem(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialItemNumber") ) {
                final Object value = values.remove("BillOfMaterialItemNumber");
                if( (value == null) || (!value.equals(getBillOfMaterialItemNumber())) ) {
                    setBillOfMaterialItemNumber(((String) value));
                }
            }
            if( values.containsKey("BOMItemDescription") ) {
                final Object value = values.remove("BOMItemDescription");
                if( (value == null) || (!value.equals(getBOMItemDescription())) ) {
                    setBOMItemDescription(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("ProductionPlant") ) {
                final Object value = values.remove("ProductionPlant");
                if( (value == null) || (!value.equals(getProductionPlant())) ) {
                    setProductionPlant(((String) value));
                }
            }
            if( values.containsKey("MatlCompRequirementDate") ) {
                final Object value = values.remove("MatlCompRequirementDate");
                if( (value == null) || (!value.equals(getMatlCompRequirementDate())) ) {
                    setMatlCompRequirementDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("RequiredQuantity") ) {
                final Object value = values.remove("RequiredQuantity");
                if( (value == null) || (!value.equals(getRequiredQuantity())) ) {
                    setRequiredQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("WithdrawnQuantity") ) {
                final Object value = values.remove("WithdrawnQuantity");
                if( (value == null) || (!value.equals(getWithdrawnQuantity())) ) {
                    setWithdrawnQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("BOMItem") ) {
                final Object value = values.remove("BOMItem");
                if( (value == null) || (!value.equals(getBOMItem())) ) {
                    setBOMItem(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("SupplyArea") ) {
                final Object value = values.remove("SupplyArea");
                if( (value == null) || (!value.equals(getSupplyArea())) ) {
                    setSupplyArea(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderSequence") ) {
                final Object value = values.remove("ManufacturingOrderSequence");
                if( (value == null) || (!value.equals(getManufacturingOrderSequence())) ) {
                    setManufacturingOrderSequence(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderOperation") ) {
                final Object value = values.remove("ManufacturingOrderOperation");
                if( (value == null) || (!value.equals(getManufacturingOrderOperation())) ) {
                    setManufacturingOrderOperation(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderCategory") ) {
                final Object value = values.remove("ManufacturingOrderCategory");
                if( (value == null) || (!value.equals(getManufacturingOrderCategory())) ) {
                    setManufacturingOrderCategory(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderType") ) {
                final Object value = values.remove("ManufacturingOrderType");
                if( (value == null) || (!value.equals(getManufacturingOrderType())) ) {
                    setManufacturingOrderType(((String) value));
                }
            }
            if( values.containsKey("OrderInternalBillOfOperations") ) {
                final Object value = values.remove("OrderInternalBillOfOperations");
                if( (value == null) || (!value.equals(getOrderInternalBillOfOperations())) ) {
                    setOrderInternalBillOfOperations(((String) value));
                }
            }
            if( values.containsKey("BOMItemText2") ) {
                final Object value = values.remove("BOMItemText2");
                if( (value == null) || (!value.equals(getBOMItemText2())) ) {
                    setBOMItemText2(((String) value));
                }
            }
            if( values.containsKey("BOMItemCategory") ) {
                final Object value = values.remove("BOMItemCategory");
                if( (value == null) || (!value.equals(getBOMItemCategory())) ) {
                    setBOMItemCategory(((String) value));
                }
            }
            if( values.containsKey("BillOfMaterialCategory") ) {
                final Object value = values.remove("BillOfMaterialCategory");
                if( (value == null) || (!value.equals(getBillOfMaterialCategory())) ) {
                    setBillOfMaterialCategory(((String) value));
                }
            }
            if( values.containsKey("SortField") ) {
                final Object value = values.remove("SortField");
                if( (value == null) || (!value.equals(getSortField())) ) {
                    setSortField(((String) value));
                }
            }
            if( values.containsKey("GoodsRecipientName") ) {
                final Object value = values.remove("GoodsRecipientName");
                if( (value == null) || (!value.equals(getGoodsRecipientName())) ) {
                    setGoodsRecipientName(((String) value));
                }
            }
            if( values.containsKey("UnloadingPointName") ) {
                final Object value = values.remove("UnloadingPointName");
                if( (value == null) || (!value.equals(getUnloadingPointName())) ) {
                    setUnloadingPointName(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("BatchSplitType") ) {
                final Object value = values.remove("BatchSplitType");
                if( (value == null) || (!value.equals(getBatchSplitType())) ) {
                    setBatchSplitType(((String) value));
                }
            }
            if( values.containsKey("MaterialCompOriginalQuantity") ) {
                final Object value = values.remove("MaterialCompOriginalQuantity");
                if( (value == null) || (!value.equals(getMaterialCompOriginalQuantity())) ) {
                    setMaterialCompOriginalQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("MatlCompIsMarkedForBackflush") ) {
                final Object value = values.remove("MatlCompIsMarkedForBackflush");
                if( (value == null) || (!value.equals(getMatlCompIsMarkedForBackflush())) ) {
                    setMatlCompIsMarkedForBackflush(((Boolean) value));
                }
            }
            if( values.containsKey("IsBulkMaterialComponent") ) {
                final Object value = values.remove("IsBulkMaterialComponent");
                if( (value == null) || (!value.equals(getIsBulkMaterialComponent())) ) {
                    setIsBulkMaterialComponent(((Boolean) value));
                }
            }
            if( values.containsKey("MaterialComponentIsPhantomItem") ) {
                final Object value = values.remove("MaterialComponentIsPhantomItem");
                if( (value == null) || (!value.equals(getMaterialComponentIsPhantomItem())) ) {
                    setMaterialComponentIsPhantomItem(((Boolean) value));
                }
            }
            if( values.containsKey("MaterialCompIsCostRelevant") ) {
                final Object value = values.remove("MaterialCompIsCostRelevant");
                if( (value == null) || (!value.equals(getMaterialCompIsCostRelevant())) ) {
                    setMaterialCompIsCostRelevant(((String) value));
                }
            }
            if( values.containsKey("ConfirmedAvailableQuantity") ) {
                final Object value = values.remove("ConfirmedAvailableQuantity");
                if( (value == null) || (!value.equals(getConfirmedAvailableQuantity())) ) {
                    setConfirmedAvailableQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("GoodsMovementType") ) {
                final Object value = values.remove("GoodsMovementType");
                if( (value == null) || (!value.equals(getGoodsMovementType())) ) {
                    setGoodsMovementType(((String) value));
                }
            }
            if( values.containsKey("MatlCompRequirementTime") ) {
                final Object value = values.remove("MatlCompRequirementTime");
                if( (value == null) || (!value.equals(getMatlCompRequirementTime())) ) {
                    setMatlCompRequirementTime(((LocalTime) value));
                }
            }
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("ComponentScrapInPercent") ) {
                final Object value = values.remove("ComponentScrapInPercent");
                if( (value == null) || (!value.equals(getComponentScrapInPercent())) ) {
                    setComponentScrapInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("OperationScrapInPercent") ) {
                final Object value = values.remove("OperationScrapInPercent");
                if( (value == null) || (!value.equals(getOperationScrapInPercent())) ) {
                    setOperationScrapInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("QuantityIsFixed") ) {
                final Object value = values.remove("QuantityIsFixed");
                if( (value == null) || (!value.equals(getQuantityIsFixed())) ) {
                    setQuantityIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("IsNetScrap") ) {
                final Object value = values.remove("IsNetScrap");
                if( (value == null) || (!value.equals(getIsNetScrap())) ) {
                    setIsNetScrap(((Boolean) value));
                }
            }
            if( values.containsKey("ReservationIsFinallyIssued") ) {
                final Object value = values.remove("ReservationIsFinallyIssued");
                if( (value == null) || (!value.equals(getReservationIsFinallyIssued())) ) {
                    setReservationIsFinallyIssued(((Boolean) value));
                }
            }
            if( values.containsKey("WithdrawnQuantityAmount") ) {
                final Object value = values.remove("WithdrawnQuantityAmount");
                if( (value == null) || (!value.equals(getWithdrawnQuantityAmount())) ) {
                    setWithdrawnQuantityAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("LeadTimeOffset") ) {
                final Object value = values.remove("LeadTimeOffset");
                if( (value == null) || (!value.equals(getLeadTimeOffset())) ) {
                    setLeadTimeOffset(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProcessOrderComponentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProcessOrderComponentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProcessOrderComponentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProcessOrderComponentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderService.DEFAULT_SERVICE_PATH);
    }

}
