/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.field.ProcessOrderItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.selectable.ProcessOrderItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * API Process Order Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProcessOrderItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProcessOrderItem extends VdmEntity<ProcessOrderItem>
{

    /**
     * Selector for all available fields of ProcessOrderItem.
     *
     */
    public final static ProcessOrderItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @return Manufacturing Order ID
     */
    @Key
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrder</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> MANUFACTURING_ORDER =
        new ProcessOrderItemField<String>("ManufacturingOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderItem</b>
     * </p>
     *
     * @return Manufacturing Order Item ID
     */
    @Key
    @SerializedName( "ManufacturingOrderItem" )
    @JsonProperty( "ManufacturingOrderItem" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderItem" )
    private String manufacturingOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderItem</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> MANUFACTURING_ORDER_ITEM =
        new ProcessOrderItemField<String>("ManufacturingOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @return Manufacturing Order Category
     */
    @SerializedName( "ManufacturingOrderCategory" )
    @JsonProperty( "ManufacturingOrderCategory" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderCategory" )
    private String manufacturingOrderCategory;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderCategory</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> MANUFACTURING_ORDER_CATEGORY =
        new ProcessOrderItemField<String>("ManufacturingOrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @return Manufacturing Order Type
     */
    @SerializedName( "ManufacturingOrderType" )
    @JsonProperty( "ManufacturingOrderType" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderType" )
    private String manufacturingOrderType;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderType</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> MANUFACTURING_ORDER_TYPE =
        new ProcessOrderItemField<String>("ManufacturingOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @return Production Plant
     */
    @SerializedName( "ProductionPlant" )
    @JsonProperty( "ProductionPlant" )
    @Nullable
    @ODataField( odataName = "ProductionPlant" )
    private String productionPlant;
    /**
     * Use with available fluent helpers to apply the <b>ProductionPlant</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> PRODUCTION_PLANT =
        new ProcessOrderItemField<String>("ProductionPlant");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number for Order
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> MATERIAL = new ProcessOrderItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlant</b>
     * </p>
     *
     * @return Planning Plant for an Order
     */
    @SerializedName( "MRPPlant" )
    @JsonProperty( "MRPPlant" )
    @Nullable
    @ODataField( odataName = "MRPPlant" )
    private String mRPPlant;
    /**
     * Use with available fluent helpers to apply the <b>MRPPlant</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> MRP_PLANT = new ProcessOrderItemField<String>("MRPPlant");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderItemActualDeliveryDate</b>
     * </p>
     *
     * @return Actual Delivery/Finish Date
     */
    @SerializedName( "MfgOrderItemActualDeliveryDate" )
    @JsonProperty( "MfgOrderItemActualDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MfgOrderItemActualDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime mfgOrderItemActualDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderItemActualDeliveryDate</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<LocalDateTime> MFG_ORDER_ITEM_ACTUAL_DELIVERY_DATE =
        new ProcessOrderItemField<LocalDateTime>("MfgOrderItemActualDeliveryDate");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderItemPlannedTotalQty</b>
     * </p>
     *
     * @return Order Item Planned Total Quantity
     */
    @SerializedName( "MfgOrderItemPlannedTotalQty" )
    @JsonProperty( "MfgOrderItemPlannedTotalQty" )
    @Nullable
    @ODataField( odataName = "MfgOrderItemPlannedTotalQty" )
    private BigDecimal mfgOrderItemPlannedTotalQty;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderItemPlannedTotalQty</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<BigDecimal> MFG_ORDER_ITEM_PLANNED_TOTAL_QTY =
        new ProcessOrderItemField<BigDecimal>("MfgOrderItemPlannedTotalQty");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderItemPlannedScrapQty</b>
     * </p>
     *
     * @return Order Item Planned Scrap Quantity
     */
    @SerializedName( "MfgOrderItemPlannedScrapQty" )
    @JsonProperty( "MfgOrderItemPlannedScrapQty" )
    @Nullable
    @ODataField( odataName = "MfgOrderItemPlannedScrapQty" )
    private BigDecimal mfgOrderItemPlannedScrapQty;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderItemPlannedScrapQty</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<BigDecimal> MFG_ORDER_ITEM_PLANNED_SCRAP_QTY =
        new ProcessOrderItemField<BigDecimal>("MfgOrderItemPlannedScrapQty");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderItemGoodsReceiptQty</b>
     * </p>
     *
     * @return Quantity of Goods Received for the Order Item
     */
    @SerializedName( "MfgOrderItemGoodsReceiptQty" )
    @JsonProperty( "MfgOrderItemGoodsReceiptQty" )
    @Nullable
    @ODataField( odataName = "MfgOrderItemGoodsReceiptQty" )
    private BigDecimal mfgOrderItemGoodsReceiptQty;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderItemGoodsReceiptQty</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<BigDecimal> MFG_ORDER_ITEM_GOODS_RECEIPT_QTY =
        new ProcessOrderItemField<BigDecimal>("MfgOrderItemGoodsReceiptQty");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderItemActualDeviationQty</b>
     * </p>
     *
     * @return Expected Surplus/Deficit For Goods Receipt
     */
    @SerializedName( "MfgOrderItemActualDeviationQty" )
    @JsonProperty( "MfgOrderItemActualDeviationQty" )
    @Nullable
    @ODataField( odataName = "MfgOrderItemActualDeviationQty" )
    private BigDecimal mfgOrderItemActualDeviationQty;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderItemActualDeviationQty</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<BigDecimal> MFG_ORDER_ITEM_ACTUAL_DEVIATION_QTY =
        new ProcessOrderItemField<BigDecimal>("MfgOrderItemActualDeviationQty");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductionUnit</b>
     * </p>
     *
     * @return Production Unit of Measure
     */
    @SerializedName( "ProductionUnit" )
    @JsonProperty( "ProductionUnit" )
    @Nullable
    @ODataField( odataName = "ProductionUnit" )
    private String productionUnit;
    /**
     * Use with available fluent helpers to apply the <b>ProductionUnit</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> PRODUCTION_UNIT =
        new ProcessOrderItemField<String>("ProductionUnit");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @return MRP Area
     */
    @SerializedName( "MRPArea" )
    @JsonProperty( "MRPArea" )
    @Nullable
    @ODataField( odataName = "MRPArea" )
    private String mRPArea;
    /**
     * Use with available fluent helpers to apply the <b>MRPArea</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> MRP_AREA = new ProcessOrderItemField<String>("MRPArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> STORAGE_LOCATION =
        new ProcessOrderItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderItemPlndDeliveryDate</b>
     * </p>
     *
     * @return Delivery Date From Planned Order
     */
    @SerializedName( "MfgOrderItemPlndDeliveryDate" )
    @JsonProperty( "MfgOrderItemPlndDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "MfgOrderItemPlndDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime mfgOrderItemPlndDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderItemPlndDeliveryDate</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<LocalDateTime> MFG_ORDER_ITEM_PLND_DELIVERY_DATE =
        new ProcessOrderItemField<LocalDateTime>("MfgOrderItemPlndDeliveryDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @return Goods Recipient
     */
    @SerializedName( "GoodsRecipientName" )
    @JsonProperty( "GoodsRecipientName" )
    @Nullable
    @ODataField( odataName = "GoodsRecipientName" )
    private String goodsRecipientName;
    /**
     * Use with available fluent helpers to apply the <b>GoodsRecipientName</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> GOODS_RECIPIENT_NAME =
        new ProcessOrderItemField<String>("GoodsRecipientName");
    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGoodsReceiptDuration</b>
     * </p>
     *
     * @return Goods Receipt Processing Duration in Days
     */
    @SerializedName( "MaterialGoodsReceiptDuration" )
    @JsonProperty( "MaterialGoodsReceiptDuration" )
    @Nullable
    @ODataField( odataName = "MaterialGoodsReceiptDuration" )
    private BigDecimal materialGoodsReceiptDuration;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGoodsReceiptDuration</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<BigDecimal> MATERIAL_GOODS_RECEIPT_DURATION =
        new ProcessOrderItemField<BigDecimal>("MaterialGoodsReceiptDuration");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventoryUsabilityCode</b>
     * </p>
     *
     * @return Inventory Usability Code
     */
    @SerializedName( "InventoryUsabilityCode" )
    @JsonProperty( "InventoryUsabilityCode" )
    @Nullable
    @ODataField( odataName = "InventoryUsabilityCode" )
    private String inventoryUsabilityCode;
    /**
     * Use with available fluent helpers to apply the <b>InventoryUsabilityCode</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> INVENTORY_USABILITY_CODE =
        new ProcessOrderItemField<String>("InventoryUsabilityCode");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @return Unloading Point
     */
    @SerializedName( "UnloadingPointName" )
    @JsonProperty( "UnloadingPointName" )
    @Nullable
    @ODataField( odataName = "UnloadingPointName" )
    private String unloadingPointName;
    /**
     * Use with available fluent helpers to apply the <b>UnloadingPointName</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> UNLOADING_POINT_NAME =
        new ProcessOrderItemField<String>("UnloadingPointName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>QuantityDistributionKey</b>
     * </p>
     *
     * @return MRP Distribution Key
     */
    @SerializedName( "QuantityDistributionKey" )
    @JsonProperty( "QuantityDistributionKey" )
    @Nullable
    @ODataField( odataName = "QuantityDistributionKey" )
    private String quantityDistributionKey;
    /**
     * Use with available fluent helpers to apply the <b>QuantityDistributionKey</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> QUANTITY_DISTRIBUTION_KEY =
        new ProcessOrderItemField<String>("QuantityDistributionKey");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StockSegment</b>
     * </p>
     *
     * @return Stock Segment
     */
    @SerializedName( "StockSegment" )
    @JsonProperty( "StockSegment" )
    @Nullable
    @ODataField( odataName = "StockSegment" )
    private String stockSegment;
    /**
     * Use with available fluent helpers to apply the <b>StockSegment</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> STOCK_SEGMENT = new ProcessOrderItemField<String>("StockSegment");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static ProcessOrderItemField<String> BATCH = new ProcessOrderItemField<String>("Batch");

    @Nonnull
    @Override
    public Class<ProcessOrderItem> getType()
    {
        return ProcessOrderItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Manufacturing Order ID
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderItem</b>
     * </p>
     *
     * @param manufacturingOrderItem
     *            Manufacturing Order Item ID
     */
    public void setManufacturingOrderItem( @Nullable final String manufacturingOrderItem )
    {
        rememberChangedField("ManufacturingOrderItem", this.manufacturingOrderItem);
        this.manufacturingOrderItem = manufacturingOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @param manufacturingOrderCategory
     *            Manufacturing Order Category
     */
    public void setManufacturingOrderCategory( @Nullable final String manufacturingOrderCategory )
    {
        rememberChangedField("ManufacturingOrderCategory", this.manufacturingOrderCategory);
        this.manufacturingOrderCategory = manufacturingOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @param manufacturingOrderType
     *            Manufacturing Order Type
     */
    public void setManufacturingOrderType( @Nullable final String manufacturingOrderType )
    {
        rememberChangedField("ManufacturingOrderType", this.manufacturingOrderType);
        this.manufacturingOrderType = manufacturingOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @param productionPlant
     *            Production Plant
     */
    public void setProductionPlant( @Nullable final String productionPlant )
    {
        rememberChangedField("ProductionPlant", this.productionPlant);
        this.productionPlant = productionPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number for Order
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MRPPlant</b>
     * </p>
     *
     * @param mRPPlant
     *            Planning Plant for an Order
     */
    public void setMRPPlant( @Nullable final String mRPPlant )
    {
        rememberChangedField("MRPPlant", this.mRPPlant);
        this.mRPPlant = mRPPlant;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderItemActualDeliveryDate</b>
     * </p>
     *
     * @param mfgOrderItemActualDeliveryDate
     *            Actual Delivery/Finish Date
     */
    public void setMfgOrderItemActualDeliveryDate( @Nullable final LocalDateTime mfgOrderItemActualDeliveryDate )
    {
        rememberChangedField("MfgOrderItemActualDeliveryDate", this.mfgOrderItemActualDeliveryDate);
        this.mfgOrderItemActualDeliveryDate = mfgOrderItemActualDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderItemPlannedTotalQty</b>
     * </p>
     *
     * @param mfgOrderItemPlannedTotalQty
     *            Order Item Planned Total Quantity
     */
    public void setMfgOrderItemPlannedTotalQty( @Nullable final BigDecimal mfgOrderItemPlannedTotalQty )
    {
        rememberChangedField("MfgOrderItemPlannedTotalQty", this.mfgOrderItemPlannedTotalQty);
        this.mfgOrderItemPlannedTotalQty = mfgOrderItemPlannedTotalQty;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderItemPlannedScrapQty</b>
     * </p>
     *
     * @param mfgOrderItemPlannedScrapQty
     *            Order Item Planned Scrap Quantity
     */
    public void setMfgOrderItemPlannedScrapQty( @Nullable final BigDecimal mfgOrderItemPlannedScrapQty )
    {
        rememberChangedField("MfgOrderItemPlannedScrapQty", this.mfgOrderItemPlannedScrapQty);
        this.mfgOrderItemPlannedScrapQty = mfgOrderItemPlannedScrapQty;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderItemGoodsReceiptQty</b>
     * </p>
     *
     * @param mfgOrderItemGoodsReceiptQty
     *            Quantity of Goods Received for the Order Item
     */
    public void setMfgOrderItemGoodsReceiptQty( @Nullable final BigDecimal mfgOrderItemGoodsReceiptQty )
    {
        rememberChangedField("MfgOrderItemGoodsReceiptQty", this.mfgOrderItemGoodsReceiptQty);
        this.mfgOrderItemGoodsReceiptQty = mfgOrderItemGoodsReceiptQty;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderItemActualDeviationQty</b>
     * </p>
     *
     * @param mfgOrderItemActualDeviationQty
     *            Expected Surplus/Deficit For Goods Receipt
     */
    public void setMfgOrderItemActualDeviationQty( @Nullable final BigDecimal mfgOrderItemActualDeviationQty )
    {
        rememberChangedField("MfgOrderItemActualDeviationQty", this.mfgOrderItemActualDeviationQty);
        this.mfgOrderItemActualDeviationQty = mfgOrderItemActualDeviationQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ProductionUnit</b>
     * </p>
     *
     * @param productionUnit
     *            Production Unit of Measure
     */
    public void setProductionUnit( @Nullable final String productionUnit )
    {
        rememberChangedField("ProductionUnit", this.productionUnit);
        this.productionUnit = productionUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>MRPArea</b>
     * </p>
     *
     * @param mRPArea
     *            MRP Area
     */
    public void setMRPArea( @Nullable final String mRPArea )
    {
        rememberChangedField("MRPArea", this.mRPArea);
        this.mRPArea = mRPArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderItemPlndDeliveryDate</b>
     * </p>
     *
     * @param mfgOrderItemPlndDeliveryDate
     *            Delivery Date From Planned Order
     */
    public void setMfgOrderItemPlndDeliveryDate( @Nullable final LocalDateTime mfgOrderItemPlndDeliveryDate )
    {
        rememberChangedField("MfgOrderItemPlndDeliveryDate", this.mfgOrderItemPlndDeliveryDate);
        this.mfgOrderItemPlndDeliveryDate = mfgOrderItemPlndDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>GoodsRecipientName</b>
     * </p>
     *
     * @param goodsRecipientName
     *            Goods Recipient
     */
    public void setGoodsRecipientName( @Nullable final String goodsRecipientName )
    {
        rememberChangedField("GoodsRecipientName", this.goodsRecipientName);
        this.goodsRecipientName = goodsRecipientName;
    }

    /**
     * Constraints: Not nullable, Precision: 3, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGoodsReceiptDuration</b>
     * </p>
     *
     * @param materialGoodsReceiptDuration
     *            Goods Receipt Processing Duration in Days
     */
    public void setMaterialGoodsReceiptDuration( @Nullable final BigDecimal materialGoodsReceiptDuration )
    {
        rememberChangedField("MaterialGoodsReceiptDuration", this.materialGoodsReceiptDuration);
        this.materialGoodsReceiptDuration = materialGoodsReceiptDuration;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventoryUsabilityCode</b>
     * </p>
     *
     * @param inventoryUsabilityCode
     *            Inventory Usability Code
     */
    public void setInventoryUsabilityCode( @Nullable final String inventoryUsabilityCode )
    {
        rememberChangedField("InventoryUsabilityCode", this.inventoryUsabilityCode);
        this.inventoryUsabilityCode = inventoryUsabilityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>UnloadingPointName</b>
     * </p>
     *
     * @param unloadingPointName
     *            Unloading Point
     */
    public void setUnloadingPointName( @Nullable final String unloadingPointName )
    {
        rememberChangedField("UnloadingPointName", this.unloadingPointName);
        this.unloadingPointName = unloadingPointName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>QuantityDistributionKey</b>
     * </p>
     *
     * @param quantityDistributionKey
     *            MRP Distribution Key
     */
    public void setQuantityDistributionKey( @Nullable final String quantityDistributionKey )
    {
        rememberChangedField("QuantityDistributionKey", this.quantityDistributionKey);
        this.quantityDistributionKey = quantityDistributionKey;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StockSegment</b>
     * </p>
     *
     * @param stockSegment
     *            Stock Segment
     */
    public void setStockSegment( @Nullable final String stockSegment )
    {
        rememberChangedField("StockSegment", this.stockSegment);
        this.stockSegment = stockSegment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProcessOrderItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ManufacturingOrder", getManufacturingOrder());
        result.put("ManufacturingOrderItem", getManufacturingOrderItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ManufacturingOrder", getManufacturingOrder());
        values.put("ManufacturingOrderItem", getManufacturingOrderItem());
        values.put("ManufacturingOrderCategory", getManufacturingOrderCategory());
        values.put("ManufacturingOrderType", getManufacturingOrderType());
        values.put("ProductionPlant", getProductionPlant());
        values.put("Material", getMaterial());
        values.put("MRPPlant", getMRPPlant());
        values.put("MfgOrderItemActualDeliveryDate", getMfgOrderItemActualDeliveryDate());
        values.put("MfgOrderItemPlannedTotalQty", getMfgOrderItemPlannedTotalQty());
        values.put("MfgOrderItemPlannedScrapQty", getMfgOrderItemPlannedScrapQty());
        values.put("MfgOrderItemGoodsReceiptQty", getMfgOrderItemGoodsReceiptQty());
        values.put("MfgOrderItemActualDeviationQty", getMfgOrderItemActualDeviationQty());
        values.put("ProductionUnit", getProductionUnit());
        values.put("MRPArea", getMRPArea());
        values.put("StorageLocation", getStorageLocation());
        values.put("MfgOrderItemPlndDeliveryDate", getMfgOrderItemPlndDeliveryDate());
        values.put("GoodsRecipientName", getGoodsRecipientName());
        values.put("MaterialGoodsReceiptDuration", getMaterialGoodsReceiptDuration());
        values.put("InventoryUsabilityCode", getInventoryUsabilityCode());
        values.put("UnloadingPointName", getUnloadingPointName());
        values.put("QuantityDistributionKey", getQuantityDistributionKey());
        values.put("StockSegment", getStockSegment());
        values.put("Batch", getBatch());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderItem") ) {
                final Object value = values.remove("ManufacturingOrderItem");
                if( (value == null) || (!value.equals(getManufacturingOrderItem())) ) {
                    setManufacturingOrderItem(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderCategory") ) {
                final Object value = values.remove("ManufacturingOrderCategory");
                if( (value == null) || (!value.equals(getManufacturingOrderCategory())) ) {
                    setManufacturingOrderCategory(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderType") ) {
                final Object value = values.remove("ManufacturingOrderType");
                if( (value == null) || (!value.equals(getManufacturingOrderType())) ) {
                    setManufacturingOrderType(((String) value));
                }
            }
            if( values.containsKey("ProductionPlant") ) {
                final Object value = values.remove("ProductionPlant");
                if( (value == null) || (!value.equals(getProductionPlant())) ) {
                    setProductionPlant(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MRPPlant") ) {
                final Object value = values.remove("MRPPlant");
                if( (value == null) || (!value.equals(getMRPPlant())) ) {
                    setMRPPlant(((String) value));
                }
            }
            if( values.containsKey("MfgOrderItemActualDeliveryDate") ) {
                final Object value = values.remove("MfgOrderItemActualDeliveryDate");
                if( (value == null) || (!value.equals(getMfgOrderItemActualDeliveryDate())) ) {
                    setMfgOrderItemActualDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("MfgOrderItemPlannedTotalQty") ) {
                final Object value = values.remove("MfgOrderItemPlannedTotalQty");
                if( (value == null) || (!value.equals(getMfgOrderItemPlannedTotalQty())) ) {
                    setMfgOrderItemPlannedTotalQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("MfgOrderItemPlannedScrapQty") ) {
                final Object value = values.remove("MfgOrderItemPlannedScrapQty");
                if( (value == null) || (!value.equals(getMfgOrderItemPlannedScrapQty())) ) {
                    setMfgOrderItemPlannedScrapQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("MfgOrderItemGoodsReceiptQty") ) {
                final Object value = values.remove("MfgOrderItemGoodsReceiptQty");
                if( (value == null) || (!value.equals(getMfgOrderItemGoodsReceiptQty())) ) {
                    setMfgOrderItemGoodsReceiptQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("MfgOrderItemActualDeviationQty") ) {
                final Object value = values.remove("MfgOrderItemActualDeviationQty");
                if( (value == null) || (!value.equals(getMfgOrderItemActualDeviationQty())) ) {
                    setMfgOrderItemActualDeviationQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductionUnit") ) {
                final Object value = values.remove("ProductionUnit");
                if( (value == null) || (!value.equals(getProductionUnit())) ) {
                    setProductionUnit(((String) value));
                }
            }
            if( values.containsKey("MRPArea") ) {
                final Object value = values.remove("MRPArea");
                if( (value == null) || (!value.equals(getMRPArea())) ) {
                    setMRPArea(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("MfgOrderItemPlndDeliveryDate") ) {
                final Object value = values.remove("MfgOrderItemPlndDeliveryDate");
                if( (value == null) || (!value.equals(getMfgOrderItemPlndDeliveryDate())) ) {
                    setMfgOrderItemPlndDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("GoodsRecipientName") ) {
                final Object value = values.remove("GoodsRecipientName");
                if( (value == null) || (!value.equals(getGoodsRecipientName())) ) {
                    setGoodsRecipientName(((String) value));
                }
            }
            if( values.containsKey("MaterialGoodsReceiptDuration") ) {
                final Object value = values.remove("MaterialGoodsReceiptDuration");
                if( (value == null) || (!value.equals(getMaterialGoodsReceiptDuration())) ) {
                    setMaterialGoodsReceiptDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("InventoryUsabilityCode") ) {
                final Object value = values.remove("InventoryUsabilityCode");
                if( (value == null) || (!value.equals(getInventoryUsabilityCode())) ) {
                    setInventoryUsabilityCode(((String) value));
                }
            }
            if( values.containsKey("UnloadingPointName") ) {
                final Object value = values.remove("UnloadingPointName");
                if( (value == null) || (!value.equals(getUnloadingPointName())) ) {
                    setUnloadingPointName(((String) value));
                }
            }
            if( values.containsKey("QuantityDistributionKey") ) {
                final Object value = values.remove("QuantityDistributionKey");
                if( (value == null) || (!value.equals(getQuantityDistributionKey())) ) {
                    setQuantityDistributionKey(((String) value));
                }
            }
            if( values.containsKey("StockSegment") ) {
                final Object value = values.remove("StockSegment");
                if( (value == null) || (!value.equals(getStockSegment())) ) {
                    setStockSegment(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProcessOrderItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProcessOrderItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProcessOrderItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProcessOrderItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderService.DEFAULT_SERVICE_PATH);
    }

}
