/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.field.ProcessOrderOperationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.selectable.ProcessOrderOperationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * API for Process Order Operations
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProcessOrderOperationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProcessOrderOperation extends VdmEntity<ProcessOrderOperation>
{

    /**
     * Selector for all available fields of ProcessOrderOperation.
     *
     */
    public final static ProcessOrderOperationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @return Order Internal ID
     */
    @Key
    @SerializedName( "OrderInternalBillOfOperations" )
    @JsonProperty( "OrderInternalBillOfOperations" )
    @Nullable
    @ODataField( odataName = "OrderInternalBillOfOperations" )
    private String orderInternalBillOfOperations;
    /**
     * Use with available fluent helpers to apply the <b>OrderInternalBillOfOperations</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> ORDER_INTERNAL_BILL_OF_OPERATIONS =
        new ProcessOrderOperationField<String>("OrderInternalBillOfOperations");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OrderIntBillOfOperationsItem</b>
     * </p>
     *
     * @return Internal Identifier of an Operation or Activity
     */
    @Key
    @SerializedName( "OrderIntBillOfOperationsItem" )
    @JsonProperty( "OrderIntBillOfOperationsItem" )
    @Nullable
    @ODataField( odataName = "OrderIntBillOfOperationsItem" )
    private String orderIntBillOfOperationsItem;
    /**
     * Use with available fluent helpers to apply the <b>OrderIntBillOfOperationsItem</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> ORDER_INT_BILL_OF_OPERATIONS_ITEM =
        new ProcessOrderOperationField<String>("OrderIntBillOfOperationsItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @return Manufacturing Order ID
     */
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrder</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> MANUFACTURING_ORDER =
        new ProcessOrderOperationField<String>("ManufacturingOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @return Manufacturing Order Operation
     */
    @SerializedName( "ManufacturingOrderOperation" )
    @JsonProperty( "ManufacturingOrderOperation" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderOperation" )
    private String manufacturingOrderOperation;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderOperation</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> MANUFACTURING_ORDER_OPERATION =
        new ProcessOrderOperationField<String>("ManufacturingOrderOperation");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderOperationIsPhase</b>
     * </p>
     *
     * @return Indicator: Phase
     */
    @SerializedName( "MfgOrderOperationIsPhase" )
    @JsonProperty( "MfgOrderOperationIsPhase" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "MfgOrderOperationIsPhase" )
    private Boolean mfgOrderOperationIsPhase;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderOperationIsPhase</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<Boolean> MFG_ORDER_OPERATION_IS_PHASE =
        new ProcessOrderOperationField<Boolean>("MfgOrderOperationIsPhase");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSequence</b>
     * </p>
     *
     * @return Manufacturing Order Sequence
     */
    @SerializedName( "ManufacturingOrderSequence" )
    @JsonProperty( "ManufacturingOrderSequence" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderSequence" )
    private String manufacturingOrderSequence;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderSequence</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> MANUFACTURING_ORDER_SEQUENCE =
        new ProcessOrderOperationField<String>("ManufacturingOrderSequence");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderSequenceText</b>
     * </p>
     *
     * @return Manufacturing Order Sequence Text
     */
    @SerializedName( "MfgOrderSequenceText" )
    @JsonProperty( "MfgOrderSequenceText" )
    @Nullable
    @ODataField( odataName = "MfgOrderSequenceText" )
    private String mfgOrderSequenceText;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderSequenceText</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> MFG_ORDER_SEQUENCE_TEXT =
        new ProcessOrderOperationField<String>("MfgOrderSequenceText");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderOperationText</b>
     * </p>
     *
     * @return Manufacturing Order Operation Text
     */
    @SerializedName( "MfgOrderOperationText" )
    @JsonProperty( "MfgOrderOperationText" )
    @Nullable
    @ODataField( odataName = "MfgOrderOperationText" )
    private String mfgOrderOperationText;
    /**
     * Use with available fluent helpers to apply the <b>MfgOrderOperationText</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> MFG_ORDER_OPERATION_TEXT =
        new ProcessOrderOperationField<String>("MfgOrderOperationText");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @return Manufacturing Order Type
     */
    @SerializedName( "ManufacturingOrderType" )
    @JsonProperty( "ManufacturingOrderType" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderType" )
    private String manufacturingOrderType;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderType</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> MANUFACTURING_ORDER_TYPE =
        new ProcessOrderOperationField<String>("ManufacturingOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcessEntryUnit</b>
     * </p>
     *
     * @return Unit of Measure for Business Process Quantity
     */
    @SerializedName( "BusinessProcessEntryUnit" )
    @JsonProperty( "BusinessProcessEntryUnit" )
    @Nullable
    @ODataField( odataName = "BusinessProcessEntryUnit" )
    private String businessProcessEntryUnit;
    /**
     * Use with available fluent helpers to apply the <b>BusinessProcessEntryUnit</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> BUSINESS_PROCESS_ENTRY_UNIT =
        new ProcessOrderOperationField<String>("BusinessProcessEntryUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @return Manufacturing Order Category
     */
    @SerializedName( "ManufacturingOrderCategory" )
    @JsonProperty( "ManufacturingOrderCategory" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderCategory" )
    private String manufacturingOrderCategory;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderCategory</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> MANUFACTURING_ORDER_CATEGORY =
        new ProcessOrderOperationField<String>("ManufacturingOrderCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @return Work Center Type Code
     */
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterTypeCode</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> WORK_CENTER_TYPE_CODE =
        new ProcessOrderOperationField<String>("WorkCenterTypeCode");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @return Work Center
     */
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenter</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> WORK_CENTER =
        new ProcessOrderOperationField<String>("WorkCenter");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtDte</b>
     * </p>
     *
     * @return Earliest Scheduled Execution Start Date
     */
    @SerializedName( "OpErlstSchedldExecStrtDte" )
    @JsonProperty( "OpErlstSchedldExecStrtDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecStrtDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opErlstSchedldExecStrtDte;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecStrtDte</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<LocalDateTime> OP_ERLST_SCHEDLD_EXEC_STRT_DTE =
        new ProcessOrderOperationField<LocalDateTime>("OpErlstSchedldExecStrtDte");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtTme</b>
     * </p>
     *
     * @return Earliest Scheduled Execution Start Time
     */
    @SerializedName( "OpErlstSchedldExecStrtTme" )
    @JsonProperty( "OpErlstSchedldExecStrtTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecStrtTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opErlstSchedldExecStrtTme;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecStrtTme</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<LocalTime> OP_ERLST_SCHEDLD_EXEC_STRT_TME =
        new ProcessOrderOperationField<LocalTime>("OpErlstSchedldExecStrtTme");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndDte</b>
     * </p>
     *
     * @return Earliest Scheduled Execution End Date
     */
    @SerializedName( "OpErlstSchedldExecEndDte" )
    @JsonProperty( "OpErlstSchedldExecEndDte" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecEndDte",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opErlstSchedldExecEndDte;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecEndDte</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<LocalDateTime> OP_ERLST_SCHEDLD_EXEC_END_DTE =
        new ProcessOrderOperationField<LocalDateTime>("OpErlstSchedldExecEndDte");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndTme</b>
     * </p>
     *
     * @return Earliest Scheduled Execution End Time
     */
    @SerializedName( "OpErlstSchedldExecEndTme" )
    @JsonProperty( "OpErlstSchedldExecEndTme" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpErlstSchedldExecEndTme",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opErlstSchedldExecEndTme;
    /**
     * Use with available fluent helpers to apply the <b>OpErlstSchedldExecEndTme</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<LocalTime> OP_ERLST_SCHEDLD_EXEC_END_TME =
        new ProcessOrderOperationField<LocalTime>("OpErlstSchedldExecEndTme");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionStartDate</b>
     * </p>
     *
     * @return Confirmed Start Date of Execution
     */
    @SerializedName( "OpActualExecutionStartDate" )
    @JsonProperty( "OpActualExecutionStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpActualExecutionStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opActualExecutionStartDate;
    /**
     * Use with available fluent helpers to apply the <b>OpActualExecutionStartDate</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<LocalDateTime> OP_ACTUAL_EXECUTION_START_DATE =
        new ProcessOrderOperationField<LocalDateTime>("OpActualExecutionStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionStartTime</b>
     * </p>
     *
     * @return Confirmed Start Time of Execution
     */
    @SerializedName( "OpActualExecutionStartTime" )
    @JsonProperty( "OpActualExecutionStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpActualExecutionStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opActualExecutionStartTime;
    /**
     * Use with available fluent helpers to apply the <b>OpActualExecutionStartTime</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<LocalTime> OP_ACTUAL_EXECUTION_START_TIME =
        new ProcessOrderOperationField<LocalTime>("OpActualExecutionStartTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionEndDate</b>
     * </p>
     *
     * @return Confirmed End Date of Execution
     */
    @SerializedName( "OpActualExecutionEndDate" )
    @JsonProperty( "OpActualExecutionEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "OpActualExecutionEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime opActualExecutionEndDate;
    /**
     * Use with available fluent helpers to apply the <b>OpActualExecutionEndDate</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<LocalDateTime> OP_ACTUAL_EXECUTION_END_DATE =
        new ProcessOrderOperationField<LocalDateTime>("OpActualExecutionEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionEndTime</b>
     * </p>
     *
     * @return Confirmed End Time of Execution
     */
    @SerializedName( "OpActualExecutionEndTime" )
    @JsonProperty( "OpActualExecutionEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "OpActualExecutionEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime opActualExecutionEndTime;
    /**
     * Use with available fluent helpers to apply the <b>OpActualExecutionEndTime</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<LocalTime> OP_ACTUAL_EXECUTION_END_TIME =
        new ProcessOrderOperationField<LocalTime>("OpActualExecutionEndTime");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnit</b>
     * </p>
     *
     * @return Operation Unit of Measure
     */
    @SerializedName( "OperationUnit" )
    @JsonProperty( "OperationUnit" )
    @Nullable
    @ODataField( odataName = "OperationUnit" )
    private String operationUnit;
    /**
     * Use with available fluent helpers to apply the <b>OperationUnit</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> OPERATION_UNIT =
        new ProcessOrderOperationField<String>("OperationUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpPlannedTotalQuantity</b>
     * </p>
     *
     * @return Operation Total Quantity
     */
    @SerializedName( "OpPlannedTotalQuantity" )
    @JsonProperty( "OpPlannedTotalQuantity" )
    @Nullable
    @ODataField( odataName = "OpPlannedTotalQuantity" )
    private BigDecimal opPlannedTotalQuantity;
    /**
     * Use with available fluent helpers to apply the <b>OpPlannedTotalQuantity</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<BigDecimal> OP_PLANNED_TOTAL_QUANTITY =
        new ProcessOrderOperationField<BigDecimal>("OpPlannedTotalQuantity");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ErlstSchedldExecDurnInWorkdays</b>
     * </p>
     *
     * @return Earliest Scheduled Execution Duration in Workdays
     */
    @SerializedName( "ErlstSchedldExecDurnInWorkdays" )
    @JsonProperty( "ErlstSchedldExecDurnInWorkdays" )
    @Nullable
    @ODataField( odataName = "ErlstSchedldExecDurnInWorkdays" )
    private Integer erlstSchedldExecDurnInWorkdays;
    /**
     * Use with available fluent helpers to apply the <b>ErlstSchedldExecDurnInWorkdays</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<Integer> ERLST_SCHEDLD_EXEC_DURN_IN_WORKDAYS =
        new ProcessOrderOperationField<Integer>("ErlstSchedldExecDurnInWorkdays");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionDays</b>
     * </p>
     *
     * @return Actual Execution Duration in Workdays
     */
    @SerializedName( "OpActualExecutionDays" )
    @JsonProperty( "OpActualExecutionDays" )
    @Nullable
    @ODataField( odataName = "OpActualExecutionDays" )
    private Integer opActualExecutionDays;
    /**
     * Use with available fluent helpers to apply the <b>OpActualExecutionDays</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<Integer> OP_ACTUAL_EXECUTION_DAYS =
        new ProcessOrderOperationField<Integer>("OpActualExecutionDays");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpTotalConfirmedYieldQty</b>
     * </p>
     *
     * @return Total Confirmed Yield
     */
    @SerializedName( "OpTotalConfirmedYieldQty" )
    @JsonProperty( "OpTotalConfirmedYieldQty" )
    @Nullable
    @ODataField( odataName = "OpTotalConfirmedYieldQty" )
    private BigDecimal opTotalConfirmedYieldQty;
    /**
     * Use with available fluent helpers to apply the <b>OpTotalConfirmedYieldQty</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<BigDecimal> OP_TOTAL_CONFIRMED_YIELD_QTY =
        new ProcessOrderOperationField<BigDecimal>("OpTotalConfirmedYieldQty");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @return Work Center Internal ID
     */
    @SerializedName( "WorkCenterInternalID" )
    @JsonProperty( "WorkCenterInternalID" )
    @Nullable
    @ODataField( odataName = "WorkCenterInternalID" )
    private String workCenterInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WorkCenterInternalID</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> WORK_CENTER_INTERNAL_ID =
        new ProcessOrderOperationField<String>("WorkCenterInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return The lastChangeDateTime contained in this entity.
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @ODataField( odataName = "LastChangeDateTime" )
    private String lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> LAST_CHANGE_DATE_TIME =
        new ProcessOrderOperationField<String>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSubOperation</b>
     * </p>
     *
     * @return Manufacturing Order Suboperation
     */
    @SerializedName( "ManufacturingOrderSubOperation" )
    @JsonProperty( "ManufacturingOrderSubOperation" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrderSubOperation" )
    private String manufacturingOrderSubOperation;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrderSubOperation</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> MANUFACTURING_ORDER_SUB_OPERATION =
        new ProcessOrderOperationField<String>("ManufacturingOrderSubOperation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     *
     * @return Operation Control Profile
     */
    @SerializedName( "OperationControlProfile" )
    @JsonProperty( "OperationControlProfile" )
    @Nullable
    @ODataField( odataName = "OperationControlProfile" )
    private String operationControlProfile;
    /**
     * Use with available fluent helpers to apply the <b>OperationControlProfile</b> field to query operations.
     *
     */
    public final static ProcessOrderOperationField<String> OPERATION_CONTROL_PROFILE =
        new ProcessOrderOperationField<String>("OperationControlProfile");

    @Nonnull
    @Override
    public Class<ProcessOrderOperation> getType()
    {
        return ProcessOrderOperation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OrderInternalBillOfOperations</b>
     * </p>
     *
     * @param orderInternalBillOfOperations
     *            Order Internal ID
     */
    public void setOrderInternalBillOfOperations( @Nullable final String orderInternalBillOfOperations )
    {
        rememberChangedField("OrderInternalBillOfOperations", this.orderInternalBillOfOperations);
        this.orderInternalBillOfOperations = orderInternalBillOfOperations;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OrderIntBillOfOperationsItem</b>
     * </p>
     *
     * @param orderIntBillOfOperationsItem
     *            Internal Identifier of an Operation or Activity
     */
    public void setOrderIntBillOfOperationsItem( @Nullable final String orderIntBillOfOperationsItem )
    {
        rememberChangedField("OrderIntBillOfOperationsItem", this.orderIntBillOfOperationsItem);
        this.orderIntBillOfOperationsItem = orderIntBillOfOperationsItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Manufacturing Order ID
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderOperation</b>
     * </p>
     *
     * @param manufacturingOrderOperation
     *            Manufacturing Order Operation
     */
    public void setManufacturingOrderOperation( @Nullable final String manufacturingOrderOperation )
    {
        rememberChangedField("ManufacturingOrderOperation", this.manufacturingOrderOperation);
        this.manufacturingOrderOperation = manufacturingOrderOperation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderOperationIsPhase</b>
     * </p>
     *
     * @param mfgOrderOperationIsPhase
     *            Indicator: Phase
     */
    public void setMfgOrderOperationIsPhase( @Nullable final Boolean mfgOrderOperationIsPhase )
    {
        rememberChangedField("MfgOrderOperationIsPhase", this.mfgOrderOperationIsPhase);
        this.mfgOrderOperationIsPhase = mfgOrderOperationIsPhase;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSequence</b>
     * </p>
     *
     * @param manufacturingOrderSequence
     *            Manufacturing Order Sequence
     */
    public void setManufacturingOrderSequence( @Nullable final String manufacturingOrderSequence )
    {
        rememberChangedField("ManufacturingOrderSequence", this.manufacturingOrderSequence);
        this.manufacturingOrderSequence = manufacturingOrderSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderSequenceText</b>
     * </p>
     *
     * @param mfgOrderSequenceText
     *            Manufacturing Order Sequence Text
     */
    public void setMfgOrderSequenceText( @Nullable final String mfgOrderSequenceText )
    {
        rememberChangedField("MfgOrderSequenceText", this.mfgOrderSequenceText);
        this.mfgOrderSequenceText = mfgOrderSequenceText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>MfgOrderOperationText</b>
     * </p>
     *
     * @param mfgOrderOperationText
     *            Manufacturing Order Operation Text
     */
    public void setMfgOrderOperationText( @Nullable final String mfgOrderOperationText )
    {
        rememberChangedField("MfgOrderOperationText", this.mfgOrderOperationText);
        this.mfgOrderOperationText = mfgOrderOperationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderType</b>
     * </p>
     *
     * @param manufacturingOrderType
     *            Manufacturing Order Type
     */
    public void setManufacturingOrderType( @Nullable final String manufacturingOrderType )
    {
        rememberChangedField("ManufacturingOrderType", this.manufacturingOrderType);
        this.manufacturingOrderType = manufacturingOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BusinessProcessEntryUnit</b>
     * </p>
     *
     * @param businessProcessEntryUnit
     *            Unit of Measure for Business Process Quantity
     */
    public void setBusinessProcessEntryUnit( @Nullable final String businessProcessEntryUnit )
    {
        rememberChangedField("BusinessProcessEntryUnit", this.businessProcessEntryUnit);
        this.businessProcessEntryUnit = businessProcessEntryUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderCategory</b>
     * </p>
     *
     * @param manufacturingOrderCategory
     *            Manufacturing Order Category
     */
    public void setManufacturingOrderCategory( @Nullable final String manufacturingOrderCategory )
    {
        rememberChangedField("ManufacturingOrderCategory", this.manufacturingOrderCategory);
        this.manufacturingOrderCategory = manufacturingOrderCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Work Center Type Code
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtDte</b>
     * </p>
     *
     * @param opErlstSchedldExecStrtDte
     *            Earliest Scheduled Execution Start Date
     */
    public void setOpErlstSchedldExecStrtDte( @Nullable final LocalDateTime opErlstSchedldExecStrtDte )
    {
        rememberChangedField("OpErlstSchedldExecStrtDte", this.opErlstSchedldExecStrtDte);
        this.opErlstSchedldExecStrtDte = opErlstSchedldExecStrtDte;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecStrtTme</b>
     * </p>
     *
     * @param opErlstSchedldExecStrtTme
     *            Earliest Scheduled Execution Start Time
     */
    public void setOpErlstSchedldExecStrtTme( @Nullable final LocalTime opErlstSchedldExecStrtTme )
    {
        rememberChangedField("OpErlstSchedldExecStrtTme", this.opErlstSchedldExecStrtTme);
        this.opErlstSchedldExecStrtTme = opErlstSchedldExecStrtTme;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndDte</b>
     * </p>
     *
     * @param opErlstSchedldExecEndDte
     *            Earliest Scheduled Execution End Date
     */
    public void setOpErlstSchedldExecEndDte( @Nullable final LocalDateTime opErlstSchedldExecEndDte )
    {
        rememberChangedField("OpErlstSchedldExecEndDte", this.opErlstSchedldExecEndDte);
        this.opErlstSchedldExecEndDte = opErlstSchedldExecEndDte;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpErlstSchedldExecEndTme</b>
     * </p>
     *
     * @param opErlstSchedldExecEndTme
     *            Earliest Scheduled Execution End Time
     */
    public void setOpErlstSchedldExecEndTme( @Nullable final LocalTime opErlstSchedldExecEndTme )
    {
        rememberChangedField("OpErlstSchedldExecEndTme", this.opErlstSchedldExecEndTme);
        this.opErlstSchedldExecEndTme = opErlstSchedldExecEndTme;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionStartDate</b>
     * </p>
     *
     * @param opActualExecutionStartDate
     *            Confirmed Start Date of Execution
     */
    public void setOpActualExecutionStartDate( @Nullable final LocalDateTime opActualExecutionStartDate )
    {
        rememberChangedField("OpActualExecutionStartDate", this.opActualExecutionStartDate);
        this.opActualExecutionStartDate = opActualExecutionStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionStartTime</b>
     * </p>
     *
     * @param opActualExecutionStartTime
     *            Confirmed Start Time of Execution
     */
    public void setOpActualExecutionStartTime( @Nullable final LocalTime opActualExecutionStartTime )
    {
        rememberChangedField("OpActualExecutionStartTime", this.opActualExecutionStartTime);
        this.opActualExecutionStartTime = opActualExecutionStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionEndDate</b>
     * </p>
     *
     * @param opActualExecutionEndDate
     *            Confirmed End Date of Execution
     */
    public void setOpActualExecutionEndDate( @Nullable final LocalDateTime opActualExecutionEndDate )
    {
        rememberChangedField("OpActualExecutionEndDate", this.opActualExecutionEndDate);
        this.opActualExecutionEndDate = opActualExecutionEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionEndTime</b>
     * </p>
     *
     * @param opActualExecutionEndTime
     *            Confirmed End Time of Execution
     */
    public void setOpActualExecutionEndTime( @Nullable final LocalTime opActualExecutionEndTime )
    {
        rememberChangedField("OpActualExecutionEndTime", this.opActualExecutionEndTime);
        this.opActualExecutionEndTime = opActualExecutionEndTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OperationUnit</b>
     * </p>
     *
     * @param operationUnit
     *            Operation Unit of Measure
     */
    public void setOperationUnit( @Nullable final String operationUnit )
    {
        rememberChangedField("OperationUnit", this.operationUnit);
        this.operationUnit = operationUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpPlannedTotalQuantity</b>
     * </p>
     *
     * @param opPlannedTotalQuantity
     *            Operation Total Quantity
     */
    public void setOpPlannedTotalQuantity( @Nullable final BigDecimal opPlannedTotalQuantity )
    {
        rememberChangedField("OpPlannedTotalQuantity", this.opPlannedTotalQuantity);
        this.opPlannedTotalQuantity = opPlannedTotalQuantity;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ErlstSchedldExecDurnInWorkdays</b>
     * </p>
     *
     * @param erlstSchedldExecDurnInWorkdays
     *            Earliest Scheduled Execution Duration in Workdays
     */
    public void setErlstSchedldExecDurnInWorkdays( @Nullable final Integer erlstSchedldExecDurnInWorkdays )
    {
        rememberChangedField("ErlstSchedldExecDurnInWorkdays", this.erlstSchedldExecDurnInWorkdays);
        this.erlstSchedldExecDurnInWorkdays = erlstSchedldExecDurnInWorkdays;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>OpActualExecutionDays</b>
     * </p>
     *
     * @param opActualExecutionDays
     *            Actual Execution Duration in Workdays
     */
    public void setOpActualExecutionDays( @Nullable final Integer opActualExecutionDays )
    {
        rememberChangedField("OpActualExecutionDays", this.opActualExecutionDays);
        this.opActualExecutionDays = opActualExecutionDays;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpTotalConfirmedYieldQty</b>
     * </p>
     *
     * @param opTotalConfirmedYieldQty
     *            Total Confirmed Yield
     */
    public void setOpTotalConfirmedYieldQty( @Nullable final BigDecimal opTotalConfirmedYieldQty )
    {
        rememberChangedField("OpTotalConfirmedYieldQty", this.opTotalConfirmedYieldQty);
        this.opTotalConfirmedYieldQty = opTotalConfirmedYieldQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WorkCenterInternalID</b>
     * </p>
     *
     * @param workCenterInternalID
     *            Work Center Internal ID
     */
    public void setWorkCenterInternalID( @Nullable final String workCenterInternalID )
    {
        rememberChangedField("WorkCenterInternalID", this.workCenterInternalID);
        this.workCenterInternalID = workCenterInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 14
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            The lastChangeDateTime to set.
     */
    public void setLastChangeDateTime( @Nullable final String lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrderSubOperation</b>
     * </p>
     *
     * @param manufacturingOrderSubOperation
     *            Manufacturing Order Suboperation
     */
    public void setManufacturingOrderSubOperation( @Nullable final String manufacturingOrderSubOperation )
    {
        rememberChangedField("ManufacturingOrderSubOperation", this.manufacturingOrderSubOperation);
        this.manufacturingOrderSubOperation = manufacturingOrderSubOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperationControlProfile</b>
     * </p>
     *
     * @param operationControlProfile
     *            Operation Control Profile
     */
    public void setOperationControlProfile( @Nullable final String operationControlProfile )
    {
        rememberChangedField("OperationControlProfile", this.operationControlProfile);
        this.operationControlProfile = operationControlProfile;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProcessOrderOperation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        result.put("OrderIntBillOfOperationsItem", getOrderIntBillOfOperationsItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("OrderInternalBillOfOperations", getOrderInternalBillOfOperations());
        values.put("OrderIntBillOfOperationsItem", getOrderIntBillOfOperationsItem());
        values.put("ManufacturingOrder", getManufacturingOrder());
        values.put("ManufacturingOrderOperation", getManufacturingOrderOperation());
        values.put("MfgOrderOperationIsPhase", getMfgOrderOperationIsPhase());
        values.put("ManufacturingOrderSequence", getManufacturingOrderSequence());
        values.put("MfgOrderSequenceText", getMfgOrderSequenceText());
        values.put("MfgOrderOperationText", getMfgOrderOperationText());
        values.put("ManufacturingOrderType", getManufacturingOrderType());
        values.put("BusinessProcessEntryUnit", getBusinessProcessEntryUnit());
        values.put("ManufacturingOrderCategory", getManufacturingOrderCategory());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("WorkCenter", getWorkCenter());
        values.put("OpErlstSchedldExecStrtDte", getOpErlstSchedldExecStrtDte());
        values.put("OpErlstSchedldExecStrtTme", getOpErlstSchedldExecStrtTme());
        values.put("OpErlstSchedldExecEndDte", getOpErlstSchedldExecEndDte());
        values.put("OpErlstSchedldExecEndTme", getOpErlstSchedldExecEndTme());
        values.put("OpActualExecutionStartDate", getOpActualExecutionStartDate());
        values.put("OpActualExecutionStartTime", getOpActualExecutionStartTime());
        values.put("OpActualExecutionEndDate", getOpActualExecutionEndDate());
        values.put("OpActualExecutionEndTime", getOpActualExecutionEndTime());
        values.put("OperationUnit", getOperationUnit());
        values.put("OpPlannedTotalQuantity", getOpPlannedTotalQuantity());
        values.put("ErlstSchedldExecDurnInWorkdays", getErlstSchedldExecDurnInWorkdays());
        values.put("OpActualExecutionDays", getOpActualExecutionDays());
        values.put("OpTotalConfirmedYieldQty", getOpTotalConfirmedYieldQty());
        values.put("WorkCenterInternalID", getWorkCenterInternalID());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("ManufacturingOrderSubOperation", getManufacturingOrderSubOperation());
        values.put("OperationControlProfile", getOperationControlProfile());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("OrderInternalBillOfOperations") ) {
                final Object value = values.remove("OrderInternalBillOfOperations");
                if( (value == null) || (!value.equals(getOrderInternalBillOfOperations())) ) {
                    setOrderInternalBillOfOperations(((String) value));
                }
            }
            if( values.containsKey("OrderIntBillOfOperationsItem") ) {
                final Object value = values.remove("OrderIntBillOfOperationsItem");
                if( (value == null) || (!value.equals(getOrderIntBillOfOperationsItem())) ) {
                    setOrderIntBillOfOperationsItem(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderOperation") ) {
                final Object value = values.remove("ManufacturingOrderOperation");
                if( (value == null) || (!value.equals(getManufacturingOrderOperation())) ) {
                    setManufacturingOrderOperation(((String) value));
                }
            }
            if( values.containsKey("MfgOrderOperationIsPhase") ) {
                final Object value = values.remove("MfgOrderOperationIsPhase");
                if( (value == null) || (!value.equals(getMfgOrderOperationIsPhase())) ) {
                    setMfgOrderOperationIsPhase(((Boolean) value));
                }
            }
            if( values.containsKey("ManufacturingOrderSequence") ) {
                final Object value = values.remove("ManufacturingOrderSequence");
                if( (value == null) || (!value.equals(getManufacturingOrderSequence())) ) {
                    setManufacturingOrderSequence(((String) value));
                }
            }
            if( values.containsKey("MfgOrderSequenceText") ) {
                final Object value = values.remove("MfgOrderSequenceText");
                if( (value == null) || (!value.equals(getMfgOrderSequenceText())) ) {
                    setMfgOrderSequenceText(((String) value));
                }
            }
            if( values.containsKey("MfgOrderOperationText") ) {
                final Object value = values.remove("MfgOrderOperationText");
                if( (value == null) || (!value.equals(getMfgOrderOperationText())) ) {
                    setMfgOrderOperationText(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderType") ) {
                final Object value = values.remove("ManufacturingOrderType");
                if( (value == null) || (!value.equals(getManufacturingOrderType())) ) {
                    setManufacturingOrderType(((String) value));
                }
            }
            if( values.containsKey("BusinessProcessEntryUnit") ) {
                final Object value = values.remove("BusinessProcessEntryUnit");
                if( (value == null) || (!value.equals(getBusinessProcessEntryUnit())) ) {
                    setBusinessProcessEntryUnit(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderCategory") ) {
                final Object value = values.remove("ManufacturingOrderCategory");
                if( (value == null) || (!value.equals(getManufacturingOrderCategory())) ) {
                    setManufacturingOrderCategory(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecStrtDte") ) {
                final Object value = values.remove("OpErlstSchedldExecStrtDte");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecStrtDte())) ) {
                    setOpErlstSchedldExecStrtDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecStrtTme") ) {
                final Object value = values.remove("OpErlstSchedldExecStrtTme");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecStrtTme())) ) {
                    setOpErlstSchedldExecStrtTme(((LocalTime) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecEndDte") ) {
                final Object value = values.remove("OpErlstSchedldExecEndDte");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecEndDte())) ) {
                    setOpErlstSchedldExecEndDte(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpErlstSchedldExecEndTme") ) {
                final Object value = values.remove("OpErlstSchedldExecEndTme");
                if( (value == null) || (!value.equals(getOpErlstSchedldExecEndTme())) ) {
                    setOpErlstSchedldExecEndTme(((LocalTime) value));
                }
            }
            if( values.containsKey("OpActualExecutionStartDate") ) {
                final Object value = values.remove("OpActualExecutionStartDate");
                if( (value == null) || (!value.equals(getOpActualExecutionStartDate())) ) {
                    setOpActualExecutionStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpActualExecutionStartTime") ) {
                final Object value = values.remove("OpActualExecutionStartTime");
                if( (value == null) || (!value.equals(getOpActualExecutionStartTime())) ) {
                    setOpActualExecutionStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("OpActualExecutionEndDate") ) {
                final Object value = values.remove("OpActualExecutionEndDate");
                if( (value == null) || (!value.equals(getOpActualExecutionEndDate())) ) {
                    setOpActualExecutionEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OpActualExecutionEndTime") ) {
                final Object value = values.remove("OpActualExecutionEndTime");
                if( (value == null) || (!value.equals(getOpActualExecutionEndTime())) ) {
                    setOpActualExecutionEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("OperationUnit") ) {
                final Object value = values.remove("OperationUnit");
                if( (value == null) || (!value.equals(getOperationUnit())) ) {
                    setOperationUnit(((String) value));
                }
            }
            if( values.containsKey("OpPlannedTotalQuantity") ) {
                final Object value = values.remove("OpPlannedTotalQuantity");
                if( (value == null) || (!value.equals(getOpPlannedTotalQuantity())) ) {
                    setOpPlannedTotalQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ErlstSchedldExecDurnInWorkdays") ) {
                final Object value = values.remove("ErlstSchedldExecDurnInWorkdays");
                if( (value == null) || (!value.equals(getErlstSchedldExecDurnInWorkdays())) ) {
                    setErlstSchedldExecDurnInWorkdays(((Integer) value));
                }
            }
            if( values.containsKey("OpActualExecutionDays") ) {
                final Object value = values.remove("OpActualExecutionDays");
                if( (value == null) || (!value.equals(getOpActualExecutionDays())) ) {
                    setOpActualExecutionDays(((Integer) value));
                }
            }
            if( values.containsKey("OpTotalConfirmedYieldQty") ) {
                final Object value = values.remove("OpTotalConfirmedYieldQty");
                if( (value == null) || (!value.equals(getOpTotalConfirmedYieldQty())) ) {
                    setOpTotalConfirmedYieldQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("WorkCenterInternalID") ) {
                final Object value = values.remove("WorkCenterInternalID");
                if( (value == null) || (!value.equals(getWorkCenterInternalID())) ) {
                    setWorkCenterInternalID(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((String) value));
                }
            }
            if( values.containsKey("ManufacturingOrderSubOperation") ) {
                final Object value = values.remove("ManufacturingOrderSubOperation");
                if( (value == null) || (!value.equals(getManufacturingOrderSubOperation())) ) {
                    setManufacturingOrderSubOperation(((String) value));
                }
            }
            if( values.containsKey("OperationControlProfile") ) {
                final Object value = values.remove("OperationControlProfile");
                if( (value == null) || (!value.equals(getOperationControlProfile())) ) {
                    setOperationControlProfile(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProcessOrderOperationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProcessOrderOperationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProcessOrderOperationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProcessOrderOperationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderService.DEFAULT_SERVICE_PATH);
    }

}
