/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.field.ProcessOrderStatusField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.selectable.ProcessOrderStatusSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * API Process Order Status
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProcessOrderStatusType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProcessOrderStatus extends VdmEntity<ProcessOrderStatus>
{

    /**
     * Selector for all available fields of ProcessOrderStatus.
     *
     */
    public final static ProcessOrderStatusSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @return Order Number
     */
    @Key
    @SerializedName( "ManufacturingOrder" )
    @JsonProperty( "ManufacturingOrder" )
    @Nullable
    @ODataField( odataName = "ManufacturingOrder" )
    private String manufacturingOrder;
    /**
     * Use with available fluent helpers to apply the <b>ManufacturingOrder</b> field to query operations.
     *
     */
    public final static ProcessOrderStatusField<String> MANUFACTURING_ORDER =
        new ProcessOrderStatusField<String>("ManufacturingOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StatusCode</b>
     * </p>
     *
     * @return Object status
     */
    @Key
    @SerializedName( "StatusCode" )
    @JsonProperty( "StatusCode" )
    @Nullable
    @ODataField( odataName = "StatusCode" )
    private String statusCode;
    /**
     * Use with available fluent helpers to apply the <b>StatusCode</b> field to query operations.
     *
     */
    public final static ProcessOrderStatusField<String> STATUS_CODE = new ProcessOrderStatusField<String>("StatusCode");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsUserStatus</b>
     * </p>
     *
     * @return Is User Status
     */
    @SerializedName( "IsUserStatus" )
    @JsonProperty( "IsUserStatus" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsUserStatus" )
    private Boolean isUserStatus;
    /**
     * Use with available fluent helpers to apply the <b>IsUserStatus</b> field to query operations.
     *
     */
    public final static ProcessOrderStatusField<Boolean> IS_USER_STATUS =
        new ProcessOrderStatusField<Boolean>("IsUserStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StatusShortName</b>
     * </p>
     *
     * @return Individual status of an object (short form)
     */
    @SerializedName( "StatusShortName" )
    @JsonProperty( "StatusShortName" )
    @Nullable
    @ODataField( odataName = "StatusShortName" )
    private String statusShortName;
    /**
     * Use with available fluent helpers to apply the <b>StatusShortName</b> field to query operations.
     *
     */
    public final static ProcessOrderStatusField<String> STATUS_SHORT_NAME =
        new ProcessOrderStatusField<String>("StatusShortName");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>StatusName</b>
     * </p>
     *
     * @return Object status
     */
    @SerializedName( "StatusName" )
    @JsonProperty( "StatusName" )
    @Nullable
    @ODataField( odataName = "StatusName" )
    private String statusName;
    /**
     * Use with available fluent helpers to apply the <b>StatusName</b> field to query operations.
     *
     */
    public final static ProcessOrderStatusField<String> STATUS_NAME = new ProcessOrderStatusField<String>("StatusName");

    @Nonnull
    @Override
    public Class<ProcessOrderStatus> getType()
    {
        return ProcessOrderStatus.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ManufacturingOrder</b>
     * </p>
     *
     * @param manufacturingOrder
     *            Order Number
     */
    public void setManufacturingOrder( @Nullable final String manufacturingOrder )
    {
        rememberChangedField("ManufacturingOrder", this.manufacturingOrder);
        this.manufacturingOrder = manufacturingOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>StatusCode</b>
     * </p>
     *
     * @param statusCode
     *            Object status
     */
    public void setStatusCode( @Nullable final String statusCode )
    {
        rememberChangedField("StatusCode", this.statusCode);
        this.statusCode = statusCode;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsUserStatus</b>
     * </p>
     *
     * @param isUserStatus
     *            Is User Status
     */
    public void setIsUserStatus( @Nullable final Boolean isUserStatus )
    {
        rememberChangedField("IsUserStatus", this.isUserStatus);
        this.isUserStatus = isUserStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StatusShortName</b>
     * </p>
     *
     * @param statusShortName
     *            Individual status of an object (short form)
     */
    public void setStatusShortName( @Nullable final String statusShortName )
    {
        rememberChangedField("StatusShortName", this.statusShortName);
        this.statusShortName = statusShortName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>StatusName</b>
     * </p>
     *
     * @param statusName
     *            Object status
     */
    public void setStatusName( @Nullable final String statusName )
    {
        rememberChangedField("StatusName", this.statusName);
        this.statusName = statusName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProcessOrderStatus";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ManufacturingOrder", getManufacturingOrder());
        result.put("StatusCode", getStatusCode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ManufacturingOrder", getManufacturingOrder());
        values.put("StatusCode", getStatusCode());
        values.put("IsUserStatus", getIsUserStatus());
        values.put("StatusShortName", getStatusShortName());
        values.put("StatusName", getStatusName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ManufacturingOrder") ) {
                final Object value = values.remove("ManufacturingOrder");
                if( (value == null) || (!value.equals(getManufacturingOrder())) ) {
                    setManufacturingOrder(((String) value));
                }
            }
            if( values.containsKey("StatusCode") ) {
                final Object value = values.remove("StatusCode");
                if( (value == null) || (!value.equals(getStatusCode())) ) {
                    setStatusCode(((String) value));
                }
            }
            if( values.containsKey("IsUserStatus") ) {
                final Object value = values.remove("IsUserStatus");
                if( (value == null) || (!value.equals(getIsUserStatus())) ) {
                    setIsUserStatus(((Boolean) value));
                }
            }
            if( values.containsKey("StatusShortName") ) {
                final Object value = values.remove("StatusShortName");
                if( (value == null) || (!value.equals(getStatusShortName())) ) {
                    setStatusShortName(((String) value));
                }
            }
            if( values.containsKey("StatusName") ) {
                final Object value = values.remove("StatusName");
                if( (value == null) || (!value.equals(getStatusName())) ) {
                    setStatusName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProcessOrderStatusField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProcessOrderStatusField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProcessOrderStatusField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProcessOrderStatusField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderService.DEFAULT_SERVICE_PATH);
    }

}
