/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link ProcessOrderServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderService ProcessOrderService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultProcessOrderServiceBatch
    extends
    BatchFluentHelperBasic<ProcessOrderServiceBatch, ProcessOrderServiceBatchChangeSet>
    implements
    ProcessOrderServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultProcessOrderServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProcessOrderServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultProcessOrderServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultProcessOrderServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultProcessOrderServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProcessOrderServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultProcessOrderServiceBatchChangeSet(this, service);
    }

}
