/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder;

/**
 * Implementation of the {@link ProcessOrderServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderService ProcessOrderService}.
 *
 */
public class DefaultProcessOrderServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<ProcessOrderServiceBatch, ProcessOrderServiceBatchChangeSet>
    implements
    ProcessOrderServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderService service;

    @SuppressWarnings( "deprecation" )
    DefaultProcessOrderServiceBatchChangeSet(
        @Nonnull final DefaultProcessOrderServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultProcessOrderServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public ProcessOrderServiceBatchChangeSet createFunctionMessage( @Nonnull final FunctionMessage functionMessage )
    {
        return addRequestCreate(service::createFunctionMessage, functionMessage);
    }

    @Nonnull
    @Override
    public ProcessOrderServiceBatchChangeSet updateFunctionMessage( @Nonnull final FunctionMessage functionMessage )
    {
        return addRequestUpdate(service::updateFunctionMessage, functionMessage);
    }

    @Nonnull
    @Override
    public ProcessOrderServiceBatchChangeSet deleteFunctionMessage( @Nonnull final FunctionMessage functionMessage )
    {
        return addRequestDelete(service::deleteFunctionMessage, functionMessage);
    }

    @Nonnull
    @Override
    public ProcessOrderServiceBatchChangeSet createProcessOrder( @Nonnull final ProcessOrder processOrder )
    {
        return addRequestCreate(service::createProcessOrder, processOrder);
    }

    @Nonnull
    @Override
    public ProcessOrderServiceBatchChangeSet updateProcessOrder( @Nonnull final ProcessOrder processOrder )
    {
        return addRequestUpdate(service::updateProcessOrder, processOrder);
    }

}
