/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.ProcessOrderService ProcessOrderService}.
 *
 */
public interface ProcessOrderServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<ProcessOrderServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<ProcessOrderServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage
     * FunctionMessage} entity and save it to the S/4HANA system.
     *
     * @param functionMessage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage
     *            FunctionMessage} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProcessOrderServiceBatchChangeSet createFunctionMessage( @Nonnull final FunctionMessage functionMessage );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage
     * FunctionMessage} entity and save it to the S/4HANA system.
     *
     * @param functionMessage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage
     *            FunctionMessage} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProcessOrderServiceBatchChangeSet updateFunctionMessage( @Nonnull final FunctionMessage functionMessage );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage
     * FunctionMessage} entity in the S/4HANA system.
     *
     * @param functionMessage
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage
     *            FunctionMessage} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProcessOrderServiceBatchChangeSet deleteFunctionMessage( @Nonnull final FunctionMessage functionMessage );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder ProcessOrder}
     * entity and save it to the S/4HANA system.
     *
     * @param processOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder ProcessOrder}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProcessOrderServiceBatchChangeSet createProcessOrder( @Nonnull final ProcessOrder processOrder );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder
     * ProcessOrder} entity and save it to the S/4HANA system.
     *
     * @param processOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrder ProcessOrder}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    ProcessOrderServiceBatchChangeSet updateProcessOrder( @Nonnull final ProcessOrder processOrder );

}
