/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.selectable.ProcessOrderItemSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderItem ProcessOrderItem} to other
 * entities. Instances of this object are used in query modifier methods of the entity fluent helpers. Contains methods
 * to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class ProcessOrderItemLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<ProcessOrderItemLink<ObjectT>, ProcessOrderItem, ObjectT>
    implements
    ProcessOrderItemSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public ProcessOrderItemLink( final String fieldName )
    {
        super(fieldName);
    }

    private ProcessOrderItemLink( final EntityLink<ProcessOrderItemLink<ObjectT>, ProcessOrderItem, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected ProcessOrderItemLink<ObjectT> translateLinkType(
        final EntityLink<ProcessOrderItemLink<ObjectT>, ProcessOrderItem, ObjectT> link )
    {
        return new ProcessOrderItemLink<ObjectT>(link);
    }

}
