/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage FunctionMessage}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.field.FunctionMessageField
 * FunctionMessageField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.link.FunctionMessageLink
 * FunctionMessageLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.FunctionMessage#MESSAGE MESSAGE}</li>
 * </ul>
 *
 */
public interface FunctionMessageSelectable extends EntitySelectable<FunctionMessage>
{

}
