/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent ProcessOrderComponent}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.field.ProcessOrderComponentField
 * ProcessOrderComponentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.link.ProcessOrderComponentLink
 * ProcessOrderComponentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#RESERVATION
 * RESERVATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#RESERVATION_ITEM
 * RESERVATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#BILL_OF_MATERIAL_ITEM_NUMBER
 * BILL_OF_MATERIAL_ITEM_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#BOM_ITEM_DESCRIPTION
 * BOM_ITEM_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#PRODUCTION_PLANT
 * PRODUCTION_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#MATL_COMP_REQUIREMENT_DATE
 * MATL_COMP_REQUIREMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#BASE_UNIT
 * BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#REQUIRED_QUANTITY
 * REQUIRED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#WITHDRAWN_QUANTITY
 * WITHDRAWN_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#BOM_ITEM
 * BOM_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#STORAGE_LOCATION
 * STORAGE_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#SUPPLY_AREA
 * SUPPLY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#MANUFACTURING_ORDER_SEQUENCE
 * MANUFACTURING_ORDER_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#MANUFACTURING_ORDER_OPERATION
 * MANUFACTURING_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#MANUFACTURING_ORDER_CATEGORY
 * MANUFACTURING_ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#MANUFACTURING_ORDER_TYPE
 * MANUFACTURING_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#ORDER_INTERNAL_BILL_OF_OPERATIONS
 * ORDER_INTERNAL_BILL_OF_OPERATIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#BOM_ITEM_TEXT2
 * BOM_ITEM_TEXT2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#BOM_ITEM_CATEGORY
 * BOM_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#BILL_OF_MATERIAL_CATEGORY
 * BILL_OF_MATERIAL_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#SORT_FIELD
 * SORT_FIELD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#GOODS_RECIPIENT_NAME
 * GOODS_RECIPIENT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#UNLOADING_POINT_NAME
 * UNLOADING_POINT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#BATCH BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#BATCH_SPLIT_TYPE
 * BATCH_SPLIT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#MATERIAL_COMP_ORIGINAL_QUANTITY
 * MATERIAL_COMP_ORIGINAL_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#MATL_COMP_IS_MARKED_FOR_BACKFLUSH
 * MATL_COMP_IS_MARKED_FOR_BACKFLUSH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#IS_BULK_MATERIAL_COMPONENT
 * IS_BULK_MATERIAL_COMPONENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#MATERIAL_COMPONENT_IS_PHANTOM_ITEM
 * MATERIAL_COMPONENT_IS_PHANTOM_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#MATERIAL_COMP_IS_COST_RELEVANT
 * MATERIAL_COMP_IS_COST_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#CONFIRMED_AVAILABLE_QUANTITY
 * CONFIRMED_AVAILABLE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#GOODS_MOVEMENT_TYPE
 * GOODS_MOVEMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#MATL_COMP_REQUIREMENT_TIME
 * MATL_COMP_REQUIREMENT_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#COMPONENT_SCRAP_IN_PERCENT
 * COMPONENT_SCRAP_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#OPERATION_SCRAP_IN_PERCENT
 * OPERATION_SCRAP_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#QUANTITY_IS_FIXED
 * QUANTITY_IS_FIXED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#IS_NET_SCRAP
 * IS_NET_SCRAP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#RESERVATION_IS_FINALLY_ISSUED
 * RESERVATION_IS_FINALLY_ISSUED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#WITHDRAWN_QUANTITY_AMOUNT
 * WITHDRAWN_QUANTITY_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#LEAD_TIME_OFFSET
 * LEAD_TIME_OFFSET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderComponent#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * </ul>
 *
 */
public interface ProcessOrderComponentSelectable extends EntitySelectable<ProcessOrderComponent>
{

}
