/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation ProcessOrderOperation}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.field.ProcessOrderOperationField
 * ProcessOrderOperationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.link.ProcessOrderOperationLink
 * ProcessOrderOperationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#ORDER_INTERNAL_BILL_OF_OPERATIONS
 * ORDER_INTERNAL_BILL_OF_OPERATIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#ORDER_INT_BILL_OF_OPERATIONS_ITEM
 * ORDER_INT_BILL_OF_OPERATIONS_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#MANUFACTURING_ORDER_OPERATION
 * MANUFACTURING_ORDER_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#MFG_ORDER_OPERATION_IS_PHASE
 * MFG_ORDER_OPERATION_IS_PHASE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#MANUFACTURING_ORDER_SEQUENCE
 * MANUFACTURING_ORDER_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#MFG_ORDER_SEQUENCE_TEXT
 * MFG_ORDER_SEQUENCE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#MFG_ORDER_OPERATION_TEXT
 * MFG_ORDER_OPERATION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#MANUFACTURING_ORDER_TYPE
 * MANUFACTURING_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#BUSINESS_PROCESS_ENTRY_UNIT
 * BUSINESS_PROCESS_ENTRY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#MANUFACTURING_ORDER_CATEGORY
 * MANUFACTURING_ORDER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#WORK_CENTER_TYPE_CODE
 * WORK_CENTER_TYPE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#WORK_CENTER
 * WORK_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#OP_ERLST_SCHEDLD_EXEC_STRT_DTE
 * OP_ERLST_SCHEDLD_EXEC_STRT_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#OP_ERLST_SCHEDLD_EXEC_STRT_TME
 * OP_ERLST_SCHEDLD_EXEC_STRT_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#OP_ERLST_SCHEDLD_EXEC_END_DTE
 * OP_ERLST_SCHEDLD_EXEC_END_DTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#OP_ERLST_SCHEDLD_EXEC_END_TME
 * OP_ERLST_SCHEDLD_EXEC_END_TME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#OP_ACTUAL_EXECUTION_START_DATE
 * OP_ACTUAL_EXECUTION_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#OP_ACTUAL_EXECUTION_START_TIME
 * OP_ACTUAL_EXECUTION_START_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#OP_ACTUAL_EXECUTION_END_DATE
 * OP_ACTUAL_EXECUTION_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#OP_ACTUAL_EXECUTION_END_TIME
 * OP_ACTUAL_EXECUTION_END_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#OPERATION_UNIT
 * OPERATION_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#OP_PLANNED_TOTAL_QUANTITY
 * OP_PLANNED_TOTAL_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#ERLST_SCHEDLD_EXEC_DURN_IN_WORKDAYS
 * ERLST_SCHEDLD_EXEC_DURN_IN_WORKDAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#OP_ACTUAL_EXECUTION_DAYS
 * OP_ACTUAL_EXECUTION_DAYS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#OP_TOTAL_CONFIRMED_YIELD_QTY
 * OP_TOTAL_CONFIRMED_YIELD_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#WORK_CENTER_INTERNAL_ID
 * WORK_CENTER_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#MANUFACTURING_ORDER_SUB_OPERATION
 * MANUFACTURING_ORDER_SUB_OPERATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderOperation#OPERATION_CONTROL_PROFILE
 * OPERATION_CONTROL_PROFILE}</li>
 * </ul>
 *
 */
public interface ProcessOrderOperationSelectable extends EntitySelectable<ProcessOrderOperation>
{

}
