/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatus;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatus ProcessOrderStatus}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.field.ProcessOrderStatusField
 * ProcessOrderStatusField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.link.ProcessOrderStatusLink
 * ProcessOrderStatusLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatus#MANUFACTURING_ORDER
 * MANUFACTURING_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatus#STATUS_CODE
 * STATUS_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatus#IS_USER_STATUS
 * IS_USER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatus#STATUS_SHORT_NAME
 * STATUS_SHORT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorder.ProcessOrderStatus#STATUS_NAME
 * STATUS_NAME}</li>
 * </ul>
 *
 */
public interface ProcessOrderStatusSelectable extends EntitySelectable<ProcessOrderStatus>
{

}
