/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmComplex;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original complex type name from the Odata EDM: <b>AProcordconfirmation2</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class AProcordconfirmation2 extends VdmComplex<AProcordconfirmation2>
{

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>APIConfHasNoGoodsMovements</b>
     * </p>
     *
     * @param aPIConfHasNoGoodsMovements
     *
     * @return No Goods Movement
     */
    @SerializedName( "APIConfHasNoGoodsMovements" )
    @JsonProperty( "APIConfHasNoGoodsMovements" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "APIConfHasNoGoodsMovements" )
    private Boolean aPIConfHasNoGoodsMovements;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BreakDurationUnit</b>
     * </p>
     *
     * @param breakDurationUnit
     *
     * @return Break Time Unit
     */
    @SerializedName( "BreakDurationUnit" )
    @JsonProperty( "BreakDurationUnit" )
    @Nullable
    @ODataField( odataName = "BreakDurationUnit" )
    private String breakDurationUnit;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BreakDurationUnitISOCode</b>
     * </p>
     *
     * @param breakDurationUnitISOCode
     *
     * @return ISO Code
     */
    @SerializedName( "BreakDurationUnitISOCode" )
    @JsonProperty( "BreakDurationUnitISOCode" )
    @Nullable
    @ODataField( odataName = "BreakDurationUnitISOCode" )
    private String breakDurationUnitISOCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BreakDurationUnitSAPCode</b>
     * </p>
     *
     * @param breakDurationUnitSAPCode
     *
     * @return Internal SAP Code
     */
    @SerializedName( "BreakDurationUnitSAPCode" )
    @JsonProperty( "BreakDurationUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "BreakDurationUnitSAPCode" )
    private String breakDurationUnitSAPCode;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>BusinessProcessConfirmedQty</b>
     * </p>
     *
     * @param businessProcessConfirmedQty
     *
     * @return Process Quantity
     */
    @SerializedName( "BusinessProcessConfirmedQty" )
    @JsonProperty( "BusinessProcessConfirmedQty" )
    @Nullable
    @ODataField( odataName = "BusinessProcessConfirmedQty" )
    private BigDecimal businessProcessConfirmedQty;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BusinessProcessEntryUnit</b>
     * </p>
     *
     * @param businessProcessEntryUnit
     *
     * @return Process Unit
     */
    @SerializedName( "BusinessProcessEntryUnit" )
    @JsonProperty( "BusinessProcessEntryUnit" )
    @Nullable
    @ODataField( odataName = "BusinessProcessEntryUnit" )
    private String businessProcessEntryUnit;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BusProcessEntrUnitISOCode</b>
     * </p>
     *
     * @param busProcessEntrUnitISOCode
     *
     * @return ISO Code
     */
    @SerializedName( "BusProcessEntrUnitISOCode" )
    @JsonProperty( "BusProcessEntrUnitISOCode" )
    @Nullable
    @ODataField( odataName = "BusProcessEntrUnitISOCode" )
    private String busProcessEntrUnitISOCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BusProcessEntryUnitSAPCode</b>
     * </p>
     *
     * @param busProcessEntryUnitSAPCode
     *
     * @return Internal SAP Code
     */
    @SerializedName( "BusProcessEntryUnitSAPCode" )
    @JsonProperty( "BusProcessEntryUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "BusProcessEntryUnitSAPCode" )
    private String busProcessEntryUnitSAPCode;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationCount</b>
     * </p>
     *
     * @param confirmationCount
     *
     * @return Order Confirmation
     */
    @SerializedName( "ConfirmationCount" )
    @JsonProperty( "ConfirmationCount" )
    @Nullable
    @ODataField( odataName = "ConfirmationCount" )
    private String confirmationCount;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationEntryDate</b>
     * </p>
     *
     * @param confirmationEntryDate
     *
     * @return Entry Date
     */
    @SerializedName( "ConfirmationEntryDate" )
    @JsonProperty( "ConfirmationEntryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmationEntryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmationEntryDate;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationEntryTime</b>
     * </p>
     *
     * @param confirmationEntryTime
     *
     * @return Entry Time
     */
    @SerializedName( "ConfirmationEntryTime" )
    @JsonProperty( "ConfirmationEntryTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmationEntryTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmationEntryTime;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationExternalEntryDate</b>
     * </p>
     *
     * @param confirmationExternalEntryDate
     *
     * @return Created on
     */
    @SerializedName( "ConfirmationExternalEntryDate" )
    @JsonProperty( "ConfirmationExternalEntryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmationExternalEntryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmationExternalEntryDate;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationExternalEntryTime</b>
     * </p>
     *
     * @param confirmationExternalEntryTime
     *
     * @return Time
     */
    @SerializedName( "ConfirmationExternalEntryTime" )
    @JsonProperty( "ConfirmationExternalEntryTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmationExternalEntryTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmationExternalEntryTime;
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationGroup</b>
     * </p>
     *
     * @param confirmationGroup
     *
     * @return Confirmation Group
     */
    @SerializedName( "ConfirmationGroup" )
    @JsonProperty( "ConfirmationGroup" )
    @Nullable
    @ODataField( odataName = "ConfirmationGroup" )
    private String confirmationGroup;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationScrapQuantity</b>
     * </p>
     *
     * @param confirmationScrapQuantity
     *
     * @return Scrap Quantity
     */
    @SerializedName( "ConfirmationScrapQuantity" )
    @JsonProperty( "ConfirmationScrapQuantity" )
    @Nullable
    @ODataField( odataName = "ConfirmationScrapQuantity" )
    private BigDecimal confirmationScrapQuantity;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationText</b>
     * </p>
     *
     * @param confirmationText
     *
     * @return Confirmation Text
     */
    @SerializedName( "ConfirmationText" )
    @JsonProperty( "ConfirmationText" )
    @Nullable
    @ODataField( odataName = "ConfirmationText" )
    private String confirmationText;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationUnit</b>
     * </p>
     *
     * @param confirmationUnit
     *
     * @return Confirmation Unit
     */
    @SerializedName( "ConfirmationUnit" )
    @JsonProperty( "ConfirmationUnit" )
    @Nullable
    @ODataField( odataName = "ConfirmationUnit" )
    private String confirmationUnit;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationUnitISOCode</b>
     * </p>
     *
     * @param confirmationUnitISOCode
     *
     * @return ISO Code
     */
    @SerializedName( "ConfirmationUnitISOCode" )
    @JsonProperty( "ConfirmationUnitISOCode" )
    @Nullable
    @ODataField( odataName = "ConfirmationUnitISOCode" )
    private String confirmationUnitISOCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationUnitSAPCode</b>
     * </p>
     *
     * @param confirmationUnitSAPCode
     *
     * @return Internal SAP Code
     */
    @SerializedName( "ConfirmationUnitSAPCode" )
    @JsonProperty( "ConfirmationUnitSAPCode" )
    @Nullable
    @ODataField( odataName = "ConfirmationUnitSAPCode" )
    private String confirmationUnitSAPCode;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationYieldQuantity</b>
     * </p>
     *
     * @param confirmationYieldQuantity
     *
     * @return Yield Quantity
     */
    @SerializedName( "ConfirmationYieldQuantity" )
    @JsonProperty( "ConfirmationYieldQuantity" )
    @Nullable
    @ODataField( odataName = "ConfirmationYieldQuantity" )
    private BigDecimal confirmationYieldQuantity;
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedBreakDuration</b>
     * </p>
     *
     * @param confirmedBreakDuration
     *
     * @return Confirmed Break Time
     */
    @SerializedName( "ConfirmedBreakDuration" )
    @JsonProperty( "ConfirmedBreakDuration" )
    @Nullable
    @ODataField( odataName = "ConfirmedBreakDuration" )
    private BigDecimal confirmedBreakDuration;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedExecutionEndDate</b>
     * </p>
     *
     * @param confirmedExecutionEndDate
     *
     * @return Confirmed Execution End Date
     */
    @SerializedName( "ConfirmedExecutionEndDate" )
    @JsonProperty( "ConfirmedExecutionEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedExecutionEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmedExecutionEndDate;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedExecutionEndTime</b>
     * </p>
     *
     * @param confirmedExecutionEndTime
     *
     * @return Confirmed Execution End Time
     */
    @SerializedName( "ConfirmedExecutionEndTime" )
    @JsonProperty( "ConfirmedExecutionEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedExecutionEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmedExecutionEndTime;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedExecutionStartDate</b>
     * </p>
     *
     * @param confirmedExecutionStartDate
     *
     * @return Confirmed Execution Start Date
     */
    @SerializedName( "ConfirmedExecutionStartDate" )
    @JsonProperty( "ConfirmedExecutionStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedExecutionStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmedExecutionStartDate;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedExecutionStartTime</b>
     * </p>
     *
     * @param confirmedExecutionStartTime
     *
     * @return Confirmed Execution Start Time
     */
    @SerializedName( "ConfirmedExecutionStartTime" )
    @JsonProperty( "ConfirmedExecutionStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedExecutionStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmedExecutionStartTime;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedProcessingEndDate</b>
     * </p>
     *
     * @param confirmedProcessingEndDate
     *
     * @return Confirmed Processing End Date
     */
    @SerializedName( "ConfirmedProcessingEndDate" )
    @JsonProperty( "ConfirmedProcessingEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedProcessingEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmedProcessingEndDate;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedProcessingEndTime</b>
     * </p>
     *
     * @param confirmedProcessingEndTime
     *
     * @return Confirmed Processing End Time
     */
    @SerializedName( "ConfirmedProcessingEndTime" )
    @JsonProperty( "ConfirmedProcessingEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedProcessingEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmedProcessingEndTime;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedProcessingStartDate</b>
     * </p>
     *
     * @param confirmedProcessingStartDate
     *
     * @return Confirmed Processing Start Date
     */
    @SerializedName( "ConfirmedProcessingStartDate" )
    @JsonProperty( "ConfirmedProcessingStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedProcessingStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmedProcessingStartDate;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedProcessingStartTime</b>
     * </p>
     *
     * @param confirmedProcessingStartTime
     *
     * @return Confirmed Processing Start Time
     */
    @SerializedName( "ConfirmedProcessingStartTime" )
    @JsonProperty( "ConfirmedProcessingStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedProcessingStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmedProcessingStartTime;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedSetupEndDate</b>
     * </p>
     *
     * @param confirmedSetupEndDate
     *
     * @return Confirmed Setup End Date
     */
    @SerializedName( "ConfirmedSetupEndDate" )
    @JsonProperty( "ConfirmedSetupEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedSetupEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmedSetupEndDate;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedSetupEndTime</b>
     * </p>
     *
     * @param confirmedSetupEndTime
     *
     * @return Confirmed Setup End Time
     */
    @SerializedName( "ConfirmedSetupEndTime" )
    @JsonProperty( "ConfirmedSetupEndTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedSetupEndTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmedSetupEndTime;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedTeardownStartDate</b>
     * </p>
     *
     * @param confirmedTeardownStartDate
     *
     * @return Confirmed Teardown Start Date
     */
    @SerializedName( "ConfirmedTeardownStartDate" )
    @JsonProperty( "ConfirmedTeardownStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedTeardownStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmedTeardownStartDate;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedTeardownStartTime</b>
     * </p>
     *
     * @param confirmedTeardownStartTime
     *
     * @return Confirmed Teardown Start Time
     */
    @SerializedName( "ConfirmedTeardownStartTime" )
    @JsonProperty( "ConfirmedTeardownStartTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedTeardownStartTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime confirmedTeardownStartTime;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>EmployeeSuitability</b>
     * </p>
     *
     * @param employeeSuitability
     *
     * @return Employee Suitability
     */
    @SerializedName( "EmployeeSuitability" )
    @JsonProperty( "EmployeeSuitability" )
    @Nullable
    @ODataField( odataName = "EmployeeSuitability" )
    private String employeeSuitability;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>EmployeeWageGroup</b>
     * </p>
     *
     * @param employeeWageGroup
     *
     * @return Employee Wage Group
     */
    @SerializedName( "EmployeeWageGroup" )
    @JsonProperty( "EmployeeWageGroup" )
    @Nullable
    @ODataField( odataName = "EmployeeWageGroup" )
    private String employeeWageGroup;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>EmployeeWageType</b>
     * </p>
     *
     * @param employeeWageType
     *
     * @return Employee Wage Type
     */
    @SerializedName( "EmployeeWageType" )
    @JsonProperty( "EmployeeWageType" )
    @Nullable
    @ODataField( odataName = "EmployeeWageType" )
    private String employeeWageType;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>EnteredByExternalUser</b>
     * </p>
     *
     * @param enteredByExternalUser
     *
     * @return Created by
     */
    @SerializedName( "EnteredByExternalUser" )
    @JsonProperty( "EnteredByExternalUser" )
    @Nullable
    @ODataField( odataName = "EnteredByExternalUser" )
    private String enteredByExternalUser;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>EnteredByUser</b>
     * </p>
     *
     * @param enteredByUser
     *
     * @return Entered by User
     */
    @SerializedName( "EnteredByUser" )
    @JsonProperty( "EnteredByUser" )
    @Nullable
    @ODataField( odataName = "EnteredByUser" )
    private String enteredByUser;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>ExternalSystemConfirmation</b>
     * </p>
     *
     * @param externalSystemConfirmation
     *
     * @return External Key
     */
    @SerializedName( "ExternalSystemConfirmation" )
    @JsonProperty( "ExternalSystemConfirmation" )
    @Nullable
    @ODataField( odataName = "ExternalSystemConfirmation" )
    private UUID externalSystemConfirmation;
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>FinalConfirmationType</b>
     * </p>
     *
     * @param finalConfirmationType
     *
     * @return Final Confirmation Type
     */
    @SerializedName( "FinalConfirmationType" )
    @JsonProperty( "FinalConfirmationType" )
    @Nullable
    @ODataField( odataName = "FinalConfirmationType" )
    private String finalConfirmationType;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsFinalConfirmation</b>
     * </p>
     *
     * @param isFinalConfirmation
     *
     * @return Final Confirmation
     */
    @SerializedName( "IsFinalConfirmation" )
    @JsonProperty( "IsFinalConfirmation" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsFinalConfirmation" )
    private Boolean isFinalConfirmation;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsReversal</b>
     * </p>
     *
     * @param isReversal
     *
     * @return Is a Cancellation
     */
    @SerializedName( "IsReversal" )
    @JsonProperty( "IsReversal" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsReversal" )
    private Boolean isReversal;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsReversed</b>
     * </p>
     *
     * @param isReversed
     *
     * @return Reversed
     */
    @SerializedName( "IsReversed" )
    @JsonProperty( "IsReversed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsReversed" )
    private Boolean isReversed;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *
     * @return Language Key
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *
     * @return Last Change
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *
     * @return Changed By
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *
     * @return Material
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>NoFurtherBusinessProcQtyIsExpd</b>
     * </p>
     *
     * @param noFurtherBusinessProcQtyIsExpd
     *
     * @return No Remaining Act.
     */
    @SerializedName( "NoFurtherBusinessProcQtyIsExpd" )
    @JsonProperty( "NoFurtherBusinessProcQtyIsExpd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NoFurtherBusinessProcQtyIsExpd" )
    private Boolean noFurtherBusinessProcQtyIsExpd;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>NoFurtherOpWorkQuantity1IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity1IsExpd
     *
     * @return No Remaining Work Quantity 1 Expected
     */
    @SerializedName( "NoFurtherOpWorkQuantity1IsExpd" )
    @JsonProperty( "NoFurtherOpWorkQuantity1IsExpd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NoFurtherOpWorkQuantity1IsExpd" )
    private Boolean noFurtherOpWorkQuantity1IsExpd;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>NoFurtherOpWorkQuantity2IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity2IsExpd
     *
     * @return No Remaining Work Quantity 2 Expected
     */
    @SerializedName( "NoFurtherOpWorkQuantity2IsExpd" )
    @JsonProperty( "NoFurtherOpWorkQuantity2IsExpd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NoFurtherOpWorkQuantity2IsExpd" )
    private Boolean noFurtherOpWorkQuantity2IsExpd;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>NoFurtherOpWorkQuantity3IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity3IsExpd
     *
     * @return No Remaining Work Quantity 3 Expected
     */
    @SerializedName( "NoFurtherOpWorkQuantity3IsExpd" )
    @JsonProperty( "NoFurtherOpWorkQuantity3IsExpd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NoFurtherOpWorkQuantity3IsExpd" )
    private Boolean noFurtherOpWorkQuantity3IsExpd;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>NoFurtherOpWorkQuantity4IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity4IsExpd
     *
     * @return No Remaining Work Quantity 4 Expected
     */
    @SerializedName( "NoFurtherOpWorkQuantity4IsExpd" )
    @JsonProperty( "NoFurtherOpWorkQuantity4IsExpd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NoFurtherOpWorkQuantity4IsExpd" )
    private Boolean noFurtherOpWorkQuantity4IsExpd;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>NoFurtherOpWorkQuantity5IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity5IsExpd
     *
     * @return No Remaining Work Quantity 5 Expected
     */
    @SerializedName( "NoFurtherOpWorkQuantity5IsExpd" )
    @JsonProperty( "NoFurtherOpWorkQuantity5IsExpd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NoFurtherOpWorkQuantity5IsExpd" )
    private Boolean noFurtherOpWorkQuantity5IsExpd;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>NoFurtherOpWorkQuantity6IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity6IsExpd
     *
     * @return No Remaining Work Quantity 6 Expected
     */
    @SerializedName( "NoFurtherOpWorkQuantity6IsExpd" )
    @JsonProperty( "NoFurtherOpWorkQuantity6IsExpd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "NoFurtherOpWorkQuantity6IsExpd" )
    private Boolean noFurtherOpWorkQuantity6IsExpd;
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>NumberOfEmployees</b>
     * </p>
     *
     * @param numberOfEmployees
     *
     * @return Number of Employees
     */
    @SerializedName( "NumberOfEmployees" )
    @JsonProperty( "NumberOfEmployees" )
    @Nullable
    @ODataField( odataName = "NumberOfEmployees" )
    private BigDecimal numberOfEmployees;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>OpConfirmedWorkQuantity1</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity1
     *
     * @return Confirmed Work Quantity 1
     */
    @SerializedName( "OpConfirmedWorkQuantity1" )
    @JsonProperty( "OpConfirmedWorkQuantity1" )
    @Nullable
    @ODataField( odataName = "OpConfirmedWorkQuantity1" )
    private BigDecimal opConfirmedWorkQuantity1;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>OpConfirmedWorkQuantity2</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity2
     *
     * @return Confirmed Work Quantity 2
     */
    @SerializedName( "OpConfirmedWorkQuantity2" )
    @JsonProperty( "OpConfirmedWorkQuantity2" )
    @Nullable
    @ODataField( odataName = "OpConfirmedWorkQuantity2" )
    private BigDecimal opConfirmedWorkQuantity2;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>OpConfirmedWorkQuantity3</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity3
     *
     * @return Confirmed Work Quantity 3
     */
    @SerializedName( "OpConfirmedWorkQuantity3" )
    @JsonProperty( "OpConfirmedWorkQuantity3" )
    @Nullable
    @ODataField( odataName = "OpConfirmedWorkQuantity3" )
    private BigDecimal opConfirmedWorkQuantity3;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>OpConfirmedWorkQuantity4</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity4
     *
     * @return Confirmed Work Quantity 4
     */
    @SerializedName( "OpConfirmedWorkQuantity4" )
    @JsonProperty( "OpConfirmedWorkQuantity4" )
    @Nullable
    @ODataField( odataName = "OpConfirmedWorkQuantity4" )
    private BigDecimal opConfirmedWorkQuantity4;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>OpConfirmedWorkQuantity5</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity5
     *
     * @return Confirmed Work Quantity 5
     */
    @SerializedName( "OpConfirmedWorkQuantity5" )
    @JsonProperty( "OpConfirmedWorkQuantity5" )
    @Nullable
    @ODataField( odataName = "OpConfirmedWorkQuantity5" )
    private BigDecimal opConfirmedWorkQuantity5;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>OpConfirmedWorkQuantity6</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity6
     *
     * @return Confirmed Work Quantity 6
     */
    @SerializedName( "OpConfirmedWorkQuantity6" )
    @JsonProperty( "OpConfirmedWorkQuantity6" )
    @Nullable
    @ODataField( odataName = "OpConfirmedWorkQuantity6" )
    private BigDecimal opConfirmedWorkQuantity6;
    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>OpenReservationsIsCleared</b>
     * </p>
     *
     * @param openReservationsIsCleared
     *
     * @return Clear Open Reservs.
     */
    @SerializedName( "OpenReservationsIsCleared" )
    @JsonProperty( "OpenReservationsIsCleared" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "OpenReservationsIsCleared" )
    private Boolean openReservationsIsCleared;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OpWorkQuantityUnit1</b>
     * </p>
     *
     * @param opWorkQuantityUnit1
     *
     * @return Confirmed Work Quantity Unit 1
     */
    @SerializedName( "OpWorkQuantityUnit1" )
    @JsonProperty( "OpWorkQuantityUnit1" )
    @Nullable
    @ODataField( odataName = "OpWorkQuantityUnit1" )
    private String opWorkQuantityUnit1;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OpWorkQuantityUnit2</b>
     * </p>
     *
     * @param opWorkQuantityUnit2
     *
     * @return Confirmed Work Quantity Unit 2
     */
    @SerializedName( "OpWorkQuantityUnit2" )
    @JsonProperty( "OpWorkQuantityUnit2" )
    @Nullable
    @ODataField( odataName = "OpWorkQuantityUnit2" )
    private String opWorkQuantityUnit2;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OpWorkQuantityUnit3</b>
     * </p>
     *
     * @param opWorkQuantityUnit3
     *
     * @return Confirmed Work Quantity Unit 3
     */
    @SerializedName( "OpWorkQuantityUnit3" )
    @JsonProperty( "OpWorkQuantityUnit3" )
    @Nullable
    @ODataField( odataName = "OpWorkQuantityUnit3" )
    private String opWorkQuantityUnit3;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OpWorkQuantityUnit4</b>
     * </p>
     *
     * @param opWorkQuantityUnit4
     *
     * @return Confirmed Work Quantity Unit 4
     */
    @SerializedName( "OpWorkQuantityUnit4" )
    @JsonProperty( "OpWorkQuantityUnit4" )
    @Nullable
    @ODataField( odataName = "OpWorkQuantityUnit4" )
    private String opWorkQuantityUnit4;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OpWorkQuantityUnit5</b>
     * </p>
     *
     * @param opWorkQuantityUnit5
     *
     * @return Confirmed Work Quantity Unit 5
     */
    @SerializedName( "OpWorkQuantityUnit5" )
    @JsonProperty( "OpWorkQuantityUnit5" )
    @Nullable
    @ODataField( odataName = "OpWorkQuantityUnit5" )
    private String opWorkQuantityUnit5;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OpWorkQuantityUnit6</b>
     * </p>
     *
     * @param opWorkQuantityUnit6
     *
     * @return Confirmed Work Quantity Unit 6
     */
    @SerializedName( "OpWorkQuantityUnit6" )
    @JsonProperty( "OpWorkQuantityUnit6" )
    @Nullable
    @ODataField( odataName = "OpWorkQuantityUnit6" )
    private String opWorkQuantityUnit6;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OrderConfirmationRecordType</b>
     * </p>
     *
     * @param orderConfirmationRecordType
     *
     * @return Record Type
     */
    @SerializedName( "OrderConfirmationRecordType" )
    @JsonProperty( "OrderConfirmationRecordType" )
    @Nullable
    @ODataField( odataName = "OrderConfirmationRecordType" )
    private String orderConfirmationRecordType;
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *
     * @return Manufacturing Order
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>OrderOperation</b>
     * </p>
     *
     * @param orderOperation
     *
     * @return Operation
     */
    @SerializedName( "OrderOperation" )
    @JsonProperty( "OrderOperation" )
    @Nullable
    @ODataField( odataName = "OrderOperation" )
    private String orderOperation;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>OrderOperationInternalID</b>
     * </p>
     *
     * @param orderOperationInternalID
     *
     * @return Operation Internal ID
     */
    @SerializedName( "OrderOperationInternalID" )
    @JsonProperty( "OrderOperationInternalID" )
    @Nullable
    @ODataField( odataName = "OrderOperationInternalID" )
    private String orderOperationInternalID;
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>OrderPlannedTotalQty</b>
     * </p>
     *
     * @param orderPlannedTotalQty
     *
     * @return Total Quantity
     */
    @SerializedName( "OrderPlannedTotalQty" )
    @JsonProperty( "OrderPlannedTotalQty" )
    @Nullable
    @ODataField( odataName = "OrderPlannedTotalQty" )
    private BigDecimal orderPlannedTotalQty;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>OrderSuboperation</b>
     * </p>
     *
     * @param orderSuboperation
     *
     * @return Suboperation
     */
    @SerializedName( "OrderSuboperation" )
    @JsonProperty( "OrderSuboperation" )
    @Nullable
    @ODataField( odataName = "OrderSuboperation" )
    private String orderSuboperation;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>OrderType</b>
     * </p>
     *
     * @param orderType
     *
     * @return Order Type
     */
    @SerializedName( "OrderType" )
    @JsonProperty( "OrderType" )
    @Nullable
    @ODataField( odataName = "OrderType" )
    private String orderType;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @param personnel
     *
     * @return Personnel
     */
    @SerializedName( "Personnel" )
    @JsonProperty( "Personnel" )
    @Nullable
    @ODataField( odataName = "Personnel" )
    private String personnel;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *
     * @return Posting Date
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>ProductionUnit</b>
     * </p>
     *
     * @param productionUnit
     *
     * @return Production Unit
     */
    @SerializedName( "ProductionUnit" )
    @JsonProperty( "ProductionUnit" )
    @Nullable
    @ODataField( odataName = "ProductionUnit" )
    private String productionUnit;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>ShiftDefinition</b>
     * </p>
     *
     * @param shiftDefinition
     *
     * @return Shift Definition
     */
    @SerializedName( "ShiftDefinition" )
    @JsonProperty( "ShiftDefinition" )
    @Nullable
    @ODataField( odataName = "ShiftDefinition" )
    private String shiftDefinition;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>ShiftGrouping</b>
     * </p>
     *
     * @param shiftGrouping
     *
     * @return Shift Grouping
     */
    @SerializedName( "ShiftGrouping" )
    @JsonProperty( "ShiftGrouping" )
    @Nullable
    @ODataField( odataName = "ShiftGrouping" )
    private String shiftGrouping;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>TimeRecording</b>
     * </p>
     *
     * @param timeRecording
     *
     * @return Time Recording
     */
    @SerializedName( "TimeRecording" )
    @JsonProperty( "TimeRecording" )
    @Nullable
    @ODataField( odataName = "TimeRecording" )
    private String timeRecording;
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>VarianceReasonCode</b>
     * </p>
     *
     * @param varianceReasonCode
     *
     * @return Variance Reason
     */
    @SerializedName( "VarianceReasonCode" )
    @JsonProperty( "VarianceReasonCode" )
    @Nullable
    @ODataField( odataName = "VarianceReasonCode" )
    private String varianceReasonCode;
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *
     * @return Work Center
     */
    @SerializedName( "WorkCenter" )
    @JsonProperty( "WorkCenter" )
    @Nullable
    @ODataField( odataName = "WorkCenter" )
    private String workCenter;
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *
     * @return Resource Object Type
     */
    @SerializedName( "WorkCenterTypeCode" )
    @JsonProperty( "WorkCenterTypeCode" )
    @Nullable
    @ODataField( odataName = "WorkCenterTypeCode" )
    private String workCenterTypeCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit1ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit1ISOCode
     *
     * @return ISO Code
     */
    @SerializedName( "WorkQuantityUnit1ISOCode" )
    @JsonProperty( "WorkQuantityUnit1ISOCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit1ISOCode" )
    private String workQuantityUnit1ISOCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit1SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit1SAPCode
     *
     * @return Internal SAP Code
     */
    @SerializedName( "WorkQuantityUnit1SAPCode" )
    @JsonProperty( "WorkQuantityUnit1SAPCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit1SAPCode" )
    private String workQuantityUnit1SAPCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit2ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit2ISOCode
     *
     * @return ISO Code
     */
    @SerializedName( "WorkQuantityUnit2ISOCode" )
    @JsonProperty( "WorkQuantityUnit2ISOCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit2ISOCode" )
    private String workQuantityUnit2ISOCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit2SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit2SAPCode
     *
     * @return Internal SAP Code
     */
    @SerializedName( "WorkQuantityUnit2SAPCode" )
    @JsonProperty( "WorkQuantityUnit2SAPCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit2SAPCode" )
    private String workQuantityUnit2SAPCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit3ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit3ISOCode
     *
     * @return ISO Code
     */
    @SerializedName( "WorkQuantityUnit3ISOCode" )
    @JsonProperty( "WorkQuantityUnit3ISOCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit3ISOCode" )
    private String workQuantityUnit3ISOCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit3SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit3SAPCode
     *
     * @return Internal SAP Code
     */
    @SerializedName( "WorkQuantityUnit3SAPCode" )
    @JsonProperty( "WorkQuantityUnit3SAPCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit3SAPCode" )
    private String workQuantityUnit3SAPCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit4ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit4ISOCode
     *
     * @return ISO Code
     */
    @SerializedName( "WorkQuantityUnit4ISOCode" )
    @JsonProperty( "WorkQuantityUnit4ISOCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit4ISOCode" )
    private String workQuantityUnit4ISOCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit4SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit4SAPCode
     *
     * @return Internal SAP Code
     */
    @SerializedName( "WorkQuantityUnit4SAPCode" )
    @JsonProperty( "WorkQuantityUnit4SAPCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit4SAPCode" )
    private String workQuantityUnit4SAPCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit5ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit5ISOCode
     *
     * @return ISO Code
     */
    @SerializedName( "WorkQuantityUnit5ISOCode" )
    @JsonProperty( "WorkQuantityUnit5ISOCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit5ISOCode" )
    private String workQuantityUnit5ISOCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit5SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit5SAPCode
     *
     * @return Internal SAP Code
     */
    @SerializedName( "WorkQuantityUnit5SAPCode" )
    @JsonProperty( "WorkQuantityUnit5SAPCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit5SAPCode" )
    private String workQuantityUnit5SAPCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit6ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit6ISOCode
     *
     * @return ISO Code
     */
    @SerializedName( "WorkQuantityUnit6ISOCode" )
    @JsonProperty( "WorkQuantityUnit6ISOCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit6ISOCode" )
    private String workQuantityUnit6ISOCode;
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit6SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit6SAPCode
     *
     * @return Internal SAP Code
     */
    @SerializedName( "WorkQuantityUnit6SAPCode" )
    @JsonProperty( "WorkQuantityUnit6SAPCode" )
    @Nullable
    @ODataField( odataName = "WorkQuantityUnit6SAPCode" )
    private String workQuantityUnit6SAPCode;

    @Nonnull
    @Override
    public Class<AProcordconfirmation2> getType()
    {
        return AProcordconfirmation2.class;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("APIConfHasNoGoodsMovements", getAPIConfHasNoGoodsMovements());
        values.put("BreakDurationUnit", getBreakDurationUnit());
        values.put("BreakDurationUnitISOCode", getBreakDurationUnitISOCode());
        values.put("BreakDurationUnitSAPCode", getBreakDurationUnitSAPCode());
        values.put("BusinessProcessConfirmedQty", getBusinessProcessConfirmedQty());
        values.put("BusinessProcessEntryUnit", getBusinessProcessEntryUnit());
        values.put("BusProcessEntrUnitISOCode", getBusProcessEntrUnitISOCode());
        values.put("BusProcessEntryUnitSAPCode", getBusProcessEntryUnitSAPCode());
        values.put("ConfirmationCount", getConfirmationCount());
        values.put("ConfirmationEntryDate", getConfirmationEntryDate());
        values.put("ConfirmationEntryTime", getConfirmationEntryTime());
        values.put("ConfirmationExternalEntryDate", getConfirmationExternalEntryDate());
        values.put("ConfirmationExternalEntryTime", getConfirmationExternalEntryTime());
        values.put("ConfirmationGroup", getConfirmationGroup());
        values.put("ConfirmationScrapQuantity", getConfirmationScrapQuantity());
        values.put("ConfirmationText", getConfirmationText());
        values.put("ConfirmationUnit", getConfirmationUnit());
        values.put("ConfirmationUnitISOCode", getConfirmationUnitISOCode());
        values.put("ConfirmationUnitSAPCode", getConfirmationUnitSAPCode());
        values.put("ConfirmationYieldQuantity", getConfirmationYieldQuantity());
        values.put("ConfirmedBreakDuration", getConfirmedBreakDuration());
        values.put("ConfirmedExecutionEndDate", getConfirmedExecutionEndDate());
        values.put("ConfirmedExecutionEndTime", getConfirmedExecutionEndTime());
        values.put("ConfirmedExecutionStartDate", getConfirmedExecutionStartDate());
        values.put("ConfirmedExecutionStartTime", getConfirmedExecutionStartTime());
        values.put("ConfirmedProcessingEndDate", getConfirmedProcessingEndDate());
        values.put("ConfirmedProcessingEndTime", getConfirmedProcessingEndTime());
        values.put("ConfirmedProcessingStartDate", getConfirmedProcessingStartDate());
        values.put("ConfirmedProcessingStartTime", getConfirmedProcessingStartTime());
        values.put("ConfirmedSetupEndDate", getConfirmedSetupEndDate());
        values.put("ConfirmedSetupEndTime", getConfirmedSetupEndTime());
        values.put("ConfirmedTeardownStartDate", getConfirmedTeardownStartDate());
        values.put("ConfirmedTeardownStartTime", getConfirmedTeardownStartTime());
        values.put("EmployeeSuitability", getEmployeeSuitability());
        values.put("EmployeeWageGroup", getEmployeeWageGroup());
        values.put("EmployeeWageType", getEmployeeWageType());
        values.put("EnteredByExternalUser", getEnteredByExternalUser());
        values.put("EnteredByUser", getEnteredByUser());
        values.put("ExternalSystemConfirmation", getExternalSystemConfirmation());
        values.put("FinalConfirmationType", getFinalConfirmationType());
        values.put("IsFinalConfirmation", getIsFinalConfirmation());
        values.put("IsReversal", getIsReversal());
        values.put("IsReversed", getIsReversed());
        values.put("Language", getLanguage());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("Material", getMaterial());
        values.put("NoFurtherBusinessProcQtyIsExpd", getNoFurtherBusinessProcQtyIsExpd());
        values.put("NoFurtherOpWorkQuantity1IsExpd", getNoFurtherOpWorkQuantity1IsExpd());
        values.put("NoFurtherOpWorkQuantity2IsExpd", getNoFurtherOpWorkQuantity2IsExpd());
        values.put("NoFurtherOpWorkQuantity3IsExpd", getNoFurtherOpWorkQuantity3IsExpd());
        values.put("NoFurtherOpWorkQuantity4IsExpd", getNoFurtherOpWorkQuantity4IsExpd());
        values.put("NoFurtherOpWorkQuantity5IsExpd", getNoFurtherOpWorkQuantity5IsExpd());
        values.put("NoFurtherOpWorkQuantity6IsExpd", getNoFurtherOpWorkQuantity6IsExpd());
        values.put("NumberOfEmployees", getNumberOfEmployees());
        values.put("OpConfirmedWorkQuantity1", getOpConfirmedWorkQuantity1());
        values.put("OpConfirmedWorkQuantity2", getOpConfirmedWorkQuantity2());
        values.put("OpConfirmedWorkQuantity3", getOpConfirmedWorkQuantity3());
        values.put("OpConfirmedWorkQuantity4", getOpConfirmedWorkQuantity4());
        values.put("OpConfirmedWorkQuantity5", getOpConfirmedWorkQuantity5());
        values.put("OpConfirmedWorkQuantity6", getOpConfirmedWorkQuantity6());
        values.put("OpenReservationsIsCleared", getOpenReservationsIsCleared());
        values.put("OpWorkQuantityUnit1", getOpWorkQuantityUnit1());
        values.put("OpWorkQuantityUnit2", getOpWorkQuantityUnit2());
        values.put("OpWorkQuantityUnit3", getOpWorkQuantityUnit3());
        values.put("OpWorkQuantityUnit4", getOpWorkQuantityUnit4());
        values.put("OpWorkQuantityUnit5", getOpWorkQuantityUnit5());
        values.put("OpWorkQuantityUnit6", getOpWorkQuantityUnit6());
        values.put("OrderConfirmationRecordType", getOrderConfirmationRecordType());
        values.put("OrderID", getOrderID());
        values.put("OrderOperation", getOrderOperation());
        values.put("OrderOperationInternalID", getOrderOperationInternalID());
        values.put("OrderPlannedTotalQty", getOrderPlannedTotalQty());
        values.put("OrderSuboperation", getOrderSuboperation());
        values.put("OrderType", getOrderType());
        values.put("Personnel", getPersonnel());
        values.put("Plant", getPlant());
        values.put("PostingDate", getPostingDate());
        values.put("ProductionUnit", getProductionUnit());
        values.put("ShiftDefinition", getShiftDefinition());
        values.put("ShiftGrouping", getShiftGrouping());
        values.put("TimeRecording", getTimeRecording());
        values.put("VarianceReasonCode", getVarianceReasonCode());
        values.put("WorkCenter", getWorkCenter());
        values.put("WorkCenterTypeCode", getWorkCenterTypeCode());
        values.put("WorkQuantityUnit1ISOCode", getWorkQuantityUnit1ISOCode());
        values.put("WorkQuantityUnit1SAPCode", getWorkQuantityUnit1SAPCode());
        values.put("WorkQuantityUnit2ISOCode", getWorkQuantityUnit2ISOCode());
        values.put("WorkQuantityUnit2SAPCode", getWorkQuantityUnit2SAPCode());
        values.put("WorkQuantityUnit3ISOCode", getWorkQuantityUnit3ISOCode());
        values.put("WorkQuantityUnit3SAPCode", getWorkQuantityUnit3SAPCode());
        values.put("WorkQuantityUnit4ISOCode", getWorkQuantityUnit4ISOCode());
        values.put("WorkQuantityUnit4SAPCode", getWorkQuantityUnit4SAPCode());
        values.put("WorkQuantityUnit5ISOCode", getWorkQuantityUnit5ISOCode());
        values.put("WorkQuantityUnit5SAPCode", getWorkQuantityUnit5SAPCode());
        values.put("WorkQuantityUnit6ISOCode", getWorkQuantityUnit6ISOCode());
        values.put("WorkQuantityUnit6SAPCode", getWorkQuantityUnit6SAPCode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("APIConfHasNoGoodsMovements") ) {
                final Object value = values.remove("APIConfHasNoGoodsMovements");
                if( (value == null) || (!value.equals(getAPIConfHasNoGoodsMovements())) ) {
                    setAPIConfHasNoGoodsMovements(((Boolean) value));
                }
            }
            if( values.containsKey("BreakDurationUnit") ) {
                final Object value = values.remove("BreakDurationUnit");
                if( (value == null) || (!value.equals(getBreakDurationUnit())) ) {
                    setBreakDurationUnit(((String) value));
                }
            }
            if( values.containsKey("BreakDurationUnitISOCode") ) {
                final Object value = values.remove("BreakDurationUnitISOCode");
                if( (value == null) || (!value.equals(getBreakDurationUnitISOCode())) ) {
                    setBreakDurationUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("BreakDurationUnitSAPCode") ) {
                final Object value = values.remove("BreakDurationUnitSAPCode");
                if( (value == null) || (!value.equals(getBreakDurationUnitSAPCode())) ) {
                    setBreakDurationUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("BusinessProcessConfirmedQty") ) {
                final Object value = values.remove("BusinessProcessConfirmedQty");
                if( (value == null) || (!value.equals(getBusinessProcessConfirmedQty())) ) {
                    setBusinessProcessConfirmedQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("BusinessProcessEntryUnit") ) {
                final Object value = values.remove("BusinessProcessEntryUnit");
                if( (value == null) || (!value.equals(getBusinessProcessEntryUnit())) ) {
                    setBusinessProcessEntryUnit(((String) value));
                }
            }
            if( values.containsKey("BusProcessEntrUnitISOCode") ) {
                final Object value = values.remove("BusProcessEntrUnitISOCode");
                if( (value == null) || (!value.equals(getBusProcessEntrUnitISOCode())) ) {
                    setBusProcessEntrUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("BusProcessEntryUnitSAPCode") ) {
                final Object value = values.remove("BusProcessEntryUnitSAPCode");
                if( (value == null) || (!value.equals(getBusProcessEntryUnitSAPCode())) ) {
                    setBusProcessEntryUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("ConfirmationCount") ) {
                final Object value = values.remove("ConfirmationCount");
                if( (value == null) || (!value.equals(getConfirmationCount())) ) {
                    setConfirmationCount(((String) value));
                }
            }
            if( values.containsKey("ConfirmationEntryDate") ) {
                final Object value = values.remove("ConfirmationEntryDate");
                if( (value == null) || (!value.equals(getConfirmationEntryDate())) ) {
                    setConfirmationEntryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmationEntryTime") ) {
                final Object value = values.remove("ConfirmationEntryTime");
                if( (value == null) || (!value.equals(getConfirmationEntryTime())) ) {
                    setConfirmationEntryTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ConfirmationExternalEntryDate") ) {
                final Object value = values.remove("ConfirmationExternalEntryDate");
                if( (value == null) || (!value.equals(getConfirmationExternalEntryDate())) ) {
                    setConfirmationExternalEntryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmationExternalEntryTime") ) {
                final Object value = values.remove("ConfirmationExternalEntryTime");
                if( (value == null) || (!value.equals(getConfirmationExternalEntryTime())) ) {
                    setConfirmationExternalEntryTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ConfirmationGroup") ) {
                final Object value = values.remove("ConfirmationGroup");
                if( (value == null) || (!value.equals(getConfirmationGroup())) ) {
                    setConfirmationGroup(((String) value));
                }
            }
            if( values.containsKey("ConfirmationScrapQuantity") ) {
                final Object value = values.remove("ConfirmationScrapQuantity");
                if( (value == null) || (!value.equals(getConfirmationScrapQuantity())) ) {
                    setConfirmationScrapQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConfirmationText") ) {
                final Object value = values.remove("ConfirmationText");
                if( (value == null) || (!value.equals(getConfirmationText())) ) {
                    setConfirmationText(((String) value));
                }
            }
            if( values.containsKey("ConfirmationUnit") ) {
                final Object value = values.remove("ConfirmationUnit");
                if( (value == null) || (!value.equals(getConfirmationUnit())) ) {
                    setConfirmationUnit(((String) value));
                }
            }
            if( values.containsKey("ConfirmationUnitISOCode") ) {
                final Object value = values.remove("ConfirmationUnitISOCode");
                if( (value == null) || (!value.equals(getConfirmationUnitISOCode())) ) {
                    setConfirmationUnitISOCode(((String) value));
                }
            }
            if( values.containsKey("ConfirmationUnitSAPCode") ) {
                final Object value = values.remove("ConfirmationUnitSAPCode");
                if( (value == null) || (!value.equals(getConfirmationUnitSAPCode())) ) {
                    setConfirmationUnitSAPCode(((String) value));
                }
            }
            if( values.containsKey("ConfirmationYieldQuantity") ) {
                final Object value = values.remove("ConfirmationYieldQuantity");
                if( (value == null) || (!value.equals(getConfirmationYieldQuantity())) ) {
                    setConfirmationYieldQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConfirmedBreakDuration") ) {
                final Object value = values.remove("ConfirmedBreakDuration");
                if( (value == null) || (!value.equals(getConfirmedBreakDuration())) ) {
                    setConfirmedBreakDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConfirmedExecutionEndDate") ) {
                final Object value = values.remove("ConfirmedExecutionEndDate");
                if( (value == null) || (!value.equals(getConfirmedExecutionEndDate())) ) {
                    setConfirmedExecutionEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmedExecutionEndTime") ) {
                final Object value = values.remove("ConfirmedExecutionEndTime");
                if( (value == null) || (!value.equals(getConfirmedExecutionEndTime())) ) {
                    setConfirmedExecutionEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ConfirmedExecutionStartDate") ) {
                final Object value = values.remove("ConfirmedExecutionStartDate");
                if( (value == null) || (!value.equals(getConfirmedExecutionStartDate())) ) {
                    setConfirmedExecutionStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmedExecutionStartTime") ) {
                final Object value = values.remove("ConfirmedExecutionStartTime");
                if( (value == null) || (!value.equals(getConfirmedExecutionStartTime())) ) {
                    setConfirmedExecutionStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ConfirmedProcessingEndDate") ) {
                final Object value = values.remove("ConfirmedProcessingEndDate");
                if( (value == null) || (!value.equals(getConfirmedProcessingEndDate())) ) {
                    setConfirmedProcessingEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmedProcessingEndTime") ) {
                final Object value = values.remove("ConfirmedProcessingEndTime");
                if( (value == null) || (!value.equals(getConfirmedProcessingEndTime())) ) {
                    setConfirmedProcessingEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ConfirmedProcessingStartDate") ) {
                final Object value = values.remove("ConfirmedProcessingStartDate");
                if( (value == null) || (!value.equals(getConfirmedProcessingStartDate())) ) {
                    setConfirmedProcessingStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmedProcessingStartTime") ) {
                final Object value = values.remove("ConfirmedProcessingStartTime");
                if( (value == null) || (!value.equals(getConfirmedProcessingStartTime())) ) {
                    setConfirmedProcessingStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ConfirmedSetupEndDate") ) {
                final Object value = values.remove("ConfirmedSetupEndDate");
                if( (value == null) || (!value.equals(getConfirmedSetupEndDate())) ) {
                    setConfirmedSetupEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmedSetupEndTime") ) {
                final Object value = values.remove("ConfirmedSetupEndTime");
                if( (value == null) || (!value.equals(getConfirmedSetupEndTime())) ) {
                    setConfirmedSetupEndTime(((LocalTime) value));
                }
            }
            if( values.containsKey("ConfirmedTeardownStartDate") ) {
                final Object value = values.remove("ConfirmedTeardownStartDate");
                if( (value == null) || (!value.equals(getConfirmedTeardownStartDate())) ) {
                    setConfirmedTeardownStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmedTeardownStartTime") ) {
                final Object value = values.remove("ConfirmedTeardownStartTime");
                if( (value == null) || (!value.equals(getConfirmedTeardownStartTime())) ) {
                    setConfirmedTeardownStartTime(((LocalTime) value));
                }
            }
            if( values.containsKey("EmployeeSuitability") ) {
                final Object value = values.remove("EmployeeSuitability");
                if( (value == null) || (!value.equals(getEmployeeSuitability())) ) {
                    setEmployeeSuitability(((String) value));
                }
            }
            if( values.containsKey("EmployeeWageGroup") ) {
                final Object value = values.remove("EmployeeWageGroup");
                if( (value == null) || (!value.equals(getEmployeeWageGroup())) ) {
                    setEmployeeWageGroup(((String) value));
                }
            }
            if( values.containsKey("EmployeeWageType") ) {
                final Object value = values.remove("EmployeeWageType");
                if( (value == null) || (!value.equals(getEmployeeWageType())) ) {
                    setEmployeeWageType(((String) value));
                }
            }
            if( values.containsKey("EnteredByExternalUser") ) {
                final Object value = values.remove("EnteredByExternalUser");
                if( (value == null) || (!value.equals(getEnteredByExternalUser())) ) {
                    setEnteredByExternalUser(((String) value));
                }
            }
            if( values.containsKey("EnteredByUser") ) {
                final Object value = values.remove("EnteredByUser");
                if( (value == null) || (!value.equals(getEnteredByUser())) ) {
                    setEnteredByUser(((String) value));
                }
            }
            if( values.containsKey("ExternalSystemConfirmation") ) {
                final Object value = values.remove("ExternalSystemConfirmation");
                if( (value == null) || (!value.equals(getExternalSystemConfirmation())) ) {
                    setExternalSystemConfirmation(((UUID) value));
                }
            }
            if( values.containsKey("FinalConfirmationType") ) {
                final Object value = values.remove("FinalConfirmationType");
                if( (value == null) || (!value.equals(getFinalConfirmationType())) ) {
                    setFinalConfirmationType(((String) value));
                }
            }
            if( values.containsKey("IsFinalConfirmation") ) {
                final Object value = values.remove("IsFinalConfirmation");
                if( (value == null) || (!value.equals(getIsFinalConfirmation())) ) {
                    setIsFinalConfirmation(((Boolean) value));
                }
            }
            if( values.containsKey("IsReversal") ) {
                final Object value = values.remove("IsReversal");
                if( (value == null) || (!value.equals(getIsReversal())) ) {
                    setIsReversal(((Boolean) value));
                }
            }
            if( values.containsKey("IsReversed") ) {
                final Object value = values.remove("IsReversed");
                if( (value == null) || (!value.equals(getIsReversed())) ) {
                    setIsReversed(((Boolean) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("NoFurtherBusinessProcQtyIsExpd") ) {
                final Object value = values.remove("NoFurtherBusinessProcQtyIsExpd");
                if( (value == null) || (!value.equals(getNoFurtherBusinessProcQtyIsExpd())) ) {
                    setNoFurtherBusinessProcQtyIsExpd(((Boolean) value));
                }
            }
            if( values.containsKey("NoFurtherOpWorkQuantity1IsExpd") ) {
                final Object value = values.remove("NoFurtherOpWorkQuantity1IsExpd");
                if( (value == null) || (!value.equals(getNoFurtherOpWorkQuantity1IsExpd())) ) {
                    setNoFurtherOpWorkQuantity1IsExpd(((Boolean) value));
                }
            }
            if( values.containsKey("NoFurtherOpWorkQuantity2IsExpd") ) {
                final Object value = values.remove("NoFurtherOpWorkQuantity2IsExpd");
                if( (value == null) || (!value.equals(getNoFurtherOpWorkQuantity2IsExpd())) ) {
                    setNoFurtherOpWorkQuantity2IsExpd(((Boolean) value));
                }
            }
            if( values.containsKey("NoFurtherOpWorkQuantity3IsExpd") ) {
                final Object value = values.remove("NoFurtherOpWorkQuantity3IsExpd");
                if( (value == null) || (!value.equals(getNoFurtherOpWorkQuantity3IsExpd())) ) {
                    setNoFurtherOpWorkQuantity3IsExpd(((Boolean) value));
                }
            }
            if( values.containsKey("NoFurtherOpWorkQuantity4IsExpd") ) {
                final Object value = values.remove("NoFurtherOpWorkQuantity4IsExpd");
                if( (value == null) || (!value.equals(getNoFurtherOpWorkQuantity4IsExpd())) ) {
                    setNoFurtherOpWorkQuantity4IsExpd(((Boolean) value));
                }
            }
            if( values.containsKey("NoFurtherOpWorkQuantity5IsExpd") ) {
                final Object value = values.remove("NoFurtherOpWorkQuantity5IsExpd");
                if( (value == null) || (!value.equals(getNoFurtherOpWorkQuantity5IsExpd())) ) {
                    setNoFurtherOpWorkQuantity5IsExpd(((Boolean) value));
                }
            }
            if( values.containsKey("NoFurtherOpWorkQuantity6IsExpd") ) {
                final Object value = values.remove("NoFurtherOpWorkQuantity6IsExpd");
                if( (value == null) || (!value.equals(getNoFurtherOpWorkQuantity6IsExpd())) ) {
                    setNoFurtherOpWorkQuantity6IsExpd(((Boolean) value));
                }
            }
            if( values.containsKey("NumberOfEmployees") ) {
                final Object value = values.remove("NumberOfEmployees");
                if( (value == null) || (!value.equals(getNumberOfEmployees())) ) {
                    setNumberOfEmployees(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpConfirmedWorkQuantity1") ) {
                final Object value = values.remove("OpConfirmedWorkQuantity1");
                if( (value == null) || (!value.equals(getOpConfirmedWorkQuantity1())) ) {
                    setOpConfirmedWorkQuantity1(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpConfirmedWorkQuantity2") ) {
                final Object value = values.remove("OpConfirmedWorkQuantity2");
                if( (value == null) || (!value.equals(getOpConfirmedWorkQuantity2())) ) {
                    setOpConfirmedWorkQuantity2(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpConfirmedWorkQuantity3") ) {
                final Object value = values.remove("OpConfirmedWorkQuantity3");
                if( (value == null) || (!value.equals(getOpConfirmedWorkQuantity3())) ) {
                    setOpConfirmedWorkQuantity3(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpConfirmedWorkQuantity4") ) {
                final Object value = values.remove("OpConfirmedWorkQuantity4");
                if( (value == null) || (!value.equals(getOpConfirmedWorkQuantity4())) ) {
                    setOpConfirmedWorkQuantity4(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpConfirmedWorkQuantity5") ) {
                final Object value = values.remove("OpConfirmedWorkQuantity5");
                if( (value == null) || (!value.equals(getOpConfirmedWorkQuantity5())) ) {
                    setOpConfirmedWorkQuantity5(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpConfirmedWorkQuantity6") ) {
                final Object value = values.remove("OpConfirmedWorkQuantity6");
                if( (value == null) || (!value.equals(getOpConfirmedWorkQuantity6())) ) {
                    setOpConfirmedWorkQuantity6(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpenReservationsIsCleared") ) {
                final Object value = values.remove("OpenReservationsIsCleared");
                if( (value == null) || (!value.equals(getOpenReservationsIsCleared())) ) {
                    setOpenReservationsIsCleared(((Boolean) value));
                }
            }
            if( values.containsKey("OpWorkQuantityUnit1") ) {
                final Object value = values.remove("OpWorkQuantityUnit1");
                if( (value == null) || (!value.equals(getOpWorkQuantityUnit1())) ) {
                    setOpWorkQuantityUnit1(((String) value));
                }
            }
            if( values.containsKey("OpWorkQuantityUnit2") ) {
                final Object value = values.remove("OpWorkQuantityUnit2");
                if( (value == null) || (!value.equals(getOpWorkQuantityUnit2())) ) {
                    setOpWorkQuantityUnit2(((String) value));
                }
            }
            if( values.containsKey("OpWorkQuantityUnit3") ) {
                final Object value = values.remove("OpWorkQuantityUnit3");
                if( (value == null) || (!value.equals(getOpWorkQuantityUnit3())) ) {
                    setOpWorkQuantityUnit3(((String) value));
                }
            }
            if( values.containsKey("OpWorkQuantityUnit4") ) {
                final Object value = values.remove("OpWorkQuantityUnit4");
                if( (value == null) || (!value.equals(getOpWorkQuantityUnit4())) ) {
                    setOpWorkQuantityUnit4(((String) value));
                }
            }
            if( values.containsKey("OpWorkQuantityUnit5") ) {
                final Object value = values.remove("OpWorkQuantityUnit5");
                if( (value == null) || (!value.equals(getOpWorkQuantityUnit5())) ) {
                    setOpWorkQuantityUnit5(((String) value));
                }
            }
            if( values.containsKey("OpWorkQuantityUnit6") ) {
                final Object value = values.remove("OpWorkQuantityUnit6");
                if( (value == null) || (!value.equals(getOpWorkQuantityUnit6())) ) {
                    setOpWorkQuantityUnit6(((String) value));
                }
            }
            if( values.containsKey("OrderConfirmationRecordType") ) {
                final Object value = values.remove("OrderConfirmationRecordType");
                if( (value == null) || (!value.equals(getOrderConfirmationRecordType())) ) {
                    setOrderConfirmationRecordType(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("OrderOperation") ) {
                final Object value = values.remove("OrderOperation");
                if( (value == null) || (!value.equals(getOrderOperation())) ) {
                    setOrderOperation(((String) value));
                }
            }
            if( values.containsKey("OrderOperationInternalID") ) {
                final Object value = values.remove("OrderOperationInternalID");
                if( (value == null) || (!value.equals(getOrderOperationInternalID())) ) {
                    setOrderOperationInternalID(((String) value));
                }
            }
            if( values.containsKey("OrderPlannedTotalQty") ) {
                final Object value = values.remove("OrderPlannedTotalQty");
                if( (value == null) || (!value.equals(getOrderPlannedTotalQty())) ) {
                    setOrderPlannedTotalQty(((BigDecimal) value));
                }
            }
            if( values.containsKey("OrderSuboperation") ) {
                final Object value = values.remove("OrderSuboperation");
                if( (value == null) || (!value.equals(getOrderSuboperation())) ) {
                    setOrderSuboperation(((String) value));
                }
            }
            if( values.containsKey("OrderType") ) {
                final Object value = values.remove("OrderType");
                if( (value == null) || (!value.equals(getOrderType())) ) {
                    setOrderType(((String) value));
                }
            }
            if( values.containsKey("Personnel") ) {
                final Object value = values.remove("Personnel");
                if( (value == null) || (!value.equals(getPersonnel())) ) {
                    setPersonnel(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProductionUnit") ) {
                final Object value = values.remove("ProductionUnit");
                if( (value == null) || (!value.equals(getProductionUnit())) ) {
                    setProductionUnit(((String) value));
                }
            }
            if( values.containsKey("ShiftDefinition") ) {
                final Object value = values.remove("ShiftDefinition");
                if( (value == null) || (!value.equals(getShiftDefinition())) ) {
                    setShiftDefinition(((String) value));
                }
            }
            if( values.containsKey("ShiftGrouping") ) {
                final Object value = values.remove("ShiftGrouping");
                if( (value == null) || (!value.equals(getShiftGrouping())) ) {
                    setShiftGrouping(((String) value));
                }
            }
            if( values.containsKey("TimeRecording") ) {
                final Object value = values.remove("TimeRecording");
                if( (value == null) || (!value.equals(getTimeRecording())) ) {
                    setTimeRecording(((String) value));
                }
            }
            if( values.containsKey("VarianceReasonCode") ) {
                final Object value = values.remove("VarianceReasonCode");
                if( (value == null) || (!value.equals(getVarianceReasonCode())) ) {
                    setVarianceReasonCode(((String) value));
                }
            }
            if( values.containsKey("WorkCenter") ) {
                final Object value = values.remove("WorkCenter");
                if( (value == null) || (!value.equals(getWorkCenter())) ) {
                    setWorkCenter(((String) value));
                }
            }
            if( values.containsKey("WorkCenterTypeCode") ) {
                final Object value = values.remove("WorkCenterTypeCode");
                if( (value == null) || (!value.equals(getWorkCenterTypeCode())) ) {
                    setWorkCenterTypeCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit1ISOCode") ) {
                final Object value = values.remove("WorkQuantityUnit1ISOCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit1ISOCode())) ) {
                    setWorkQuantityUnit1ISOCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit1SAPCode") ) {
                final Object value = values.remove("WorkQuantityUnit1SAPCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit1SAPCode())) ) {
                    setWorkQuantityUnit1SAPCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit2ISOCode") ) {
                final Object value = values.remove("WorkQuantityUnit2ISOCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit2ISOCode())) ) {
                    setWorkQuantityUnit2ISOCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit2SAPCode") ) {
                final Object value = values.remove("WorkQuantityUnit2SAPCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit2SAPCode())) ) {
                    setWorkQuantityUnit2SAPCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit3ISOCode") ) {
                final Object value = values.remove("WorkQuantityUnit3ISOCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit3ISOCode())) ) {
                    setWorkQuantityUnit3ISOCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit3SAPCode") ) {
                final Object value = values.remove("WorkQuantityUnit3SAPCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit3SAPCode())) ) {
                    setWorkQuantityUnit3SAPCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit4ISOCode") ) {
                final Object value = values.remove("WorkQuantityUnit4ISOCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit4ISOCode())) ) {
                    setWorkQuantityUnit4ISOCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit4SAPCode") ) {
                final Object value = values.remove("WorkQuantityUnit4SAPCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit4SAPCode())) ) {
                    setWorkQuantityUnit4SAPCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit5ISOCode") ) {
                final Object value = values.remove("WorkQuantityUnit5ISOCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit5ISOCode())) ) {
                    setWorkQuantityUnit5ISOCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit5SAPCode") ) {
                final Object value = values.remove("WorkQuantityUnit5SAPCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit5SAPCode())) ) {
                    setWorkQuantityUnit5SAPCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit6ISOCode") ) {
                final Object value = values.remove("WorkQuantityUnit6ISOCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit6ISOCode())) ) {
                    setWorkQuantityUnit6ISOCode(((String) value));
                }
            }
            if( values.containsKey("WorkQuantityUnit6SAPCode") ) {
                final Object value = values.remove("WorkQuantityUnit6SAPCode");
                if( (value == null) || (!value.equals(getWorkQuantityUnit6SAPCode())) ) {
                    setWorkQuantityUnit6SAPCode(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        return result;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>APIConfHasNoGoodsMovements</b>
     * </p>
     *
     * @param aPIConfHasNoGoodsMovements
     *            No Goods Movement
     */
    public void setAPIConfHasNoGoodsMovements( @Nullable final Boolean aPIConfHasNoGoodsMovements )
    {
        rememberChangedField("APIConfHasNoGoodsMovements", this.aPIConfHasNoGoodsMovements);
        this.aPIConfHasNoGoodsMovements = aPIConfHasNoGoodsMovements;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BreakDurationUnit</b>
     * </p>
     *
     * @param breakDurationUnit
     *            Break Time Unit
     */
    public void setBreakDurationUnit( @Nullable final String breakDurationUnit )
    {
        rememberChangedField("BreakDurationUnit", this.breakDurationUnit);
        this.breakDurationUnit = breakDurationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BreakDurationUnitISOCode</b>
     * </p>
     *
     * @param breakDurationUnitISOCode
     *            ISO Code
     */
    public void setBreakDurationUnitISOCode( @Nullable final String breakDurationUnitISOCode )
    {
        rememberChangedField("BreakDurationUnitISOCode", this.breakDurationUnitISOCode);
        this.breakDurationUnitISOCode = breakDurationUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BreakDurationUnitSAPCode</b>
     * </p>
     *
     * @param breakDurationUnitSAPCode
     *            Internal SAP Code
     */
    public void setBreakDurationUnitSAPCode( @Nullable final String breakDurationUnitSAPCode )
    {
        rememberChangedField("BreakDurationUnitSAPCode", this.breakDurationUnitSAPCode);
        this.breakDurationUnitSAPCode = breakDurationUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>BusinessProcessConfirmedQty</b>
     * </p>
     *
     * @param businessProcessConfirmedQty
     *            Process Quantity
     */
    public void setBusinessProcessConfirmedQty( @Nullable final BigDecimal businessProcessConfirmedQty )
    {
        rememberChangedField("BusinessProcessConfirmedQty", this.businessProcessConfirmedQty);
        this.businessProcessConfirmedQty = businessProcessConfirmedQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BusinessProcessEntryUnit</b>
     * </p>
     *
     * @param businessProcessEntryUnit
     *            Process Unit
     */
    public void setBusinessProcessEntryUnit( @Nullable final String businessProcessEntryUnit )
    {
        rememberChangedField("BusinessProcessEntryUnit", this.businessProcessEntryUnit);
        this.businessProcessEntryUnit = businessProcessEntryUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BusProcessEntrUnitISOCode</b>
     * </p>
     *
     * @param busProcessEntrUnitISOCode
     *            ISO Code
     */
    public void setBusProcessEntrUnitISOCode( @Nullable final String busProcessEntrUnitISOCode )
    {
        rememberChangedField("BusProcessEntrUnitISOCode", this.busProcessEntrUnitISOCode);
        this.busProcessEntrUnitISOCode = busProcessEntrUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>BusProcessEntryUnitSAPCode</b>
     * </p>
     *
     * @param busProcessEntryUnitSAPCode
     *            Internal SAP Code
     */
    public void setBusProcessEntryUnitSAPCode( @Nullable final String busProcessEntryUnitSAPCode )
    {
        rememberChangedField("BusProcessEntryUnitSAPCode", this.busProcessEntryUnitSAPCode);
        this.busProcessEntryUnitSAPCode = busProcessEntryUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationCount</b>
     * </p>
     *
     * @param confirmationCount
     *            Order Confirmation
     */
    public void setConfirmationCount( @Nullable final String confirmationCount )
    {
        rememberChangedField("ConfirmationCount", this.confirmationCount);
        this.confirmationCount = confirmationCount;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationEntryDate</b>
     * </p>
     *
     * @param confirmationEntryDate
     *            Entry Date
     */
    public void setConfirmationEntryDate( @Nullable final LocalDateTime confirmationEntryDate )
    {
        rememberChangedField("ConfirmationEntryDate", this.confirmationEntryDate);
        this.confirmationEntryDate = confirmationEntryDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationEntryTime</b>
     * </p>
     *
     * @param confirmationEntryTime
     *            Entry Time
     */
    public void setConfirmationEntryTime( @Nullable final LocalTime confirmationEntryTime )
    {
        rememberChangedField("ConfirmationEntryTime", this.confirmationEntryTime);
        this.confirmationEntryTime = confirmationEntryTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationExternalEntryDate</b>
     * </p>
     *
     * @param confirmationExternalEntryDate
     *            Created on
     */
    public void setConfirmationExternalEntryDate( @Nullable final LocalDateTime confirmationExternalEntryDate )
    {
        rememberChangedField("ConfirmationExternalEntryDate", this.confirmationExternalEntryDate);
        this.confirmationExternalEntryDate = confirmationExternalEntryDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationExternalEntryTime</b>
     * </p>
     *
     * @param confirmationExternalEntryTime
     *            Time
     */
    public void setConfirmationExternalEntryTime( @Nullable final LocalTime confirmationExternalEntryTime )
    {
        rememberChangedField("ConfirmationExternalEntryTime", this.confirmationExternalEntryTime);
        this.confirmationExternalEntryTime = confirmationExternalEntryTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationGroup</b>
     * </p>
     *
     * @param confirmationGroup
     *            Confirmation Group
     */
    public void setConfirmationGroup( @Nullable final String confirmationGroup )
    {
        rememberChangedField("ConfirmationGroup", this.confirmationGroup);
        this.confirmationGroup = confirmationGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationScrapQuantity</b>
     * </p>
     *
     * @param confirmationScrapQuantity
     *            Scrap Quantity
     */
    public void setConfirmationScrapQuantity( @Nullable final BigDecimal confirmationScrapQuantity )
    {
        rememberChangedField("ConfirmationScrapQuantity", this.confirmationScrapQuantity);
        this.confirmationScrapQuantity = confirmationScrapQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationText</b>
     * </p>
     *
     * @param confirmationText
     *            Confirmation Text
     */
    public void setConfirmationText( @Nullable final String confirmationText )
    {
        rememberChangedField("ConfirmationText", this.confirmationText);
        this.confirmationText = confirmationText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationUnit</b>
     * </p>
     *
     * @param confirmationUnit
     *            Confirmation Unit
     */
    public void setConfirmationUnit( @Nullable final String confirmationUnit )
    {
        rememberChangedField("ConfirmationUnit", this.confirmationUnit);
        this.confirmationUnit = confirmationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationUnitISOCode</b>
     * </p>
     *
     * @param confirmationUnitISOCode
     *            ISO Code
     */
    public void setConfirmationUnitISOCode( @Nullable final String confirmationUnitISOCode )
    {
        rememberChangedField("ConfirmationUnitISOCode", this.confirmationUnitISOCode);
        this.confirmationUnitISOCode = confirmationUnitISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationUnitSAPCode</b>
     * </p>
     *
     * @param confirmationUnitSAPCode
     *            Internal SAP Code
     */
    public void setConfirmationUnitSAPCode( @Nullable final String confirmationUnitSAPCode )
    {
        rememberChangedField("ConfirmationUnitSAPCode", this.confirmationUnitSAPCode);
        this.confirmationUnitSAPCode = confirmationUnitSAPCode;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>ConfirmationYieldQuantity</b>
     * </p>
     *
     * @param confirmationYieldQuantity
     *            Yield Quantity
     */
    public void setConfirmationYieldQuantity( @Nullable final BigDecimal confirmationYieldQuantity )
    {
        rememberChangedField("ConfirmationYieldQuantity", this.confirmationYieldQuantity);
        this.confirmationYieldQuantity = confirmationYieldQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedBreakDuration</b>
     * </p>
     *
     * @param confirmedBreakDuration
     *            Confirmed Break Time
     */
    public void setConfirmedBreakDuration( @Nullable final BigDecimal confirmedBreakDuration )
    {
        rememberChangedField("ConfirmedBreakDuration", this.confirmedBreakDuration);
        this.confirmedBreakDuration = confirmedBreakDuration;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedExecutionEndDate</b>
     * </p>
     *
     * @param confirmedExecutionEndDate
     *            Confirmed Execution End Date
     */
    public void setConfirmedExecutionEndDate( @Nullable final LocalDateTime confirmedExecutionEndDate )
    {
        rememberChangedField("ConfirmedExecutionEndDate", this.confirmedExecutionEndDate);
        this.confirmedExecutionEndDate = confirmedExecutionEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedExecutionEndTime</b>
     * </p>
     *
     * @param confirmedExecutionEndTime
     *            Confirmed Execution End Time
     */
    public void setConfirmedExecutionEndTime( @Nullable final LocalTime confirmedExecutionEndTime )
    {
        rememberChangedField("ConfirmedExecutionEndTime", this.confirmedExecutionEndTime);
        this.confirmedExecutionEndTime = confirmedExecutionEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedExecutionStartDate</b>
     * </p>
     *
     * @param confirmedExecutionStartDate
     *            Confirmed Execution Start Date
     */
    public void setConfirmedExecutionStartDate( @Nullable final LocalDateTime confirmedExecutionStartDate )
    {
        rememberChangedField("ConfirmedExecutionStartDate", this.confirmedExecutionStartDate);
        this.confirmedExecutionStartDate = confirmedExecutionStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedExecutionStartTime</b>
     * </p>
     *
     * @param confirmedExecutionStartTime
     *            Confirmed Execution Start Time
     */
    public void setConfirmedExecutionStartTime( @Nullable final LocalTime confirmedExecutionStartTime )
    {
        rememberChangedField("ConfirmedExecutionStartTime", this.confirmedExecutionStartTime);
        this.confirmedExecutionStartTime = confirmedExecutionStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedProcessingEndDate</b>
     * </p>
     *
     * @param confirmedProcessingEndDate
     *            Confirmed Processing End Date
     */
    public void setConfirmedProcessingEndDate( @Nullable final LocalDateTime confirmedProcessingEndDate )
    {
        rememberChangedField("ConfirmedProcessingEndDate", this.confirmedProcessingEndDate);
        this.confirmedProcessingEndDate = confirmedProcessingEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedProcessingEndTime</b>
     * </p>
     *
     * @param confirmedProcessingEndTime
     *            Confirmed Processing End Time
     */
    public void setConfirmedProcessingEndTime( @Nullable final LocalTime confirmedProcessingEndTime )
    {
        rememberChangedField("ConfirmedProcessingEndTime", this.confirmedProcessingEndTime);
        this.confirmedProcessingEndTime = confirmedProcessingEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedProcessingStartDate</b>
     * </p>
     *
     * @param confirmedProcessingStartDate
     *            Confirmed Processing Start Date
     */
    public void setConfirmedProcessingStartDate( @Nullable final LocalDateTime confirmedProcessingStartDate )
    {
        rememberChangedField("ConfirmedProcessingStartDate", this.confirmedProcessingStartDate);
        this.confirmedProcessingStartDate = confirmedProcessingStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedProcessingStartTime</b>
     * </p>
     *
     * @param confirmedProcessingStartTime
     *            Confirmed Processing Start Time
     */
    public void setConfirmedProcessingStartTime( @Nullable final LocalTime confirmedProcessingStartTime )
    {
        rememberChangedField("ConfirmedProcessingStartTime", this.confirmedProcessingStartTime);
        this.confirmedProcessingStartTime = confirmedProcessingStartTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedSetupEndDate</b>
     * </p>
     *
     * @param confirmedSetupEndDate
     *            Confirmed Setup End Date
     */
    public void setConfirmedSetupEndDate( @Nullable final LocalDateTime confirmedSetupEndDate )
    {
        rememberChangedField("ConfirmedSetupEndDate", this.confirmedSetupEndDate);
        this.confirmedSetupEndDate = confirmedSetupEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedSetupEndTime</b>
     * </p>
     *
     * @param confirmedSetupEndTime
     *            Confirmed Setup End Time
     */
    public void setConfirmedSetupEndTime( @Nullable final LocalTime confirmedSetupEndTime )
    {
        rememberChangedField("ConfirmedSetupEndTime", this.confirmedSetupEndTime);
        this.confirmedSetupEndTime = confirmedSetupEndTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedTeardownStartDate</b>
     * </p>
     *
     * @param confirmedTeardownStartDate
     *            Confirmed Teardown Start Date
     */
    public void setConfirmedTeardownStartDate( @Nullable final LocalDateTime confirmedTeardownStartDate )
    {
        rememberChangedField("ConfirmedTeardownStartDate", this.confirmedTeardownStartDate);
        this.confirmedTeardownStartDate = confirmedTeardownStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>ConfirmedTeardownStartTime</b>
     * </p>
     *
     * @param confirmedTeardownStartTime
     *            Confirmed Teardown Start Time
     */
    public void setConfirmedTeardownStartTime( @Nullable final LocalTime confirmedTeardownStartTime )
    {
        rememberChangedField("ConfirmedTeardownStartTime", this.confirmedTeardownStartTime);
        this.confirmedTeardownStartTime = confirmedTeardownStartTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>EmployeeSuitability</b>
     * </p>
     *
     * @param employeeSuitability
     *            Employee Suitability
     */
    public void setEmployeeSuitability( @Nullable final String employeeSuitability )
    {
        rememberChangedField("EmployeeSuitability", this.employeeSuitability);
        this.employeeSuitability = employeeSuitability;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>EmployeeWageGroup</b>
     * </p>
     *
     * @param employeeWageGroup
     *            Employee Wage Group
     */
    public void setEmployeeWageGroup( @Nullable final String employeeWageGroup )
    {
        rememberChangedField("EmployeeWageGroup", this.employeeWageGroup);
        this.employeeWageGroup = employeeWageGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>EmployeeWageType</b>
     * </p>
     *
     * @param employeeWageType
     *            Employee Wage Type
     */
    public void setEmployeeWageType( @Nullable final String employeeWageType )
    {
        rememberChangedField("EmployeeWageType", this.employeeWageType);
        this.employeeWageType = employeeWageType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>EnteredByExternalUser</b>
     * </p>
     *
     * @param enteredByExternalUser
     *            Created by
     */
    public void setEnteredByExternalUser( @Nullable final String enteredByExternalUser )
    {
        rememberChangedField("EnteredByExternalUser", this.enteredByExternalUser);
        this.enteredByExternalUser = enteredByExternalUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>EnteredByUser</b>
     * </p>
     *
     * @param enteredByUser
     *            Entered by User
     */
    public void setEnteredByUser( @Nullable final String enteredByUser )
    {
        rememberChangedField("EnteredByUser", this.enteredByUser);
        this.enteredByUser = enteredByUser;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>ExternalSystemConfirmation</b>
     * </p>
     *
     * @param externalSystemConfirmation
     *            External Key
     */
    public void setExternalSystemConfirmation( @Nullable final UUID externalSystemConfirmation )
    {
        rememberChangedField("ExternalSystemConfirmation", this.externalSystemConfirmation);
        this.externalSystemConfirmation = externalSystemConfirmation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property from the Odata EDM: <b>FinalConfirmationType</b>
     * </p>
     *
     * @param finalConfirmationType
     *            Final Confirmation Type
     */
    public void setFinalConfirmationType( @Nullable final String finalConfirmationType )
    {
        rememberChangedField("FinalConfirmationType", this.finalConfirmationType);
        this.finalConfirmationType = finalConfirmationType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsFinalConfirmation</b>
     * </p>
     *
     * @param isFinalConfirmation
     *            Final Confirmation
     */
    public void setIsFinalConfirmation( @Nullable final Boolean isFinalConfirmation )
    {
        rememberChangedField("IsFinalConfirmation", this.isFinalConfirmation);
        this.isFinalConfirmation = isFinalConfirmation;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsReversal</b>
     * </p>
     *
     * @param isReversal
     *            Is a Cancellation
     */
    public void setIsReversal( @Nullable final Boolean isReversal )
    {
        rememberChangedField("IsReversal", this.isReversal);
        this.isReversal = isReversal;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>IsReversed</b>
     * </p>
     *
     * @param isReversed
     *            Reversed
     */
    public void setIsReversed( @Nullable final Boolean isReversed )
    {
        rememberChangedField("IsReversed", this.isReversed);
        this.isReversed = isReversed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Change
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Changed By
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>NoFurtherBusinessProcQtyIsExpd</b>
     * </p>
     *
     * @param noFurtherBusinessProcQtyIsExpd
     *            No Remaining Act.
     */
    public void setNoFurtherBusinessProcQtyIsExpd( @Nullable final Boolean noFurtherBusinessProcQtyIsExpd )
    {
        rememberChangedField("NoFurtherBusinessProcQtyIsExpd", this.noFurtherBusinessProcQtyIsExpd);
        this.noFurtherBusinessProcQtyIsExpd = noFurtherBusinessProcQtyIsExpd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>NoFurtherOpWorkQuantity1IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity1IsExpd
     *            No Remaining Work Quantity 1 Expected
     */
    public void setNoFurtherOpWorkQuantity1IsExpd( @Nullable final Boolean noFurtherOpWorkQuantity1IsExpd )
    {
        rememberChangedField("NoFurtherOpWorkQuantity1IsExpd", this.noFurtherOpWorkQuantity1IsExpd);
        this.noFurtherOpWorkQuantity1IsExpd = noFurtherOpWorkQuantity1IsExpd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>NoFurtherOpWorkQuantity2IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity2IsExpd
     *            No Remaining Work Quantity 2 Expected
     */
    public void setNoFurtherOpWorkQuantity2IsExpd( @Nullable final Boolean noFurtherOpWorkQuantity2IsExpd )
    {
        rememberChangedField("NoFurtherOpWorkQuantity2IsExpd", this.noFurtherOpWorkQuantity2IsExpd);
        this.noFurtherOpWorkQuantity2IsExpd = noFurtherOpWorkQuantity2IsExpd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>NoFurtherOpWorkQuantity3IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity3IsExpd
     *            No Remaining Work Quantity 3 Expected
     */
    public void setNoFurtherOpWorkQuantity3IsExpd( @Nullable final Boolean noFurtherOpWorkQuantity3IsExpd )
    {
        rememberChangedField("NoFurtherOpWorkQuantity3IsExpd", this.noFurtherOpWorkQuantity3IsExpd);
        this.noFurtherOpWorkQuantity3IsExpd = noFurtherOpWorkQuantity3IsExpd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>NoFurtherOpWorkQuantity4IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity4IsExpd
     *            No Remaining Work Quantity 4 Expected
     */
    public void setNoFurtherOpWorkQuantity4IsExpd( @Nullable final Boolean noFurtherOpWorkQuantity4IsExpd )
    {
        rememberChangedField("NoFurtherOpWorkQuantity4IsExpd", this.noFurtherOpWorkQuantity4IsExpd);
        this.noFurtherOpWorkQuantity4IsExpd = noFurtherOpWorkQuantity4IsExpd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>NoFurtherOpWorkQuantity5IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity5IsExpd
     *            No Remaining Work Quantity 5 Expected
     */
    public void setNoFurtherOpWorkQuantity5IsExpd( @Nullable final Boolean noFurtherOpWorkQuantity5IsExpd )
    {
        rememberChangedField("NoFurtherOpWorkQuantity5IsExpd", this.noFurtherOpWorkQuantity5IsExpd);
        this.noFurtherOpWorkQuantity5IsExpd = noFurtherOpWorkQuantity5IsExpd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>NoFurtherOpWorkQuantity6IsExpd</b>
     * </p>
     *
     * @param noFurtherOpWorkQuantity6IsExpd
     *            No Remaining Work Quantity 6 Expected
     */
    public void setNoFurtherOpWorkQuantity6IsExpd( @Nullable final Boolean noFurtherOpWorkQuantity6IsExpd )
    {
        rememberChangedField("NoFurtherOpWorkQuantity6IsExpd", this.noFurtherOpWorkQuantity6IsExpd);
        this.noFurtherOpWorkQuantity6IsExpd = noFurtherOpWorkQuantity6IsExpd;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property from the Odata EDM: <b>NumberOfEmployees</b>
     * </p>
     *
     * @param numberOfEmployees
     *            Number of Employees
     */
    public void setNumberOfEmployees( @Nullable final BigDecimal numberOfEmployees )
    {
        rememberChangedField("NumberOfEmployees", this.numberOfEmployees);
        this.numberOfEmployees = numberOfEmployees;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>OpConfirmedWorkQuantity1</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity1
     *            Confirmed Work Quantity 1
     */
    public void setOpConfirmedWorkQuantity1( @Nullable final BigDecimal opConfirmedWorkQuantity1 )
    {
        rememberChangedField("OpConfirmedWorkQuantity1", this.opConfirmedWorkQuantity1);
        this.opConfirmedWorkQuantity1 = opConfirmedWorkQuantity1;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>OpConfirmedWorkQuantity2</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity2
     *            Confirmed Work Quantity 2
     */
    public void setOpConfirmedWorkQuantity2( @Nullable final BigDecimal opConfirmedWorkQuantity2 )
    {
        rememberChangedField("OpConfirmedWorkQuantity2", this.opConfirmedWorkQuantity2);
        this.opConfirmedWorkQuantity2 = opConfirmedWorkQuantity2;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>OpConfirmedWorkQuantity3</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity3
     *            Confirmed Work Quantity 3
     */
    public void setOpConfirmedWorkQuantity3( @Nullable final BigDecimal opConfirmedWorkQuantity3 )
    {
        rememberChangedField("OpConfirmedWorkQuantity3", this.opConfirmedWorkQuantity3);
        this.opConfirmedWorkQuantity3 = opConfirmedWorkQuantity3;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>OpConfirmedWorkQuantity4</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity4
     *            Confirmed Work Quantity 4
     */
    public void setOpConfirmedWorkQuantity4( @Nullable final BigDecimal opConfirmedWorkQuantity4 )
    {
        rememberChangedField("OpConfirmedWorkQuantity4", this.opConfirmedWorkQuantity4);
        this.opConfirmedWorkQuantity4 = opConfirmedWorkQuantity4;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>OpConfirmedWorkQuantity5</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity5
     *            Confirmed Work Quantity 5
     */
    public void setOpConfirmedWorkQuantity5( @Nullable final BigDecimal opConfirmedWorkQuantity5 )
    {
        rememberChangedField("OpConfirmedWorkQuantity5", this.opConfirmedWorkQuantity5);
        this.opConfirmedWorkQuantity5 = opConfirmedWorkQuantity5;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>OpConfirmedWorkQuantity6</b>
     * </p>
     *
     * @param opConfirmedWorkQuantity6
     *            Confirmed Work Quantity 6
     */
    public void setOpConfirmedWorkQuantity6( @Nullable final BigDecimal opConfirmedWorkQuantity6 )
    {
        rememberChangedField("OpConfirmedWorkQuantity6", this.opConfirmedWorkQuantity6);
        this.opConfirmedWorkQuantity6 = opConfirmedWorkQuantity6;
    }

    /**
     * Constraints: none
     * <p>
     * Original property from the Odata EDM: <b>OpenReservationsIsCleared</b>
     * </p>
     *
     * @param openReservationsIsCleared
     *            Clear Open Reservs.
     */
    public void setOpenReservationsIsCleared( @Nullable final Boolean openReservationsIsCleared )
    {
        rememberChangedField("OpenReservationsIsCleared", this.openReservationsIsCleared);
        this.openReservationsIsCleared = openReservationsIsCleared;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OpWorkQuantityUnit1</b>
     * </p>
     *
     * @param opWorkQuantityUnit1
     *            Confirmed Work Quantity Unit 1
     */
    public void setOpWorkQuantityUnit1( @Nullable final String opWorkQuantityUnit1 )
    {
        rememberChangedField("OpWorkQuantityUnit1", this.opWorkQuantityUnit1);
        this.opWorkQuantityUnit1 = opWorkQuantityUnit1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OpWorkQuantityUnit2</b>
     * </p>
     *
     * @param opWorkQuantityUnit2
     *            Confirmed Work Quantity Unit 2
     */
    public void setOpWorkQuantityUnit2( @Nullable final String opWorkQuantityUnit2 )
    {
        rememberChangedField("OpWorkQuantityUnit2", this.opWorkQuantityUnit2);
        this.opWorkQuantityUnit2 = opWorkQuantityUnit2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OpWorkQuantityUnit3</b>
     * </p>
     *
     * @param opWorkQuantityUnit3
     *            Confirmed Work Quantity Unit 3
     */
    public void setOpWorkQuantityUnit3( @Nullable final String opWorkQuantityUnit3 )
    {
        rememberChangedField("OpWorkQuantityUnit3", this.opWorkQuantityUnit3);
        this.opWorkQuantityUnit3 = opWorkQuantityUnit3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OpWorkQuantityUnit4</b>
     * </p>
     *
     * @param opWorkQuantityUnit4
     *            Confirmed Work Quantity Unit 4
     */
    public void setOpWorkQuantityUnit4( @Nullable final String opWorkQuantityUnit4 )
    {
        rememberChangedField("OpWorkQuantityUnit4", this.opWorkQuantityUnit4);
        this.opWorkQuantityUnit4 = opWorkQuantityUnit4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OpWorkQuantityUnit5</b>
     * </p>
     *
     * @param opWorkQuantityUnit5
     *            Confirmed Work Quantity Unit 5
     */
    public void setOpWorkQuantityUnit5( @Nullable final String opWorkQuantityUnit5 )
    {
        rememberChangedField("OpWorkQuantityUnit5", this.opWorkQuantityUnit5);
        this.opWorkQuantityUnit5 = opWorkQuantityUnit5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OpWorkQuantityUnit6</b>
     * </p>
     *
     * @param opWorkQuantityUnit6
     *            Confirmed Work Quantity Unit 6
     */
    public void setOpWorkQuantityUnit6( @Nullable final String opWorkQuantityUnit6 )
    {
        rememberChangedField("OpWorkQuantityUnit6", this.opWorkQuantityUnit6);
        this.opWorkQuantityUnit6 = opWorkQuantityUnit6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>OrderConfirmationRecordType</b>
     * </p>
     *
     * @param orderConfirmationRecordType
     *            Record Type
     */
    public void setOrderConfirmationRecordType( @Nullable final String orderConfirmationRecordType )
    {
        rememberChangedField("OrderConfirmationRecordType", this.orderConfirmationRecordType);
        this.orderConfirmationRecordType = orderConfirmationRecordType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Manufacturing Order
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>OrderOperation</b>
     * </p>
     *
     * @param orderOperation
     *            Operation
     */
    public void setOrderOperation( @Nullable final String orderOperation )
    {
        rememberChangedField("OrderOperation", this.orderOperation);
        this.orderOperation = orderOperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>OrderOperationInternalID</b>
     * </p>
     *
     * @param orderOperationInternalID
     *            Operation Internal ID
     */
    public void setOrderOperationInternalID( @Nullable final String orderOperationInternalID )
    {
        rememberChangedField("OrderOperationInternalID", this.orderOperationInternalID);
        this.orderOperationInternalID = orderOperationInternalID;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property from the Odata EDM: <b>OrderPlannedTotalQty</b>
     * </p>
     *
     * @param orderPlannedTotalQty
     *            Total Quantity
     */
    public void setOrderPlannedTotalQty( @Nullable final BigDecimal orderPlannedTotalQty )
    {
        rememberChangedField("OrderPlannedTotalQty", this.orderPlannedTotalQty);
        this.orderPlannedTotalQty = orderPlannedTotalQty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>OrderSuboperation</b>
     * </p>
     *
     * @param orderSuboperation
     *            Suboperation
     */
    public void setOrderSuboperation( @Nullable final String orderSuboperation )
    {
        rememberChangedField("OrderSuboperation", this.orderSuboperation);
        this.orderSuboperation = orderSuboperation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>OrderType</b>
     * </p>
     *
     * @param orderType
     *            Order Type
     */
    public void setOrderType( @Nullable final String orderType )
    {
        rememberChangedField("OrderType", this.orderType);
        this.orderType = orderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @param personnel
     *            Personnel
     */
    public void setPersonnel( @Nullable final String personnel )
    {
        rememberChangedField("Personnel", this.personnel);
        this.personnel = personnel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>ProductionUnit</b>
     * </p>
     *
     * @param productionUnit
     *            Production Unit
     */
    public void setProductionUnit( @Nullable final String productionUnit )
    {
        rememberChangedField("ProductionUnit", this.productionUnit);
        this.productionUnit = productionUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>ShiftDefinition</b>
     * </p>
     *
     * @param shiftDefinition
     *            Shift Definition
     */
    public void setShiftDefinition( @Nullable final String shiftDefinition )
    {
        rememberChangedField("ShiftDefinition", this.shiftDefinition);
        this.shiftDefinition = shiftDefinition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>ShiftGrouping</b>
     * </p>
     *
     * @param shiftGrouping
     *            Shift Grouping
     */
    public void setShiftGrouping( @Nullable final String shiftGrouping )
    {
        rememberChangedField("ShiftGrouping", this.shiftGrouping);
        this.shiftGrouping = shiftGrouping;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>TimeRecording</b>
     * </p>
     *
     * @param timeRecording
     *            Time Recording
     */
    public void setTimeRecording( @Nullable final String timeRecording )
    {
        rememberChangedField("TimeRecording", this.timeRecording);
        this.timeRecording = timeRecording;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property from the Odata EDM: <b>VarianceReasonCode</b>
     * </p>
     *
     * @param varianceReasonCode
     *            Variance Reason
     */
    public void setVarianceReasonCode( @Nullable final String varianceReasonCode )
    {
        rememberChangedField("VarianceReasonCode", this.varianceReasonCode);
        this.varianceReasonCode = varianceReasonCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property from the Odata EDM: <b>WorkCenter</b>
     * </p>
     *
     * @param workCenter
     *            Work Center
     */
    public void setWorkCenter( @Nullable final String workCenter )
    {
        rememberChangedField("WorkCenter", this.workCenter);
        this.workCenter = workCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property from the Odata EDM: <b>WorkCenterTypeCode</b>
     * </p>
     *
     * @param workCenterTypeCode
     *            Resource Object Type
     */
    public void setWorkCenterTypeCode( @Nullable final String workCenterTypeCode )
    {
        rememberChangedField("WorkCenterTypeCode", this.workCenterTypeCode);
        this.workCenterTypeCode = workCenterTypeCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit1ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit1ISOCode
     *            ISO Code
     */
    public void setWorkQuantityUnit1ISOCode( @Nullable final String workQuantityUnit1ISOCode )
    {
        rememberChangedField("WorkQuantityUnit1ISOCode", this.workQuantityUnit1ISOCode);
        this.workQuantityUnit1ISOCode = workQuantityUnit1ISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit1SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit1SAPCode
     *            Internal SAP Code
     */
    public void setWorkQuantityUnit1SAPCode( @Nullable final String workQuantityUnit1SAPCode )
    {
        rememberChangedField("WorkQuantityUnit1SAPCode", this.workQuantityUnit1SAPCode);
        this.workQuantityUnit1SAPCode = workQuantityUnit1SAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit2ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit2ISOCode
     *            ISO Code
     */
    public void setWorkQuantityUnit2ISOCode( @Nullable final String workQuantityUnit2ISOCode )
    {
        rememberChangedField("WorkQuantityUnit2ISOCode", this.workQuantityUnit2ISOCode);
        this.workQuantityUnit2ISOCode = workQuantityUnit2ISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit2SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit2SAPCode
     *            Internal SAP Code
     */
    public void setWorkQuantityUnit2SAPCode( @Nullable final String workQuantityUnit2SAPCode )
    {
        rememberChangedField("WorkQuantityUnit2SAPCode", this.workQuantityUnit2SAPCode);
        this.workQuantityUnit2SAPCode = workQuantityUnit2SAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit3ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit3ISOCode
     *            ISO Code
     */
    public void setWorkQuantityUnit3ISOCode( @Nullable final String workQuantityUnit3ISOCode )
    {
        rememberChangedField("WorkQuantityUnit3ISOCode", this.workQuantityUnit3ISOCode);
        this.workQuantityUnit3ISOCode = workQuantityUnit3ISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit3SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit3SAPCode
     *            Internal SAP Code
     */
    public void setWorkQuantityUnit3SAPCode( @Nullable final String workQuantityUnit3SAPCode )
    {
        rememberChangedField("WorkQuantityUnit3SAPCode", this.workQuantityUnit3SAPCode);
        this.workQuantityUnit3SAPCode = workQuantityUnit3SAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit4ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit4ISOCode
     *            ISO Code
     */
    public void setWorkQuantityUnit4ISOCode( @Nullable final String workQuantityUnit4ISOCode )
    {
        rememberChangedField("WorkQuantityUnit4ISOCode", this.workQuantityUnit4ISOCode);
        this.workQuantityUnit4ISOCode = workQuantityUnit4ISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit4SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit4SAPCode
     *            Internal SAP Code
     */
    public void setWorkQuantityUnit4SAPCode( @Nullable final String workQuantityUnit4SAPCode )
    {
        rememberChangedField("WorkQuantityUnit4SAPCode", this.workQuantityUnit4SAPCode);
        this.workQuantityUnit4SAPCode = workQuantityUnit4SAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit5ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit5ISOCode
     *            ISO Code
     */
    public void setWorkQuantityUnit5ISOCode( @Nullable final String workQuantityUnit5ISOCode )
    {
        rememberChangedField("WorkQuantityUnit5ISOCode", this.workQuantityUnit5ISOCode);
        this.workQuantityUnit5ISOCode = workQuantityUnit5ISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit5SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit5SAPCode
     *            Internal SAP Code
     */
    public void setWorkQuantityUnit5SAPCode( @Nullable final String workQuantityUnit5SAPCode )
    {
        rememberChangedField("WorkQuantityUnit5SAPCode", this.workQuantityUnit5SAPCode);
        this.workQuantityUnit5SAPCode = workQuantityUnit5SAPCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit6ISOCode</b>
     * </p>
     *
     * @param workQuantityUnit6ISOCode
     *            ISO Code
     */
    public void setWorkQuantityUnit6ISOCode( @Nullable final String workQuantityUnit6ISOCode )
    {
        rememberChangedField("WorkQuantityUnit6ISOCode", this.workQuantityUnit6ISOCode);
        this.workQuantityUnit6ISOCode = workQuantityUnit6ISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property from the Odata EDM: <b>WorkQuantityUnit6SAPCode</b>
     * </p>
     *
     * @param workQuantityUnit6SAPCode
     *            Internal SAP Code
     */
    public void setWorkQuantityUnit6SAPCode( @Nullable final String workQuantityUnit6SAPCode )
    {
        rememberChangedField("WorkQuantityUnit6SAPCode", this.workQuantityUnit6SAPCode);
        this.workQuantityUnit6SAPCode = workQuantityUnit6SAPCode;
    }

}
