/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.processorderconfirmationv2;

import java.math.BigDecimal;
import java.net.URI;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.CollectionValuedFluentHelperFunction;

/**
 * Fluent helper for the <b>GetGdsMvtProposal</b> OData function import.
 *
 */
public class GetGdsMvtProposalFluentHelper
    extends
    CollectionValuedFluentHelperFunction<GetGdsMvtProposalFluentHelper, AProcordconfmatldocitem, List<AProcordconfmatldocitem>>
{

    private final Map<String, Object> values = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will execute the <b>GetGdsMvtProposal</b> OData function import with the
     * provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the fluent
     * helper object.
     *
     * @param dateAndTimeIsToBeProposed
     *            Propose Dates
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DateAndTimeIsToBeProposed</b>
     *            </p>
     * @param orderID
     *            Manufacturing Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderID</b>
     *            </p>
     * @param confirmationUnitISOCode
     *            ISO Code
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationUnitISOCode</b>
     *            </p>
     * @param confirmationGroup
     *            Confirmation Group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationGroup</b>
     *            </p>
     * @param confirmationYieldQuantity
     *            Yield Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationYieldQuantity</b>
     *            </p>
     * @param quantityIsToBeProposed
     *            Propose Quantities
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>QuantityIsToBeProposed</b>
     *            </p>
     * @param orderConfirmationRecordType
     *            Record Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderConfirmationRecordType</b>
     *            </p>
     * @param confirmationUnit
     *            Display Unit/Measure
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationUnit</b>
     *            </p>
     * @param orderSuboperation
     *            Suboperation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderSuboperation</b>
     *            </p>
     * @param personnelIsToBeProposed
     *            Propose Personnel
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PersonnelIsToBeProposed</b>
     *            </p>
     * @param activityIsToBeProposed
     *            Propose Activities
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActivityIsToBeProposed</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param orderOperation
     *            Operation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderOperation</b>
     *            </p>
     * @param confirmationScrapQuantity
     *            Scrap Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationScrapQuantity</b>
     *            </p>
     */
    public GetGdsMvtProposalFluentHelper(
        @Nonnull final String servicePath,
        @Nullable final String confirmationGroup,
        @Nullable final String orderID,
        @Nullable final String orderOperation,
        @Nullable final String orderSuboperation,
        @Nullable final String orderConfirmationRecordType,
        @Nullable final String confirmationUnit,
        @Nullable final String confirmationUnitISOCode,
        @Nullable final BigDecimal confirmationYieldQuantity,
        @Nullable final BigDecimal confirmationScrapQuantity,
        @Nullable final Boolean quantityIsToBeProposed,
        @Nullable final Boolean activityIsToBeProposed,
        @Nullable final Boolean dateAndTimeIsToBeProposed,
        @Nullable final Boolean personnelIsToBeProposed )
    {
        super(servicePath);
        if( confirmationGroup != null ) {
            values.put("ConfirmationGroup", confirmationGroup);
        }
        if( orderID != null ) {
            values.put("OrderID", orderID);
        }
        if( orderOperation != null ) {
            values.put("OrderOperation", orderOperation);
        }
        if( orderSuboperation != null ) {
            values.put("OrderSuboperation", orderSuboperation);
        }
        if( orderConfirmationRecordType != null ) {
            values.put("OrderConfirmationRecordType", orderConfirmationRecordType);
        }
        if( confirmationUnit != null ) {
            values.put("ConfirmationUnit", confirmationUnit);
        }
        if( confirmationUnitISOCode != null ) {
            values.put("ConfirmationUnitISOCode", confirmationUnitISOCode);
        }
        if( confirmationYieldQuantity != null ) {
            values.put("ConfirmationYieldQuantity", confirmationYieldQuantity);
        }
        if( confirmationScrapQuantity != null ) {
            values.put("ConfirmationScrapQuantity", confirmationScrapQuantity);
        }
        if( quantityIsToBeProposed != null ) {
            values.put("QuantityIsToBeProposed", quantityIsToBeProposed);
        }
        if( activityIsToBeProposed != null ) {
            values.put("ActivityIsToBeProposed", activityIsToBeProposed);
        }
        if( dateAndTimeIsToBeProposed != null ) {
            values.put("DateAndTimeIsToBeProposed", dateAndTimeIsToBeProposed);
        }
        if( personnelIsToBeProposed != null ) {
            values.put("PersonnelIsToBeProposed", personnelIsToBeProposed);
        }
    }

    /**
     * Creates a fluent helper object that will execute the <b>GetGdsMvtProposal</b> OData function import with the
     * provided parameters. To perform execution, call the {@link #executeRequest executeRequest} method on the fluent
     * helper object.
     *
     * @param dateAndTimeIsToBeProposed
     *            Propose Dates
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>DateAndTimeIsToBeProposed</b>
     *            </p>
     * @param orderID
     *            Manufacturing Order
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 12
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderID</b>
     *            </p>
     * @param confirmationUnitISOCode
     *            ISO Code
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationUnitISOCode</b>
     *            </p>
     * @param confirmationGroup
     *            Confirmation Group
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 10
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationGroup</b>
     *            </p>
     * @param confirmationYieldQuantity
     *            Yield Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationYieldQuantity</b>
     *            </p>
     * @param quantityIsToBeProposed
     *            Propose Quantities
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>QuantityIsToBeProposed</b>
     *            </p>
     * @param orderConfirmationRecordType
     *            Record Type
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderConfirmationRecordType</b>
     *            </p>
     * @param confirmationUnit
     *            Display Unit/Measure
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationUnit</b>
     *            </p>
     * @param orderSuboperation
     *            Suboperation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderSuboperation</b>
     *            </p>
     * @param personnelIsToBeProposed
     *            Propose Personnel
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>PersonnelIsToBeProposed</b>
     *            </p>
     * @param activityIsToBeProposed
     *            Propose Activities
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ActivityIsToBeProposed</b>
     *            </p>
     * @param servicePath
     *            Service path to be used to call the functions against.
     * @param orderOperation
     *            Operation
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 4
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>OrderOperation</b>
     *            </p>
     * @param confirmationScrapQuantity
     *            Scrap Quantity
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Precision: 13, Scale: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationScrapQuantity</b>
     *            </p>
     * @param confirmationUnitSAPCode
     *            Internal SAP Code
     *            <p>
     *            </p>
     *            <p>
     *            Constraints: Nullable, Maximum length: 3
     *            </p>
     *            <p>
     *            Original parameter name from the Odata EDM: <b>ConfirmationUnitSAPCode</b>
     *            </p>
     */
    public GetGdsMvtProposalFluentHelper(
        @Nonnull final String servicePath,
        @Nullable final String confirmationGroup,
        @Nullable final String orderID,
        @Nullable final String orderOperation,
        @Nullable final String orderSuboperation,
        @Nullable final String orderConfirmationRecordType,
        @Nullable final String confirmationUnit,
        @Nullable final String confirmationUnitISOCode,
        @Nullable final BigDecimal confirmationYieldQuantity,
        @Nullable final BigDecimal confirmationScrapQuantity,
        @Nullable final Boolean quantityIsToBeProposed,
        @Nullable final Boolean activityIsToBeProposed,
        @Nullable final Boolean dateAndTimeIsToBeProposed,
        @Nullable final Boolean personnelIsToBeProposed,
        @Nullable final String confirmationUnitSAPCode )
    {
        super(servicePath);
        if( confirmationGroup != null ) {
            values.put("ConfirmationGroup", confirmationGroup);
        }
        if( orderID != null ) {
            values.put("OrderID", orderID);
        }
        if( orderOperation != null ) {
            values.put("OrderOperation", orderOperation);
        }
        if( orderSuboperation != null ) {
            values.put("OrderSuboperation", orderSuboperation);
        }
        if( orderConfirmationRecordType != null ) {
            values.put("OrderConfirmationRecordType", orderConfirmationRecordType);
        }
        if( confirmationUnit != null ) {
            values.put("ConfirmationUnit", confirmationUnit);
        }
        if( confirmationUnitISOCode != null ) {
            values.put("ConfirmationUnitISOCode", confirmationUnitISOCode);
        }
        if( confirmationYieldQuantity != null ) {
            values.put("ConfirmationYieldQuantity", confirmationYieldQuantity);
        }
        if( confirmationScrapQuantity != null ) {
            values.put("ConfirmationScrapQuantity", confirmationScrapQuantity);
        }
        if( quantityIsToBeProposed != null ) {
            values.put("QuantityIsToBeProposed", quantityIsToBeProposed);
        }
        if( activityIsToBeProposed != null ) {
            values.put("ActivityIsToBeProposed", activityIsToBeProposed);
        }
        if( dateAndTimeIsToBeProposed != null ) {
            values.put("DateAndTimeIsToBeProposed", dateAndTimeIsToBeProposed);
        }
        if( personnelIsToBeProposed != null ) {
            values.put("PersonnelIsToBeProposed", personnelIsToBeProposed);
        }
        if( confirmationUnitSAPCode != null ) {
            values.put("ConfirmationUnitSAPCode", confirmationUnitSAPCode);
        }
    }

    @Override
    @Nonnull
    protected Class<AProcordconfmatldocitem> getEntityClass()
    {
        return AProcordconfmatldocitem.class;
    }

    @Override
    @Nonnull
    protected String getFunctionName()
    {
        return "GetGdsMvtProposal";
    }

    @Override
    @Nullable
    protected JsonElement refineJsonResponse( @Nullable JsonElement jsonElement )
    {
        if( (jsonElement instanceof JsonObject) && ((JsonObject) jsonElement).has(getFunctionName()) ) {
            jsonElement = ((JsonObject) jsonElement).get(getFunctionName());
        }
        return super.refineJsonResponse(jsonElement);
    }

    @Override
    @Nonnull
    protected Map<String, Object> getParameters()
    {
        return values;
    }

    @Override
    @Nonnull
    protected HttpUriRequest createRequest( @Nonnull final URI uri )
    {
        return new HttpPost(uri);
    }

    /**
     * Execute this function import.
     *
     */
    @Override
    @Nonnull
    public List<AProcordconfmatldocitem> executeRequest( @Nonnull final HttpDestinationProperties destination )
    {
        return super.executeMultiple(destination);
    }

}
